/*
 * Decompiled with CFR 0.152.
 */
package CalendarPKG;

import CalendarPKG.EDate;
import CalendarPKG.HolidayData;
import java.util.Calendar;
import java.util.Date;

public class Tools {
    static char[] cp1256_to_unicode_tab = new char[]{'\u20ac', '\u067e', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0679', '\u2039', '\u0152', '\u0686', '\u0698', '\u0688', '\u06af', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u06a9', '\u2122', '\u0691', '\u203a', '\u0153', '\u200c', '\u200d', '\u06ba', '\u00a0', '\u060c', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u06be', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u061b', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u061f', '\u06c1', '\u0621', '\u0622', '\u0623', '\u0624', '\u0625', '\u0626', '\u0627', '\u0628', '\u0629', '\u062a', '\u062b', '\u062c', '\u062d', '\u062e', '\u062f', '\u0630', '\u0631', '\u0632', '\u0633', '\u0634', '\u0635', '\u0636', '\u00d7', '\u0637', '\u0638', '\u0639', '\u063a', '\u0640', '\u0641', '\u0642', '\u0643', '\u00e0', '\u0644', '\u00e2', '\u0645', '\u0646', '\u0647', '\u0648', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u0649', '\u064a', '\u00ee', '\u00ef', '\u064b', '\u064c', '\u064d', '\u064e', '\u00f4', '\u064f', '\u0650', '\u00f7', '\u0651', '\u00f9', '\u0652', '\u00fb', '\u00fc', '\u200e', '\u200f', '\u00ff'};

    public static void memcpy(Object[] dest, Object[] source, int size) {
        for (int i = 0; i < size; ++i) {
            dest[i] = source[i];
        }
    }

    static char cp1256_to_unicode(char ch) {
        if (ch >= '\u0080' && ch <= '\u00ff') {
            return cp1256_to_unicode_tab[ch - 128];
        }
        return ch;
    }

    public static char[] cp1256_to_unicode(int nLen, char[] pch) {
        int nLoop = 0;
        char[] pwch = new char[pch.length];
        if (nLen == 0) {
            nLen = -1;
        }
        while (nLoop < nLen && pch[nLoop] != '\u0000') {
            pwch[nLoop] = Tools.cp1256_to_unicode(pch[nLoop]);
            ++nLoop;
        }
        pwch[nLoop] = '\u0000';
        return pwch;
    }

    public static String ArabicAscii2Unicode(char[] b) {
        String out = "";
        for (int i = 0; i < b.length; ++i) {
            int ch = b[i];
            if ((ch &= 0xFF) == 0) break;
            out = ch >= 128 && ch <= 255 ? out + cp1256_to_unicode_tab[ch - 128] : out + (char)ch;
        }
        return out;
    }

    public static EDate ArmenianEasterSunday(int nYear) {
        Calendar d = Calendar.getInstance();
        int nCent = nYear / 100;
        int nRemain19 = nYear % 19;
        int n1 = (nCent - 15) / 2 + 202 - 11 * nRemain19;
        if (nCent > 20) {
            if (nCent > 26) {
                --n1;
            }
            if (nCent > 38) {
                --n1;
            }
            if (nCent == 21 || nCent == 24 || nCent == 25 || nCent == 33 || nCent == 36 || nCent == 37) {
                --n1;
            }
        }
        if ((n1 %= 30) == 29 || n1 == 28 && nRemain19 > 10) {
            --n1;
        }
        EDate dtPFM = new EDate();
        dtPFM.m_year = nYear;
        if (n1 > 10) {
            dtPFM.m_month = 3;
            dtPFM.m_date = n1 - 10;
        } else {
            dtPFM.m_month = 2;
            dtPFM.m_date = n1 + 21;
        }
        d.set(5, dtPFM.m_date);
        d.set(2, dtPFM.m_month);
        d.set(1, dtPFM.m_year);
        long nWeekDay = (7L - (long)(d.get(7) - 1)) * 86400000L;
        d.setTime(new Date(d.getTime().getTime() + nWeekDay));
        dtPFM.m_date = d.get(5);
        dtPFM.m_month = d.get(2) + 1;
        return dtPFM;
    }

    public static EDate OrthodoxEasterSunday(int nYear) {
        int nRemain19 = nYear % 19;
        int nRemain7 = nYear % 7;
        int nRemain4 = nYear % 4;
        int n1 = (19 * nRemain19 + 16) % 30;
        int n2 = (2 * nRemain4 + 4 * nRemain7 + 6 * n1) % 7;
        int n3 = n1 + n2;
        int nCent = nYear / 100;
        EDate dt = new EDate();
        dt.m_year = nYear;
        if ((n3 += nCent - nCent / 4 - 2) > 40) {
            dt.m_month = 4;
            dt.m_date = n3 - 40;
        } else if (n3 > 10) {
            dt.m_month = 3;
            dt.m_date = n3 - 10;
        } else {
            dt.m_month = 2;
            dt.m_date = n3 + 21;
        }
        ++dt.m_month;
        return dt;
    }

    public static int getDayOfWeek(HolidayData.Holiday d) {
        Calendar cal = Calendar.getInstance();
        cal.set(5, d.nDay);
        cal.set(2, d.nMonth - 1);
        return cal.get(7) - 1;
    }
}

