/*
 * Decompiled with CFR 0.152.
 */
package MobmeControls;

import MobmeControls.ArabicUtils;
import MobmeControls.CustomComponent;
import MobmeControls.IMobeListListener;
import MobmeControls.MobmeChoiceListener;
import MobmeControls.MobmeChoiceLoader;
import MobmeControls.MobmeForm;
import MobmeControls.MobmeListCtrl;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;

public class MobmeChoice
extends CustomComponent
implements CommandListener,
Runnable,
IMobeListListener {
    MobmeChoiceLoader m_ChoiceLoader = null;
    String m_strLabel = "";
    String m_strTitle = "";
    Displayable m_Parent = null;
    MobmeChoiceListener m_SelListener = null;
    Display m_Display = null;
    boolean m_bIsArabic = false;
    Font m_F;
    boolean m_bIsRightPressed = false;
    boolean m_bIsLeftPressed = false;
    boolean m_bIsTraversedOut = true;
    boolean m_bIsLocked = false;
    String[] m_strList;
    int m_iPos;
    MobmeForm m_FullListForm = null;
    MobmeListCtrl m_FullList = null;
    TextHScroller m_TextHScrollerObj = null;

    public MobmeChoice(String Title, Displayable parent, Display display, Font f, boolean bIsArabic) {
        this.m_strTitle = Title;
        this.m_Parent = parent;
        this.m_Display = display;
        this.m_bIsArabic = bIsArabic;
        this.m_F = f;
        this.m_strList = new String[0];
        this.m_iPos = -1;
        this.m_FullListForm = new MobmeForm();
        this.m_FullListForm.setTitle("\u0627\u062e\u062a\u0631 \u0645\u0646 \u0627\u0644\u0642\u0627\u0626\u0645\u0629");
        this.m_FullListForm.addCommand(new Command("\u0631\u062c\u0648\u0639", 2, 0));
        this.m_FullListForm.addCommand(new Command("\u0627\u062e\u062a\u0631", 4, 1));
        this.m_FullList = new MobmeListCtrl("", (Displayable)this.m_FullListForm, this.m_Display, this.m_F, this.m_bIsArabic, this.m_strList);
        this.m_FullList.SetDimension(this.m_FullListForm.getWidth(), this.m_FullListForm.getHeight() - 10);
        this.m_FullList.SetItemChangeListener(this);
        this.m_FullListForm.append(this.m_FullList);
        this.m_FullListForm.setCommandListener(this);
    }

    public void setLoader(MobmeChoiceLoader cLoader) {
        this.m_ChoiceLoader = cLoader;
    }

    public void setSelListener(MobmeChoiceListener SelListener) {
        this.m_SelListener = SelListener;
    }

    protected int getMinContentWidth() {
        return this.m_Parent.getWidth();
    }

    protected int getMinContentHeight() {
        return this.m_F.getHeight() + 8;
    }

    protected int getPrefContentWidth(int i) {
        return this.m_Parent.getWidth();
    }

    protected int getPrefContentHeight(int i) {
        return this.m_F.getHeight() + 8;
    }

    protected void paint(Graphics graphics, int w, int h) {
        if (this.m_bIsLocked) {
            return;
        }
        int oldC = graphics.getColor();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, w, h);
        graphics.setColor(0);
        graphics.drawRect(1, 1, w - 5, h - 2);
        int xUnit = 3;
        int yUnit = 3;
        int TrWidth = (h - 4) / 2;
        if (this.m_bIsArabic) {
            if (this.m_bIsLeftPressed) {
                graphics.setColor(0);
                graphics.fillRect(xUnit - 1, yUnit - 1, TrWidth + xUnit + 2, h - 2 * yUnit + 3);
                graphics.setColor(0xFFFFFF);
            } else {
                graphics.setColor(0);
            }
            graphics.fillTriangle(xUnit, h / 2, TrWidth + xUnit, yUnit, TrWidth + xUnit, h - yUnit);
            if (this.m_bIsRightPressed) {
                graphics.setColor(0);
                graphics.fillRect(TrWidth + xUnit + xUnit, yUnit - 1, TrWidth + xUnit + 2, h - 2 * yUnit + 3);
                graphics.setColor(0xFFFFFF);
            } else {
                graphics.setColor(0);
            }
            graphics.fillTriangle(TrWidth + xUnit + xUnit * 2, yUnit, TrWidth + xUnit + xUnit * 2, h - yUnit, TrWidth * 2 + xUnit + xUnit * 2, h / 2);
        } else {
            int xorigin = w - (TrWidth * 2 + xUnit + xUnit * 3) - 5;
            if (this.m_bIsLeftPressed) {
                graphics.setColor(0);
                graphics.fillRect(xorigin + xUnit - 1, yUnit - 1, TrWidth + xUnit + 2, h - 2 * yUnit + 3);
                graphics.setColor(0xFFFFFF);
            } else {
                graphics.setColor(0);
            }
            graphics.fillTriangle(xorigin + xUnit, h / 2, xorigin + TrWidth + xUnit, yUnit, xorigin + TrWidth + xUnit, h - yUnit);
            if (this.m_bIsRightPressed) {
                graphics.setColor(0);
                graphics.fillRect(xorigin + TrWidth + xUnit + xUnit, yUnit - 1, TrWidth + xUnit + 2, h - 2 * yUnit + 3);
                graphics.setColor(0xFFFFFF);
            } else {
                graphics.setColor(0);
            }
            graphics.fillTriangle(xorigin + TrWidth + xUnit + xUnit * 2, yUnit, xorigin + TrWidth + xUnit + xUnit * 2, h - yUnit, xorigin + TrWidth * 2 + xUnit + xUnit * 2, h / 2);
        }
        graphics.setColor(oldC);
        if (this.m_iPos == -1) {
            return;
        }
        if (this.m_ChoiceLoader == null) {
            if (this.m_iPos < 0 || this.m_iPos >= this.m_strList.length) {
                return;
            }
            this.m_strLabel = this.m_strList[this.m_iPos];
        } else {
            if (this.m_iPos < 0 || this.m_iPos >= this.m_ChoiceLoader.GetListCount()) {
                return;
            }
            this.m_strLabel = this.m_ChoiceLoader.GetItemStrAt(this.m_iPos);
        }
        if (this.m_strLabel == "") {
            return;
        }
        if (this.m_bIsArabic) {
            this.m_strLabel = ArabicUtils.ArabicString(this.m_strLabel);
        }
        Font oldf = graphics.getFont();
        int iTextWidth = oldf.stringWidth(this.m_strLabel);
        int iTextXScroll = 0;
        if (iTextWidth > w - (TrWidth * 2 + xUnit + xUnit * 2 + 4) - 5) {
            if (this.m_TextHScrollerObj != null) {
                if (this.m_TextHScrollerObj.m_iScrolledTxtPos != this.m_iPos) {
                    this.m_TextHScrollerObj.m_bIsRun = false;
                    this.m_TextHScrollerObj = new TextHScroller();
                    this.m_TextHScrollerObj.m_bIsRun = true;
                    this.m_TextHScrollerObj.m_iScrolledTxtPos = this.m_iPos;
                    this.m_TextHScrollerObj.m_iAvWidth = w - (TrWidth * 2 + xUnit + xUnit * 2 + 4) - 7;
                    this.m_TextHScrollerObj.m_iTextWidth = iTextWidth;
                    new Thread(this.m_TextHScrollerObj).start();
                } else {
                    iTextXScroll = this.m_TextHScrollerObj.m_iTextXScroll;
                }
            } else {
                this.m_TextHScrollerObj = new TextHScroller();
                this.m_TextHScrollerObj.m_bIsRun = true;
                this.m_TextHScrollerObj.m_iScrolledTxtPos = this.m_iPos;
                this.m_TextHScrollerObj.m_iAvWidth = w - (TrWidth * 2 + xUnit + xUnit * 2 + 4) - 7;
                this.m_TextHScrollerObj.m_iTextWidth = iTextWidth;
                new Thread(this.m_TextHScrollerObj).start();
            }
        } else if (this.m_TextHScrollerObj != null) {
            this.m_TextHScrollerObj.m_bIsRun = false;
            this.m_TextHScrollerObj = null;
        }
        if (this.m_bIsArabic) {
            graphics.setClip(TrWidth * 2 + xUnit + xUnit * 2 + 2, yUnit, w - (TrWidth * 2 + xUnit + xUnit * 2 + 4) - 5, h - yUnit * 2);
            graphics.drawString(this.m_strLabel, w - 8 + iTextXScroll, 3, 24);
        } else {
            graphics.setClip(5, yUnit, w - (TrWidth * 2 + xUnit + xUnit * 3), h - yUnit * 2);
            graphics.drawString(this.m_strLabel, 5 - iTextXScroll, 0, 20);
        }
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        this.m_bIsLeftPressed = false;
        this.m_bIsRightPressed = false;
        switch (dir) {
            case 6: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                this.m_bIsLeftPressed = true;
                if (this.m_ChoiceLoader == null) {
                    if (this.m_iPos < this.m_strList.length - 1) {
                        ++this.m_iPos;
                    }
                } else if (this.m_iPos < this.m_ChoiceLoader.GetListCount() - 1) {
                    ++this.m_iPos;
                }
                this.rePaint();
                new Thread(this).start();
                break;
            }
            case 5: {
                this.m_bIsRightPressed = true;
                if (this.m_iPos > 0) {
                    --this.m_iPos;
                }
                this.rePaint();
                new Thread(this).start();
            }
        }
        return true;
    }

    protected void traverseOut() {
        this.m_bIsTraversedOut = true;
    }

    protected void keyPressed(int keyCode) {
        int keyAction = this.getGameAction(keyCode);
        if (keyCode > 48 && keyCode < 57 || keyCode == 35 || keyCode == 42) {
            keyAction = keyCode;
        }
        if (keyAction == 8) {
            if (this.m_ChoiceLoader == null) {
                if (this.m_strList.length > 0) {
                    this.m_FullList.UpdateList(this.m_strList, 0);
                    this.m_FullList.SetSelectedIndex(this.m_iPos);
                    this.m_Display.setCurrent((Displayable)this.m_FullListForm);
                    this.m_FullListForm.RefreshScreen();
                }
            } else if (this.m_ChoiceLoader.GetListCount() > 0) {
                this.m_FullList.UpdateList(this.m_ChoiceLoader, 0);
                this.m_FullList.SetSelectedIndex(this.m_iPos);
                this.m_Display.setCurrent((Displayable)this.m_FullListForm);
                this.m_FullListForm.RefreshScreen();
            }
        }
    }

    protected void keyReleased(int keyCode) {
        this.m_bIsLeftPressed = false;
        this.m_bIsRightPressed = false;
        this.rePaint();
        int keyAction = this.getGameAction(keyCode);
        if (keyCode > 48 && keyCode < 57 || keyCode == 35 || keyCode == 42) {
            keyAction = keyCode;
        }
        if ((keyAction == 2 || keyAction == 5) && this.m_SelListener != null) {
            this.m_SelListener.OnSelectionChanged((Item)this, this.m_iPos);
        }
    }

    protected void keyRepeated(int keyCode) {
    }

    public void AddString(String str) {
        String[] strTmp = this.m_strList;
        this.m_strList = new String[strTmp.length + 1];
        for (int i = 0; i < strTmp.length; ++i) {
            this.m_strList[i] = strTmp[i];
        }
        this.m_strList[i] = new String(str);
        strTmp = null;
    }

    public void SetPos(int iPos) {
        if (this.m_ChoiceLoader == null ? iPos < 0 || iPos >= this.m_strList.length : iPos < 0 || iPos >= this.m_ChoiceLoader.GetListCount()) {
            return;
        }
        this.m_iPos = iPos;
        this.rePaint();
    }

    public int GetPos() {
        return this.m_iPos;
    }

    public String GetString(int iPos) {
        if (this.m_ChoiceLoader == null) {
            if (iPos < 0 || iPos >= this.m_strList.length) {
                return "";
            }
            return this.m_strList[this.m_iPos];
        }
        if (iPos < 0 || iPos >= this.m_ChoiceLoader.GetListCount()) {
            return "";
        }
        return this.m_ChoiceLoader.GetItemStrAt(this.m_iPos);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.m_FullListForm) {
            MobmeForm frm;
            if (command.getPriority() == 1) {
                this.m_iPos = this.m_FullList.GetSelectedIndex();
                this.m_Display.setCurrent(this.m_Parent);
                try {
                    frm = (MobmeForm)this.m_Parent;
                    frm.RefreshScreen();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (this.m_SelListener != null) {
                    this.m_SelListener.OnSelectionChanged((Item)this, this.m_iPos);
                }
            }
            if (command.getPriority() == 0) {
                this.m_Display.setCurrent(this.m_Parent);
                try {
                    frm = (MobmeForm)this.m_Parent;
                    frm.RefreshScreen();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        while (this.m_bIsLeftPressed || this.m_bIsRightPressed) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            if (this.m_bIsLeftPressed) {
                if (this.m_ChoiceLoader == null) {
                    if (this.m_iPos < this.m_strList.length - 1) {
                        ++this.m_iPos;
                    }
                } else if (this.m_iPos < this.m_ChoiceLoader.GetListCount() - 1) {
                    ++this.m_iPos;
                }
                this.rePaint();
                continue;
            }
            if (!this.m_bIsRightPressed) break;
            if (this.m_iPos > 0) {
                --this.m_iPos;
            }
            this.rePaint();
        }
    }

    public void Reset() {
        this.m_strList = new String[0];
        this.m_iPos = -1;
    }

    public void Lock(boolean bIsLocked) {
        this.m_bIsLocked = bIsLocked;
        if (!bIsLocked) {
            this.rePaint();
        }
    }

    public int GetItemsCount() {
        if (this.m_ChoiceLoader == null) {
            return this.m_strList.length;
        }
        return this.m_ChoiceLoader.GetListCount();
    }

    public void OnAction(int iCurSel) {
        this.m_iPos = this.m_FullList.GetSelectedIndex();
        this.m_Display.setCurrent(this.m_Parent);
        try {
            if (this.m_Parent instanceof MobmeForm) {
                MobmeForm frm = (MobmeForm)this.m_Parent;
                frm.RefreshScreen();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_SelListener != null) {
            this.m_SelListener.OnSelectionChanged((Item)this, this.m_iPos);
        }
    }

    public void OnChangeItem(int iIndex, boolean LangID) {
    }

    public void OnVScroll(int iDirection, boolean LangID) {
    }

    class TextHScroller
    implements Runnable {
        public boolean m_bIsRun;
        public int m_iScrolledTxtPos = -1;
        public int m_iTextXScroll;
        public int m_iAvWidth;
        public int m_iTextWidth;

        TextHScroller() {
        }

        public void run() {
            int iStep = 2;
            this.m_iTextXScroll = 0;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            while (this.m_bIsRun) {
                try {
                    Thread.sleep(150L);
                    if (this.m_iTextXScroll <= 0) {
                        iStep = 2;
                        Thread.sleep(1000L);
                    } else if (this.m_iTextWidth <= this.m_iTextXScroll + this.m_iAvWidth) {
                        iStep = -2;
                        Thread.sleep(1000L);
                    }
                    this.m_iTextXScroll += iStep;
                    MobmeChoice.this.rePaint();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

