/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.kdom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import org.kxml.XmlIO;
import org.kxml.io.AbstractXmlWriter;
import org.kxml.io.XmlWriter;
import org.kxml.kdom.Element;
import org.kxml.parser.AbstractXmlParser;
import org.kxml.parser.ParseEvent;

public class Node
implements XmlIO {
    protected Vector children;
    protected StringBuffer types;

    public void addChild(int index, int type, Object child) {
        if (child == null) {
            throw new NullPointerException();
        }
        if (this.children == null) {
            this.children = new Vector();
            this.types = new StringBuffer();
        }
        if (type == 4) {
            if (!(child instanceof Element)) {
                throw new RuntimeException("Element obj expected)");
            }
            ((Element)child).setParent(this);
        } else if (!(child instanceof String)) {
            throw new RuntimeException("String expected");
        }
        this.children.insertElementAt(child, index);
        this.types.insert(index, (char)type);
    }

    public void addChild(int type, Object child) {
        this.addChild(this.getChildCount(), type, child);
    }

    public Element createElement(String namespace, String name) {
        Element e = new Element();
        e.namespace = namespace == null ? "" : namespace;
        e.name = name;
        return e;
    }

    public Object getChild(int index) {
        return this.children.elementAt(index);
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public Element getElement(int index) {
        Object child = this.getChild(index);
        return child instanceof Element ? (Element)child : null;
    }

    public Element getElement(String name) {
        return this.getElement(this.getNamespace(), name);
    }

    public Element getElement(String namespace, String name) {
        int i = this.indexOf(namespace, name, 0);
        int j = this.indexOf(namespace, name, i + 1);
        if (i == -1 || j != -1) {
            throw new RuntimeException("Element {" + namespace + "}" + name + (i == -1 ? " not found in " : " more than once in ") + this.getName());
        }
        return this.getElement(i);
    }

    public String getName() {
        return "#document-fragment";
    }

    public String getNamespace() {
        return "";
    }

    public String getText() {
        StringBuffer buf = new StringBuffer();
        int len = this.getChildCount();
        for (int i = 0; i < len; ++i) {
            if ((this.getType(i) & 0x180) != 0) {
                buf.append(this.getText(i));
                continue;
            }
            if (this.getType(i) != 4) continue;
            throw new RuntimeException("not text-only content!");
        }
        return buf.toString();
    }

    public String getText(int index) {
        return (this.getType(index) & 0x180) != 0 ? (String)this.getChild(index) : null;
    }

    public int getType(int index) {
        return this.types.charAt(index);
    }

    public int indexOf(String name, int startIndex) {
        return this.indexOf(this.getNamespace(), name, startIndex);
    }

    public int indexOf(String namespace, String name, int startIndex) {
        int len = this.getChildCount();
        for (int i = startIndex; i < len; ++i) {
            Element child = this.getElement(i);
            if (child == null || !name.equals(child.getName()) || namespace != null && !namespace.equals(child.getNamespace())) continue;
            return i;
        }
        return -1;
    }

    public void parse(AbstractXmlParser parser) throws IOException {
        boolean leave = false;
        do {
            ParseEvent event = parser.peek();
            switch (event.getType()) {
                case 64: {
                    Element child = this.createElement(event.getNamespace(), event.getName());
                    child.setAttributes(event.getAttributes());
                    this.addChild(4, child);
                    child.parse(parser);
                    break;
                }
                case 8: 
                case 16: {
                    leave = true;
                    break;
                }
                default: {
                    this.addChild(event.getType(), event.getText());
                    parser.read();
                }
            }
        } while (!leave);
    }

    public void removeChild(int idx) {
        this.children.removeElementAt(idx);
        int n = this.types.length() - 1;
        for (int i = idx; i < n; ++i) {
            this.types.setCharAt(i, this.types.charAt(i + 1));
        }
        this.types.setLength(n);
    }

    public String toString() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            XmlWriter xw = new XmlWriter(new OutputStreamWriter(bos));
            this.write(xw);
            xw.close();
            return new String(bos.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void write(AbstractXmlWriter writer) throws IOException {
        this.writeChildren(writer);
        writer.flush();
    }

    public void writeChildren(AbstractXmlWriter writer) throws IOException {
        if (this.children == null) {
            return;
        }
        int len = this.children.size();
        block4: for (int i = 0; i < len; ++i) {
            int type = this.getType(i);
            Object child = this.children.elementAt(i);
            switch (type) {
                case 4: {
                    ((Element)child).write(writer);
                    continue block4;
                }
                case 128: 
                case 256: {
                    writer.write((String)child);
                    continue block4;
                }
                default: {
                    writer.writeLegacy(type, (String)child);
                }
            }
        }
    }
}

