/*
 * Decompiled with CFR 0.152.
 */
package MobmeControls;

import MobmeControls.ArabicUtils;
import MobmeControls.CustomComponent;
import MobmeControls.MobmeForm;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MobmeRadioList
extends CustomComponent {
    Displayable m_Parent = null;
    Display m_Display = null;
    boolean m_bIsArabic = false;
    boolean m_bIsTraversedOut = true;
    Font m_F;
    MobmeRadioSelChangeListener m_ActListener = null;
    int m_iPos;
    int m_iSelPos;
    String[] m_strList;
    String m_Title;

    public MobmeRadioList(String Title, Displayable parent, Display display, Font f, boolean bIsArabic) {
        this.m_Parent = parent;
        this.m_Display = display;
        this.m_bIsArabic = bIsArabic;
        this.m_F = f;
        this.m_iPos = -1;
        this.m_iSelPos = -1;
        this.m_strList = null;
        this.m_Title = Title;
        if (this.m_bIsArabic) {
            this.m_Title = ArabicUtils.ArabicString(this.m_Title);
        }
    }

    public void Create(String[] strList) {
        this.m_strList = strList;
        for (int i = 0; i < this.m_strList.length; ++i) {
            if (!this.m_bIsArabic) continue;
            this.m_strList[i] = ArabicUtils.ArabicString(this.m_strList[i]);
        }
        this.m_iPos = this.m_strList.length > 0 ? 0 : -1;
        this.m_iSelPos = -1;
        this.rePaint();
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        switch (dir) {
            case 1: {
                if (this.m_iPos == 0) {
                    return false;
                }
                --this.m_iPos;
                this.rePaint();
                return true;
            }
            case 6: {
                if (this.m_iPos == this.m_strList.length - 1) {
                    return false;
                }
                ++this.m_iPos;
                this.rePaint();
                return true;
            }
            case 2: {
                return false;
            }
            case 5: {
                return false;
            }
        }
        return true;
    }

    protected void traverseOut() {
        this.m_bIsTraversedOut = true;
    }

    protected int getMinContentWidth() {
        return this.m_Parent.getWidth();
    }

    protected int getMinContentHeight() {
        return this.m_strList.length * (this.m_F.getHeight() + 4) + (this.m_Title != null && this.m_Title.length() > 0 ? this.m_F.getHeight() + 4 : 0);
    }

    protected int getPrefContentWidth(int i) {
        return this.m_Parent.getWidth();
    }

    protected int getPrefContentHeight(int i) {
        return this.m_strList.length * (this.m_F.getHeight() + 4) + (this.m_Title != null && this.m_Title.length() > 0 ? this.m_F.getHeight() + 4 : 0);
    }

    protected void paint(Graphics graphics, int w, int h) {
        int oldC = graphics.getColor();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, w, h);
        graphics.setColor(0);
        graphics.drawRect(1, 1, w - 5, h - 2);
        if (this.m_bIsArabic) {
            this.paintRTL(graphics, w, h);
        } else {
            this.paintLTR(graphics, w, h);
        }
        graphics.setColor(oldC);
    }

    protected void paintRTL(Graphics graphics, int w, int h) {
        if (this.m_Title != null && this.m_Title.length() > 0) {
            graphics.drawString(this.m_Title, w - 5, 2, 24);
        }
        int ih = this.m_F.getHeight() + 4;
        int ix = w - 5 - this.m_F.getHeight() - 2;
        int iy = ih;
        boolean bIsFocused = true;
        if (this.m_Parent instanceof MobmeForm) {
            MobmeForm p = (MobmeForm)this.m_Parent;
            bIsFocused = p.GetFocusedItem() == this;
        }
        for (int i = 0; i < this.m_strList.length; ++i) {
            if (i == this.m_iPos && bIsFocused) {
                graphics.setColor(255);
                graphics.fillRect(1, iy, w - 2, ih);
                graphics.setColor(0xFFFFFF);
            } else {
                graphics.setColor(0);
            }
            this.drawRadioCircles(graphics, ix + 2, iy + 2, i);
            graphics.drawString(this.m_strList[i], ix, iy + 2, 24);
            iy += ih;
        }
    }

    protected void paintLTR(Graphics graphics, int w, int h) {
    }

    protected void drawRadioCircles(Graphics graphics, int x, int y, int iPos) {
        int cirhw = this.m_F.getHeight() - 4;
        graphics.drawArc(x, y + 2, cirhw, cirhw, 0, 360);
        if (iPos == this.m_iSelPos) {
            graphics.fillArc(x + 2, y + 4, cirhw - 4, cirhw - 4, 0, 360);
        }
    }

    public int GetSelPos() {
        return this.m_iSelPos;
    }

    public void SetSelPos(int iSelPos) {
        this.m_iSelPos = iSelPos;
    }

    protected void keyPressed(int keyCode) {
        int keyAction = this.getGameAction(keyCode);
        if (keyCode > 48 && keyCode < 57 || keyCode == 35 || keyCode == 42) {
            keyAction = keyCode;
        }
        if (keyAction == 8) {
            this.m_iSelPos = this.m_iPos;
            if (this.m_ActListener != null) {
                this.m_ActListener.OnSelChange(this.m_iSelPos);
            }
            this.rePaint();
        }
    }

    public static interface MobmeRadioSelChangeListener {
        public void OnSelChange(int var1);
    }
}

