/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import java.util.Date;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class RSHandler {
    private RecordStore rs = null;
    static final String Tazkerah_RS = "Tazkera_db";
    static final String DATA_RS = "DataPath_db";
    String DataPath = null;
    static final int ARABIC = 0;
    static final int ENGLISH = 1;
    static final int GRID = 0;
    static final int LIST = 1;
    private int Language = 0;
    private int AlarmStatus = 1;
    Date AM;
    Date PM;
    Splash splash;
    private AlarmsHandler alarm;

    public RSHandler(Splash s) {
        this.splash = s;
        try {
            this.getDataPath();
            this.openRecStore();
            this.retrieveAppData();
            this.closeRecStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        this.initAlarm();
    }

    private void getDataPath() throws RecordStoreException {
        try {
            this.rs = RecordStore.openRecordStore((String)DATA_RS, (boolean)false);
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
            try {
                this.rs = RecordStore.openRecordStore((String)DATA_RS, (boolean)true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.rs.getNumRecords() != 0) {
            this.DataPath = this.readRecords(this.rs.getNextRecordID() - 1);
        }
        this.rs.closeRecordStore();
        this.rs = null;
    }

    public void saveDataPath() throws RecordStoreException {
        try {
            this.rs = RecordStore.openRecordStore((String)DATA_RS, (boolean)false);
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        if (this.rs.getNumRecords() != 0) {
            byte[] rec = this.DataPath.getBytes();
            this.rs.setRecord(1, rec, 0, rec.length);
        } else {
            this.writeRecord(this.DataPath.trim());
        }
        this.rs.closeRecordStore();
        this.rs = null;
    }

    public String getDataURL() {
        if (this.DataPath == null) {
            return null;
        }
        return this.DataPath;
    }

    public void setDataURL(String str) {
        this.DataPath = str;
    }

    public void initAlarm() {
        this.alarm = null;
        if (this.getAlarmStatus() == 1) {
            this.alarm = new AlarmsHandler(this.splash);
            this.alarm.setAlarms(this.AM, this.PM);
            this.alarm.start();
        }
    }

    public long PushNextAlarm() {
        return this.alarm.getNextAlarm();
    }

    public void retrieveAppData() {
        String str = this.readRecords(1);
        this.AM = new Date();
        this.PM = new Date();
        this.Language = str.equals("AR") ? 0 : 1;
        this.AlarmStatus = Integer.parseInt(this.readRecords(2));
        Calendar ToDay = Calendar.getInstance();
        ToDay.setTime(new Date());
        this.AM.setTime(Long.parseLong(this.readRecords(3)));
        Calendar firstA = Calendar.getInstance();
        firstA.setTime(this.AM);
        ToDay.set(11, firstA.get(11));
        ToDay.set(12, firstA.get(12));
        ToDay.set(13, 0);
        this.AM.setTime(ToDay.getTime().getTime());
        Calendar ToDay2 = Calendar.getInstance();
        ToDay2.setTime(new Date());
        this.PM.setTime(Long.parseLong(this.readRecords(4)));
        Calendar ndA = Calendar.getInstance();
        ndA.setTime(this.PM);
        ToDay2.set(11, ndA.get(11));
        ToDay2.set(12, ndA.get(12));
        ToDay2.set(13, 0);
        this.PM.setTime(ToDay2.getTime().getTime());
    }

    public void restoreDefaults() {
        this.AlarmStatus = 1;
        Calendar Mc = Calendar.getInstance();
        Calendar Nc = Calendar.getInstance();
        this.AM = new Date();
        Mc.setTime(this.AM);
        Mc.set(11, 5);
        Mc.set(12, 0);
        Mc.set(13, 0);
        this.AM.setTime(Mc.getTime().getTime());
        this.PM = new Date();
        Nc.setTime(this.PM);
        Nc.set(11, 20);
        Nc.set(12, 0);
        Nc.set(13, 0);
        this.PM.setTime(Nc.getTime().getTime());
    }

    private void saveDefaults() {
        this.restoreDefaults();
        String str = this.Language == 0 ? "AR" : "EN";
        this.writeRecord(str.trim());
        this.writeRecord("" + this.AlarmStatus);
        this.writeRecord("" + this.AM.getTime());
        this.writeRecord("" + this.PM.getTime());
    }

    public void saveLastStatus() throws RecordStoreException {
        try {
            this.rs = RecordStore.openRecordStore((String)Tazkerah_RS, (boolean)false);
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        String str = this.Language == 0 ? "AR" : "EN";
        if (this.rs.getNumRecords() != 0) {
            byte[] rec = str.getBytes();
            this.rs.setRecord(1, rec, 0, rec.length);
            rec = null;
            rec = ("" + this.AlarmStatus).getBytes();
            this.rs.setRecord(2, rec, 0, rec.length);
            rec = null;
            rec = ("" + this.AM.getTime()).getBytes();
            this.rs.setRecord(3, rec, 0, rec.length);
            rec = null;
            rec = ("" + this.PM.getTime()).getBytes();
            this.rs.setRecord(4, rec, 0, rec.length);
        }
        this.rs.closeRecordStore();
        this.rs = null;
    }

    public int getLanguage() {
        return this.Language;
    }

    public void setLanguage(int lang) {
        this.Language = lang;
    }

    public int getAlarmStatus() {
        return this.AlarmStatus;
    }

    public void setAlarmStatus(int a) {
        this.AlarmStatus = a;
    }

    public Date getMorningAlarm() {
        return this.AM;
    }

    public void setMorningAlarm(Date am) {
        this.AM = am;
    }

    public Date getNightAlarm() {
        return this.PM;
    }

    public void setNightAlarm(Date pm) {
        this.PM = pm;
    }

    public void openRecStore() throws RecordStoreException {
        try {
            this.rs = RecordStore.openRecordStore((String)Tazkerah_RS, (boolean)false);
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
            try {
                this.rs = RecordStore.openRecordStore((String)Tazkerah_RS, (boolean)true);
                this.saveDefaults();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void writeRecord(String str) {
        byte[] rec = str.getBytes();
        try {
            this.rs.addRecord(rec, 0, rec.length);
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
        }
    }

    public String readRecords(int index) {
        try {
            byte[] recData = new byte[this.rs.getRecordSize(index)];
            int len = this.rs.getRecord(index, recData, 0);
            return new String(recData, 0, len);
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
            return null;
        }
    }

    public void closeRecStore() {
        try {
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
        }
    }

    public void deleteRecStore() {
        if (RecordStore.listRecordStores() == null) {
            // empty if block
        }
    }
}

