/*
 * Decompiled with CFR 0.152.
 */
package com.loboltd.javamap.query;

import java.util.Vector;

public abstract class Query {
    public static final byte NEXT = 1;
    public static final byte PRE = -1;
    protected String keyWord;
    protected String area;
    protected String language;
    protected Vector fileNames;
    protected int maxResultNum;
    protected int indexFileNum;
    protected Vector buildings = new Vector();
    private int currentPage;
    private int currentCountInPage;
    private int preResultNum;
    private boolean queryOver = false;
    private QueryThread query;

    protected abstract int search(String var1, int var2, int var3, Vector var4);

    protected abstract Vector findFile(String var1);

    public void setKeyWord(String keyWord) {
        this.keyWord = keyWord.toUpperCase();
    }

    public void search(byte type) {
        this.queryOver = false;
        this.query = new QueryThread();
        this.query.type = type;
        this.query.start();
    }

    public int getMaxResultNum() {
        return this.maxResultNum;
    }

    public void setMaxResultNum(int maxResultNum) {
        this.maxResultNum = maxResultNum;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setIndexFileNum(int indexFileNum) {
        this.indexFileNum = indexFileNum;
    }

    public boolean isQueryOver() {
        return this.queryOver;
    }

    public Vector getResultSet() {
        return this.buildings;
    }

    public void stopQuery() {
        this.query.interrupt();
    }

    private class QueryThread
    extends Thread {
        private byte type;

        private QueryThread() {
        }

        public void run() {
            if (Query.this.fileNames == null || Query.this.fileNames.size() == 0) {
                Query.this.fileNames = Query.this.findFile(Query.this.keyWord);
                if (Query.this.fileNames == null || Query.this.fileNames.size() == 0) {
                    Query.this.queryOver = true;
                    return;
                }
            }
            Query.this.buildings = new Vector();
            int count = 0;
            int k = Query.this.currentPage;
            switch (this.type) {
                case 1: {
                    int startCount = Query.this.currentCountInPage;
                    int endCount = startCount + Query.this.maxResultNum - count;
                    int resultNum = 0;
                    while (k < Query.this.fileNames.size()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e.toString());
                        }
                        resultNum = Query.this.search((String)Query.this.fileNames.elementAt(k), startCount, endCount, Query.this.buildings);
                        if ((count += resultNum) != 0) {
                            Query.this.preResultNum = count;
                        }
                        if (resultNum > 0) {
                            Query.this.currentCountInPage = resultNum + startCount;
                        }
                        if (count >= Query.this.maxResultNum) {
                            count = Query.this.maxResultNum;
                            if (count == 0) break;
                            Query.this.preResultNum = count;
                            break;
                        }
                        startCount = 0;
                        endCount = Query.this.maxResultNum - count;
                        ++k;
                    }
                    Query.this.currentPage = k >= Query.this.fileNames.size() ? Query.this.fileNames.size() - 1 : k;
                    Query.this.queryOver = true;
                    Runtime.getRuntime().gc();
                    break;
                }
                case -1: {
                    int endCount = Query.this.currentCountInPage - Query.this.preResultNum;
                    int tempCount = Query.this.currentCountInPage;
                    while (endCount <= 0) {
                        if (k > 0) {
                            Vector temp = new Vector();
                            int recordCount = Query.this.search((String)Query.this.fileNames.elementAt(--k), 0, Integer.MAX_VALUE, temp);
                            endCount = recordCount - (Query.this.preResultNum - tempCount);
                            tempCount += recordCount;
                            temp.removeAllElements();
                            temp = null;
                            continue;
                        }
                        endCount = Query.this.currentCountInPage;
                        Query.this.queryOver = true;
                        return;
                    }
                    Query.this.preResultNum = Query.this.maxResultNum;
                    Query.this.currentPage = k <= 0 ? 0 : k;
                    Query.this.currentCountInPage = endCount;
                    int startCount = endCount >= Query.this.maxResultNum ? endCount - Query.this.maxResultNum : 0;
                    int resultNum = 0;
                    Vector temp = new Vector();
                    while (k >= 0) {
                        int i;
                        Vector temp2 = new Vector();
                        resultNum = Query.this.search((String)Query.this.fileNames.elementAt(k), startCount, endCount, temp2);
                        if (!temp.isEmpty()) {
                            i = temp2.size() - 1;
                            while (i >= 0) {
                                temp.insertElementAt(temp2.elementAt(i), 0);
                                --i;
                            }
                            temp2.removeAllElements();
                        } else {
                            i = 0;
                            while (i < temp2.size()) {
                                temp.addElement(temp2.elementAt(i));
                                ++i;
                            }
                        }
                        if ((count += resultNum) >= Query.this.maxResultNum) {
                            count = Query.this.maxResultNum;
                            while (!temp.isEmpty()) {
                                Query.this.buildings.addElement(temp.firstElement());
                                temp.removeElementAt(0);
                            }
                            break;
                        }
                        if (startCount == 0) {
                            if (k <= 0) break;
                            int maxPrePageCount = Query.this.search((String)Query.this.fileNames.elementAt(k - 1), 0, Integer.MAX_VALUE, temp2);
                            temp2.removeAllElements();
                            temp2 = null;
                            endCount = maxPrePageCount;
                            startCount = endCount >= Query.this.maxResultNum - count ? endCount - (Query.this.maxResultNum - count) : 0;
                        } else {
                            endCount = startCount;
                            startCount = startCount >= Query.this.maxResultNum ? startCount - Query.this.maxResultNum : 0;
                        }
                        --k;
                    }
                    if (temp != null && temp.size() > 0) {
                        temp.removeAllElements();
                        temp = null;
                    }
                    Query.this.queryOver = true;
                    Runtime.getRuntime().gc();
                    break;
                }
            }
        }
    }
}

