/*
 * Decompiled with CFR 0.152.
 */
package net.kbox.component;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.game.GameCanvas;
import net.kbox.ActionController;
import net.kbox.component.KCommand;
import net.kbox.component.Unique;
import net.kbox.exception.NotActionControllerException;

public abstract class KGameCanvas
extends GameCanvas
implements Unique {
    protected final String uniqueID;
    protected ActionController controller;
    protected boolean isPressed;
    protected int keyPressedDelay;
    protected int keyPressedDelayDESC;
    protected int minDelay;
    protected Hashtable cmds = new Hashtable();
    protected PressThread pressThread;

    public String getUniqueID() {
        return this.uniqueID;
    }

    public void addCommand(Command cmd) {
        if (cmd instanceof KCommand) {
            KCommand kcmd = (KCommand)cmd;
            if (!this.cmds.containsKey(kcmd.getUniqueID())) {
                this.cmds.put(kcmd.getUniqueID(), kcmd);
                super.addCommand(cmd);
            } else {
                Command oldCmd = (Command)this.cmds.get(kcmd.getUniqueID());
                this.cmds.put(kcmd.getUniqueID(), kcmd);
                super.removeCommand(oldCmd);
                super.addCommand((Command)kcmd);
            }
        } else {
            super.addCommand(cmd);
        }
    }

    public KCommand getKCommand(String uniqueId) {
        return (KCommand)this.cmds.get(uniqueId);
    }

    public KCommand removeKCommand(String uniqueId) {
        KCommand kcmd = (KCommand)this.cmds.get(uniqueId);
        this.cmds.remove(uniqueId);
        super.removeCommand((Command)kcmd);
        return kcmd;
    }

    public void removeAllKCommand() {
        Enumeration enu = this.cmds.keys();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            KCommand kcmd = (KCommand)this.cmds.get(key);
            super.removeCommand((Command)kcmd);
        }
        this.cmds.clear();
    }

    public KGameCanvas(String uniqueID) {
        super(false);
        this.uniqueID = uniqueID;
        this.keyPressedDelay = 85;
        this.keyPressedDelayDESC = 5;
        this.minDelay = 45;
    }

    public KGameCanvas(String uniqueID, int keyPressedDelay, int keyPressedDelayDESC, int minDelay) {
        super(false);
        this.uniqueID = uniqueID;
        this.keyPressedDelay = keyPressedDelay;
        this.keyPressedDelayDESC = keyPressedDelayDESC;
        this.minDelay = minDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int keyCode) {
        String keyName = this.mapKeyCode(keyCode);
        KGameCanvas kgc = this;
        if (keyName != null) {
            this.controller.keyPressedAction("PRESSED", keyName, kgc);
        } else {
            KGameCanvas kGameCanvas = this;
            synchronized (kGameCanvas) {
                if (this.pressThread == null || !this.pressThread.isAlive()) {
                    this.pressThread = new PressThread(this);
                    this.pressThread.start();
                }
            }
        }
    }

    protected String mapKeyCode(int keyCode) {
        String mapName;
        switch (keyCode) {
            case 48: {
                mapName = "0";
                break;
            }
            case 49: {
                mapName = "1";
                break;
            }
            case 50: {
                mapName = "2";
                break;
            }
            case 51: {
                mapName = "3";
                break;
            }
            case 52: {
                mapName = "4";
                break;
            }
            case 53: {
                mapName = "5";
                break;
            }
            case 54: {
                mapName = "6";
                break;
            }
            case 55: {
                mapName = "7";
                break;
            }
            case 56: {
                mapName = "8";
                break;
            }
            case 57: {
                mapName = "9";
                break;
            }
            case 35: {
                mapName = "#";
                break;
            }
            case 42: {
                mapName = "*";
                break;
            }
            default: {
                mapName = null;
            }
        }
        return mapName;
    }

    protected void keyReleased(int keyCode) {
        this.isPressed = false;
    }

    public void setCommandListener(CommandListener listener) {
        if (!(listener instanceof ActionController)) {
            throw new NotActionControllerException(listener.toString());
        }
        super.setCommandListener(listener);
        this.controller = (ActionController)listener;
    }

    protected class PressThread
    extends Thread {
        KGameCanvas kgc;

        PressThread(KGameCanvas kgc) {
            this.kgc = kgc;
        }

        public void run() {
            int delay = KGameCanvas.this.keyPressedDelay;
            int keyState;
            while ((keyState = KGameCanvas.this.getKeyStates()) != -1) {
                if ((keyState & 4) != 0) {
                    KGameCanvas.this.controller.keyPressedAction("PRESSED", "LEFT", this.kgc);
                } else if ((keyState & 0x20) != 0) {
                    KGameCanvas.this.controller.keyPressedAction("PRESSED", "RIGHT", this.kgc);
                } else if ((keyState & 2) != 0) {
                    KGameCanvas.this.controller.keyPressedAction("PRESSED", "UP", this.kgc);
                } else if ((keyState & 0x40) != 0) {
                    KGameCanvas.this.controller.keyPressedAction("PRESSED", "DOWN", this.kgc);
                } else if ((keyState & 0x100) != 0) {
                    KGameCanvas.this.controller.keyPressedAction("PRESSED", "FIRE", this.kgc);
                } else {
                    return;
                }
                delay = (delay -= KGameCanvas.this.keyPressedDelayDESC) > KGameCanvas.this.minDelay ? delay : KGameCanvas.this.minDelay;
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e.toString());
                }
            }
            return;
        }
    }
}

