/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import wrapper.WrapperMIDlet;

public class Menu
extends Canvas
implements Runnable {
    final int SOFTKEY_LEFT;
    final int SOFTKEY_RIGHT;
    private Image splash;
    private Image icon;
    private XFont f = new XFont();
    private int selected;
    private String[] names;
    private int type;
    private Throwable t;
    private int state;
    private static final int ST_LOAD = 0;
    private static final int ST_SPLASH = 1;
    private static final int ST_MENU = 2;
    private static final int ST_EXIT = 100;
    private static final int COL_WHITE = 0xFFFFFF;
    private static final int COL_BLACK = 0;
    private static final int SOFTKEY_HPAD = 3;
    private static final int SOFTKEY_VPAD = 3;
    private int softkeyHeight;
    private String lsk;
    private String rsk;
    private int screenWidth = 0;
    private int screenHeight = 0;
    private static final int SPLASH_DELAY = 3000;
    private int scrollingPosition = 0;
    private static final int LB = 36;
    private static final int RB = 40;
    static final int IMAGE_LOGO = 0;
    static final int IMAGE_DEMO_LOGO = 1;
    static final int IMAGE_BG = 2;
    static final int IMAGE_ARROW_LEFT = 3;
    static final int IMAGE_ARROW_RIGHT = 4;
    static final int IMAGE_BOX_LEFT = 5;
    static final int IMAGE_BOX_MID = 6;
    static final int IMAGE_BOX_RIGHT = 7;
    static final int MAX_IMAGE = 8;
    private Image[] images = null;
    public static String demoURL;
    static boolean demoEnabled;
    static final String defaultDemoText = "Demo is over";
    static String demoText;
    static String portalURL;
    static String portalText;
    private int TEXT_MENU = 0;
    private int TEXT_SOFTKEY = 1;
    private int TEXT_MOREGAMES = 2;
    private int MAX_TEXT = 3;
    private int TEXT_MENU_MORE_GAMES = 0;
    private int SOFTKEY_OK = 0;
    private int SOFTKEY_BACK = 1;
    private int SOFTKEY_EXIT = 2;
    public static String[][] texts;
    static Bundle bundle;
    public static int lang_sel;
    public static int lang_num;
    public static String[] lang_code;
    public static String[] lang_name;
    private static boolean isLanguagesSelector;
    private static boolean isMultiLanguages;
    public static boolean isDemo;

    public Menu() {
        this.SOFTKEY_LEFT = -6;
        this.SOFTKEY_RIGHT = -7;
        this.setFullScreenMode(true);
    }

    public void keyPressed(int keyCode) {
        switch (this.state) {
            case 2: {
                if (this.isAction(keyCode)) {
                    if (this.names.length - 1 == this.selected) {
                        this.startBrowser(portalURL);
                    } else {
                        WrapperMIDlet.getInstance().executeMIDlet(this.selected);
                    }
                } else if (this.isLeft(keyCode)) {
                    --this.selected;
                    if (this.selected < 0) {
                        this.selected = this.names.length - 1;
                    }
                    this.scrollingPosition = 0;
                } else if (this.isRight(keyCode)) {
                    ++this.selected;
                    if (this.selected >= this.names.length) {
                        this.selected = 0;
                    }
                    this.scrollingPosition = 0;
                }
                if (keyCode == 48 || keyCode == -7) {
                    this.changeState(100);
                }
                this.repaint();
            }
        }
    }

    private boolean isAction(int keyCode) {
        if (keyCode == 53 || keyCode == -6) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 8;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isUp(int keyCode) {
        if (keyCode == 50) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isDown(int keyCode) {
        if (keyCode == 56) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 6;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isLeft(int keyCode) {
        if (keyCode == 50) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isRight(int keyCode) {
        if (keyCode == 54) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 5;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void executionException(int type, Throwable t) {
        this.type = type;
        this.t = t;
        this.repaint();
        this.serviceRepaints();
    }

    public void run() {
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        while (this.state != 100) {
            switch (this.state) {
                case 0: {
                    this.load();
                    this.f.load("/font.png", "/font.xft");
                    this.softkeyHeight = this.f.getHeight() + 6;
                    isLanguagesSelector = false;
                    isMultiLanguages = false;
                    if (!this.isInitializedLanguages()) {
                        isLanguagesSelector = true;
                        if (lang_sel == 0) {
                            lang_sel = 1;
                        }
                        this.loadStrings();
                    } else {
                        this.loadStrings();
                    }
                    WrapperMIDlet wrapper = WrapperMIDlet.getInstance();
                    int count = wrapper.getMIDletCount();
                    this.names = new String[(count > 0 ? count : 3) + 1];
                    for (int i2 = 0; i2 < this.names.length - 1; ++i2) {
                        this.names[i2] = count > 0 ? wrapper.getName(i2) : "Test MIDlet " + i2;
                    }
                    this.names[this.names.length - 1] = texts[this.TEXT_MENU][this.TEXT_MENU_MORE_GAMES];
                    if (1 < lang_num) {
                        isMultiLanguages = true;
                    }
                    if (1 < lang_num && isLanguagesSelector) {
                        this.changeState(2);
                        break;
                    }
                    this.changeState(2);
                    break;
                }
                case 1: {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.changeState(2);
                    break;
                }
                case 2: {
                    this.handleMenu();
                }
            }
        }
        WrapperMIDlet.getInstance().notifyDestroyed();
    }

    private void changeState(int newState) {
        this.state = newState;
        switch (this.state) {
            case 2: {
                this.setSoftkeys(texts[this.TEXT_SOFTKEY][this.SOFTKEY_OK], texts[this.TEXT_SOFTKEY][this.SOFTKEY_EXIT]);
            }
        }
        this.repaint();
        this.serviceRepaints();
    }

    private void setSoftkeys(String lsk, String rsk) {
        this.lsk = lsk != null && lsk.length() > 0 ? lsk : null;
        this.rsk = rsk != null && rsk.length() > 0 ? rsk : null;
    }

    protected void paint(Graphics g2) {
        switch (this.state) {
            case 0: {
                this.paintLoading(g2);
                break;
            }
            case 1: {
                this.paintSplash(g2);
                break;
            }
            case 2: {
                this.paintMenu(g2);
            }
        }
    }

    private void paintLoading(Graphics g2) {
    }

    private void paintSplash(Graphics g2) {
        g2.setColor(0xFFFFFF);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.splash != null) {
            g2.drawImage(this.splash, this.getWidth() / 2, this.getHeight() / 2, 3);
        }
    }

    private void paintMenu(Graphics g2) {
        g2.setColor(0xFFFFFF);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.drawImage(this.images[2], this.screenWidth, 0, 24);
        g2.drawImage(this.images[0], this.screenWidth / 2, 72, 17);
        g2.drawImage(this.images[1], this.screenWidth / 2, 105, 17);
        if (this.t == null) {
            int y = this.screenHeight - (20 + this.softkeyHeight + this.images[3].getHeight());
            g2.drawImage(this.images[3], 8, y, 20);
            g2.drawImage(this.images[4], this.screenWidth - 8, y, 24);
            this.drawLabelBox(g2, 57, y, 126);
            g2.setClip(57, y + 4, 126, this.f.getHeight());
            int tw = this.f.stringWidth(this.names[this.selected]) * 3 / 2;
            this.f.drawString(g2, this.names[this.selected], this.screenWidth / 2 - (this.scrollingPosition + tw), y + 4, 17);
            this.f.drawString(g2, this.names[this.selected], this.screenWidth / 2 - this.scrollingPosition, y + 4, 17);
            this.f.drawString(g2, this.names[this.selected], this.screenWidth / 2 - (this.scrollingPosition - tw), y + 4, 17);
            this.f.drawString(g2, this.names[this.selected], this.screenWidth / 2 - (this.scrollingPosition - tw * 2), y + 4, 17);
            g2.setClip(0, 0, this.screenWidth, this.screenHeight);
        } else {
            this.t.printStackTrace();
            int y = this.getHeight() - 2 - this.f.getHeight() + this.f.getBaseline();
            this.f.drawString(g2, "Type: " + this.type, 2, y - 2 * this.f.getHeight(), 36);
            this.f.drawString(g2, this.t.getClass().getName(), 2, y - this.f.getHeight(), 36);
            this.f.drawString(g2, this.t.getMessage(), 2, y, 36);
            this.f.drawString(g2, this.t.toString(), 2, 2 + this.f.getBaseline(), 36);
        }
        this.paintSoftkeys(g2);
    }

    private void handleMenu() {
        this.scrollingPosition += 4;
        int tw = this.f.stringWidth(this.names[this.selected]) * 3 / 2;
        if (tw < this.scrollingPosition) {
            this.scrollingPosition = 0;
            System.out.println(" sets position 0");
        }
        this.repaint();
        this.serviceRepaints();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void paintSoftkeys(Graphics g2) {
        if (this.lsk != null || this.rsk != null) {
            int fullHeight = super.getHeight();
            int y = fullHeight - 3;
            int top = y - this.softkeyHeight - 3;
            if (this.lsk != null) {
                this.drawLabelBox(g2, -16, y - this.f.getHeight() - 3, this.f.stringWidth(this.lsk) + 16 + 3);
                this.f.drawString(g2, this.lsk, 3, y, 36);
            }
            if (this.rsk != null) {
                this.drawLabelBox(g2, this.getWidth() - this.f.stringWidth(this.rsk) - 3, y - this.f.getHeight() - 3, this.f.stringWidth(this.rsk) + 16 + 3);
                this.f.drawString(g2, this.rsk, this.getWidth() - 3, y, 40);
            }
        }
    }

    private void drawLabelBox(Graphics g2, int x, int y, int len) {
        int iw = this.images[6].getWidth();
        g2.drawImage(this.images[5], x, y, 24);
        g2.drawImage(this.images[7], x + len, y, 20);
        for (int i2 = 0; i2 < len / iw * iw; i2 += iw) {
            g2.drawImage(this.images[6], x + i2, y, 20);
        }
        g2.drawImage(this.images[6], x + len, y, 24);
    }

    public DataInputStream initializeImageFromBNDL(String resource) throws Exception {
        DataInputStream in = null;
        in = new DataInputStream(this.getClass().getResourceAsStream(resource));
        in.readInt();
        return in;
    }

    public Image loadImageFromBNDL(DataInputStream in) throws Exception {
        Image img = null;
        int numBytes = in.readInt();
        byte[] b2 = new byte[numBytes];
        in.readFully(b2);
        img = Image.createImage((byte[])b2, (int)0, (int)numBytes);
        b2 = null;
        return img;
    }

    public void skipImageFromBNDL(DataInputStream in) throws Exception {
        int numBytes = in.readInt();
        in.skipBytes(numBytes);
    }

    public void closeImageFromBNDL(DataInputStream in) throws Exception {
        if (null != in) {
            in.close();
        }
        in = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load() {
        block11: {
            DataInputStream bndl = null;
            this.images = new Image[8];
            bndl = this.initializeImageFromBNDL("/menu.bin");
            for (int i2 = 0; i2 < this.images.length; ++i2) {
                this.images[i2] = this.loadImageFromBNDL(bndl);
            }
            try {
                this.closeImageFromBNDL(bndl);
            }
            catch (Exception e2) {}
            break block11;
            catch (Exception e3) {
                try {
                    e3.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        this.closeImageFromBNDL(bndl);
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    this.closeImageFromBNDL(bndl);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void startBrowser(String urlName) {
        System.out.println("platformRequest: " + urlName);
        try {
            if (null != urlName) {
                Thread.sleep(100L);
                WrapperMIDlet.getInstance().platformRequest(urlName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.terminate();
    }

    public void terminate() {
        try {
            WrapperMIDlet.getInstance().notifyDestroyed();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadStrings() {
        try {
            String lang = lang_code[lang_sel - 1];
            Bundle b2 = null;
            try {
                texts = new String[this.MAX_TEXT][];
                b2 = new Bundle("/text__" + lang + ".txt");
                Menu.texts[this.TEXT_SOFTKEY] = b2.getArray("softkeys");
                Menu.texts[this.TEXT_MENU] = b2.getArray("menu");
                b2 = null;
                b2 = new Bundle("/portal__" + lang + ".txt");
                Menu.texts[this.TEXT_MOREGAMES] = b2.getArray("portal");
                b2 = null;
            }
            catch (Exception e2) {
                System.out.println("loadStrings " + e2);
            }
            Menu.readSpecialFeatures(lang_sel - 1);
        }
        catch (Exception e3) {
            System.out.println("loadStrings " + e3);
        }
    }

    public static void readSpecialFeatures(int sel) {
        block12: {
            System.out.println(" readSpecialFeatures ");
            try {
                bundle = new Bundle("lang.txt");
            }
            catch (Exception e2) {
                System.out.println("file lang.txt not found");
                return;
            }
            demoURL = null;
            try {
                String[] demoArray = bundle.getArray("demo");
                for (int i2 = 0; i2 < demoArray.length; ++i2) {
                    if (demoArray[i2].indexOf("msg__" + lang_code[sel]) != -1 && (demoText = Menu.getKeyValue(demoArray[i2])).length() > 0) {
                        demoEnabled = true;
                    }
                    if (demoArray[i2].indexOf("url__" + lang_code[sel]) == -1) continue;
                    demoURL = Menu.getPropertyURL(Menu.getKeyValue(demoArray[i2]));
                    System.out.println(" demoURL " + demoURL);
                }
            }
            catch (Exception e3) {
                if (demoText != null) break block12;
                demoText = defaultDemoText;
            }
        }
        portalURL = null;
        String portalTag = "portal=";
        try {
            String[] urls = bundle.getArray("urls");
            if (urls != null) {
                for (int i3 = 0; i3 < urls.length; ++i3) {
                    if (urls[i3].indexOf("portal=") != 0) continue;
                    portalURL = Menu.getPropertyURL(Menu.getKeyValue(urls[i3]));
                }
            }
        }
        catch (Exception e4) {
            System.out.println("portal / url not found");
        }
        Menu.cleanBundle();
        String langCode = lang_code[sel];
        try {
            bundle = new Bundle("portal__" + langCode + ".txt");
            portalText = bundle.getArray("portal")[0];
        }
        catch (Exception e5) {
            System.out.println("file portal__" + langCode + ".txt not found");
            return;
        }
        Menu.cleanBundle();
    }

    public static void cleanBundle() {
        if (bundle != null) {
            Menu.bundle.hash.clear();
            bundle = null;
            System.gc();
        }
    }

    public static String getPropertyURL(String value) {
        int pos = value.indexOf("jad:");
        if (pos != 0) {
            return value;
        }
        int pos2 = value.indexOf(124);
        String tag = value.substring(pos + "jad:".length(), pos2);
        value = value.substring(pos2 + 1);
        String valJAD = WrapperMIDlet.getInstance().getAppProperty(tag);
        if (valJAD == null) {
            return value;
        }
        if ((value = value + "&url=" + valJAD).length() > 128) {
            return valJAD;
        }
        return value;
    }

    public static String getKeyValue(String str) {
        return str.substring(str.indexOf("=") + 1, str.length());
    }

    private boolean isInitializedLanguages() {
        this.loadLanguageInfo();
        if (lang_num <= 1) {
            lang_sel = 1;
            return true;
        }
        if (lang_sel == 0) {
            this.initializeLanguages();
            return false;
        }
        return true;
    }

    private void loadLanguageInfo() {
        Bundle b2 = null;
        try {
            try {
                b2 = new Bundle("lang.txt");
            }
            catch (Exception e2) {
                System.out.println("file lang.txt not found");
            }
            String[] content = b2.getArray("lang");
            b2 = null;
            lang_code = new String[content.length];
            lang_name = new String[content.length];
            int next_lang = 0;
            DataInputStream test = null;
            Vector<String> langVec = new Vector<String>();
            for (int i2 = 0; i2 < content.length; ++i2) {
                int pos = content[i2].indexOf(",");
                Menu.lang_code[next_lang] = content[i2].substring(0, pos);
                Menu.lang_name[next_lang] = content[i2].substring(pos + 1, content[i2].length());
                try {
                    test = new DataInputStream(this.getClass().getResourceAsStream("/text__" + lang_code[next_lang] + ".txt"));
                    ((InputStream)test).close();
                    test = null;
                }
                catch (Exception e3) {
                    System.out.println("/text__" + lang_code[next_lang] + ".txt NOT FOUND");
                    continue;
                }
                System.out.println("/text__" + lang_code[next_lang] + ".txt FOUND");
                langVec.addElement(lang_name[next_lang]);
                ++next_lang;
            }
            lang_num = next_lang;
            lang_name = new String[lang_num];
            int count = 0;
            Enumeration e4 = langVec.elements();
            while (e4.hasMoreElements()) {
                Menu.lang_name[count] = (String)e4.nextElement();
                ++count;
            }
            content = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initializeLanguages() {
        String property = System.getProperty("microedition.locale");
        if (property == null) {
            lang_sel = 1;
        } else {
            for (lang_sel = 1; lang_sel <= lang_num && !property.startsWith(lang_code[lang_sel - 1]); ++lang_sel) {
            }
            if (lang_sel >= lang_num + 1) {
                lang_sel = 1;
            }
        }
    }

    static {
        demoEnabled = false;
        bundle = null;
        lang_sel = 0;
        lang_code = null;
        lang_name = null;
        isLanguagesSelector = false;
        isMultiLanguages = false;
        isDemo = false;
    }
}

