/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class XFont {
    final boolean debugColor;
    public static final char WHITE_SPACE = ' ';
    public static final char LINE_BREAK = '|';
    public static final char PAGE_BREAK = '\u00b6';
    int numCol;
    private int color = 0;
    public static final int COL_WHITE = 0;
    public static final int COL_BLACK = 1;
    private byte[][] col_palette;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    private int style;
    private Image[] xfontImg;
    private String characters;
    private int[][] xfontPosition;
    private int[][] xfontRectangles;
    private int[] xfontWidth;
    private int xfontHeight;
    private int xfontBaseline;
    private int xfontWordspace;
    private int xfontTracking;
    private Font systemFont;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    private boolean isXFont = false;
    private static int[] CRCTable;

    public XFont() {
        this(null);
    }

    public XFont(byte[][] palette) {
        this.debugColor = true;
        this.numCol = palette == null ? 1 : palette.length;
        this.col_palette = palette;
        this.systemFont = Font.getFont((int)0, (int)1, (int)8);
        this.style = 0;
    }

    public void setTracking(int xfontTracking) {
        this.xfontTracking = xfontTracking;
    }

    public int getTracking() {
        return this.xfontTracking;
    }

    public void setStyle(int newStyle) {
        if (newStyle == 1 && this.style == 0) {
            ++this.xfontTracking;
        }
        if (newStyle == 0 && this.style == 1) {
            --this.xfontTracking;
        }
        this.style = newStyle;
    }

    public void setColor(int color) {
        if (color > this.numCol - 1) {
            color = 0;
        }
        this.color = color;
    }

    public int getHeight() {
        if (this.isXFont) {
            return this.xfontHeight;
        }
        return this.systemFont.getHeight();
    }

    public int getBaseline() {
        if (this.isXFont) {
            return this.xfontBaseline;
        }
        return this.systemFont.getBaselinePosition();
    }

    public int stringWidth(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        if (this.isXFont) {
            int w = 0;
            for (int i2 = 0; i2 < str.length(); ++i2) {
                char c2 = str.charAt(i2);
                w += this.charWidth(c2) + this.xfontTracking;
            }
            if (this.style == 1) {
                ++w;
            }
            return w - this.xfontTracking;
        }
        return this.systemFont.stringWidth(str);
    }

    public int charWidth(char c2) {
        if (this.isXFont) {
            int w = 0;
            int charIndex = -1;
            w = c2 == ' ' ? this.xfontWordspace : (-1 != (charIndex = this.characters.indexOf(c2)) ? this.xfontWidth[charIndex] : this.systemFont.charWidth(c2));
            return w;
        }
        return this.systemFont.charWidth(c2);
    }

    public void drawString(Graphics g2, String str, int x, int y, int anchor) {
        if (str == null || str.length() == 0) {
            return;
        }
        if (this.isXFont) {
            g2.setColor(0xFFFFFF);
            int charIndex = 0;
            int imageIndex = 0;
            int baseline = this.xfontBaseline;
            int px = x;
            int py = y;
            if ((anchor & 4) == 0) {
                if ((anchor & 1) != 0) {
                    px -= this.stringWidth(str) / 2;
                } else if ((anchor & 8) != 0) {
                    px -= this.stringWidth(str);
                }
            }
            if ((anchor & 0x40) == 0) {
                if ((anchor & 0x10) != 0) {
                    py += baseline;
                } else if ((anchor & 0x20) != 0) {
                    py += -(this.xfontHeight - baseline);
                } else if ((anchor & 2) != 0) {
                    py += this.xfontHeight / 2 - (this.xfontHeight - baseline);
                }
            } else {
                py = y;
            }
            this.saveClip(g2);
            try {
                for (int i2 = 0; i2 < str.length(); ++i2) {
                    int ch;
                    int cw;
                    char c2 = str.charAt(i2);
                    charIndex = this.characters.indexOf(c2);
                    if (c2 == ' ') {
                        px += this.xfontWordspace + this.xfontTracking;
                        continue;
                    }
                    if (-1 != charIndex && null != this.xfontPosition[charIndex]) {
                        for (int n2 = 0; n2 < this.xfontPosition[charIndex].length / 3; ++n2) {
                            imageIndex = this.xfontPosition[charIndex][n2 * 3];
                            int ix = this.xfontPosition[charIndex][n2 * 3 + 1];
                            int iy = this.xfontPosition[charIndex][n2 * 3 + 2];
                            int cx = this.xfontRectangles[imageIndex][0];
                            int cy = this.xfontRectangles[imageIndex][1];
                            cw = this.xfontRectangles[imageIndex][2];
                            ch = this.xfontRectangles[imageIndex][3];
                            this.drawImage(g2, this.xfontImg[this.color], px + ix, py + iy, cx, cy, cw, ch);
                            if (this.style != 1) continue;
                            this.drawImage(g2, this.xfontImg[this.color], px + ix + 1, py + iy, cx, cy, cw, ch);
                        }
                        px += this.xfontWidth[charIndex] + this.xfontTracking;
                        continue;
                    }
                    cw = this.charWidth(c2);
                    ch = this.getHeight();
                    g2.drawChar(c2, px, py, 20);
                    px += cw + this.xfontTracking;
                }
            }
            catch (Exception e2) {
                System.out.println("ex drawString: " + e2.getMessage());
            }
            this.restoreClip(g2);
        } else {
            g2.setFont(this.systemFont);
            if ((anchor & 0x40) == 0) {
                if ((anchor & 2) != 0) {
                    anchor &= 0xFFFFFFFD;
                    anchor |= 0x10;
                    y -= this.systemFont.getHeight() / 2 - 2;
                }
            } else {
                anchor &= 0xFFFFFFBF;
                anchor |= 0x20;
                y += this.getHeight();
            }
            if (this.color == 0) {
                g2.setColor(16751616);
            } else {
                g2.setColor(0x777777);
            }
            g2.drawString(str, x, y, anchor);
        }
    }

    private void drawImage(Graphics g2, Image img, int x, int y, int clipX, int clipY, int clipWidth, int clipHeight) {
        if (this.setClip(g2, x, y, clipWidth, clipHeight)) {
            g2.drawImage(img, x - clipX, y - clipY, 20);
        }
    }

    public void load(String imgURL, String dataURL) {
        try {
            int n2;
            int i2;
            if (null == imgURL || null == dataURL) {
                this.isXFont = false;
                return;
            }
            this.xfontImg = new Image[this.numCol];
            byte[] imgData = this.readResource(imgURL);
            this.xfontImg[0] = Image.createImage((byte[])imgData, (int)0, (int)imgData.length);
            for (int i3 = 1; i3 < this.numCol; ++i3) {
                this.xfontImg[i3] = this.createModifiedImage(imgData, this.col_palette[i3]);
            }
            int len = 0;
            int len2 = 0;
            DataInputStream in = new DataInputStream(this.getClass().getResourceAsStream(dataURL));
            in.readInt();
            this.characters = in.readUTF();
            len = in.readShort();
            this.xfontPosition = new int[len][];
            for (i2 = 0; i2 < len; ++i2) {
                len2 = in.readByte();
                if (len2 == -1) continue;
                this.xfontPosition[i2] = new int[len2 * 3];
                for (n2 = 0; n2 < len2; ++n2) {
                    this.xfontPosition[i2][0 + n2 * 3] = in.readShort();
                    this.xfontPosition[i2][1 + n2 * 3] = in.readByte();
                    this.xfontPosition[i2][2 + n2 * 3] = in.readByte();
                }
            }
            len = in.readShort();
            this.xfontRectangles = new int[len][];
            for (i2 = 0; i2 < len; ++i2) {
                this.xfontRectangles[i2] = new int[4];
                for (n2 = 0; n2 < 4; ++n2) {
                    this.xfontRectangles[i2][n2] = 0xFF & in.readByte();
                }
            }
            len = in.readShort();
            this.xfontWidth = new int[len];
            for (i2 = 0; i2 < len; ++i2) {
                this.xfontWidth[i2] = in.readByte();
            }
            this.xfontHeight = in.readByte();
            this.xfontBaseline = in.readByte();
            this.xfontWordspace = in.readByte();
            this.xfontTracking = in.readByte();
            in.close();
            System.gc();
            this.isXFont = true;
        }
        catch (Exception e2) {
            System.out.println("ex loading font data");
            e2.printStackTrace();
            this.isXFont = false;
        }
    }

    public void unload() {
        this.xfontImg = null;
        this.characters = null;
        this.xfontPosition = null;
        this.xfontRectangles = null;
        this.xfontWidth = null;
        this.systemFont = null;
    }

    public Image createModifiedImage(byte[] b2, byte[] plte) {
        int pos = 0;
        try {
            for (int i2 = 16; i2 < b2.length; ++i2) {
                if (b2[i2 - 3] != 80 || b2[i2 - 2] != 76 || b2[i2 - 1] != 84 || b2[i2 - 0] != 69) continue;
                pos = i2 + 1;
                break;
            }
            byte[] newData = new byte[b2.length];
            System.arraycopy(b2, 0, newData, 0, b2.length);
            System.arraycopy(plte, 0, newData, pos, plte.length);
            int crc = ~XFont.crc32(newData, pos - 4, plte.length + 4);
            pos += plte.length;
            newData[pos++] = (byte)(crc >> 24);
            newData[pos++] = (byte)(crc >> 16);
            newData[pos++] = (byte)(crc >> 8);
            newData[pos] = (byte)crc;
            return Image.createImage((byte[])newData, (int)0, (int)newData.length);
        }
        catch (Exception e2) {
            System.out.println("ex createModifiedImage: " + e2.getMessage());
            e2.printStackTrace();
            return null;
        }
    }

    private void saveClip(Graphics g2) {
        this.clipX = g2.getClipX();
        this.clipY = g2.getClipY();
        this.clipW = g2.getClipWidth();
        this.clipH = g2.getClipHeight();
    }

    private void restoreClip(Graphics g2) {
        g2.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
    }

    private boolean setClip(Graphics g2, int x, int y, int width, int height) {
        int x1 = Math.max(x, this.clipX);
        int y1 = Math.max(y, this.clipY);
        int x2 = Math.min(x + width, this.clipX + this.clipW);
        int y2 = Math.min(y + height, this.clipY + this.clipH);
        int w = x2 - x1;
        int h2 = y2 - y1;
        if (w < 0 || h2 < 0) {
            return false;
        }
        g2.setClip(x1, y1, w, h2);
        return true;
    }

    private byte[] readResource(String location) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(location);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        int len = -1;
        while ((len = in.read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        in.close();
        return baos.toByteArray();
    }

    private char[] wrap(String text, int width) {
        int len = text.length();
        int k2 = 0;
        int lineLen = 0;
        int wordLen = 0;
        int spaceLen = this.charWidth(' ');
        char[] string = text.toCharArray();
        for (int i2 = 0; i2 < len; ++i2) {
            if (string[i2] == ' ') {
                k2 = i2 + 1;
                wordLen = 0;
                if (k2 < len) {
                    while (string[k2] != ' ' && string[k2] != '|' && string[k2] != '\u00b6' && lineLen + wordLen <= width) {
                        wordLen += this.charWidth(string[k2]) + this.xfontTracking;
                        if (++k2 < len) continue;
                    }
                }
                if (lineLen + wordLen + spaceLen > width) {
                    string[i2] = 124;
                } else {
                    lineLen += spaceLen;
                }
            }
            if (string[i2] != '|' && string[i2] != '\u00b6' && string[i2] != ' ') {
                lineLen += this.charWidth(string[i2]) + this.xfontTracking;
                continue;
            }
            if (string[i2] != '|' && string[i2] != '\u00b6') continue;
            lineLen = 0;
        }
        return string;
    }

    public String[][] breakPages(String src, int width, int height) {
        if (height <= 0) {
            height = 10000;
        }
        Vector pages = new Vector();
        Vector<String> lines = new Vector<String>();
        StringBuffer line = new StringBuffer();
        int lineLen = height / this.getHeight();
        char[] string = this.wrap(src, width);
        int len = string.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (string[i2] == '|' || string[i2] == '\u00b6') {
                lines.addElement(line.toString());
                line = new StringBuffer();
                --lineLen;
            } else {
                line.append(string[i2]);
            }
            if (lineLen > 0 && string[i2] != '\u00b6') continue;
            pages.addElement(lines);
            lines = new Vector();
            lineLen = height / this.getHeight();
        }
        lines.addElement(line.toString());
        pages.addElement(lines);
        String[][] texts = new String[pages.size()][];
        for (int i3 = 0; i3 < texts.length; ++i3) {
            Vector v = (Vector)pages.elementAt(i3);
            texts[i3] = new String[v.size()];
            for (int j2 = 0; j2 < texts[i3].length; ++j2) {
                texts[i3][j2] = (String)v.elementAt(j2);
            }
        }
        return texts;
    }

    private static int crc32(byte[] buffer, int start, int count) {
        int crc;
        int i2;
        if (CRCTable == null) {
            CRCTable = new int[256];
            for (i2 = 0; i2 < 256; ++i2) {
                crc = i2;
                for (int j2 = 8; j2 > 0; --j2) {
                    if ((crc & 1) == 1) {
                        crc = crc >>> 1 ^ 0xEDB88320;
                        continue;
                    }
                    crc >>>= 1;
                }
                XFont.CRCTable[i2] = crc;
            }
        }
        i2 = start;
        crc = -1;
        while (count-- != 0) {
            crc = CRCTable[(crc ^ buffer[i2++]) & 0xFF] ^ crc >>> 8;
        }
        return crc;
    }

    public static String valueOf(int number, int figure) {
        String num = String.valueOf(number);
        return figure <= num.length() ? num : ("0000000000000000" + num).substring(16 + num.length() - figure, 16 + num.length());
    }

    public static String replace(String replace, String src) {
        try {
            String tag = "%";
            String temp1 = src.substring(0, src.indexOf("%"));
            String temp2 = src.substring(src.indexOf("%") + 1, src.length());
            return temp1 + replace + temp2;
        }
        catch (Exception e2) {
            return src;
        }
    }

    public String replace(String src, String[] args) {
        return this.replace(new StringBuffer(src), 0, args).toString();
    }

    private StringBuffer replace(StringBuffer src, int pos, String[] args) {
        StringBuffer result = new StringBuffer();
        for (int i2 = pos; i2 < src.length(); ++i2) {
            if ('(' == src.charAt(i2)) {
                this.replace(src, i2 + 1, args);
                --i2;
                continue;
            }
            if (')' == src.charAt(i2)) {
                StringBuffer res = this.replace(result, args);
                src.delete(pos - 1, i2 + 1);
                src.insert(pos - 1, res.toString());
                return res;
            }
            result.append(src.charAt(i2));
        }
        return src;
    }

    private StringBuffer replace(StringBuffer src, String[] args) {
        StringBuffer result = new StringBuffer();
        StringBuffer left = new StringBuffer();
        StringBuffer right = new StringBuffer();
        int sign = 0;
        boolean qestion = false;
        boolean comment = false;
        int pos = 0;
        block17: for (int i2 = 0; i2 < src.length(); ++i2) {
            char c2 = src.charAt(i2);
            if ('\"' == c2) {
                comment = !comment;
                continue;
            }
            if (!comment && ' ' == c2) continue;
            if ('$' == c2) {
                int number = "0123456789".indexOf(src.charAt(++i2));
                switch (pos) {
                    case 0: {
                        if (0 == sign) {
                            left.append(args[number]);
                            break;
                        }
                        right.append(args[number]);
                        break;
                    }
                    case 1: {
                        if (!qestion) break;
                        result.append(args[number]);
                        break;
                    }
                    case 2: {
                        if (qestion) break;
                        result.append(args[number]);
                    }
                }
                continue;
            }
            if ('!' == c2) {
                sign |= 1;
                continue;
            }
            if ('=' == c2) {
                sign |= 2;
                continue;
            }
            if ('<' == c2) {
                sign |= 4;
                continue;
            }
            if ('>' == c2) {
                sign |= 8;
                continue;
            }
            if ('?' == c2) {
                switch (sign) {
                    case 3: {
                        if (0 != right.toString().compareTo(left.toString())) {
                            qestion = true;
                            break;
                        }
                        qestion = false;
                        break;
                    }
                    case 6: {
                        if (0 <= right.toString().compareTo(left.toString())) {
                            qestion = true;
                            break;
                        }
                        qestion = false;
                        break;
                    }
                    case 10: {
                        if (0 >= right.toString().compareTo(left.toString())) {
                            qestion = true;
                            break;
                        }
                        qestion = false;
                        break;
                    }
                    case 4: {
                        if (0 < right.toString().compareTo(left.toString())) {
                            qestion = true;
                            break;
                        }
                        qestion = false;
                        break;
                    }
                    case 8: {
                        if (0 > right.toString().compareTo(left.toString())) {
                            qestion = true;
                            break;
                        }
                        qestion = false;
                        break;
                    }
                    default: {
                        qestion = 0 == right.toString().compareTo(left.toString());
                    }
                }
                pos = 1;
                continue;
            }
            if (':' == c2) {
                pos = 2;
                continue;
            }
            switch (pos) {
                case 0: {
                    if (0 == sign) {
                        left.append(c2);
                        continue block17;
                    }
                    right.append(c2);
                    continue block17;
                }
                case 1: {
                    if (!qestion) continue block17;
                    result.append(c2);
                    continue block17;
                }
                case 2: {
                    if (qestion) continue block17;
                    result.append(c2);
                }
            }
        }
        if (0 == pos) {
            result = left;
        }
        return result;
    }

    public String getLabelString(String str, int width) {
        if (width < this.stringWidth(str)) {
            int w = this.stringWidth("...");
            int count = 0;
            for (int i2 = 0; i2 < str.length() && width >= (w += this.charWidth(str.charAt(i2))); ++i2) {
                ++count;
            }
            return str.substring(0, count) + "...";
        }
        return str;
    }
}

