/*
 *     Copyright (c)2001-2002 DemiVision, LLC. All Rights Reserved.
 *
 * The information contained herein is the CONFIDENTIAL and PROPRIETARY
 *                  information of DemiVision, LLC.
 */

package com.bejeweled2_j2me;

import javax.microedition.lcdui.*;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStoreException;
import java.io.IOException;


/**
 * <tt>DioskilosMIDlet</tt> is the parent class of all game MIDlets running
 * on the <i>Kraken</i> platform. The DioskilosMIDlet is primarily a shell
 * with most functionality being delegated to the <tt>GameEngine</tt>. The
 * DioskilosMIDlet loads and initializes the remainder of the library and
 * application in an indepedent thread so that the application launches as
 * quickly as possible. The startup splash images and progress bar are provided
 * by the <tt>SplashScreen</tt>.<p>
 *
 * Developers should extend DioskilosMIDlet to provide an appropriately named
 * MIDlet for their own application (e.g., HelloWorldMIDlet). The derived MIDlet
 * will be the primary entry point into the application. In most cases, little
 * to no additional functionality will need to be provided in the derived class.
 *
 * @see         SplashScreen
 * @see         GameEngine
 *
 * @author      Barry Sohl
 * @version     0.9.9
 */
class   DioskilosMIDlet extends shell.core.GameMIDlet implements CommandListener, Runnable
{
    /* Data Fields */

    /** Reference to the master <tt>GameEngine</tt>, used in {registerScreens()}. */
    protected GameEngine gameEngine;

    private String appName;                 // MIDlet params

    private Form       errForm;             // Fatal error handling
    private StringItem errStr;
    private Command    exitCmd;

    private Thread loaderThread;            // Aynchronous loading
    private SplashScreen splashScreen;
    private long startTime;

    private static boolean firstStart;
    private static boolean loading;

    private static final int FUNLIGHT_DELAY = 200;

    public DioskilosMIDlet() {
        firstStart = true;
        loading = false;
    }
    
    /**
     * Instantiates a single instance of each system screen and registers it
     * with the <tt>GameEngine</tt>. Developers must override this method if
     * they are extending any of the system screens. In this case, the developer
     * should instantiate their own derived screen and register it instead of the
     * default screen. The overriden method must still register the default
     * screens for all system screens not being customized. This mechanism is
     * required because MIDlets do not allow custom class loaders.
     *
     * @throws  IOException if error occurs registering screen.
     */
    protected void registerScreens() throws IOException
    {}

    /* MIDlet */


    /**
     * Gain control of funlights on the phone.
     */
    private void initFunlights() {
    }

    /**
     * Typically called at application startup or following {pauseApp()}.
     * Note that this method can be called multiple times but that initialization
     * occurs only on the first call. Performs general initialization for the
     * entire application. Loads and/or allocates <i>all</i> resources for the
     * application and starts all threads. Developers should extend this method
     * to provide application specific initialization. <i>Do not override this
     * method</i>.
     */
    public void startApp()
    {
        try
        {
            // Initial start, launch app
            if ( firstStart )
            {
                if(!loading) {
                    loading = true;

                    // Prep splash screen
                    splashScreen = new SplashScreen();
                    splashScreen.init( this );
                    
                    // First splash image must be loaded in main thread
                    splashScreen.titleImage = Image.createImage( StringTable.FILE_ROOT + StringTable.FILE_TITLE );
                    splashScreen.logoImage = Image.createImage( StringTable.FILE_ROOT + "logo.png" );
                    if (Build.SHOW_FLAG_SELECT)
                    {
                        splashScreen.flagImage = Image.createImage( StringTable.FILE_ROOT + "flags.png" );
                        splashScreen.defaultLocale = getAppProperty("microedition.locale");
                    }
                    splashScreen.eaLogo = Image.createImage(Build.EA_LOGO);
                    getDisplay().setCurrent( splashScreen );

                    // Start progress bar
                    startTime = System.currentTimeMillis();
                    splashScreen.start();
                    load();
                } else if((splashScreen != null) && (splashScreen.titleImage != null)) {
                    getDisplay().setCurrent(splashScreen);
                }
            }
            // Only a restart following loss of focus
            else
            {
                gameEngine.start( false, true);

                initFunlights();
            }
       }
        catch ( Exception ex )
        {
            displayErr( ex );
        }
    }

    /**
     * Begine loading process (asynchronous).
     */
    public void load() {
        // Read string table.
        //StringTable.initialize();

        // Start async app load
        loaderThread = new Thread( this );
        loaderThread.start();
    }

    /**
     * Typically called when the application loses focus. Will always be
     * proceeded by a call to {startApp()}. Game loop functionality
     * is paused, however network threads are not. No resources are released.
     * <i>Do not override this method</i>.
     */
    public void pauseApp()
    {
        try
        {
            gameEngine.pause();
        }
        catch ( Exception ex )
        {
            if (Build.DEBUG) gameEngine.writeDebug( StringTable.DBG_DMPA1 , ex );
        }
    }

    /**
     * Called once-only prior to application termination. If termination is
     * optional, a request is made to continue running. Releases all resources.
     * Developers should extend this method to provide application specific
     * cleanup. <i>Do not override this method</i>.
     *
     * @param   unconditional   is termination mandatory?
     * @throws MIDletStateChangeException if continuation request is made.
     */
    public void destroyApp( boolean unconditional ) 
    {
        // Request a stay of execution
        if ( !unconditional )
        {
            //throw new MIDletStateChangeException();
            return;
        }

        // Termination is mandatory, cleanup
        try
        {
            gameEngine.destroy();
        }
        catch ( Exception ex )
        {
            if (Build.DEBUG) gameEngine.writeDebug( StringTable.DBG_DMDA1 , ex );
        }
    }

    /**
     * Displays an error dialog screen in the case of a fatal error.
     *
     * @param   msg     error message.
     */
    private void displayErr( Exception ex )
    {
        String errMsg = StringTable.START_FAILURE + StringTable.ERR_APP_PREFIX +
            appName + StringTable.ERR_APP_SUFFIX + ex;

        errForm = new Form( StringTable.ERROR_TITLE );
        errStr = new StringItem( null, errMsg );
        exitCmd = new Command( StringTable.EXIT_SOFTKEY, Command.EXIT, 0 );

        // Layout interface
        errForm.append( errStr );
        errForm.addCommand( exitCmd );
        errForm.setCommandListener( this );

        getDisplay().setCurrent( errForm );
        
        ex.printStackTrace();
    }

    /* CommandListener */

    /**
     * Handles commands from the fatal error screen. At this point, the user
     * has acknowledged the error, so the application exits. <i>For internal
     * use only</i>.
     *
     * @param   cmd     command being handled.
     * @param   dis     displayable containing command.
     */
    public void commandAction( Command cmd, Displayable dis )
    {
        // Terminate
        if ( cmd == exitCmd )
        {
            try
            {
                destroyApp( true );
                notifyDestroyed();
            }
            catch ( Exception ex )
            {}
        }
    }

    /* Runnable */

    /**
     * Performs application loading and initialization in an independent thread
     * so that splash screen can be displayed as soon as possible. Also allows the
     * splash screen to update the progress bar while loading is in progress.
     */
    public void run()
    {
        // Wait until the Flag select screen is done
        if (Build.SHOW_FLAG_SELECT)
        {
            while (splashScreen.state == SplashScreen.STATE_FLAG_SELECT) 
            {
                try {
                    Thread.sleep(100);
                }
                catch (InterruptedException ex) { }
            }
            startTime = System.currentTimeMillis();
        }
        
        try
        {
            // Read params
            appName = "BEJEWELED";//getAppProperty( StringTable.PROP_APP_NAME );

            // Init everything upfront
            gameEngine = GameEngine.getInstance();
            gameEngine.init( this );

            Thread.yield();         // Allow loading display some time.
            registerScreens();

            // Read persisted settings (must occur last)
            boolean resetWarning = false;
            try {
                gameEngine.getSettings().read();
            } catch(RecordStoreException exception) {
                resetWarning = gameEngine.getSettings().restore(true);
            }

            long elapsed = (System.currentTimeMillis() - startTime);
            long minDuration = (SplashScreen.MIN_DURATION * 2);

            // If app loaded too fast, wait a little
            if ( elapsed < minDuration )
            {
                loaderThread.sleep( (minDuration - elapsed) );
            }

            // Loading done
            postload();
            splashScreen.stop();
            firstStart = false;

            // Ready to rock and roll...
            gameEngine.start( true, true);

            // Display warning if RMS failed...
            if(resetWarning) {
                Dialog.getInstance().showError(
                    gameEngine.getScreenInstance(GameEngine.SCREEN_MAIN),
                    StringTable.RMS_FAILURE);
            }
        }
        catch ( Exception ex )
        {
            displayErr( ex );
        }
    }

    /**
     * Override to handle anything required after all other setup
     * is done but before the splash screen is removed and the
     * game engine is started.
     */
    protected void postload() {}

}

/**/
