package sims2;

//package root;


/**
 * Enumeration class - will be removed upon obfuscation
 */
public final class GameDefines
{
	/*
	 * Public defines
	 */
	/** debug flag */
	public static final boolean DEBUG = false;
	public static final boolean DEBUG_HEAP = false;
	public static final boolean DEBUG_FPS = false;
	public static final boolean DEBUG_COORDINATES = false;
	public static final boolean DEBUG_LOG = false;
	public static final boolean SOFT_KEY_TOOL_TIP = true;
	public static final boolean DEBUG_GET_MONEY = false;

	public static final long DELAY = 35l;   	/** minimum frame time in milliseconds */

	public static final int MILLIS_IN_SEC 				= 1000;
	public static final int TEXT_BOX_MAX_WIDTH 			= 124;
	public static final int TEXT_MAX_LINES_LARGE		= 10;
	public static final int TEXT_MAX_LINES_SMALL		= 14;
	public static final int TEXT_MAX_LINES_LARGE_MENU	= 14;
	public static final int TEXT_MAX_LINES_SMALL_MENU	= 26;

	/*
	 * Game Modes
	 */
	public static final int GAME_MODE_INVALID 					= -1;
	public static final int GAME_MODE_INITIALIZE_APP			= 0;
	public static final int GAME_MODE_LOGO_WAIT					= 1;
	public static final int GAME_MODE_INITIALIZE_START_MENU		= 2;
	public static final int GAME_MODE_INITIALIZE_INTRODUCTION	= 3;
	public static final int GAME_MODE_INITIALIZE_SELECT_A_SIM	= 4;
	public static final int GAME_MODE_START_MENU 				= 5;
	public static final int GAME_MODE_INTRODUCTION				= 6;
	public static final int GAME_MODE_SELECT_A_SIM 				= 7;
	public static final int GAME_MODE_INITIALIZE_GAME 			= 8;
	public static final int GAME_MODE_RUN_GAME 					= 9;
	public static final int GAME_MODE_OBJECT_DIALOG				= 10;
	public static final int GAME_MODE_PAUSE_MENU 				= 11;
	public static final int GAME_MODE_SOCIAL_MENU				= 12;
	public static final int GAME_MODE_CUTSCENE					= 13;
	public static final int GAME_MODE_PAUSE_APP					= 14;
	public static final int GAME_MODE_EXTERNAL 					= 15;

	//Demo Screen
	public static final int GAME_MODE_INITIALIZE_DEMOOVER		= 16;
	public static final int GAME_MODE_DEMOOVER					= 17;

	//#ifdef ENABLE_VODAFONE_DEMO
 	public static final int GAME_MODE_INITIALIZE_DEMO_SPLASH	= 18;
 	public static final int GAME_MODE_DEMO_SPLASH				= 19;
 	public static final int GAME_MODE_INITIALIZE_VODAFONE_DEMOOVER = 20;
 	public static final int GAME_MODE_VODAFONE_DEMOOVER = 21;
 	public static final int GAME_MODE_DEMO_PAUSE_MENU 			= 22;
 	public static final int DICE_HEIGHT				 			= 120;
	//#endif

	/*
	 * Game Flag Bits
	 */
	public static final int GAME_FLAG_WOO_HOO_HAPPENED			= 0;
	public static final int GAME_FLAG_MUSIC_PLAYING 			= 1;
	public static final int GAME_FLAG_SHOW_SIMOLEANS			= 2;
//	public static final int GAME_FLAG_UPDATE_PLAYER				= 3;
	public static final int GAME_FLAG_DECREMENT_NEEDS			= 4;
	public static final int GAME_FLAG_PLAYER_BUSY				= 5;
	public static final int GAME_FLAG_PLAYER_SLEEPING			= 6;
	public static final int GAME_FLAG_PLAYER_DYING				= 7;
	public static final int GAME_FLAG_ANSWER_DOOR 				= 8;
	public static final int GAME_FLAG_DOOR_EVENT 				= 9;
	public static final int GAME_FLAG_DOOR_EVENT_GOOD			= 10;
	public static final int GAME_FLAG_DOOR_OPTION_SELECTED		= 11;
	public static final int GAME_FLAG_WORK_WARNING_DONE			= 12;
	public static final int GAME_FLAG_NO_OPTIONS_AVAIL			= 13;
//	public static final int GAME_FLAG_SHOWER_OCCUPIED			= 14;
	public static final int GAME_FLAG_FRIDGE_IN_USE				= 15;
	public static final int GAME_FLAG_PHONE_RINGING				= 16;
//	public static final int GAME_FLAG_DIALOG_PAL_WHITE			= 17;
	public static final int GAME_FLAG_PURCHASE_OBJECT			= 18;
	public static final int GAME_FLAG_GUITAR_IN_USE				= 19;
	public static final int GAME_FLAG_EXTINGUISHER_IN_USE		= 20;
	public static final int GAME_FLAG_BED_IN_USE				= 21;
	public static final int GAME_FLAG_BWTV_IN_USE				= 22;
	public static final int GAME_FLAG_ACTION_CANCELLED			= 23;
	public static final int GAME_FLAG_ACTION_STOPPED			= 24;
	public static final int GAME_FLAG_PLAYER_ACTION				= 25;
	public static final int GAME_FLAG_PLAYER_WORKING			= 26;
	public static final int GAME_FLAG_PLAYER_FAILING			= 27;
//	public static final int GAME_FLAG_LAST_FLAG					= 31;

	/*
	 * Game Flag Masks
	 */
	public static final int GAME_FLAG_MASK_WOO_HOO_HAPPENED 	= (1 << 0);
	public static final int GAME_FLAG_MASK_MUSIC_PLAYING 		= (1 << 1);
	public static final int GAME_FLAG_MASK_SHOW_SIMOLEANS		= (1 << 2);
//	public static final int GAME_FLAG_MASK_UPDATE_PLAYER		= (1 << 3);
	public static final int GAME_FLAG_MASK_DECREMENT_NEEDS 		= (1 << 4);
	public static final int GAME_FLAG_MASK_PLAYER_BUSY			= (1 << 5);
	public static final int GAME_FLAG_MASK_PLAYER_SLEEPING		= (1 << 6);
	public static final int GAME_FLAG_MASK_PLAYER_DYING			= (1 << 7);
	public static final int GAME_FLAG_MASK_ANSWER_DOOR 			= (1 << 8);
	public static final int GAME_FLAG_MASK_DOOR_EVENT 			= (1 << 9);
	public static final int GAME_FLAG_MASK_DOOR_EVENT_GOOD		= (1 << 10);
	public static final int GAME_FLAG_MASK_DOOR_OPTION_SELECTED	= (1 << 11);
	public static final int GAME_FLAG_MASK_WORK_WARNING_DONE	= (1 << 12);
	public static final int GAME_FLAG_MASK_NO_OPTIONS_AVAIL		= (1 << 13);
//	public static final int GAME_FLAG_MASK_SHOWER_OCCUPIED		= (1 << 14);
	public static final int GAME_FLAG_MASK_FRIDGE_IN_USE		= (1 << 15);
	public static final int GAME_FLAG_MASK_PHONE_RINGING		= (1 << 16);
//	public static final int GAME_FLAG_MASK_DIALOG_PAL_WHITE		= (1 << 17);
	public static final int GAME_FLAG_MASK_PURCHASE_OBJECT		= (1 << 18);
	public static final int GAME_FLAG_MASK_GUITAR_IN_USE		= (1 << 19);
	public static final int GAME_FLAG_MASK_EXTINGUISHER_IN_USE	= (1 << 20);
	public static final int GAME_FLAG_MASK_BED_IN_USE			= (1 << 21);
	public static final int GAME_FLAG_MASK_BWTV_IN_USE			= (1 << 22);
	public static final int GAME_FLAG_MASK_ACTION_CANCELLED		= (1 << 23);
	public static final int GAME_FLAG_MASK_ACTION_STOPPED		= (1 << 24);
	public static final int GAME_FLAG_MASK_PLAYER_ACTION		= (1 << 25);
	public static final int GAME_FLAG_MASK_PLAYER_WORKING		= (1 << 26);
	public static final int GAME_FLAG_MASK_PLAYER_FAILING		= (1 << 27);
//	public static final int GAME_FLAG_MASK_LAST_FLAG			= (1 << 31);

	/** Initial Game/Engine Flag Mask */
	public static final int INIT_GAME_ENGINE_FLAG_MASK			= 0;

	/*
	 * Saved Flag Bits
	 */
	public static final int SAVE_FLAG_PLAYER_MALE 				= 0;
	public static final int SAVE_FLAG_ALARM_SET		 			= 1;
	public static final int SAVE_FLAG_OVEN_ON_FIRE				= 2;
	public static final int SAVE_FLAG_MICROWAVE_ON_FIRE			= 3;
	public static final int SAVE_FLAG_SMOKE_ALARM_RINGING		= 4;
	public static final int SAVE_FLAG_PLAYER_AT_WORK			= 5;
	public static final int SAVE_FLAG_PLAYER_MISSED_WORK		= 6;
//	public static final int SAVE_FLAG_PLAYER_NEVER_MISSED_WORK	= 7;
	public static final int SAVE_FLAG_FRIEND_HELP_RECEIEVED 	= 8;
	public static final int SAVE_FLAG_HAVE_THROWN_PARTY_TODAY	= 9;
	public static final int SAVE_FLAG_STEREO_ON_ROCK			= 10;
	public static final int SAVE_FLAG_DECKS_ON_DANCE			= 11;
//	public static final int SAVE_FLAG_WEDDING_GIFT_RECEIVED		= 12;
//	public static final int SAVE_FLAG_WORK_BONUS_RECEIEVE		= 13;
	public static final int SAVE_FLAG_GOAL_ACHIEVED				= 14;
	public static final int SAVE_FLAG_SOUND_ON					= 15;
//	public static final int SAVE_FLAG_LAST_FLAG					= 31;

	/*
	 * Saved Flag Masks
	 */
	public static final int SAVE_FLAG_MASK_PLAYER_MALE 				= (1 << 0);
	public static final int SAVE_FLAG_MASK_ALARM_SET		 		= (1 << 1);
	public static final int SAVE_FLAG_MASK_OVEN_ON_FIRE				= (1 << 2);
	public static final int SAVE_FLAG_MASK_MICROWAVE_ON_FIRE		= (1 << 3);
	public static final int SAVE_FLAG_MASK_SMOKE_ALARM_RINGING		= (1 << 4);
//	public static final int SAVE_FLAG_MASK_PLAYER_AT_WORK			= (1 << 5);
	public static final int SAVE_FLAG_MASK_PLAYER_MISSED_WORK		= (1 << 6);
//	public static final int SAVE_FLAG_MASK_PLAYER_NEVER_MISSED_WORK	= (1 << 7);
	public static final int SAVE_FLAG_MASK_FRIEND_HELP_RECEIEVED 	= (1 << 8);
	public static final int SAVE_FLAG_MASK_HAVE_THROWN_PARTY_TODAY	= (1 << 9);
	public static final int SAVE_FLAG_MASK_STEREO_ON_ROCK			= (1 << 10);
	public static final int SAVE_FLAG_MASK_DECKS_ON_DANCE			= (1 << 11);
//	public static final int SAVE_FLAG_MASK_WEDDING_GIFT_RECEIVED	= (1 << 12);
//	public static final int SAVE_FLAG_MASK_WORK_BONUS_RECEIEVE		= (1 << 13);
	public static final int SAVE_FLAG_MASK_GOAL_ACHIEVED			= (1 << 14);
	public static final int SAVE_FLAG_MASK_SOUND_ON					= (1 << 15);
//	public static final int SAVE_FLAG_MASK_LAST_FLAG			= (1 << 31);

	/** Saved Flag Mask */
	public static final int INITIAL_SAVED_FLAG_MASK	=// 0;
//		(1 << SAVE_FLAG_PLAYER_NEVER_MISSED_WORK ) |
		(1 << SAVE_FLAG_STEREO_ON_ROCK ) |
		(1 << SAVE_FLAG_DECKS_ON_DANCE );

	/*
	 * Paused Game Defines
	 */
	public static final int PAUSED_MODE_CALL	 		= 0;
	public static final int PAUSED_MODE_WANTS		 	= 1;
	public static final int PAUSED_MODE_JOB_DATA	 	= 2;
	public static final int PAUSED_MODE_FRIENDS	 		= 3;
	public static final int PAUSED_MODE_SKILLS 			= 4;
	public static final int PAUSED_MODE_OPTIONS	 		= 5;
	public static final int PAUSED_MODE_HELP		 	= 6;
	public static final int PAUSED_MODE_MAIN		 	= 7;
//#ifdef ENABLE_VODAFONE_DEMO
 	public static final int PAUSED_MODE_DEMO		 	= 8;
//#endif
	public static final int NUM_PAUSED_MAIN_OPTIONS 	= 7;
	public static final int PAUSED_MAIN_X_OFFSET	 	= 4;
	public static final int PAUSED_MAIN_Y_OFFSET 		= 4;
	public static final int PAUSED_JOB_X_OFFSET	 		= 2;

	public static final int CALL_OPTION_0	 			= 0;
	public static final int CALL_OPTION_1 				= 1;
	public static final int CALL_OPTION_2	 			= 2;
	public static final int CALL_OPTION_3	 			= 3;
	public static final int CALL_OPTION_4	 			= 4;
	public static final int NUM_CALL_MENU_OPTIONS 		= 5;
	public static final int CALL_MENU_YES_NO_UPGRADE 	= 6;
	public static final int CALL_MENU_YES_NO_OBJECT 	= 7;
	public static final int CALL_MENU_TEXT_DISPLAY		= 8;

	public static final int CALL_MENU_TITLE_OFFSET		= 38;
	public static final int WANT_MENU_TITLE_OFFSET		= 40;
	public static final int ABOUT_MENU_TITLE_OFFSET		= 40;
	public static final int ABOUT_MENU_TEXT_OFFSET		= 20;
	public static final int CUT_SCENE_MENU_TEXT_OFFSET	= 20;
	public static final int THROW_PARTY_RESPONSE_Y_POS	= 180;
	public static final int PURCHASE_MENU_TEXT_OFFSET	= 2;

	public static final int NUM_OBJECTS_TO_DISPLAY		= 6;

	public static final int HELP_MENU_0	 				= 0;
	public static final int HELP_MENU_1 				= 1;
	public static final int HELP_MENU_2	 				= 2;
	public static final int HELP_MENU_3	 				= 3;
	public static final int HELP_MENU_4	 				= 4;
	public static final int NUM_HELP_MENU_OPTIONS 		= 5;

	public static final int SOCIAL_MODE_ROOT	 		= 0;
	public static final int SOCIAL_MODE_TALK 			= 1;
	public static final int SOCIAL_MODE_GOSSIP	 		= 2;
	public static final int SOCIAL_MODE_FRIENDLY	 	= 3;
	public static final int SOCIAL_MODE_ROMANTIC	 	= 4;
	public static final int SOCIAL_MODE_RELATIONSHIP	= 5;
	public static final int SOCIAL_MODE_WAIT			= 6;
	public static final int SOCIAL_MODE_INVALID			= -1;

	public static final int GAME_OPTION_SOUND			= 0;
	public static final int GAME_OPTION_CREDITS			= 1;
	public static final int GAME_OPTION_SAVE_GAME	 	= 2;
	public static final int GAME_OPTION_QUIT_GAME	 	= 3;
	public static final int GAME_OPTION_ABOUT 			= 4;
	public static final int NUM_GAME_OPTIONS 			= 5;

	public static final int FRIEND_SPRITE_Y_OFFSET		= 8;
	public static final int FRIEND_REL_SPR_X_OFFSET		= (SKUConsts.ISO_VIEW_WIDTH - 16);
	public static final int FRIEND_SKILL_INFO_OFFSET	= 8;

	/*
	 * Social screen defines
	 */
	public static final int PLAYER_NAME_X_OFFSET		= 10;
	public static final int NPC_NAME_X_OFFSET			= SKUConsts.ISO_VIEW_WIDTH;
	public static final int RELATIONSHIP_X_OFFSET		= 8;
	public static final int NAME_Y_OFFSET				= 8;

	public static final int SOCIAL_REL_SPR_X_OFFSET		= (SKUConsts.ISO_VIEW_WIDTH - 16);
	public static final int ROOMMATE_SPR_X_OFFSET		= -16;
	public static final int SOCIAL_SPRITE_Y_OFFSET		= 24;

	public static final int REACTION_SPRITE_X_OFFSET	= -8;
	public static final int REACTION_SPRITE_Y_OFFSET	= 48;
	public static final int REACTION_SPRITE_Y_MOVE		= 24;

	public static final int PLAYER_SPRITE_X_OFFSET		= 20;
	//#ifdef LARGE
		public static final int NPC_SPRITE_X_OFFSET			= (SKUConsts.ISO_VIEW_WIDTH - 20);
	//#else
//# 	public static final int NPC_SPRITE_X_OFFSET			= 140;
	//#endif
	public static final int SPRITE_Y_OFFSET				= 100;

	/*
	 * Tutorial defines
	 */
	public static final int GOAL_TEXT_0_A 				= 0;	// Goal 0 text - intro text and eat something goal
	public static final int GOAL_TEXT_0_B				= 1;
	public static final int GOAL_TEXT_0_C 				= 2;
	public static final int GOAL_TEXT_0_D 				= 3;
	public static final int GOAL_TEXT_0_E 				= 4;
	public static final int GOAL_TEXT_1_A		 		= 5;	// Goal 1 text - Ben's intro text and talk to Ben goal
	public static final int GOAL_TEXT_1_B		 		= 6;	// Goal 1 text - Ben's intro text and talk to Ben goal
	public static final int GOAL_TEXT_1_C		 		= 7;
	public static final int GOAL_TEXT_1_D				= 8;
	public static final int GOAL_TEXT_1_E 				= 9;
	public static final int GOAL_TEXT_1_F 				= 10;
	public static final int GOAL_TEXT_2_A 				= 11;	// Goal 2 text - Make friends with Ben
	public static final int GOAL_TEXT_3_A 				= 12;	// Goal 3 text - Get Chef job
	public static final int GOAL_TEXT_3_B		 		= 13;
	public static final int GOAL_TEXT_3_C		 		= 14;
	public static final int GOAL_TEXT_4_A	 			= 15;	// Goal 4 text - Get living room upgrade
	public static final int GOAL_TEXT_4_B	 			= 16;
	public static final int GOAL_TEXT_5_A	 			= 17;	// Goal 5 text - Get Head Chef job
	public static final int GOAL_TEXT_5_B	 			= 18;
	public static final int GOAL_TEXT_6_A	 			= 19;	// Goal 6 text - Get Recreation room upgrade
	public static final int GOAL_TEXT_6_B	 			= 20;
	public static final int GOAL_TEXT_6_C	 			= 21;
	public static final int GOAL_TEXT_7_A	 			= 22;	// Goal 7 text - Get Personal Trainer job
	public static final int GOAL_TEXT_8_A	 			= 23;	// Goal 8 text - meet Lorna
	public static final int GOAL_TEXT_8_B	 			= 24;
	public static final int GOAL_TEXT_9_A	 			= 25;	// Goal 9 text - Get Party DJ job
	public static final int GOAL_TEXT_10_A	 			= 26;	// Goal 10 text - Buy Party Room
	public static final int GOAL_TEXT_10_B	 			= 27;
	public static final int GOAL_TEXT_11_A	 			= 28;	// Goal 11 text - Unlock Juice Bar and Decks
	public static final int GOAL_TEXT_12_A	 			= 29;	// Goal 12 text - Throw party to meet Ian
	public static final int GOAL_TEXT_12_B	 			= 30;
	public static final int GOAL_TEXT_13_A	 			= 31;	// Goal 13 text - Get Guitarist job
	public static final int GOAL_TEXT_14_A	 			= 32;	// Goal 14 text - Buy the garden
	public static final int GOAL_TEXT_14_B	 			= 33;
	public static final int GOAL_TEXT_15_A	 			= 34;	// Goal 15 text - Open goal...
	public static final int NUM_GOAL_DIALOGS 			= GOAL_TEXT_15_A;

	/*
	 * Initial Menu Defines
	 */
	//#ifdef LARGE
		public static final int LEGAL_EA_TEXT_Y_OFFSET		= 268;
		public static final int START_MENU_TEXT_Y_OFFSET	= 160;
		public static final int START_MENU_LEGAL_Y_OFFSET	= 276;
		public static final int LOADING_TEXT_Y_OFFSET		= 210;
		public static final int SIM_SELECT_OPT_TEXT_Y_POS 	= 120;
		public static final int SIM_SELECT_TITLE_TEXT_Y_POS = 28;
		public static final int SIM_SELECT_SPRITE_Y_POS		= 60;
	//#elif Nextel
//# 	public static final int LEGAL_EA_TEXT_Y_OFFSET		= 155;
//# 	public static final int START_MENU_TEXT_Y_OFFSET	= 105;
//# 	public static final int START_MENU_LEGAL_Y_OFFSET	= 176;
//# 	public static final int LOADING_TEXT_Y_OFFSET		= 110;
//# 	public static final int SIM_SELECT_OPT_TEXT_Y_POS 	= 100;
//# 	public static final int SIM_SELECT_TITLE_TEXT_Y_POS = 8;
//# 	public static final int SIM_SELECT_SPRITE_Y_POS		= 40;
	//#else
//# 	public static final int LEGAL_EA_TEXT_Y_OFFSET		= 155;
//# 	public static final int START_MENU_TEXT_Y_OFFSET	= 95;
//# 	public static final int START_MENU_LEGAL_Y_OFFSET	= 176;
//# 	public static final int LOADING_TEXT_Y_OFFSET		= 110;
//# 	public static final int SIM_SELECT_OPT_TEXT_Y_POS 	= 100;
//# 	public static final int SIM_SELECT_TITLE_TEXT_Y_POS = 8;
//# 	public static final int SIM_SELECT_SPRITE_Y_POS		= 40;
	//#endif

	public static final int NUM_START_MENU_OPTIONS =
		(shell.Build.VODAFONE) ? 5 : 4;

	public static final int SIM_SELECT_GENDER 			= 0;
	public static final int SIM_SELECT_PALETTE 			= 1;
	public static final int SIM_SELECT_SIGN 			= 2;
	public static final int SIM_SELECT_NAME 			= 3;
	public static final int NUM_SIM_SELECT_OPTIONS		= 4;

	public static final int SIM_SELECT_ARROW_X_OFFSET	= 15;
	public static final int SIM_SELECT_ARROW_Y_OFFSET	= 2;

	public static final int SIM_SELECT_NUM_OPTIONS		= 12;
	public static final int SIM_SELECT_MAX_PALETTES		= 11;

	public static final int SIM_SELECT_SPRITE_X_POS		= (SKUConsts.ISO_VIEW_HALF_WIDTH - 12);

	/*
	 * Dialog Defines
	 */
	public static final int DIALOG_ID_0					= 0;
	public static final int DIALOG_ID_1					= 1;
	public static final int DIALOG_ID_2					= 2;
	public static final int DIALOG_ID_3					= 3;
	public static final int DIALOG_ID_4					= 4;
	public static final int DIALOG_ID_5					= 5;
	public static final int DIALOG_ID_6					= 6;
	public static final int DIALOG_ID_7					= 7;
	public static final int DIALOG_ID_8					= 8;
	public static final int DIALOG_ID_9					= 9;
	public static final int DIALOG_ID_10				= 10;
	public static final int DIALOG_ID_11				= 11;
	public static final int DIALOG_ID_TIME				= 12;
	public static final int DIALOG_ID_DAY				= 13;
	public static final int DIALOG_ID_SOFT_KEY_1		= 14;
	public static final int DIALOG_ID_SOFT_KEY_2		= 15;
	public static final int DIALOG_ID_MONEY				= 16;
	public static final int DIALOG_ID_RESERVED_0		= 17;
	public static final int DIALOG_ID_RESERVED_1		= 18;
	public static final int NUM_DIALOG_IDS				= 19;
	public static final int NUM_DIALOG_STRINGS_IDS		= 12;

	/*
	 * UI defines
	 */
	public static final int DAY_X_OFFSET				= 0;
	//#ifdef LARGE
		public static final int DAY_Y_OFFSET			= 10;
	//#else
//# 	public static final int DAY_Y_OFFSET			= 5;
	//#endif

	public static final int TIME_X_OFFSET				= 6;
	//#ifdef LARGE
		public static final int TIME_Y_OFFSET			= 10;
		public static final int SIMOLEANS_X_OFFSET			= 0;
		public static final int SIMOLEANS_Y_OFFSET			= 262;
	//#else
//# 	public static final int TIME_Y_OFFSET			= 5;
//# 	public static final int SIMOLEANS_X_OFFSET			= 0;
//# 	public static final int SIMOLEANS_Y_OFFSET			= 170;
	//#endif

	public static final int SIMOLEAN_FLASH_TIME			= 40;

	public static final int MOBILE_X_OFFSET				= 10;
	public static final int MOBILE_Y_OFFSET				= 5;

	public static final int SOFT_KEY_TEXT_X_OFFSET		= 4;
	//#ifdef LARGE
		public static int 		SOFT_KEY_TEXT_Y_OFFSET		= SKUConsts.SCREEN_HEIGHT - 21;
	//#else
//# 	public static int 		SOFT_KEY_TEXT_Y_OFFSET		= 194;
	//#endif

	public static final int NEED_BAR_X_POS				= 18;
	public static final int NEED_BAR_Y_POS				= 5;
	public static final int NEED_BAR_X_OFFSET			= 20;
	public static final int NUM_NEED_BAR_FRAMES			= 10;
	public static final int SKILL_BAR_OUTLINE_X_OFFSET	= 2;
	public static final int SKILL_BAR_OUTLINE_Y_OFFSET	= -2;
	public static final int SKILL_BAR_Y_OFFSET			= -40;
	public static final int DROP_SHADOW_OFFSET 			= 1;

	public static final int BOTTOM_ARROW_Y_OFFSET		= -53;

	/*
	 * Save Game defines
	 */
	public static final int SAVE_GAME_ID_1				= 0;
	public static final int NUM_SAVE_GAME_IDS			= 1;
	//public static final String SAVE_GAME_NAME_1			= "Save Slot 1";
	public static final String SAVE_GAME_NAME_1			= "SimSaveGame";

	// To invalidate save data change the version number
	public static final int SAVE_GAME_VERSION_NUM		= 4;

//	public static final int NUM_SAVE_GAME_BYTES 		= 267;
//		0 + 															// num booleans
//		2 + 															// num bytes
//		(1 * 2)															// num shorts
//		(17 * 4) + 														// num ints
//		(1 * 8) + 														// num longs
//		(SimAttributes.NUM_INTERESTS * WorldData.NUM_NPCS) +			// num bytes in m_DiscussedTopics[][]
//		(SimAttributes.NUM_POSSIBLE_WANTS * 2) + 						// num bytes in m_CurrWants[]
//		( (SimAttributes.NUM_NEEDS + SimAttributes.NUM_SKILLS) * 2) + 	// num bytes in m_SimTraits[]
//		(WorldData.NUM_NPCS * 2) + 										// num bytes in m_Relationships[]
//		(WorldData.NUM_NPCS * 8) + 										// num bytes in m_NpcSchedule
//		14 + 1;															// max num bytes m_BuyList Vector can possibly have (+1 for the number of elements)


	public static final int CURSOR_PLUSPLUS		= 0;
	public static final int CURSOR_MINUSMINUS	= 1;
	public static final int CURSOR_DOTDOTDOT	= 2;

} // End of class GameDefines
