package sims2;

//package root;


import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;


//import com.ideaworks3d.debug.Debug;




//#ifdef ENABLE_GAMELOBBY
//# import java.util.Hashtable;
//# import m7.GLMIDlet;
//#endif


import javax.microedition.media.*;
import java.io.*;

public class SimsApp extends
//#ifdef ENABLE_GAMELOBBY
//# GLMIDlet	implements GameLobbyInterface, Runnable
//#else
shell.core.GameMIDlet 		implements Runnable
//#endif
{
	/*
	 * Public methods - Constructors, etc
	 */


	//#ifdef ENABLE_GAMELOBBY
//# 	GameLobbyCanvas			gameLobbyCanvas		= null;
	//#endif

	/**
	 * Constructor
	 *
	 */
	public SimsApp()
	{
		//try	{
		//	isDemo = getAppProperty("Demo").equals("true");
		//}catch(Exception e){
		//}
        isDemo = true;


		s_MIDlet = this;

		m_IsPaused = true;

		/* game canvas */
		SimsCanvas.s_Canvas = new SimsCanvas();

		//#ifdef LOADING_TEXT
		//SimsCanvas.s_Canvas.sLoading = "LOADING...";
		//#endif

		m_PrevGameState = GameDefines.GAME_MODE_INVALID;
		m_CurrGameState = GameDefines.GAME_MODE_INITIALIZE_APP;

		//#ifdef ENABLE_GAMELOBBY
//# 		gameLobbyCanvas = new GameLobbyCanvas(this, Display.getDisplay(this));
//# 		gameLobbyCanvas.setCanvas(SimsCanvas.s_Canvas);
//# 
//# 		gameLobbyCanvas.setBackgroundColor(0);
//# 		Display.getDisplay(this).setCurrent(gameLobbyCanvas);
//# 		gameLobbyCanvas.go();
//# 
		//#else
		/* set canvas as current display */
		getDisplay().setCurrent(SimsCanvas.s_Canvas);
		//#endif

		//#ifndef LARGE
//# 		// push the text down by offset
//# 		int offSet = SimsCanvas.s_Canvas.getHeight() - 210;
		//#ifdef LARGE_SCREEN
//# 		offSet -= (SimsCanvas.s_Canvas.getHeight() - SKUConsts.SCREEN_HEIGHT) / 2;
		//#endif
//# 		if( offSet < 0 ) offSet = 0;
//# 		GameDefines.SOFT_KEY_TEXT_Y_OFFSET += offSet;
		//#endif


	} // end SimsApp constructor

// Player player;
// private class PlayThread implements Runnable{
// public void run(){
// try{
// System.out.println("Playing");
// player.realize();
// player.prefetch();
// player.setLoopCount(-1);
// player.start();
// System.out.println("Played");
// }catch(Exception e){
// e.printStackTrace();
// }
// }
// }
	/**
	 * game thread function
	 *
	 */
	boolean skip = false;
	public void run()
	{
		try
		{
			while(!m_RequestThreadStop)
			{
				/* game loop */
				long frameStart = System.currentTimeMillis();
				int millisSinceLastFrame = (int)(frameStart - m_LastFrameStart);
				m_LastFrameStart = frameStart;

				// System.out.println("m_CurrGameState: " +m_CurrGameState+ "
				// m_SubMenuState: " +m_SubMenuState+ " m_DialogSelectedOption
				// "+m_DialogSelectedOption);
				switch (m_CurrGameState)
				{
				case GameDefines.GAME_MODE_INITIALIZE_APP:
// if (GameDefines.DEBUG_HEAP)
// {
// m_TotalHeap = Runtime.getRuntime().totalMemory();
// }

					/* get data tables first thing */
					System.out.println("Before Load Tables");
					s_CurrBG = null;// vir - prevent menu splash from apearing before EA splash
					LoadTables();

					/* load string table */
					SimsCanvas.s_Canvas.loadStringTable();

					// load the dialog static images (as they are referenced in
					// the dialog system even if not used)
					Dialogue.LoadStaticImages();

					// load the save flags for the sound option
					byte[] data = GetRMSValue(GameDefines.SAVE_GAME_NAME_1);

					// if there was data
					if ( (data != null) &&
						 (data[0] == GameDefines.SAVE_GAME_VERSION_NUM) )
					{
						try
						{
							DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data, 1, data.length - 1) );
							m_SaveFlags = dis.readInt();
							dis.close();
						}
						catch(Exception e)
						{
							if (GameDefines.DEBUG)
								e.printStackTrace();
						}
					}

					// initialize the game variables
					InitGameVariables();

					// load the current splash screen to draw to the BG
					s_CurrBG = Utility.loadImage("splashscreens/ea", false);

					// draw the legal text at bottom of the screen
					m_Dialogs[GameDefines.DIALOG_ID_0] =
						new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.EA_LEGAL_TEXT), false, 0,
										GameDefines.LEGAL_EA_TEXT_Y_OFFSET, Colors.BLACK, (Graphics.TOP | Graphics.HCENTER) );

					m_GameTimer = (System.currentTimeMillis() + SimAttributes.ROOM_LOGO_DISPLAY_TIME);
					SwitchGameState(GameDefines.GAME_MODE_LOGO_WAIT);

					//#ifdef LOADING_TEXT
					SimsCanvas.s_Canvas.sLoading = null;
					//#endif

					SimsCanvas.s_Canvas.m_IsInitialised = true;

					break;

				case GameDefines.GAME_MODE_LOGO_WAIT:
					if (m_GameTimer < System.currentTimeMillis() )
					{
						if (m_PrevGameState == GameDefines.GAME_MODE_INITIALIZE_APP)
						{
							// load the current splash screen to draw to the BG
							s_CurrBG = Utility.loadImage("splashscreens/maxis", false);

							// draw the legal text at bottom of the screen
							m_Dialogs[GameDefines.DIALOG_ID_0] = null;
							m_Dialogs[GameDefines.DIALOG_ID_0] =
								new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.MAXIS_LEGAL_TEXT), false, 0,
												GameDefines.LEGAL_EA_TEXT_Y_OFFSET, Colors.BLACK, (Graphics.TOP | Graphics.HCENTER) );

							m_GameTimer = (System.currentTimeMillis() + SimAttributes.ROOM_LOGO_DISPLAY_TIME);
							SwitchGameState(GameDefines.GAME_MODE_LOGO_WAIT);

							// Load the sounds.
							Utility.loadAllSounds();



// //attempt to play a sound
// try{
// //InputStream streamSounds =
// (this.getClass()).getResourceAsStream("/bgm.mid");
// byte [] clip=null;
// clip = (byte[])Midp2SoundEngine.getInstance().soundData.elementAt(0);
// InputStream streamSounds = (InputStream) new ByteArrayInputStream(clip);
// player = Manager.createPlayer(streamSounds,"audio/midi");
// streamSounds.close();
// new Thread(new PlayThread()).start();
// }catch(Exception e){
// e.printStackTrace();
// }
						}
						else
						{
							m_Dialogs[GameDefines.DIALOG_ID_0] = null;
							SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_START_MENU);
						}
					}
					break;

				case GameDefines.GAME_MODE_INITIALIZE_START_MENU:
					InitInitialMenusOptions(m_CurrGameState);
					SwitchGameState(GameDefines.GAME_MODE_START_MENU);
					break;

				case GameDefines.GAME_MODE_INITIALIZE_INTRODUCTION:
					InitInitialMenusOptions(m_CurrGameState);
					SwitchGameState(GameDefines.GAME_MODE_INTRODUCTION);
					break;

				case GameDefines.GAME_MODE_INITIALIZE_DEMOOVER:
					InitInitialMenusOptions(m_CurrGameState);
					SwitchGameState(GameDefines.GAME_MODE_DEMOOVER);
					break;
//#ifdef ENABLE_VODAFONE_DEMO
 				case GameDefines.GAME_MODE_INITIALIZE_VODAFONE_DEMOOVER:
 					InitInitialDemoMenusOptions(m_CurrGameState);
 					SwitchGameState(GameDefines.GAME_MODE_VODAFONE_DEMOOVER);
 					break;
 
 				case GameDefines.GAME_MODE_INITIALIZE_DEMO_SPLASH:
 					InitInitialDemoMenusOptions(m_CurrGameState);
 					SwitchGameState(GameDefines.GAME_MODE_DEMO_SPLASH);
 					break;
 				case GameDefines.GAME_MODE_DEMO_SPLASH:
 					Dialogue.UpdateStaticDialogue();
 					m_DialogSelectedOption = Dialogue.s_dialogue.GetSelection();
 					DoInitialMenus(m_CurrGameState);
 					break;
 
 				case GameDefines.GAME_MODE_VODAFONE_DEMOOVER:
 					Dialogue.UpdateStaticDialogue();
 					m_DialogSelectedOption = Dialogue.s_dialogue.GetSelection();
 					DoInitialMenus(m_CurrGameState);
 					break;
 
//#endif
				case GameDefines.GAME_MODE_INITIALIZE_SELECT_A_SIM:
					InitInitialMenusOptions(m_CurrGameState);
					SwitchGameState(GameDefines.GAME_MODE_SELECT_A_SIM);
					break;

				case GameDefines.GAME_MODE_DEMOOVER:
					Dialogue.UpdateStaticDialogue();
					m_DialogSelectedOption = Dialogue.s_dialogue.GetSelection();
					DoInitialMenus(m_CurrGameState);
					break;

				case GameDefines.GAME_MODE_SELECT_A_SIM:
					m_PlayerSim.Tick(millisSinceLastFrame);
				case GameDefines.GAME_MODE_START_MENU:
				case GameDefines.GAME_MODE_INTRODUCTION:
					Dialogue.UpdateStaticDialogue();
					m_DialogSelectedOption = Dialogue.s_dialogue.GetSelection();
					DoInitialMenus(m_CurrGameState);
					break;

				case GameDefines.GAME_MODE_INITIALIZE_GAME:
					// force a garbage collection to get rid of extraneous boot
					// up data and
					// clears out the Sim data from the Create-A-Sim menu
					CallGC();

					// mask the NPCs as not in the house
					m_LockFlags |= WorldData.INITIAL_NPC_LOC_FLAG_MASK;

					// load Sim Object static images now
					SimObject.LoadStaticImages();

					// initialize the panels
					SimsCanvas.s_Canvas.InitPanels();

					// Load the resources.
					LoadIsoResources();

					SwitchGameState(GameDefines.GAME_MODE_RUN_GAME);
					m_Dialogs[GameDefines.DIALOG_ID_0] = null;
					break;

				case GameDefines.GAME_MODE_RUN_GAME:
					if(Dialogue.s_dialogueActive)
					{
						Dialogue.UpdateStaticDialogue();
						m_PlayerSim.Tick(millisSinceLastFrame);

						// reset the game timer and phone ringing if it was
						// animating
						if (!Dialogue.s_dialogueActive)
						{
							m_GameTimer = System.currentTimeMillis();

							if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PHONE_RINGING) != 0)
							{
								m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_PHONE_RINGING;
							}
						}
					}
					else
					{
						// Execute the game functionality.
						m_GameTimeElapsed = System.currentTimeMillis() - m_GameTimer;
						m_GameTimer = System.currentTimeMillis();
						UpdateGameTimers();
						UpdateGameLogic();
						HandleGameInput();

						// Update the game data.
						UpdateIsoResources(millisSinceLastFrame);

						// clear the woo hoo flag as anything that needed it has
						// gone by
						m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_WOO_HOO_HAPPENED;
					}

					UpdateMoneyDisplay();
					UpdatePhoneFrame();
					break;

				case GameDefines.GAME_MODE_OBJECT_DIALOG:
					// game pauses while doing a dialog
					Dialogue.UpdateStaticDialogue();

					if (!Dialogue.s_dialogueActive)
					{
						int selection = Dialogue.s_dialogue.GetSelection();

						// Has an option apart from cancel been selected?
						if ( (selection < (m_DialogNumOptions - 1) ) &&
							 (selection >= 0) )
						{
							// Are we activating a different object or currently
							// idle
							// or have we made a different selection
							if((m_NextObject != m_CurrentObject) ||
								(m_CurrActionNum != selection) ||
								((m_GameFlags & GameDefines.GAME_FLAG_MASK_ACTION_CANCELLED) != 0))
							{
								if(m_CurrentObject != null)
								{
									StopAction(true, true);
								}
								// Setup new interaction
								m_CurrentObject = m_NextObject;
								m_SecondaryObject = House.s_LotSingleton.GetItem(
									GetSecondaryItemGuid(m_NextObject.m_GuId) );
								m_CurrItemId = m_NextObject.m_GuId;

								if (m_CurrItemId == WorldData.ITEM_FRONT_DOOR)
								{
									// Using this boolean flag to tell the
									// system that the door
									// dialog has happened & an option other
									// than can
									m_GameFlags |= GameDefines.GAME_FLAG_MASK_DOOR_OPTION_SELECTED;
								}

								m_CurrActionNum = selection;
								m_GameFlags |= GameDefines.GAME_FLAG_MASK_PLAYER_ACTION;
								m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_ACTION_CANCELLED;
								m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_ACTION_STOPPED;
							}
						}
						// Cancel was selected, was it on the current object?
						else if(m_NextObject == m_CurrentObject)
						{
							CancelAction();
							m_GameFlags |= GameDefines.GAME_FLAG_MASK_ACTION_CANCELLED;
						}

						// reset the phone ringing animation and move back to
						// the game state
// if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PHONE_RINGING) != 0)
// {
// m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_PHONE_RINGING;
// }

						SwitchGameState(GameDefines.GAME_MODE_RUN_GAME);
					}

					UpdateMoneyDisplay();
					UpdatePhoneFrame();
					break;
//#ifdef ENABLE_VODAFONE_DEMO
 				case GameDefines.GAME_MODE_DEMO_PAUSE_MENU:
 					Dialogue.UpdateStaticDialogue();
 					DoDemoPauseMenu();
 
 					break;
//#endif

				case GameDefines.GAME_MODE_PAUSE_MENU:
					Dialogue.UpdateStaticDialogue();
					DoPauseMenu();

					// Draw the ++/--/...
					DrawRelationshipChangeSprites(SKUConsts.ISO_VIEW_WIDTH, GameDefines.REACTION_SPRITE_Y_OFFSET);
					break;

				case GameDefines.GAME_MODE_SOCIAL_MENU:
					Dialogue.UpdateStaticDialogue();
					if (!Dialogue.s_dialogueActive && !(SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK) ))
					{
						m_DialogSelectedOption = Dialogue.s_dialogue.GetSelection();
						HandleSocialMenuOptions();
					}
					// if the back button was pressed, return to the previous
					// menu
					else if ( (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK) ) )
					{
						if(m_SocialMenuState == GameDefines.SOCIAL_MODE_ROOT)
						{
							Dialogue.s_dialogueActive = false;
							ExitSocialMenu();
						}
						else
						{
							Dialogue.s_dialogueActive = false;
							InitSocialRootMenu(false);
						}
					}

					// Draw the ++/--/...
					DrawRelationshipChangeSprites(SKUConsts.ISO_VIEW_WIDTH, GameDefines.REACTION_SPRITE_Y_OFFSET);
					break;

				case GameDefines.GAME_MODE_CUTSCENE:
					Dialogue.UpdateStaticDialogue();
					HandleCutsceneInput();

					// Draw the ++/--/...
					DrawRelationshipChangeSprites(SKUConsts.ISO_VIEW_WIDTH, GameDefines.REACTION_SPRITE_Y_OFFSET);
					break;

				case GameDefines.GAME_MODE_PAUSE_APP:
					if ( (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.FIRE) ) ||
						 (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.ACCEPT) ) ||
						 (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK) ) )
					{
						// clear out string
						m_Dialogs[GameDefines.DIALOG_ID_RESERVED_0] = null;
						m_Dialogs[GameDefines.DIALOG_ID_RESERVED_1] = null;

						// restore the previous menu
						m_CurrGameState = m_PauseGameState;

						// reset the gameTimer
						m_GameTimer = System.currentTimeMillis();

						// reset the BG
						s_CurrBG = s_OldBG;
					}
					break;

				default:
					break;
				}

// if (GameDefines.DEBUG_FPS)
// {
// Temp_PrintFPSStatus(frameStart, millisSinceLastFrame);
// }

// if (GameDefines.DEBUG_HEAP)
// {
// TempPrintHeapStatus();
// }


				// Finish the frame.
				//#ifdef FRAME_SKIP
//# 					if( !skip ){
//# 						SimsCanvas.s_Canvas.repaint();
//# 						SimsCanvas.s_Canvas.serviceRepaints();
//# 					}
//# 					skip = !skip;
				//#else
					SimsCanvas.s_Canvas.repaint();
					SimsCanvas.s_Canvas.serviceRepaints();
				//#endif

				// clear the key state for the next loop
				SimsCanvas.s_Canvas.updateKeyState(false);

				// Yield.
				while(System.currentTimeMillis()-frameStart < GameDefines.DELAY)
					Thread.yield();

				// Move the game time forward.
				if( (m_CurrGameState == GameDefines.GAME_MODE_RUN_GAME) ||
					(m_CurrGameState == GameDefines.GAME_MODE_SOCIAL_MENU) )
				{
					m_GameTime += System.currentTimeMillis()-frameStart;
				}
			}

			// Free thread (another one can begin)
			m_RequestThreadStop = false;
			m_Thread = null;
		}
		catch(Exception e)
		{
			if (GameDefines.DEBUG)
				e.printStackTrace();

			// sometimes an out of memory exception is thrown, so call a garbage
			// collection in case
			CallGC();
		}

	} // end run

	/**
	 * Load the player sprite into the map
	 *
	 *
	 */
	public void LoadPlayer()
	{
		// if player is already loaded, remove the billboard
		if (m_PlayerSim != null)
		{
			m_PlayerSim = null;
			CallGC();
		}

		int genderIndex = ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_PLAYER_MALE) != 0) ? 1 : 0;

		int appearanceIndex = m_PlayerPalette % appearanceGuids[genderIndex].length;
		int appearanceGuid = appearanceGuids[genderIndex][appearanceIndex];

		// Create the player sim (the visitor generator object should take care
		// of creating the others.)
		m_PlayerSim = new SimObject(0, appearanceGuid, true, m_PlayerName);
		m_PlayerSim.SetFacing(0);
		m_PlayerSim.SetXPos(27-8);
		m_PlayerSim.SetYPos(9);
	}

	public int GetNumSkillPoints(int skillId)
	{
		if( skillId >= SimAttributes.FIRST_SKILL &&
			skillId <= SimAttributes.LAST_SKILL )
		{
			return m_SimTraits[skillId] >> 12;
		}

		// Failed.
		return -1;
	}

	public int GetNeedValue(int needId)
	{
		if( needId >= SimAttributes.FIRST_NEED &&
			needId <= SimAttributes.LAST_NEED )
		{
			// This is 1.7.8 fixed point.
			return m_SimTraits[needId];
		}

		// Failed.
		return -1;
	}

	public void RemoveNPCFromMap(int npcId)
	{
		House.s_LotSingleton.RemoveObject(m_NpcObjects[npcId]);
		m_NpcObjects[npcId] = null;
		m_NpcSchedule[npcId] = 0;
		m_NpcsInHouse--;

		// Unlock our NPCs location
		if(m_NpcLocations[npcId] != WorldData.NPC_LOC_INVALID)
		{
			m_LockFlags |= (long)1 << m_NpcLocations[npcId];
			m_NpcLocations[npcId] = WorldData.NPC_LOC_INVALID;
		}
	} // end RemoveNPCFromMap

	/*
	 * Protected methods - application functions
	 */

	/**
	 * Destroy app override
	 *
	 */
	public void destroyApp(boolean unconditional) 
	{
		// Terminate all threads
		SetPausedState(true);
		notifyDestroyed();

	} // end destroyApp

	/**
	 * Pause app override
	 *
	 */
	public static boolean pauseNotRun = true;
	public void pauseApp()
	{
		//#ifdef ENABLE_GAMELOBBY
//# 		if (gameLobbyCanvas != null)
//# 			gameLobbyCanvas.stop();
		//#endif


		//System.out.println("pauseApp");
		if( m_CurrGameState != GameDefines.GAME_MODE_EXTERNAL ){
			SetPausedState(true);
		}

	} // end pauseApp

	/**
	 * application lifecycle
	 *
	 */
	public void startApp()
	{

		//#ifdef ENABLE_GAMELOBBY
//# 
//# 		Display theDisplay = Display.getDisplay(this);
//# 		// do gamelobby checks
//# // if (gameLobbyCanvas == null)
//# // {
//# // gameLobbyCanvas = new GameLobbyCanvas(this, theDisplay);
//# // gameLobbyCanvas.setCanvas(SimsCanvas.s_Canvas);
//# //
//# // gameLobbyCanvas.setBackgroundColor(0);
//# // theDisplay.setCurrent(gameLobbyCanvas);
//# // gameLobbyCanvas.go();
//# //
//# // bypassStartApp();
//# //
//# //
//# // }
//# // else
//# 		if (gameLobbyCanvas != null && !GameLobbyCanvas.initialized())
//# 		{
//# 			gameLobbyCanvas.stop();
//# 			gameLobbyCanvas.go();
//# 			theDisplay.setCurrent(gameLobbyCanvas);
//# 
//# 		}
//# 		else
        //#endif
	 	//	bypassStartApp();

// // If not installed from JAD then
// String installed = getAppProperty("Installed-Properly");
// if ((installed == null) || !installed.equals("true"))
// {
// Alert alert = new Alert("Installed incorrectly", "Install from JAD, not JAR",
// null, AlertType.ERROR);
// alert.setTimeout(Alert.FOREVER);
// Display.getDisplay(this).setCurrent(alert);
//
//
// return;
// }
//
// SetPausedState(false);

	} // end startApp


	public void bypassStartApp()
    {
        // If not installed from JAD then
        //String installed = getAppProperty("Installed-Properly");
        //if ((installed == null) || !installed.equals("true"))
        //{
        //    Alert alert = new Alert("Installed incorrectly", "Install from JAD, not JAR", null, AlertType.ERROR);
        //    alert.setTimeout(Alert.FOREVER);
        //    getDisplay().setCurrent(alert);
        //
        //
        //    return;
        //}
        Display theDisplay = getDisplay();
        theDisplay.setCurrent( SimsCanvas.s_Canvas );
		SetPausedState(false);
		
		//vir
		if (m_CurrGameState == GameDefines.GAME_MODE_RUN_GAME)
		{
			s_OldBG = s_CurrBG;
			s_CurrBG = Utility.loadImage("splashscreens/Sims2Logo", true);
		}
		
		SimsCanvas.s_Canvas.repaint();
		SimsCanvas.s_Canvas.serviceRepaints();

    }




	/*
	 * Game Lobby Interface Methods
	 */

	//#ifdef ENABLE_GAMELOBBY
//#     public Vector returnScoreVector(Hashtable arg0) {
//#     	return createScoresVector(arg0);
//# 
//#     }
//# 	protected void rxData(Hashtable arg0)
//# 	{
//# 	  if(gameLobbyCanvas!=null)
//# 	   gameLobbyCanvas.rxData(arg0);
//# 
//# 	}
//# 
//# 
//# 	public void returnFromGamelobby(){
//# 	   if( m_CurrGameState == GameDefines.GAME_MODE_EXTERNAL ){
//# 			SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_START_MENU);
//# 	   }
//# 	}
//#    public void statusChanged(int iTaskCompleted) {
//# 		/*
//# 		 * HANDLE THE STATUS CHANGE WHEN THE GLCANVAS DOES NOT TAKE CONTROL
//# 		 *
//# 		 */
//# 
//# 		System.out.println("statusChanged");
//# 	}
//# 
//# 
	//#endif



	/*
	 * Private Utility methods
	 */

	/**
	 * Pause/resume the game
	 *
	 * @param pauseNotRun
	 *            True if we want to pause, false if we want to resume
	 */
	public void SetPausedState(boolean pauseNotRun)
	{
		// Only do something if we need to change state
		if (pauseNotRun != m_IsPaused)
		{
			// Change state
			m_IsPaused = pauseNotRun;
			//Debug.println("SetPausedState called: " + pauseNotRun);

			// Implement pause/unpause
			if (pauseNotRun)
			{
				// Only allow to go to paused state from other states,
				// else we lose state to return to.
				if (m_CurrGameState == GameDefines.GAME_MODE_RUN_GAME)
				{
					
					// move to the pause mode
					m_PauseGameState = m_CurrGameState;
					m_CurrGameState = GameDefines.GAME_MODE_PAUSE_APP;

					// show the paused string with a box
					m_Dialogs[GameDefines.DIALOG_ID_RESERVED_0] = null;
					m_Dialogs[GameDefines.DIALOG_ID_RESERVED_0] =
						new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.PAUSE_TEXT), false, 0, GameDefines.LOADING_TEXT_Y_OFFSET,
										Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.HCENTER) );

					// display the soft key for going back
					m_Dialogs[GameDefines.DIALOG_ID_RESERVED_1] = null;
					m_Dialogs[GameDefines.DIALOG_ID_RESERVED_1] =
						new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.BACK), false,
										(SKUConsts.ISO_VIEW_WIDTH - GameDefines.SOFT_KEY_TEXT_X_OFFSET),
										GameDefines.SOFT_KEY_TEXT_Y_OFFSET, Style.DIALOGUE_MAIN_TEXT_COLOR,
										(Graphics.TOP | Graphics.RIGHT) );
					m_Dialogs[GameDefines.DIALOG_ID_RESERVED_1].m_font = Dialogue.FONT_PROP_SMALL;
					m_Dialogs[GameDefines.DIALOG_ID_RESERVED_1].DoLayout();
				}

				// Sort out the fire alarm.
				if( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_SMOKE_ALARM_RINGING) != 0)
				{
					m_SaveFlags &= ~GameDefines.SAVE_FLAG_MASK_SMOKE_ALARM_RINGING;
				}

				Utility.stopAllSound();

				// Tell thread to die
				m_RequestThreadStop = true;

				// Notify system
// notifyPaused();
			}
			else	// Resume required
			{
				// wait until last thread is dead
				while (m_Thread != null)
				{
					Thread.yield();
				}
                
                if (m_CurrGameState == GameDefines.GAME_MODE_PAUSE_APP)
				{
                    s_OldBG = s_CurrBG;
                    s_CurrBG = Utility.loadImage("splashscreens/Sims2Logo", true);
                }

				/* game thread */
				m_Thread = new Thread(this);
				m_Thread.start();

// resumeRequest();
			}
		}

	}

	/**
	 * Play sound wrapper function
	 *
	 * @param soundId
	 * @param count
	 */
	private void PlaySound(int soundId, int count)
	{
		if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_SOUND_ON) != 0)
		{
			Utility.playSound(soundId, false, count);
		}
	}

	/**
	 * Gets the saved data from RMS using the given name (the name will need to
	 * be some preset identifier such as Save_1)
	 *
	 * @param name
	 * @return
	 */
	private static byte[] GetRMSValue(String name)
	{
		try
		{
			RecordStore store = RecordStore.openRecordStore(name, false);

			for(RecordEnumeration e = store.enumerateRecords(null, null, false); e.hasNextElement(); )
			{
				byte[] rec = e.nextRecord();
				store.closeRecordStore();
				return rec;
			}

			store.closeRecordStore();
		}
		catch(Exception e)
		{
			if (GameDefines.DEBUG)
			{
				e.printStackTrace();
			}
		}

		return null;

	} // end getValue

	/**
	 * Sets the saved data to RMS using the given name and byte array containing
	 * the data (the name will need to be some preset identifier such as Save_1)
	 *
	 * @param name
	 * @param b
	 * @return
	 */
	private static void SetRMSValue(String name, byte[] b)
	{
		DeleteRMSValue(name);

		if (b != null)
		{
			try
			{
				RecordStore store = RecordStore.openRecordStore(name, true);
				store.addRecord(b, 0, b.length);
				store.closeRecordStore();
			}
			catch(Exception e)
			{
				if (GameDefines.DEBUG)
					e.printStackTrace();
			}
		}

	} // end setValue

	/**
	 * Deletes the RMS Save data with the given name
	 *
	 * @param name
	 */
	private static void DeleteRMSValue(String name)
	{
		try
		{
			RecordStore.deleteRecordStore(name);
		}
		catch(Exception e)
		{
			if (GameDefines.DEBUG)
			{
				e.printStackTrace();
			}
		}

	} // end deleteRMSValue

	/**
	 * Load the game state variables
	 *
	 */
	public boolean LoadGameState()
	{
		int i;

		// Get the data that was saved into RMS
		byte[] data = GetRMSValue(GameDefines.SAVE_GAME_NAME_1);

		// if there was data
		if ( (data != null) &&
			 (data[0] == GameDefines.SAVE_GAME_VERSION_NUM) )
		{
			try
			{
				DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data, 1, data.length - 1) );

				// start with the booleans
				// next do the bytes
				// next do the shorts

				// next do the ints
				m_SaveFlags = dis.readInt();
				m_NpcFlags = dis.readInt();
				m_CurrDay = dis.readInt();
				m_CurrHour = dis.readInt();
				m_CurrMin = dis.readInt();
				m_Simoleans = dis.readInt();
				m_CurrGoal = dis.readInt();
				m_CurrJob = dis.readInt();
				m_NextJob = dis.readInt();
				m_WorkStartDay = dis.readInt();
				m_PlayerName = dis.readInt();
				m_PlayerSign = dis.readInt();
				m_PlayerPalette = dis.readInt();
				m_SpouseNpcId = dis.readInt();
				m_RoommateNpcId = dis.readInt();
				m_HungerCounter = dis.readInt();
				m_SuffocationCounter = dis.readInt();
				m_GoalPosition = dis.readInt();

				// next do the longs
				m_LockFlags = dis.readLong();

				// next do the special arrays
				// double byte array
				for (i = 0; i < SimAttributes.NUM_INTERESTS; i++)
				{
					for (int j = 0; j < WorldData.NUM_NPCS; j++)
					{
						m_DiscussedTopics[i][j] = dis.readByte();
					}
				}

				// short array
				for (i = 0; i < SimAttributes.NUM_POSSIBLE_WANTS; i++)
					m_CurrWants[i] = dis.readShort();

				// short array
				for (i = 0; i < (SimAttributes.NUM_NEEDS + SimAttributes.NUM_SKILLS); i++)
					m_SimTraits[i] = dis.readShort();

				// short array
				for (i = 0; i < WorldData.NUM_NPCS; i++)
					m_Relationships[i] = dis.readShort();

				// long array
				for (i = 0; i < WorldData.NUM_NPCS; i++)
					m_NpcSchedule[i] = dis.readLong();

				// finally convert the vector for the buy list (it really just
				// stores bytes)
				int numElements = dis.read();

				// make sure the vector is clean (no left overs from
				// initialization
				m_BuyList.removeAllElements();

				for (i = 0; i < numElements; i++)
					m_BuyList.addElement(new Integer(dis.read()));

				dis.close();
				return true;
			}
			catch (Exception e)
			{
				if (GameDefines.DEBUG)
				{
					e.printStackTrace();
				}
			}
		}

		return false;

	} // end LoadGameState

	/**
	 * Save the current game state
	 *
	 */
	private void SaveGameState()
	{
		try
		{
			int i;

			ByteArrayOutputStream bos = new ByteArrayOutputStream();
			DataOutputStream dos = new DataOutputStream(bos);

			// copy the data into a byte array to write to the RMS starting with
			// the version number
			dos.write(GameDefines.SAVE_GAME_VERSION_NUM);

			// start with the booleans
			// next do the bytes
			// next do the shorts

			// next do the ints
			dos.writeInt(m_SaveFlags);
			dos.writeInt(m_NpcFlags);
			dos.writeInt(m_CurrDay);
			dos.writeInt(m_CurrHour);
			dos.writeInt(m_CurrMin);
			dos.writeInt(m_Simoleans);
			dos.writeInt(m_CurrGoal);
			dos.writeInt(m_CurrJob);
			dos.writeInt(m_NextJob);
			dos.writeInt(m_WorkStartDay);
			dos.writeInt(m_PlayerName);
			dos.writeInt(m_PlayerSign);
			dos.writeInt(m_PlayerPalette);
			dos.writeInt(m_SpouseNpcId);
			dos.writeInt(m_RoommateNpcId);
			dos.writeInt(m_HungerCounter);
			dos.writeInt(m_SuffocationCounter);
			dos.writeInt(m_GoalPosition);

			// next do the longs
			dos.writeLong(m_LockFlags);

			// next do the special arrays
			// double byte array
			for (i = 0; i < SimAttributes.NUM_INTERESTS; i++)
				for (int j = 0; j < WorldData.NUM_NPCS; j++)
					dos.write(m_DiscussedTopics[i][j]);

			// short array
			for (i = 0; i < SimAttributes.NUM_POSSIBLE_WANTS; i++)
				dos.writeShort(m_CurrWants[i]);

			// short array
			for (i = 0; i < (SimAttributes.NUM_NEEDS + SimAttributes.NUM_SKILLS); i++)
				dos.writeShort(m_SimTraits[i]);

			// short array
			for (i = 0; i < WorldData.NUM_NPCS; i++)
				dos.writeShort(m_Relationships[i]);

			// long array
			for (i = 0; i < WorldData.NUM_NPCS; i++)
				dos.writeLong(m_NpcSchedule[i]);

			dos.write(m_BuyList.size());

			// finally convert the vector for the buy list (it really just
			// stores bytes)

			for (Enumeration e = m_BuyList.elements(); e.hasMoreElements(); )
				dos.write(( (Integer)e.nextElement() ).intValue());

			// write the data to the RMS (for now there is only one save game)
			SetRMSValue(GameDefines.SAVE_GAME_NAME_1, bos.toByteArray());

			dos.close();
			bos.close();
		}
		catch(IOException e)
		{
			if (GameDefines.DEBUG)
			{
				e.printStackTrace();
			}
		}

		//#ifdef ENABLE_GAMELOBBY
//# 		SimsCanvas.s_Canvas.bNoPause = true;
//# 		gameLobbyCanvas.sendGameData(  (m_CurrDay*24*60)+(m_CurrHour*60)+m_CurrMin, true );
		//#endif

	} // end SaveGameState

	/**
	 * Load all the data tables stored in the resource folder (These data tables
	 * are pre-compiled and stored in the t file)
	 *
	 */
	private void LoadTables()
	{
		try
		{
			DataInputStream dis = new DataInputStream(getClass().getResourceAsStream("/sims2" + "/t") );

			/*
			 * read the int tables
			 */
			ITEM_APP_DATA = read1dInt(dis);
			NPC_APP_DATA = read1dInt(dis);

			/*
			 * read the short tables
			 */
			ITEM_ACTION_TABLE = read3dShort(dis);

// ROOM_POSITION_STRING_DATA = read2dShort(dis);

			ITEM_COST = read1dShort(dis);
			ROOM_COST = read1dShort(dis);
			PLAYER_INTERESTS = read1dShort(dis);


			/*
			 * read the byte tables
			 */
// ROOM_POSITION_DATA = read3dByte(dis);

			NPC_POSITION_DATA = read2dByte(dis);
			ITEM_DATA_TABLE = read2dByte(dis);
// ROOM_NUM_DATA = read2dByte(dis);
			JOB_DATA = read2dByte(dis);
			NPC_JOB_DATA = read2dByte(dis);
			NPC_VISITING_TIME = read2dByte(dis);
			SOCIAL_SCORES = read2dByte(dis);
			NPC_RELATIONSHIP_THRESHOLDS = read2dByte(dis);

			dis.close();
		}
		catch (Exception e)
		{
			if (GameDefines.DEBUG)
			{
				e.printStackTrace();
			}
		}

	} // end LoadTables

	/**
	 * utility method to read short array from stream
	 *
	 */
	public static short[] readShorts(DataInputStream dis, int length) throws IOException
	{
		short[] shorts = new short[length];

		for(int i = 0; i < length; i++)
			shorts[i] = dis.readShort();

		return shorts;
	}

	/**
	 * Read a 1-dimensional int array from the given output stream
	 *
	 * @param dis
	 * @return
	 * @throws IOException
	 */
	private static int[] read1dInt(DataInputStream dis) throws IOException
	{
		int[] a = new int[dis.readInt()];

		for(int i = 0; i < a.length; i++)
		{
			a[i] = dis.readInt();
		}

		return a;
	}

	/**
	 * Read a 2-dimensional int array from the given output stream
	 *
	 * @param dis
	 * @return
	 * @throws IOException
	 */
	/*
	 * private static int[][] read2dInt(DataInputStream dis) throws IOException {
	 * int[][] a = new int[dis.readInt()][];
	 *
	 * for(int i = 0; i < a.length; i++) { a[i] = read1dInt(dis); }
	 *
	 * return a; }
	 */

	/**
	 * Read a 3-dimensional int array from the given output stream
	 *
	 * @param dis
	 * @return
	 * @throws IOException
	 */
	/*
	 * private static int[][][] read3dInt(DataInputStream dis) throws
	 * IOException { int[][][] a = new int[dis.readInt()][][];
	 *
	 * for(int i = 0; i < a.length; i++) { a[i] = read2dInt(dis); }
	 *
	 * return a; }
	 */

	/**
	 * Read a 1-dimensional short array from the given output stream
	 *
	 * @param dis
	 * @return
	 * @throws IOException
	 */
	private static short[] read1dShort(DataInputStream dis) throws IOException
	{
		short[] a = new short[dis.readShort()];

		for(int i = 0; i < a.length; i++)
		{
			a[i] = dis.readShort();
		}

		return a;
	}

	/**
	 * Read a 2-dimensional short array from the given output stream
	 *
	 * @param dis
	 * @return
	 * @throws IOException
	 */
	private static short[][] read2dShort(DataInputStream dis) throws IOException
	{
		short[][] a = new short[dis.readShort()][];

		for(int i = 0; i < a.length; i++)
		{
			a[i] = read1dShort(dis);
		}

		return a;
	}

	/**
	 * Read a 3-dimensional short array from the given output stream
	 *
	 * @param dis
	 * @return
	 * @throws IOException
	 */
	private static short[][][] read3dShort(DataInputStream dis) throws IOException
	{
		short[][][] a = new short[dis.readShort()][][];

		for(int i = 0; i < a.length; i++)
		{
			a[i] = read2dShort(dis);
		}

		return a;
	}

	/**
	 * Read a 1-dimensional Byte array from the given output stream
	 *
	 * @param dis
	 * @return
	 * @throws IOException
	 */
	private static byte[] read1dByte(DataInputStream dis) throws IOException
	{
		byte[] a = new byte[dis.readByte()];

		for(int i = 0; i < a.length; i++)
		{
			a[i] = dis.readByte();
		}

		return a;
	}

	/**
	 * Read a 2-dimensional Byte array from the given output stream
	 *
	 * @param dis
	 * @return
	 * @throws IOException
	 */
	private static byte[][] read2dByte(DataInputStream dis) throws IOException
	{
		byte[][] a = new byte[dis.readByte()][];

		for(int i = 0; i < a.length; i++)
		{
			a[i] = read1dByte(dis);
		}

		return a;
	}

	/**
	 * Read a 3-dimensional Byte array from the given output stream
	 *
	 * @param dis
	 * @return
	 * @throws IOException
	 */
	/*
	 * private static byte[][][] read3dByte(DataInputStream dis) throws
	 * IOException { byte[][][] a = new byte[dis.readByte()][][];
	 *
	 * for(int i = 0; i < a.length; i++) { a[i] = read2dByte(dis); }
	 *
	 * return a; }
	 */

	/**
	 *
	 */
	private int GetLeftRightOption(int curOption, int startOption, int numOptions, boolean wrapOk)
	{
		int newOption = curOption;

		if (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.LEFT) )
		{
			newOption--;

			if (newOption < startOption)
			{
				if (wrapOk)
				{
					newOption = (startOption + numOptions - 1);
				}
				else
				{
					newOption = curOption;
				}
			}
		}
		else
		{
			newOption++;

			if (newOption > (startOption + numOptions - 1) )
			{
				if (wrapOk)
				{
					newOption = startOption;
				}
				else
				{
					newOption = curOption;
				}
			}
		}

		return(newOption);

	} // end GetLeftRightOption

	private void CallGC()
	{
		int gcTimer = 1000;

		System.gc();

		// force a 1000ms wait to clean up
		while (gcTimer > 0)
		{
			gcTimer--;
		}

	}

	/**
	 * Temporary function to show the fps status in text.
	 * <p>
	 * This writes over the dialog strings - do not call when in dialogs.
	 * </p>
	 * TODO: Remove this function when done debugging
	 */
	/*
	 * private void Temp_PrintFPSStatus(long start, long millisSinceLastFrame) {
	 * if ( (m_CurrGameState == GameDefines.GAME_MODE_RUN_GAME) || (
	 * (m_CurrGameState == GameDefines.GAME_MODE_PAUSE_MENU) && (m_MenuState !=
	 * GameDefines.PAUSED_MODE_FRIENDS) && (m_MenuState !=
	 * GameDefines.PAUSED_MODE_JOB_DATA) ) || (m_CurrGameState ==
	 * GameDefines.GAME_MODE_SOCIAL_MENU) || (m_CurrGameState ==
	 * GameDefines.GAME_MODE_CUTSCENE) ) { // Count millis elapsed since last
	 * frame m_MillisThisSecond -= millisSinceLastFrame;
	 *
	 * if (m_MillisThisSecond <= 0) { if ( (m_FramesThisSecond !=
	 * m_FramesPerSecond) || (m_Dialogs[GameDefines.DIALOG_ID_RESERVED_0] ==
	 * null) ) { int yPos = 150;
	 *
	 * if (!(m_CurrGameState == GameDefines.GAME_MODE_RUN_GAME) ) { yPos = 175; }
	 *
	 * m_Dialogs[GameDefines.DIALOG_ID_RESERVED_0] = null;
	 * m_Dialogs[GameDefines.DIALOG_ID_RESERVED_0] = new Dialogue(("FPS: " +
	 * m_FramesPerSecond), false, GameDefines.SOFT_KEY_TEXT_X_OFFSET, yPos,
	 * Colors.BLACK, (Graphics.TOP | Graphics.LEFT) );
	 *
	 * m_FramesPerSecond = m_FramesThisSecond; }
	 *
	 * m_MillisThisSecond = GameDefines.MILLIS_IN_SEC; m_FramesThisSecond = 0; }
	 *
	 * m_FramesThisSecond++; }
	 *  }
	 */ // end Temp_PrintFPSStatus

	/*
	 * private void TempPrintHeapStatus() { long freeHeap =
	 * Runtime.getRuntime().freeMemory();
	 *
	 * long totalUsage = m_TotalHeap - freeHeap;
	 *
	 * if (totalUsage != m_CurrentHeap) { m_CurrentHeap = totalUsage;
	 *
	 * int yPos = 12;
	 *
	 * m_Dialogs[GameDefines.DIALOG_ID_RESERVED_1] = null;
	 * m_Dialogs[GameDefines.DIALOG_ID_RESERVED_1] = new Dialogue( ("Heap used: " +
	 * m_CurrentHeap), false, 0, yPos, Colors.BLACK, (Graphics.TOP |
	 * Graphics.LEFT) );
	 *
	 * m_Dialogs[GameDefines.DIALOG_ID_MONEY] = null;
	 * m_Dialogs[GameDefines.DIALOG_ID_MONEY] = new Dialogue( ("Free memory: " +
	 * freeHeap), false, 0, (yPos + 12), Colors.BLACK, (Graphics.TOP |
	 * Graphics.LEFT) ); }
	 *  }
	 */ // end TempPrintHeapStatus

	/*
	 * Game logic specific utility methods
	 */

	private void LoadIsoResources()
	{
		// Make sure that the level is set correctly.
		// This is the number of leading zeros of the flags.
		long check = m_LockFlags >> SimAttributes.ROOM_LIVINGROOM;
		for(m_Level = 0; m_Level < SimAttributes.NUM_ROOMS-SimAttributes.ROOM_LIVINGROOM; ++m_Level, check >>= 1)
		{
			if((check & 0x01) == 1)
				break;
		}

		LoadHouse();
		LoadPlayer();

		House.s_LotSingleton.AddObject(m_PlayerSim);
	}

	/**
	 * Loads the house data
	 *
	 *
	 */
	private void LoadHouse()
	{
		int tilesetGuid = 34558;

		// Create the tileset.
		MapTileSet tileset = new MapTileSet(tilesetGuid);

		int lotNum = 0;
		int lotGuid = 34560 + m_Level;
		int objectsGuid = 34565 + m_Level;

		// Create the lot (and it's objects).
		House.CreateLot(lotGuid, lotNum, objectsGuid, tileset);
	}

	private void UpdateIsoResources(int time)
	{
		m_PlayerSim.Tick(time);

		// run through the NPCs and do their ticks as well if they are in the
		// lot
		for (int i = 0; i < WorldData.NUM_NPCS; i++)
		{
			if (m_NpcObjects[i] != null)
			{
				// Get the npc to idle if he's bored.
				m_NpcTimers[i] -= time;

				// Checking IsBusy ensures the NPC is not leaving
				if((m_NpcTimers[i] < 0) && (!m_NpcObjects[i].IsBusy())) // &&
																		// (!m_NpcObjects[i].GetIsAnimRunning())
				{
					m_NpcCount[i]--;
					if(m_NpcCount[i] < 0)
					{
						m_NpcCount[i] = SimAttributes.ITCHY_FEET_COUNT_MIN + Utility.RandomRange(SimAttributes.ITCHY_FEET_COUNT_MAX);
						MoveNpc(i, GetValidNpcLocation());
					}
					else
					{
						// Reset and idle.
						m_NpcTimers[i] = SimAttributes.IDLE_DELAY;
						m_NpcObjects[i].ControlAnimation(SimObject.ANIM_ID_IDLE, true, AnimationEffect.NONE);
					}
				}

				// Do this last as we might remove the NPC from the world and
				// set m_NpcObjects[i] = null
				m_NpcObjects[i].Tick(time);
			}
		}

		House.s_LotSingleton.Update(time);
	}

	/**
	 * Gets a valid NPC location if one is available,
	 *
	 * @return valid location or -1 if none are available
	 */
	private int GetValidNpcLocation()
	{
		// Find out how many rooms are available.
		int numRooms = 0;
		long flags = m_LockFlags;
		while(((flags & 0x01) == 0) && (numRooms < SimAttributes.NUM_ROOMS))
		{
			numRooms++;
			flags >>= 1;
		}

		// Find out how many locations are available.
		int maxNpcLoc = 0;
		switch(numRooms)
		{
		case 4:
			maxNpcLoc = WorldData.NPC_LOC_LIVINGROOM_2;
			break;
		case 5:
			maxNpcLoc = WorldData.NPC_LOC_RECROOM_2;
			break;
		case 6:
			maxNpcLoc = WorldData.NPC_LOC_PARTYROOM_6;
			break;
		case 7:
			maxNpcLoc = WorldData.NPC_LOC_GARDEN_2;
			break;
		default:
			maxNpcLoc = WorldData.NPC_LOC_BEDROOM;
			break;
		}

		//Debug.debugAssert(maxNpcLoc >= WorldData.FIRST_NPC_LOC);
		//Debug.debugAssert(maxNpcLoc <= WorldData.LAST_NPC_LOC);

		// Return a random unoccupied location.
		// NB This will infinite loop if there aren't any.
		int location = -1;
		do
		{
			location = Math.abs(Utility.m_Random.nextInt() );
			location %= (maxNpcLoc-WorldData.FIRST_NPC_LOC);
			location += WorldData.FIRST_NPC_LOC;

		} while(GetNPCAtLocation(location) != WorldData.NPC_INVALID);

		return location;
	}

	/**
	 * Exits the game and closes all associated data as needed
	 *
	 */
	public void ExitGame(boolean exitToTitle)
	{
	//#ifndef ENABLE_VODAFONE_DEMO
		if(isDemo){
		//	SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_DEMOOVER);
			demoOver = true;
            exitToTitle = false;
		//	//return;
		}
		//else{
	//#endif

			InvalidateStrings();

			// if we are exiting to the title screen, then re-initialize the
			// variables and go to title screen
			if (exitToTitle)
			{
				// Clean out the canvas.
				InitGameVariables();
				SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_START_MENU);
				CallGC();
			}
			// otherwise exit the application
			else
			{
				//try
				//{
					this.destroyApp(true);
				//}
				//catch (MIDletStateChangeException e)
				//{
				//	if (GameDefines.DEBUG)
				//		e.printStackTrace();
				//}
			}
//#ifndef ENABLE_VODAFONE_DEMO
		//}
//#endif

	} // end ExitGame

	/**
	 * Initialize all game logic related variables
	 *
	 */
	private void InitGameVariables()
	{
		int i;

		// Setup action queue
		m_CurrentAction = ACTION_INVALID;
		m_ActionQueue = new Vector();

		m_NpcTimers = new int[WorldData.NUM_NPCS];
		for(int j = 0; j < m_NpcTimers.length; ++j)
			m_NpcTimers[j] = SimAttributes.IDLE_DELAY;

		m_NpcCount = new int[WorldData.NUM_NPCS];
		for(int j = 0; j < m_NpcCount.length; ++j)
			m_NpcCount[j] = SimAttributes.ITCHY_FEET_COUNT_MIN + Utility.RandomRange(SimAttributes.ITCHY_FEET_COUNT_MAX);

		m_SocialMenuState = GameDefines.SOCIAL_MODE_INVALID;
		m_MainPauseMenuSelection = GameDefines.PAUSED_MODE_CALL;

		// store the current sound state to preserve it
		boolean soundOn = ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_SOUND_ON) != 0);

		// set up the boolean flags
		m_GameFlags	= GameDefines.INIT_GAME_ENGINE_FLAG_MASK;
		m_SaveFlags = GameDefines.INITIAL_SAVED_FLAG_MASK;
		m_NpcFlags = WorldData.INITIAL_NPC_FLAG_MASK;

		if (GameDefines.DEBUG)
			m_LockFlags = 0;
		else
			m_LockFlags = WorldData.INITIAL_LOCKED_FLAG_MASK;

		// update the sound flag if it was turned on (as the sound is not in the
		// default flags!)
		if (soundOn)
		{
			m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_SOUND_ON;
		}

// START:DiscussedTopics#
		// The npc boredom factors.
		m_DiscussedTopics = new byte[SimAttributes.NUM_INTERESTS][WorldData.NUM_NPCS];
// END

		// Reset spouse and roommate.
		m_SpouseNpcId = WorldData.NPC_INVALID;
		m_RoommateNpcId = WorldData.NPC_INVALID;
		m_NPCAtDoor = WorldData.NPC_INVALID;

		// Create and set the relationships - leave them at zero for the moment.
		m_Relationships = new short[WorldData.NUM_NPCS];

		// Set up the NPC location array - leave them at zero for the moment.
		m_NpcLocations = new short[WorldData.NUM_NPCS];
		m_NpcObjects = new SimObject[WorldData.NUM_NPCS];

		// Variable for storing npcs invited over or coming to a party.
		m_NpcsComing = new short[WorldData.NUM_NPCS];

		// create the Sim need and skill arrays
		m_SimTraits = new short[SimAttributes.NUM_NEEDS + SimAttributes.NUM_SKILLS];

		// Create npc schedules.
		m_NpcSchedule = new long[WorldData.NUM_NPCS];

		// initialize the needs
		m_SimTraits[SimAttributes.NEED_HUNGER]	= SimAttributes.NEED_HUNGER_INIT_VAL;
		m_SimTraits[SimAttributes.NEED_HYGIENE]	= SimAttributes.NEED_HYGIENE_INIT_VAL;
		m_SimTraits[SimAttributes.NEED_BLADDER]	= SimAttributes.NEED_BLADDER_INIT_VAL;
		m_SimTraits[SimAttributes.NEED_FUN] 	= SimAttributes.NEED_FUN_INIT_VAL;
		m_SimTraits[SimAttributes.NEED_SOCIAL] 	= SimAttributes.NEED_SOCIAL_INIT_VAL;
		m_SimTraits[SimAttributes.NEED_ENERGY] 	= SimAttributes.NEED_ENERGY_INIT_VAL;

		// set the need timer
		m_NeedWarningWaitTimer 	= SimAttributes.NEED_WARNING_WAIT_TIME;
		m_NeedWarningTimer		= SimAttributes.NEED_WARNING_TIME;

		// set the need failure variables
		m_HungerCounter = 0;
		m_SuffocationCounter = 0;

		// set up the action variables
		m_CurrItemId = WorldData.INVALID_ITEM_ID;
		m_CurrActionNum = WorldData.ACTION_0;
		m_CurrActionState = WorldData.ACTION_STATE_PRE_INIT;

		// set up the dialog variables
		m_DialogStringIds = new short[GameDefines.NUM_DIALOG_STRINGS_IDS];
		m_Dialogs = new Dialogue[GameDefines.NUM_DIALOG_IDS];

		// set up the time variables
		m_CurrDay = WorldData.DEFAULT_DAY;
		m_CurrHour = WorldData.DEFAULT_HOUR;
		m_CurrMin = WorldData.DEFAULT_MIN;

		// set up the initial simoleans
		if (GameDefines.DEBUG_GET_MONEY)
		{
			m_Simoleans = 50000;
		}
		else
		{
			m_Simoleans = WorldData.NUM_STARTING_SIMOLEANS;
		}

		// initialize the goals to the first goal
		m_CurrGoal = SimAttributes.GOAL_0;

		// initialize the job data
		m_CurrJob = WorldData.JOB_NONE;
		m_NextJob = WorldData.JOB_NONE;

		// initialize the failure state to the maximum state
		m_WarningFailureState = SimAttributes.WARN_FAILURE_MAX;

		// create the new buy vector
		m_BuyList = new Vector();

		// initialize general logic variables
		m_GoalPosition	= GameDefines.GOAL_TEXT_0_A;
		m_DoorEventHour = 0;

		// initialize the sprite variables

		// This is a relative timer for events.
		m_GameTime = 0;

		// initialize the wants
		m_CurrWants = new short[SimAttributes.NUM_POSSIBLE_WANTS];

		for (i = 0; i < SimAttributes.NUM_POSSIBLE_WANTS; i++)
		{
			m_CurrWants[i] = SimAttributes.WANT_INVALID;
		}

		// initialize the sprite arrays
		s_RoommateSpriteIcons = new Image[WorldData.NUM_NPCS];
		s_FriendshipSpriteIcons = new Image[WorldData.NUM_NPCS];
		s_RoommateSpritePos = new int[WorldData.NUM_NPCS][2];
		s_FriendshipSpritePos = new int[WorldData.NUM_NPCS][2];

		m_SkillBarSpriteFrames = -1;


	} // end InitializeGameVariables

	/**
	 * Updates the game clock based off the given parameters
	 *
	 * @param days
	 * @param hours
	 * @param minutes
	 */
	private void UpdateClock(int days, int hours, int minutes)
	{
		// adjust the values
		m_CurrMin += minutes;
		m_CurrHour += hours;
		m_CurrDay += days;

		// check for overflow of minutes
		while ( (m_CurrMin - WorldData.NUM_MIN_PER_HOUR) >= 0)
		{
			m_CurrMin -= WorldData.NUM_MIN_PER_HOUR;
			m_CurrHour++;
		}

		// check for overflow of hours
		while ( (m_CurrHour - WorldData.NUM_HOUR_PER_DAY) >= 0)
		{
			m_CurrHour -= WorldData.NUM_HOUR_PER_DAY;
			m_CurrDay++;
		}

		// check for overflow of days
		while ( (m_CurrDay - WorldData.NUM_DAYS_PER_WEEK) >= 0)
		{
			m_CurrDay -= WorldData.NUM_DAYS_PER_WEEK;
		}

	} // end UpdateClock

	/**
	 * Updates the game logic as needed
	 *
	 */
	private void UpdateGameLogic()
	{
		UpdateBusyFlag();

		// Process the current action.
		switch(m_CurrentAction)
		{
		case ACTION_INVALID:
			// Get the next action from the queue.
			m_CurrentAction = GetNextAction();
			break;

		case ACTION_ADD_NPC:
			if (!House.s_LotSingleton.IsSpaceOccupied(WorldData.NPC_FRONT_DOOR_X_POS, WorldData.NPC_FRONT_DOOR_Y_POS) )
			{
				// Only let the npc in when the coast is clear.
				AddNpc(m_Param1, m_Param2);
				m_CurrentAction = ACTION_INVALID;
			}
			break;
		}

		// if the Sim has died, do the Sim Death code and move on
		if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_DYING) != 0)
		{
			// for now just exits the application
			ExitGame(true);
			return;
		}

// NOTE: This must remain above the update time, or it will speed up even if job
// isn't selected!!
		// if the player has chosen the door, and we are just returning from the
		// selection dialog, do the selection
		if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_DOOR_OPTION_SELECTED) != 0)
		{
			// reset the door option selection flag
			m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_DOOR_OPTION_SELECTED);

			// if the player is busy, then a valid option has been selected, so
			// make the player walk to the door
			// if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_BUSY) != 0)
			{
				// move the player to the door
				m_PlayerSim.AddWalkToAction(House.s_LotSingleton.GetItem(WorldData.ITEM_FRONT_DOOR));
				m_WalkingToDoor = true;
			}
		}

// NOTE: This must remain above the update time, or it will speed up even if job
// isn't selected!!
		// if the player is walking to the door, and is no longer busy, then do
		// the option
		if (m_WalkingToDoor && !m_PlayerSim.IsBusy())
		{
			m_WalkingToDoor = false;
			// m_CurrActionNum = Dialogue.s_dialogue.GetSelection();

			// hard coding the door options
			if ( (m_CurrActionNum == 0) &&
				 ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_WORK_WARNING_DONE) != 0) )// Go
																						// to
																						// work
			{
				// if the player is too unhappy, then don't go to work
				if (DoesSimWantToDoAction(false) )
				{
					m_PlayerSim.RemoveFromMap(House.s_LotSingleton);

					// m_GameFlags |= GameDefines.GAME_FLAG_MASK_PLAYER_BUSY;
					m_GameFlags |= GameDefines.GAME_FLAG_MASK_PLAYER_WORKING;
					m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_WORK_WARNING_DONE);
					m_SaveFlags &= ~(GameDefines.SAVE_FLAG_MASK_PLAYER_MISSED_WORK);
				}
// else
// {
// m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_PLAYER_BUSY);
// }
			}
			// answering the door will always be second
			else if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_ANSWER_DOOR) != 0)
			{
				// also return, as we've just changed to the dialog mode and
				// don't want any other game logic to interfere
				m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_ANSWER_DOOR);
				m_DoorEventHour = 0;

				// Do the random door response
				if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_DOOR_EVENT) != 0)
				{
					m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_DOOR_EVENT);
					String stringWithParams = "";

					// Get a random number.
					int percentile = Math.abs(Utility.m_Random.nextInt() );

					// now check to see if an event has happened
					if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_DOOR_EVENT_GOOD) != 0)
					{
						percentile %= (WorldData.RANDOM_DOOR_GOOD_EVENT_AMT - WorldData.RANDOM_DOOR_GOOD_EVENT_START);
						percentile += WorldData.RANDOM_DOOR_GOOD_EVENT_START;
						UpdateSimoleans(percentile, true, false);
						stringWithParams =
							Utility.GetExpandedTokenString(new String[] {SimsCanvas.s_Canvas.getStringById(StringId.RANDOM_MESSAGE_0),
										"" + percentile});
					}
					else
					{
						percentile %= (WorldData.RANDOM_DOOR_BAD_EVENT_AMT - WorldData.RANDOM_DOOR_BAD_EVENT_START);
						percentile += WorldData.RANDOM_DOOR_BAD_EVENT_START;
						UpdateSimoleans(-percentile, true, false);

						int message = Math.abs(Utility.m_Random.nextInt() );
						message %= 3;

						// choose the random door message randomly here
						stringWithParams =
							Utility.GetExpandedTokenString(new String[] {SimsCanvas.s_Canvas.getStringById(StringId.RANDOM_MESSAGE_1 + message),
										"" + percentile});
					}

					// display the message
					Dialogue.CreateModalDialogue(stringWithParams, Dialogue.BUTTONS_CONFIRM);

					if ( ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING) == 0) &&
						 ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_WORKING) == 0) )
					{
						return;
					}
				}

				// if it was the talk to ben goal, then let him in
				if (m_CurrGoal == SimAttributes.GOAL_1)
				{
					m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED;
				}

				if (m_NPCAtDoor != WorldData.NPC_INVALID)
				{
					RequestAddNpc(m_NPCAtDoor, WorldData.INITIAL_NPC_LOC, WorldData.NPC_COMING_AUTO);
					m_NPCAtDoor = WorldData.NPC_INVALID;
				}

				StopAction(true, false);
			}
		}

		if (UpdateTime() )
		{
			if ( ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING) == 0) &&
				 ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_WORKING) == 0) )
			{
				return;
			}
		}

		UpdateSmokeAlarm();

		if (DecrementSimNeeds())
		{
			if ( ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING) == 0) &&
				 ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_WORKING) == 0) )
			{
				return;
			}
		}

		if ( ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING) == 0) &&
			 ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_WORKING) == 0) )
		{
			if (DoJobNotification() )
			{
				return;
			}

			// check to see if a random door event should occur
			if (DoRandomDoorEvent() )
			{
				return;
			}
		}

		if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_WORKING) != 0)
		{
			// if it is time to come back from work, then reset the work related
			// values
			if ( (m_CurrHour >= JOB_DATA[m_CurrJob][WorldData.JOB_DATA_END_HOUR]) &&
				 ( (JOB_DATA[m_CurrJob][WorldData.JOB_DATA_END_HOUR] > JOB_DATA[m_CurrJob][WorldData.JOB_DATA_START_HOUR]) ||
				   (m_CurrDay > m_WorkStartDay) ) )
			{
				m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_PLAYER_WORKING;
				UpdateSimoleans(JOB_DATA[m_CurrJob][WorldData.JOB_DATA_SALARY] * WorldData.JOB_SALARY_MULTIPLIER, true, false);

				// Finish up the work state
				StopAction(false, false);

				// add the player back to the map
				m_PlayerSim.AddToMap(House.s_LotSingleton);
			}
		}
		// if the player is in a failure state, do the failure stuff
		else if ((m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_FAILING) != 0)
		{
			// if it is a failure state, finish it...
			if (m_WarningFailureState >= SimAttributes.NUM_NEEDS)
			{
				FinishFailureState();
			}
			// otherwise check to see if the time is up and put the Sim back to
			// stand
			else if (m_NeedWarningTimer < 0)
			{
				m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_PLAYER_FAILING);
				m_WarningFailureState = SimAttributes.WARN_FAILURE_MAX;
				m_PlayerSim.ControlAnimation(SimObject.ANIM_ID_STAND, true, AnimationEffect.DISABLE);
			}
		}
		// if the player is doing an action, do the animation and stuff
		else if ((m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_ACTION) != 0)
		{
			DoItemAction();
		}
		else
		{
			if (!UpdateGoals() )
			{
				UpdateWants();
			}
		}

		UpdateBusyFlag();
	} // end UpdateGameLogic

	private void UpdateBusyFlag()
	{
		if(((m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_WORKING) != 0) ||
			((m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_FAILING) != 0) ||
			((m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_ACTION) != 0))
		{
			m_GameFlags |= GameDefines.GAME_FLAG_MASK_PLAYER_BUSY;
		}
		else
		{
			m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_PLAYER_BUSY;
		}
	}

	/**
	 * Updates the goals, and displays the text associated with each to progress
	 * the story line
	 *
	 * @return
	 */
	private boolean UpdateGoals()
	{
		boolean dialogInUse = false;
		boolean updateTutorial = false;

		if (m_GoalPosition < GameDefines.NUM_GOAL_DIALOGS)
		{
			int stringId = -1;

			switch (m_GoalPosition)
			{
			case GameDefines.GOAL_TEXT_0_A:	// display the Ben welcome text
				stringId = StringId.INTRODUCTION_1;
				break;

			case GameDefines.GOAL_TEXT_0_B:	// display the Hunger information
				stringId = StringId.TUTORIAL_0;
				m_GoalTimer = SimAttributes.GOAL_DELAY_TIME_MS;
				break;

			case GameDefines.GOAL_TEXT_0_C:	// display the new goal text - Goal
											// 0
				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED) == 0)
				{
					if (m_GoalTimer < 0)
					{
						stringId = StringId.TUTORIAL_1;
					}

					break;
				}
				else
				{
					m_GoalPosition++;
				}

			case GameDefines.GOAL_TEXT_0_D:	// display hunger satiated text
				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED) != 0)
				{
					stringId = StringId.TUTORIAL_2;
					m_GoalTimer = SimAttributes.GOAL_DELAY_TIME_MS;
				}
				break;

			case GameDefines.GOAL_TEXT_1_A:	// display Ben at the door text
				if (m_GoalTimer < 0)
				{
					// unlock Ben and make him show up
					stringId = UpdateNPCAtDoor(WorldData.NPC_BEN);
					m_NpcFlags |= (1 << WorldData.NPC_BEN);
				}
				break;

			case GameDefines.GOAL_TEXT_1_B:
				stringId = StringId.TUTORIAL_3;
				break;

			case GameDefines.GOAL_TEXT_1_C:	// display Ben's intro text
				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED) != 0)
				{
					stringId = StringId.TUTORIAL_4;
				}
				break;

			case GameDefines.GOAL_TEXT_1_D:	// display the doing great, keep it
											// up to make friends text
				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED) != 0)
				{
					stringId = StringId.TUTORIAL_5;

					// add the kitchen items to the game
					m_BuyList.addElement(new Integer(WorldData.ITEM_GAS_COOKER) );
					m_BuyList.addElement(new Integer(WorldData.ITEM_COFFEE_MACHINE) );
					m_BuyList.addElement(new Integer(WorldData.ITEM_ALARM_CLOCK) );
					m_BuyList.addElement(new Integer(WorldData.ITEM_BATH) );
				}
				break;

			case GameDefines.GOAL_TEXT_1_E:		// move to Goal 2 - Make Friends
												// with Ben
				DisplayNewGoalText(true);
				updateTutorial = true;
				break;

			case GameDefines.GOAL_TEXT_1_F:	// display the objects for purchase
											// text
				stringId = StringId.SIMCO_REMIND_OBJECT;
				PlaySound(SoundId.SOUND_MOBILE, 1);

				// Make the phone ring for this....
				m_GameFlags |= GameDefines.GAME_FLAG_MASK_PHONE_RINGING;
				break;

			case GameDefines.GOAL_TEXT_2_A:		// move to Goal 3 - Get Chef job
				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED) != 0)
				{
					DisplayNewGoalText(true);
					updateTutorial = true;

					// unlock Penny and make her show up
					UpdateNPCAtDoor(WorldData.NPC_PENNY);
					m_NpcFlags |= (1 << WorldData.NPC_PENNY);
				}
				break;

			case GameDefines.GOAL_TEXT_3_A:	// display that penny is at the door
				stringId = StringId.DOOR_EVENT;
				break;

			case GameDefines.GOAL_TEXT_3_B:	// Move to goal 4 - Buy Living Room
				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED) != 0)
				{
					DisplayNewGoalText(true);
					updateTutorial = true;
					m_BuyList.addElement(new Integer(SimAttributes.ROOM_LIVINGROOM) );
				}
				break;

			case GameDefines.GOAL_TEXT_3_C:	// display the room upgrade text
				stringId = StringId.SIMCO_REMIND_UPGRADE;
				PlaySound(SoundId.SOUND_MOBILE, 1);

				// Make the phone ring for this....
				m_GameFlags |= GameDefines.GAME_FLAG_MASK_PHONE_RINGING;
				break;

			case GameDefines.GOAL_TEXT_4_A:
			case GameDefines.GOAL_TEXT_6_A:
			case GameDefines.GOAL_TEXT_10_A:
			case GameDefines.GOAL_TEXT_14_A:	// display the more objects
												// available text
				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED) != 0)
				{
					stringId = StringId.SIMCO_REMIND_OBJECT;
					PlaySound(SoundId.SOUND_MOBILE, 1);

					// Make the phone ring for this....
					m_GameFlags |= GameDefines.GAME_FLAG_MASK_PHONE_RINGING;
				}
				break;

			case GameDefines.GOAL_TEXT_5_A:		// move to goal 6 - Get
												// Recreation room upgrade
				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED) != 0)
				{
					DisplayNewGoalText(true);
					updateTutorial = true;
					m_BuyList.addElement(new Integer(SimAttributes.ROOM_RECROOM) );
				}
				break;

			case GameDefines.GOAL_TEXT_5_B:
				// unlock John and make him show up
				stringId = UpdateNPCAtDoor(WorldData.NPC_JOHN);
				m_NpcFlags |= (1 << WorldData.NPC_JOHN);
				break;

			case GameDefines.GOAL_TEXT_6_C:
				// Unlock Kitty and make her show up
				stringId = UpdateNPCAtDoor(WorldData.NPC_KITTY);
				m_NpcFlags |= (1 << WorldData.NPC_KITTY);
				break;

			case GameDefines.GOAL_TEXT_7_A:		// move to goal 8 - meet Lorna
				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED) != 0)
				{
					DisplayNewGoalText(true);
					updateTutorial = true;
				}
				break;

			case GameDefines.GOAL_TEXT_8_A:
				int numFriends = GetNumFriends();

				// if the player has made 4 friends, then it is time to bring
				// Lorna in
				if (numFriends >= WorldData.NUM_FRIENDS_FOR_LORNA)
				{
					// unlock lorna and make her show up
					stringId = UpdateNPCAtDoor(WorldData.NPC_LORNA);
					m_NpcFlags |= (1 << WorldData.NPC_LORNA);
				}
				break;

			case GameDefines.GOAL_TEXT_9_A:		// move to goal 10 - Buy Party
												// Room
				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED) != 0)
				{
					DisplayNewGoalText(true);
					updateTutorial = true;
					m_BuyList.addElement(new Integer(SimAttributes.ROOM_PARTYROOM) );
				}
				break;

			case GameDefines.GOAL_TEXT_11_A:	// move to goal 12 - Throw party
												// to meet Ian
				// if the deck and dance floor has been purchased, then this
				// goal has been met
				if ( ( (m_LockFlags & ( (long)1 << WorldData.ITEM_DECKS) ) == 0) &&
					 ( (m_LockFlags & ( (long)1 << WorldData.ITEM_JUICE_BAR) ) == 0) )
				{
					DisplayNewGoalText(true);
					updateTutorial = true;
				}
				break;

			case GameDefines.GOAL_TEXT_12_A:
				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED) != 0)
				{
					// Unlock Ian and make him show up at the door
					stringId = UpdateNPCAtDoor(WorldData.NPC_IAN);
					m_NpcFlags |= (1 << WorldData.NPC_IAN);
				}
				break;

			case GameDefines.GOAL_TEXT_13_A:	// move to goal 14 - Buy the
												// garden
				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED) != 0)
				{
					DisplayNewGoalText(true);
					updateTutorial = true;
					m_BuyList.addElement(new Integer(SimAttributes.ROOM_GARDEN) );
				}
				break;

			case GameDefines.GOAL_TEXT_0_E: 	// move to Goal 1 - Talk to Ben
			case GameDefines.GOAL_TEXT_4_B: 	// move to goal 5 - Get Head
												// Chef job
			case GameDefines.GOAL_TEXT_6_B: 	// move to goal 7 - Get Personal
												// Trainer job
			case GameDefines.GOAL_TEXT_8_B:		// move to goal 9 - Get Party DJ
												// job
			case GameDefines.GOAL_TEXT_10_B:	// move to goal 11 - Unlock
												// Juice Bar and Decks
			case GameDefines.GOAL_TEXT_12_B:	// move to goal 13 - Get
												// Guitarist job
			case GameDefines.GOAL_TEXT_14_B:	// move to goal 15 - Last
												// goal...open ended...fall in
												// love, blah, blah, blah
			default:	// display the new goal text as the default
				DisplayNewGoalText(true);
				updateTutorial = true;
				break;
			}

			if ( (stringId >= 0) ||
				 updateTutorial)
			{
				if (stringId >= 0)
				{
					Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(stringId), Dialogue.BUTTONS_CONFIRM);
				}

				m_SaveFlags &= ~(GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED);
				dialogInUse = true;
				m_GoalPosition++;
			}
		}

		return (dialogInUse);

	} // end UpdateGoals

	/**
	 * Updates the in-game timers to keep the game in synch.
	 *
	 */
	private void UpdateGameTimers()
	{
		if (m_GoalTimer >= 0)
		{
			m_GoalTimer -= (2*m_GameTimeElapsed);
		}

		if (m_TimeTimer >= 0)
		{
			m_TimeTimer -= m_GameTimeElapsed;
		}

		if (m_NeedWarningTimer >= 0)
		{
			m_NeedWarningTimer -= m_GameTimeElapsed;
		}

// if (m_GoalTimer >= 0)
// {
// m_GoalTimer -= m_GameTimeElapsed;
// }

	} // end UpdateGameTimers

	/**
	 * Updates the NPC arriving at the door, clearing out any other door events
	 *
	 * @param npcId
	 * @return
	 */
	private int UpdateNPCAtDoor(int npcId)
	{
		// make NPC show up
		m_GameFlags |= GameDefines.GAME_FLAG_MASK_ANSWER_DOOR;
		m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_DOOR_EVENT);
		m_DoorEventHour = 0;
		m_NPCAtDoor = npcId;

		PlaySound(SoundId.SOUND_DOORBELL, 1);
		return(StringId.DOOR_EVENT);

	} // end UpdateNPCAtDoor

	/**
	 * Updates the wants if they've been satisfied recently
	 *
	 * @return
	 */
	private boolean UpdateWants()
	{
		boolean dialogInUse = false;

		// go through the wants to see if they've been satisfied, and if so, get
		// a new one
		for (int i = 0; i < SimAttributes.NUM_POSSIBLE_WANTS; i++)
		{
			if (m_CurrWants[i] == SimAttributes.WANT_INVALID)
			{
				dialogInUse = true;
				m_CurrWants[i] = GetNewWant();
			}
		}

		if (dialogInUse)
		{
			DisplayNewGoalText(false);
		}

		return(dialogInUse);

	} // end UpdateWants

	/**
	 * Gets a new want, choosing randomly from every available want NOTE: This
	 * is a brute force method, and could use some work
	 *
	 * @return
	 */
	private short GetNewWant()
	{
		int i;
		Vector 	availableWants = new Vector();
		short	selectedWant = SimAttributes.WANT_INVALID;
		/*
		 * Gain skill point wants:
		 */
		// go through the skills to see if any are available for a want and add
		// them to the list
		for (i = 0; i < SimAttributes.NUM_SKILLS; i++)
		{
			if (m_SimTraits[SimAttributes.FIRST_SKILL + i] < SimAttributes.MAX_SKILL_VALUE)
			{
				availableWants.addElement(new Integer(SimAttributes.WANT_SKILL_START_OFFSET + i) );
			}
		}

		/*
		 * Buy item wants:
		 */
		// Go through each unlocked room and determine if the objects are
		// unlocked for each item that can be bought
		// Kitchen, bathroom and bedroom don't need to be checked as they are
		// unlocked to begin with
		if ( (m_LockFlags & ( (long)1 << WorldData.ITEM_GAS_COOKER) ) != 0)
		{
			availableWants.addElement(new Integer(SimAttributes.WANT_ITEM_PURCHASE_OVEN) );
		}

		if ( (m_LockFlags & ( (long)1 << WorldData.ITEM_COFFEE_MACHINE) ) != 0 )
		{
			availableWants.addElement(new Integer(SimAttributes.WANT_ITEM_PURCHASE_COFFEE_MAKER) );
		}

		if ( (m_LockFlags & ( (long)1 << WorldData.ITEM_ALARM_CLOCK) ) != 0 )
		{
			availableWants.addElement(new Integer(SimAttributes.WANT_ITEM_PURCHASE_ALARM_CLOCK) );
		}

		if ( (m_LockFlags & ( (long)1 << WorldData.ITEM_BATH) ) != 0 )
		{
			availableWants.addElement(new Integer(SimAttributes.WANT_ITEM_PURCHASE_BATH) );
		}

		if ( (m_LockFlags & ( (long)1 << SimAttributes.ROOM_LIVINGROOM) ) == 0 )
		{
			if ( (m_LockFlags & ( (long)1 << WorldData.ITEM_FLAT_SCREEN_TV) ) != 0 )
			{
				availableWants.addElement(new Integer(SimAttributes.WANT_ITEM_PURCHASE_FLAT_SCREEN) );
			}
		}

		if ( (m_LockFlags & ( (long)1 << SimAttributes.ROOM_RECROOM) ) == 0 )
		{
			if ( (m_LockFlags & ( (long)1 << WorldData.ITEM_GUITAR) ) != 0 )
			{
				availableWants.addElement(new Integer(SimAttributes.WANT_ITEM_PURCHASE_GUITAR) );
			}

			if ( (m_LockFlags & ( (long)1 << WorldData.ITEM_CHESS_TABLE) ) != 0 )
			{
				availableWants.addElement(new Integer(SimAttributes.WANT_ITEM_PURCHASE_CHESS_TABLE) );
			}
		}

		if ( (m_LockFlags & ( (long)1 << SimAttributes.ROOM_PARTYROOM) ) == 0 )
		{
			if ( (m_LockFlags & ( (long)1 << WorldData.ITEM_DECKS) ) != 0 )
			{
				availableWants.addElement(new Integer(SimAttributes.WANT_ITEM_PURCHASE_DECKS) );
			}

			if ( (m_LockFlags & ( (long)1 << WorldData.ITEM_JUICE_BAR) ) != 0 )
			{
				availableWants.addElement(new Integer(SimAttributes.WANT_ITEM_PURCHASE_JUICE_BAR) );
			}
		}

		if ( (m_LockFlags & ( (long)1 << SimAttributes.ROOM_GARDEN) ) == 0 )
		{
			if ( (m_LockFlags & ( (long)1 << WorldData.ITEM_HOT_TUB) ) != 0 )
			{
				availableWants.addElement(new Integer(SimAttributes.WANT_ITEM_PURCHASE_HOT_TUB) );
			}
		}

		/*
		 * Social wants:
		 */
		// see how many friends the player has, and if there are less than 6,
		// add a have # friends want
		int numFriends = GetNumFriends();

		// go through the social wants and add them all to the list, unless it
		// is special case
		for (i = 0; i < SimAttributes.NUM_SOCIAL_WANTS; i++)
		{
			// Special cases, 1. if you have made friends with everyone, you
			// can't make a new friend
			// 2. if you are already married, can't get married
			// 3. if you are not married, can't get divorced
			if ( ( (i == SimAttributes.WANT_SOCIAL_MAKE_FRIEND_OFFSET) &&
				   (numFriends >= WorldData.NUM_NPCS) ) ||
				 ( (i == SimAttributes.WANT_SOCIAL_GET_MARRIED_OFFSET) &&
				   (m_SpouseNpcId != WorldData.NPC_INVALID) ) ||
				 ( (i == SimAttributes.WANT_SOCIAL_GET_DIVORCED_OFFSET) &&
				   (m_SpouseNpcId == WorldData.NPC_INVALID) ) )
			{
				continue;
			}

			availableWants.addElement(new Integer(SimAttributes.WANT_SOCIAL_START_OFFSET + i) );
		}

		boolean	wantFound;

		// now select a want that isn't already selected (have to randomly
		// choose one until it doesn't match any
		// currently valid wants
		do
		{
			wantFound = true;
			int randomInt = Math.abs(Utility.m_Random.nextInt() );
			randomInt %= availableWants.size();
			selectedWant = (short)( ( (Integer)availableWants.elementAt(randomInt) ).intValue() );

			for (i = 0; i < SimAttributes.NUM_POSSIBLE_WANTS; i++)
			{
				if (selectedWant == m_CurrWants[i])
				{
					wantFound = false;
					break;
				}
			}

		} while (!wantFound);

		return(selectedWant);

	} // end GetNewWant

	/**
	 * Checks if the given want satisfies any of the player's wants
	 *
	 * @param wantToSatisfy
	 */
	private void SatisfyWant(int wantToSatisfy)
	{
		// go through the wants to see the given one satisfies any
		for (int i = 0; i < SimAttributes.NUM_POSSIBLE_WANTS; i++)
		{
			if (m_CurrWants[i] == wantToSatisfy)
			{
				// mark the want as satisfied (empty it)
				m_CurrWants[i] = SimAttributes.WANT_INVALID;

				// increase the player's simoleans a little
// UpdateSimoleans(SimAttributes.WANT_SIMOLEAN_INC, true, false);
				break;
			}
		}

	} // end SatisfyWant

	/**
	 * Do a random check for a door event every hour
	 *
	 */
	private boolean DoRandomDoorEvent()
	{
		boolean displayDialog = false;

		// only need to do this if an event is occuring
		if (m_DoorEventHour != 0)
		{
			// If it isn't the top of the hour, or someone else is at the door,
			// don't do this.
			if ( (m_CurrHour == m_DoorEventHour) &&
				 ( (m_CurrMin >= 0) && (m_CurrMin < WorldData.RANDOM_DOOR_REMOVE_MIN) ) &&
				 ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_ANSWER_DOOR) == 0) &&
				 ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_DOOR_EVENT) == 0) )
			{
				// as long as we aren't already on the way to another dialog,
				// then do this
				if (m_CurrGameState == GameDefines.GAME_MODE_RUN_GAME)
				{
					PlaySound(SoundId.SOUND_DOORBELL, 1);
					displayDialog = true;

					Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.DOOR_EVENT), Dialogue.BUTTONS_CONFIRM);

					// set the door event
					m_GameFlags |= (GameDefines.GAME_FLAG_MASK_ANSWER_DOOR | GameDefines.GAME_FLAG_MASK_DOOR_EVENT);

					m_DoorEventMin = m_CurrMin + WorldData.RANDOM_DOOR_REMOVE_MIN;
				}
			}
			else if ( ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_DOOR_EVENT) != 0) &&
							(m_CurrMin == m_DoorEventMin) )
			{
				// reset the door event
				m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_ANSWER_DOOR | GameDefines.GAME_FLAG_MASK_DOOR_EVENT);
				m_DoorEventHour = 0;
			}
		}

		return(displayDialog);

	} // end DoRandomDoorEvent

	/*
	 * UI and Draw methods
	 */

	/**
	 * Update the relationship change sprite
	 *
	 * @param xPos
	 * @param yPos
	 */
	private void DrawRelationshipChangeSprites(int xPos, int yPos)
	{
		// add the double plus cursor
		if (m_DoubleCursorTimer != 0)
		{
			// Check if finished.
			if (m_GameTime > m_DoubleCursorTimer)
			{
				m_DoubleCursorTimer = 0;
				s_GeneralSpriteImage = null;
			}
			// otherwise draw the sprite
			else if (s_GeneralSpriteImage == null)
			{
				if (m_DoubleCursorType == GameDefines.CURSOR_MINUSMINUS)
				{
					s_GeneralSpriteImage = Utility.loadImage("thoughts/DoubleMinus", true);
				}
				else if (m_DoubleCursorType == GameDefines.CURSOR_PLUSPLUS)
				{
					s_GeneralSpriteImage = Utility.loadImage("thoughts/DoublePlus", true);
				}
				else
				{
					s_GeneralSpriteImage = Utility.loadImage("thoughts/dotdotdot", true);
				}

				s_GeneralSpriteXPos = (xPos - s_GeneralSpriteImage.getWidth() +
								GameDefines.REACTION_SPRITE_X_OFFSET);
				s_GeneralSpriteYPos = yPos;
				s_GeneralSpriteSatartYPos = yPos;
			}
			else
			{
				if (s_GeneralSpriteYPos > (s_GeneralSpriteSatartYPos - GameDefines.REACTION_SPRITE_Y_MOVE) )
				{
					s_GeneralSpriteYPos--;
				}
				else
				{
					m_DoubleCursorTimer = (m_GameTime - 1);
				}
			}
		}

	} // end DrawRelationshipChangeSprites

	/**
	 * Updates the Simolean display on the screen
	 *
	 */
	private void UpdateMoneyDisplay()
	{
		// replaced the money display update
		if (m_SimoleanTimer-- > 0)
		{
			if ( (m_SimoleanTimer % 3) == 0)
			{
				m_GameFlags ^= GameDefines.GAME_FLAG_MASK_SHOW_SIMOLEANS;
			}
		}
		else
		{
			m_GameFlags |= GameDefines.GAME_FLAG_MASK_SHOW_SIMOLEANS;
		}

	} // end UpdateMoneyDisplay

	/**
	 * Updates the time and time display for the game
	 *
	 */
	private boolean UpdateTime()
	{
		boolean dialogInitiated = false;

		if ( (m_Dialogs[GameDefines.DIALOG_ID_TIME] == null) ||
			 (m_TimeTimer < 0) )
		{
			// get the speed at which to update the timer
			int updateSpeed = WorldData.NUM_MS_PER_MIN;

			if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING) != 0)
			{
				updateSpeed /= WorldData.SLEEP_TIME_PROGRESSION;
			}
			else if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_WORKING) != 0)
			{
				updateSpeed /= WorldData.WORK_TIME_PROGRESSION;
			}

			// reset the timer
			m_TimeTimer = updateSpeed;

			// update the clock (normal time progression should always be 1)
			if (m_GoalPosition > GameDefines.GOAL_TEXT_0_B)
			{
				UpdateClock(0, 0, WorldData.NORMAL_TIME_PROGRESSION);
			}

			// set the need decrement flag (happens every game minute)
			m_GameFlags |= GameDefines.GAME_FLAG_MASK_DECREMENT_NEEDS;

			// Get the day string and the old day string
			String s = SimsCanvas.s_Canvas.getStringById(m_CurrDay + StringId.MONDAY);

			// change the day only if the day has changed!
			if ( (m_Dialogs[GameDefines.DIALOG_ID_DAY] == null) ||
				 (! (s.equals( (String)m_Dialogs[GameDefines.DIALOG_ID_DAY].m_textLines.firstElement() ) ) ) )
			{
				m_Dialogs[GameDefines.DIALOG_ID_DAY] = null;
				m_Dialogs[GameDefines.DIALOG_ID_DAY] =
					new Dialogue(s, false, (SKUConsts.ISO_VIEW_WIDTH - GameDefines.SOFT_KEY_TEXT_X_OFFSET),
									GameDefines.DAY_Y_OFFSET, Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.RIGHT) );
			}

			// figure out if it is AM or PM
			String amOrPM = SimsCanvas.s_Canvas.getStringById(StringId.MORNING);
			int currentHour = m_CurrHour;
			// if it is after 12, then it is evening
			if ( (currentHour - 12) >= 0)
			{
				amOrPM = SimsCanvas.s_Canvas.getStringById(StringId.EVENING);

				currentHour -= 12;
			}


			if(isDemo && m_CurrHour >= 12 )
			{
                if (shell.Build.VODAFONE) {
                    exitMain = false;
                    SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_VODAFONE_DEMOOVER);
                }
                else {
                    ExitGame(true);
                }

				demoOver = true;
			}


			// now if the time is zero, then we need to convert it back to 12
			// for noon and Midnight
			if (currentHour == 0)
			{
				currentHour = 12;
			}

			// now make sure to display the minute as two digits
			String minutes = "";

			if (m_CurrMin < 10)
			{
				minutes = "0";
			}

			s =  currentHour + ":" + minutes + m_CurrMin + amOrPM;

			// draw the clock (creating the string)
			m_Dialogs[GameDefines.DIALOG_ID_TIME] = null;
			m_Dialogs[GameDefines.DIALOG_ID_TIME] =
				new Dialogue(s, false, GameDefines.SOFT_KEY_TEXT_X_OFFSET, GameDefines.TIME_Y_OFFSET,
								Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.LEFT) );

			// Update the npcs.
			dialogInitiated = UpdateNightlyTasks();

			if (!dialogInitiated )
			{
				dialogInitiated = UpdateNpcSchedule();
			}
		}

		return(dialogInitiated);

	} // end UpdateTime

	/*
	 * Menu methods
	 */

	private void SetUpLoadingScreen()
	{
		s_CurrBG = Utility.loadImage("splashscreens/Sims2Logo", true);

		// draw the loading text at bottom of the screen
		m_Dialogs[GameDefines.DIALOG_ID_0] =
			new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.LOADING), false, 0,
							GameDefines.LOADING_TEXT_Y_OFFSET, Colors.YELLOW, (Graphics.TOP | Graphics.HCENTER) );

	} // end SetUpLoadingScreen

	/**
	 * Run the initial menus.
	 *
	 * @param gameState
	 *            The current game state
	 */
	private void DoInitialMenus(int gameState)
	{
		switch(m_CurrGameState)
		{
		case GameDefines.GAME_MODE_START_MENU:
			if (!Dialogue.s_dialogueActive)
			{
				if (m_SubMenuState == 0)
				{
					HandleStartMenuInput();
				}
				else
				{
					// if we were in the overwrite saved game message for a new
					// game, and the player selected yes then move on
					if ( (m_SubMenuState == 1) &&
						 (m_DialogSelectedOption == 1) )
					{
						SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_INTRODUCTION);
					}
					// if we were in the 'do you want to quit' message
					else if ( (m_SubMenuState == 3) &&
							  (m_DialogSelectedOption == 1) )
					{
							ExitGame(false);
					}
					// otherwise, it must've been the load failure dialog or
					// they said no, so move back to the main game menu
					else
					{
						SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_START_MENU);
					}

					m_SubMenuState = 0;
				}
			}
			break;

		case GameDefines.GAME_MODE_SELECT_A_SIM:
			HandleSelectSimMenuInput();
			break;

		case GameDefines.GAME_MODE_INTRODUCTION:
            if(SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK))
            {
                SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_START_MENU);
            }
            else if(SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.ACCEPT) || SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.FIRE))
            {
                SetUpLoadingScreen();
                InitPauseExitSoftKeyText(false, false);
                SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_SELECT_A_SIM);
            }
			break;
		//#ifdef ENABLE_VODAFONE_DEMO
 		case GameDefines.GAME_MODE_VODAFONE_DEMOOVER:
 			if(SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK))
 			{
 				ExitGame(false);
 			}
 			else if(SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.ACCEPT) || SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.FIRE))
 			{
 				//String buyURI = getAppProperty("BUY-URI");
 				//launchBrowser(buyURI, true);
                shell.BuyScene.autoBuy = true;
				ExitGame(false);
 			}
 			break;
		//#endif
		case GameDefines.GAME_MODE_DEMOOVER:
			if (!Dialogue.s_dialogueActive)
			{
				if (m_DialogSelectedOption < 0)
				{
					ExitGame(false);

				}
				else
				{
					//Buy Link
					//String buyURI = getAppProperty("BUY-URI");
					//launchBrowser(buyURI, true);
                    shell.BuyScene.autoBuy = true;
                    ExitGame(false);
				}
			}

			break;
//#ifdef ENABLE_VODAFONE_DEMO
 		case GameDefines.GAME_MODE_DEMO_SPLASH:
 			if(SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK))
 			{
 				ExitGame(false);
 			}
 			else if(SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.ACCEPT) || SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.FIRE))
 			{
 				SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_INTRODUCTION);
 			}
 			break;
//#endif
		default:
			break;
		}
	}

	private void launchBrowser(String url, boolean exit)
	{
		try
		{
			platformRequest(url);
		}
		catch(Exception e)
		{
		}
		if(exit)
		{
			ExitGame(false);
		}
	}
	private void InitDemoOver()
	{
		InvalidateStrings();

		// draw the title
		DrawTitleText(StringId.DEMOOVER_TITLE);
		m_SubMenuState = m_DialogSelectedOption;
		int yPos = GameDefines.ABOUT_MENU_TITLE_OFFSET;

		String s = new String();
		s += " ";
		s += SimsCanvas.s_Canvas.getStringById(StringId.DEMOOVER_TEXT);

		// draw the legal information
		m_Dialogs[GameDefines.DIALOG_ID_0] =
			new Dialogue(s, false, 0, yPos, (Graphics.TOP | Graphics.HCENTER) );

		// add the exit options
		InitPauseExitSoftKeyText(false, true);

	}
	/**
	 * Perform the pause menu operations
	 *
	 */
	private void DoPauseMenu()
	{
		boolean optionSelected = false;
		boolean revertToMainOptions = false;

		m_DialogSelectedOption = Dialogue.s_dialogue.m_selectionState;
		m_DialogPreviousOption = Dialogue.s_dialogue.m_prevSelectionState;

		// not all menu states use the dialog system to display text
		if ( (m_MenuState != GameDefines.PAUSED_MODE_JOB_DATA) &&
			 (m_MenuState != GameDefines.PAUSED_MODE_WANTS) &&
			 !( (m_MenuState == GameDefines.PAUSED_MODE_OPTIONS) &&
				(m_SubMenuState == GameDefines.GAME_OPTION_ABOUT) ) )
		{
			optionSelected = (Dialogue.s_dialogue.GetSelection() >= 0);
		}

		switch(m_MenuState)
		{
		case GameDefines.PAUSED_MODE_CALL:
			revertToMainOptions = DoCallMenuSelection(optionSelected);
			break;

		case GameDefines.PAUSED_MODE_OPTIONS:
			revertToMainOptions = DoGameOptionSelection(optionSelected);
			break;

		case GameDefines.PAUSED_MODE_FRIENDS:
			// if the exit button was pressed, then go back to the main pause
			// menu
			if (!Dialogue.s_dialogueActive)
			{
				revertToMainOptions = true;

				// invalidate all the relationship sprites
				for (int i = 0; i < WorldData.NUM_NPCS; i++)
				{
					s_RoommateSpriteIcons[i] = null;
					s_FriendshipSpriteIcons[i] = null;
				}
			}
			// othwerwise update the bio at the bottom
			else
			{
				if (m_DialogPreviousOption != m_DialogSelectedOption)
				{
					m_Dialogs[GameDefines.DIALOG_ID_0].SetText(SimsCanvas.s_Canvas.getStringById(StringId.BIO_BEN + m_DialogSelectedOption) );
				}
			}
			break;

		case GameDefines.PAUSED_MODE_JOB_DATA:
		case GameDefines.PAUSED_MODE_WANTS:
			// if the exit button was pressed, then go back to the main pause
			// menu
			if ( (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK)) ||
				 (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.ACCEPT)) ||
				 (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.FIRE)) )
			{
				revertToMainOptions = true;
			}
			break;

		case GameDefines.PAUSED_MODE_SKILLS:
			// if the exit button was pressed, then go back to the main pause
			// menu
			if (!Dialogue.s_dialogueActive)
			{
				revertToMainOptions = true;
			}
			else
			{
				if (m_DialogPreviousOption != m_DialogSelectedOption)
				{
					m_Dialogs[GameDefines.DIALOG_ID_0].SetText(SimsCanvas.s_Canvas.getStringById(StringId.SKILL_INFO_0 + m_DialogSelectedOption) );
				}
			}
			break;

		case GameDefines.PAUSED_MODE_HELP:
			// if we are in help selection state, then do that mode
			if (m_SubMenuState == 0)
			{
				// if the exit button was pressed, then go back to the main
				// pause menu
				if (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK) )
				{
					revertToMainOptions = true;
				}
				// if the fire button was pressed, go to the selected help text
				else if (optionSelected)
				{
					m_SubMenuState = 1;
					InvalidateStrings();

					// draw the title
					DrawTitleText(StringId.HELP_OPTION_0 + m_DialogSelectedOption);

					Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.HELP_0 + m_DialogSelectedOption),
									Dialogue.BUTTONS_NONE, DialogueStyles.NO_BOX, true, true);

					InitPauseExitSoftKeyText(false, true);
				}
			}
			// otherwise wait for exit button to go back to help options
			else
			{
				// if the exit button was pressed, then go back to the main help
				// menu
				if (!Dialogue.s_dialogueActive)
				{
					m_SubMenuState = 0;
					InvalidateStrings();

					// draw the title
					DrawTitleText(StringId.PAUSE_MAIN_OPTION_0 + m_MenuState);
					InitHelpMenu();
				}
			}
			break;

		case GameDefines.PAUSED_MODE_MAIN:
			m_LastVMSelection = m_DialogSelectedOption;
			DoMainPauseSelection(optionSelected);
			break;

		default:
			break;
		}

		if (revertToMainOptions)
		{
			InvalidateStrings();
			InitMainPauseMenu();
			m_MenuState = GameDefines.PAUSED_MODE_MAIN;
			m_NumNpcsComing = 0;
		}

	} // end DoMainPauseMenu

//#ifdef ENABLE_VODAFONE_DEMO
 	/**
 	 * Perform the pause menu operations
 	 *
 	 */
 	private void DoDemoPauseMenu()
 	{
 		boolean optionSelected = false;
 		boolean revertToMainOptions = false;
 
 		m_DialogSelectedOption = Dialogue.s_dialogue.m_selectionState;
 		m_DialogPreviousOption = Dialogue.s_dialogue.m_prevSelectionState;
 
 		// not all menu states use the dialog system to display text
 		optionSelected = (Dialogue.s_dialogue.GetSelection() >= 0);
 		//System.out.println("Option selected :" + optionSelected);
 
 		//System.out.println("Menu STate :" + m_MenuState);
 		switch(m_MenuState)
 		{
 			case GameDefines.PAUSED_MODE_DEMO:
 				m_LastVMSelection = m_DialogSelectedOption;
 				DoDemoPauseSelection(optionSelected);
 				break;
 
 			default:
 			break;
 		}
 
 		if (revertToMainOptions)
 		{
 			InvalidateStrings();
 			InitMainPauseMenu();
 			m_MenuState = GameDefines.PAUSED_MODE_DEMO;
 			m_NumNpcsComing = 0;
 		}
 
 	} // end DoDemoPauseMenu
//#endif


	/**
	 * Set up to go to the pause menu
	 *
	 */
	private void GoToPauseMenu()
	{
		// set up the initial menu options
		m_MenuState = GameDefines.PAUSED_MODE_MAIN;
		InvalidateStrings();
		s_CurrBG = Utility.loadImage("in_game_menus/Soc_Default", true);
		SwitchGameState(GameDefines.GAME_MODE_PAUSE_MENU);
		InitMainPauseMenu();

	} // end GoToPauseMenu

	/**
	 * Set up to go to the pause menu
	 *
	 */
//#ifdef ENABLE_VODAFONE_DEMO
 	private void GoToDemoPauseMenu()
 	{
 		// set up the initial menu options
 		m_MenuState = GameDefines.PAUSED_MODE_DEMO;
 		InvalidateStrings();
 		s_CurrBG = Utility.loadImage("in_game_menus/Soc_Default", true);
 		SwitchGameState(GameDefines.GAME_MODE_DEMO_PAUSE_MENU);
 		InitDemoPauseMenu();
 
 	} // end GoToPauseMenu
//#endif

	/**
	 * Initiate a cutscene.
	 *
	 * @param npcId
	 *            NPC with whom to have the cutscene
	 * @param strings
	 *            String to display with parameters
	 */
	private void InitCutscene(int npcId, int stringId)
	{
// InvalidateStrings();
		UpdateSocialBG(m_SelectedNpc, false);
		UpdateSocialRelationshipScore();

		SwitchGameState(GameDefines.GAME_MODE_CUTSCENE);
		m_SocialMenuState = GameDefines.SOCIAL_MODE_INVALID;

		// Draw the text at the top of the screen.
		Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(stringId), Dialogue.BUTTONS_NONE, DialogueStyles.NO_BOX, true, true);
		Dialogue.s_dialogue.Move(Dialogue.s_dialogue.m_x, GameDefines.CUT_SCENE_MENU_TEXT_OFFSET);
		InitPauseExitSoftKeyText(false, true);

		int soundId = -1;

		// figure out which sound to play
		switch(stringId)
		{
		case StringId.CUTSCENE_FRIEND:
// s_CurrBG = Utility.loadImage("in_game_menus/Soc_Friend");
			soundId = SoundId.RELATIONSHIP_MILESTONES_FRIEND;
			break;

		case StringId.CUTSCENE_LOVE:
// s_CurrBG = Utility.loadImage("in_game_menus/Soc_Love");
			soundId = SoundId.RELATIONSHIP_MILESTONES_BEST_FRIEND;
			break;

		case StringId.CUTSCENE_MARRIED:
// s_CurrBG = Utility.loadImage("in_game_menus/Soc_Marraige");
			soundId = SoundId.RELATIONSHIP_MILESTONES_LOVER;
			break;

		case StringId.CUTSCENE_WOO_HOO:
			s_CurrBG = Utility.loadImage("in_game_menus/Soc_Stay", true);
// s_CurrBG = Utility.loadImage("in_game_menus/Soc_Love");
			soundId = SoundId.WANTS_PLATINUM;
			break;

		case StringId.CUTSCENE_DIVORCE:
			s_CurrBG = Utility.loadImage("in_game_menus/Soc_Divorce", true);
// s_CurrBG = Utility.loadImage("in_game_menus/Soc_Default");
			soundId = SoundId.SIMLISH_FEMALE_ROMANTIC_NEG;
			break;

		default:
			break;
		}

		if (soundId >= 0)
		{
			PlaySound(soundId, 1);
		}

	} // end InitCutscene

	/**
	* Initial Demo Screen Handling
	*
	*
	*/
//#ifdef ENABLE_VODAFONE_DEMO
 	private void InitInitialDemoMenusOptions(int gameState)
 	{
 		boolean displayStart = true;
 		InvalidateStrings();
 		switch(gameState)
 		{
 
 			case GameDefines.GAME_MODE_INITIALIZE_DEMO_SPLASH:
 				s_CurrBG = Utility.getDemoBackground();
                DrawDemoFreeTrialText(StringId.SIMS_TITLE,true);
                DrawDemoStartText(StringId.DEMO_START_TEXT);
 				//Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.DEMO_START_TEXT),
 				//					Dialogue.BUTTONS_NONE, DialogueStyles.NO_BOX, true, true);
 				//displayStart = true;
 				break;
 
 			case GameDefines.GAME_MODE_INITIALIZE_VODAFONE_DEMOOVER:
 				s_CurrBG = Utility.getDemoBackground();
 				if(!exitMain)
 					DrawDemoOverText(StringId.TRIAL_OVER);
 				Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.TRIAL_OVER_TEXT),
 									Dialogue.BUTTONS_NONE, DialogueStyles.NO_BOX, true, true);
 				displayStart = false;
 				break;
 
 		}
 		InitStartExitSoftKeyText(displayStart, true);
 	}
 	private void InitStartExitSoftKeyText(boolean displayStart, boolean displayBack)
 	{
 		m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1] = null;
 		m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2] = null;
 
 		// add the select string to the bottom right soft key area if needed
 		if (displayStart)
 		{
 				m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1] =
 				new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.DEMO_START_BTN), false,
 								GameDefines.SOFT_KEY_TEXT_X_OFFSET, GameDefines.SOFT_KEY_TEXT_Y_OFFSET,
 								Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.LEFT) );
 			m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1].m_font = Dialogue.FONT_PROP_SMALL;
 			m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1].DoLayout();
 		}
 		else
 		{
 				m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1] =
 				new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.GET_GAME), false,
 								GameDefines.SOFT_KEY_TEXT_X_OFFSET, GameDefines.SOFT_KEY_TEXT_Y_OFFSET,
 								Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.LEFT) );
 			m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1].m_font = Dialogue.FONT_PROP_SMALL;
 			m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1].DoLayout();
 
 		}
 		// add the back string to the bottom left soft key area if needed
 		if (displayBack)
 		{
 				m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2] =
 				new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.DEMO_EXIT_BTN), false,
 								(SKUConsts.ISO_VIEW_WIDTH - GameDefines.SOFT_KEY_TEXT_X_OFFSET), GameDefines.SOFT_KEY_TEXT_Y_OFFSET,
 								Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.RIGHT) );
 			m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2].m_font = Dialogue.FONT_PROP_SMALL;
 			m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2].DoLayout();
 		}
 
 	} // end InitStartExitSoftKeyText
    
    private void InitStartBackSoftKeyText()
 	{
        m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1] =
        new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.DEMO_START_BTN), false,
                        GameDefines.SOFT_KEY_TEXT_X_OFFSET, GameDefines.SOFT_KEY_TEXT_Y_OFFSET,
                        Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.LEFT) );
        m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1].m_font = Dialogue.FONT_PROP_SMALL;
        m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1].DoLayout();

        m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2] =
        new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.BACK), false,
                        (SKUConsts.ISO_VIEW_WIDTH - GameDefines.SOFT_KEY_TEXT_X_OFFSET), GameDefines.SOFT_KEY_TEXT_Y_OFFSET,
                        Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.RIGHT) );
        m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2].m_font = Dialogue.FONT_PROP_SMALL;
        m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2].DoLayout();

 	} // end InitStartExitSoftKeyText
 
//#endif

	/**
	 * Set up a dialog to show the options available at the start menu.
	 *
	 * @param gameState
	 *            The current game state
	 */
	private void InitInitialMenusOptions(int gameState)
	{
		boolean drawBack = true;
		Vector options = new Vector();

		InvalidateStrings();

		switch(gameState)
		{
		case GameDefines.GAME_MODE_INITIALIZE_START_MENU:
			// set the BG image to the default image
			s_CurrBG = Utility.loadImage("splashscreens/Sims2Logo", true);

			Vector disabledOptions = new Vector();
			if (shell.Build.VODAFONE) {
 				options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.GET_GAME) );
 				options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.START_MENU_OPTION_DEMO) );
			}
			else {
				options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.START_MENU_OPTION_0) );
			}

			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.START_MENU_OPTION_1) );

// String[] records = RecordStore.listRecordStores();
//
// // if there is no save data, make the load option unavailable
// if ( (records == null) ||
// !(records[0].equals(GameDefines.SAVE_GAME_NAME_1)) )
// {
// disabledOptions.addElement(new Integer(1) );
// }

			try{
				RecordStore store = RecordStore.openRecordStore(GameDefines.SAVE_GAME_NAME_1, false);
				store.closeRecordStore();
			}catch(Exception e){
				//#ifdef DEBUG
//# 				e.printStackTrace();
				//#endif

				// no save game present, turn off the option
				if (shell.Build.VODAFONE) {
					disabledOptions.addElement(new Integer(2) );
				}
				else {
					disabledOptions.addElement(new Integer(1) );
				}
			}

			if (shell.Build.VODAFONE) {
//# 				//Dont Enable Load Game Always
 				disabledOptions.addElement(new Integer(2) );
			}


			
			m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_SOUND_ON;
			try{
				RecordStore store = RecordStore.openRecordStore("SimsSoundPref", false);
				store.closeRecordStore();
				if( store != null ){
					m_SaveFlags &= ~GameDefines.SAVE_FLAG_MASK_SOUND_ON;
				}
				else
				{
					
				}
				
			}catch(Exception e){
				//#ifdef DEBUG
//# 				e.printStackTrace();
				//#endif
			}

			// get the new on/off string
			if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_SOUND_ON) != 0)
			{
				options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.START_MENU_OPTION_4) );
			}
			else
			{
				options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.START_MENU_OPTION_2) );
			}

			//#ifdef ENABLE_GAMELOBBY
//# 			options.addElement( "Game Lobby" );
			//#endif

			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.START_MENU_OPTION_3) );


			m_DialogNumOptions = GameDefines.NUM_START_MENU_OPTIONS;
			drawBack = false;

			// initialize the dialog for the options
			Dialogue.SetStaticDialogue(new Dialogue(options, disabledOptions, DialogueStyles.NO_BOX,
							(Graphics.TOP | Graphics.HCENTER), 0, false, true ), -1);

			// move the static dialog down a bit
			Dialogue.s_dialogue.Move(Dialogue.s_dialogue.m_x, GameDefines.START_MENU_TEXT_Y_OFFSET);

			// draw the legal text at bottom of the screen
// m_Dialogs[GameDefines.DIALOG_ID_0] =
// new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.TITLE_LEGAL_TEXT),
// false, 0,
// GameDefines.START_MENU_LEGAL_Y_OFFSET, Colors.WHITE, (Graphics.TOP |
// Graphics.HCENTER) );
			m_Dialogs[GameDefines.DIALOG_ID_0] =
				new Dialogue(" 2007 Electronic Arts Inc.", false, 0,
								GameDefines.START_MENU_LEGAL_Y_OFFSET, Colors.WHITE, (Graphics.TOP | Graphics.HCENTER) );

			break;

		case GameDefines.GAME_MODE_INITIALIZE_INTRODUCTION:
			s_CurrBG = Utility.loadImage("in_game_menus/Soc_Default", true);
			Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.INTRODUCTION_0), 
                Dialogue.BUTTONS_NONE, DialogueStyles.GRAPHIC_BOX, true, true);
			break;

//#ifdef ENABLE_VODAFONE_DEMO
 		case GameDefines.GAME_MODE_INITIALIZE_VODAFONE_DEMOOVER:
 			s_CurrBG = Utility.getDemoBackground();
 			DrawTitleText(StringId.TRIAL_OVER);
 			Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.TRIAL_OVER_TEXT),
 									Dialogue.BUTTONS_NONE, DialogueStyles.NO_BOX, true, true);
 			break;
//#endif
		case GameDefines.GAME_MODE_INITIALIZE_DEMOOVER:
			s_CurrBG = Utility.loadImage("in_game_menus/Soc_Default", true);
			Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.DEMOOVER_TEXT), Dialogue.BUTTONS_YESNO);
			break;

		case GameDefines.GAME_MODE_INITIALIZE_SELECT_A_SIM:
			LoadPlayer();
			m_PlayerSim.ControlAnimation(SimObject.ANIM_ID_DANCE, true, AnimationEffect.NONE);

			s_CurrBG = Utility.loadImage("in_game_menus/Soc_Default", true);
			m_PlayerName = (StringId.PLAYER_NAME_0 + GameDefines.SIM_SELECT_NUM_OPTIONS);
			m_PlayerSign = StringId.CAPRICORN;

			disabledOptions = new Vector();
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.GENDER_MENU_OPTION_1) );
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.CREATE_A_SIM_APPEARANCE) );
			options.addElement(SimsCanvas.s_Canvas.getStringById(m_PlayerSign) );
			options.addElement(SimsCanvas.s_Canvas.getStringById(m_PlayerName) );
            
            disabledOptions.addElement(new Integer(1));
            disabledOptions.addElement(new Integer(2));
            disabledOptions.addElement(new Integer(3));

			Dialogue.SetStaticDialogue(new Dialogue(options, disabledOptions, DialogueStyles.NO_BOX,
						(Graphics.TOP | Graphics.HCENTER), 0, true, true ), -1);

			//Dialogue.SetStaticDialogue(new Dialogue(options, DialogueStyles.NO_BOX,
			//				(Graphics.TOP | Graphics.HCENTER), 0, true, true ), -1);

			// move the static dialog down a bit
			Dialogue.s_dialogue.Move(Dialogue.s_dialogue.m_x, GameDefines.SIM_SELECT_OPT_TEXT_Y_POS);

			// draw the title text at top of the screen
			m_Dialogs[GameDefines.DIALOG_ID_0] = null;
			m_Dialogs[GameDefines.DIALOG_ID_0] =
				new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.CREATE_A_SIM_TITLE), false, 0,
								GameDefines.SIM_SELECT_TITLE_TEXT_Y_POS, Colors.YELLOW, (Graphics.TOP | Graphics.HCENTER) );

			// load the arrow sprites for to show the player can choose
			// different options
			s_RoommateSpriteIcons[0] = Utility.loadImage("in_game_menus/tiny_arrow_left", true);
			s_RoommateSpritePos[0][0] =
				(Dialogue.s_dialogue.m_x - s_RoommateSpriteIcons[0].getWidth() - GameDefines.SIM_SELECT_ARROW_X_OFFSET);
			s_RoommateSpritePos[0][1] = (Dialogue.s_dialogue.m_y + GameDefines.SIM_SELECT_ARROW_Y_OFFSET);

			s_FriendshipSpriteIcons[0] = Utility.loadImage("in_game_menus/tiny_arrow_right", true);
			s_FriendshipSpritePos[0][0] =
				(Dialogue.s_dialogue.m_x + Dialogue.s_dialogue.m_width +  GameDefines.SIM_SELECT_ARROW_X_OFFSET);
			s_FriendshipSpritePos[0][1] =
				(Dialogue.s_dialogue.m_y + GameDefines.SIM_SELECT_ARROW_Y_OFFSET);
			break;

		default:
			break;
		}

		if (gameState == GameDefines.GAME_MODE_INITIALIZE_INTRODUCTION) {
            InitStartBackSoftKeyText();
        }
        //else if (SKUConsts.VODAFONE_DEMO && drawQuit) {
        //    InitPauseExitSoftKeyText(true, false);
        //
        //    m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2] =
		//		new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.START_MENU_OPTION_3), false,
		//						(SKUConsts.ISO_VIEW_WIDTH - GameDefines.SOFT_KEY_TEXT_X_OFFSET), GameDefines.SOFT_KEY_TEXT_Y_OFFSET,
		//						Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.RIGHT) );
		//	m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2].m_font = Dialogue.FONT_PROP_SMALL;
		//	m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2].DoLayout();
        //}
        else {
            InitPauseExitSoftKeyText(true, drawBack);
        }
	}

	/**
	 * Sets up the text for the pause menu exit soft key
	 *
	 * @param displaySelect
	 * @param displayBack
	 */
	private void InitPauseExitSoftKeyText(boolean displaySelect, boolean displayBack)
	{
		m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1] = null;
		m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2] = null;

		// add the select string to the bottom right soft key area if needed
		if (displaySelect)
		{
			if(demoOver)
			{
				m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1] =
				new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.DEMO_BUY), false,
								GameDefines.SOFT_KEY_TEXT_X_OFFSET, GameDefines.SOFT_KEY_TEXT_Y_OFFSET,
								Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.LEFT) );

			}
			else
			{
				m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1] =
				new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.SELECT), false,
								GameDefines.SOFT_KEY_TEXT_X_OFFSET, GameDefines.SOFT_KEY_TEXT_Y_OFFSET,
								Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.LEFT) );
			}
			m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1].m_font = Dialogue.FONT_PROP_SMALL;
			m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_1].DoLayout();
		}

		// add the back string to the bottom left soft key area if needed
		if (displayBack)
		{
			if(demoOver)
			{
				m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2] =
				new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.GAME_OPTION_QUIT), false,
								(SKUConsts.ISO_VIEW_WIDTH - GameDefines.SOFT_KEY_TEXT_X_OFFSET), GameDefines.SOFT_KEY_TEXT_Y_OFFSET,
								Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.RIGHT) );

			}
			else
			{
				m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2] =
				new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.BACK), false,
								(SKUConsts.ISO_VIEW_WIDTH - GameDefines.SOFT_KEY_TEXT_X_OFFSET), GameDefines.SOFT_KEY_TEXT_Y_OFFSET,
								Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.RIGHT) );
			}
			m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2].m_font = Dialogue.FONT_PROP_SMALL;
			m_Dialogs[GameDefines.DIALOG_ID_SOFT_KEY_2].DoLayout();
		}

	} // end InitPauseExitSoftKeyText


	/**
	 * Initializes the Main Pause Menu
	 *
	 */
	private void InitMainPauseMenu()
	{
		Vector options = new Vector();
		Vector disabledOptions = new Vector();

		// draw the title
		DrawTitleText(StringId.VIRTUAL_MOBILE_TITLE);

		// load the main options
		for (int i = 0; i < GameDefines.NUM_PAUSED_MAIN_OPTIONS; i++)
		{
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.PAUSE_MAIN_OPTION_0 + i) );
		}

		// don't allow calling when the player is at work or is busy
		if ((m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_BUSY) != 0)
		{
			disabledOptions.addElement(new Integer(GameDefines.PAUSED_MODE_CALL) );
		}

		// grey out friends when the player has none
		if (m_NpcFlags == 0)
		{
			disabledOptions.addElement(new Integer(GameDefines.PAUSED_MODE_FRIENDS) );
		}

		m_DialogNumOptions = GameDefines.NUM_PAUSED_MAIN_OPTIONS;

		// initialize the dialog for the options
		Dialogue.SetStaticDialogue(new Dialogue(options, disabledOptions, DialogueStyles.NO_BOX,
						(Graphics.TOP | Graphics.HCENTER), m_LastVMSelection, true, true ), -1);

		InitPauseExitSoftKeyText(true, true);

	} // InitMainPauseMenu

//#ifdef ENABLE_VODAFONE_DEMO
 	/**
 	 * Initializes the Demo Pause Menu
 	 *
 	 */
 
 	private void InitDemoPauseMenu()
 	{
 		Vector options = new Vector();
 
 		// draw the title
 		DrawTitleText(StringId.DEMO_MENU);
 
 		// load the demo options
 		options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.DEMO_RESUME) );
 		options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.VIRTUAL_MOBILE_TITLE) );
 		options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.DEMO_RESTART) );
 		options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.DEMO_EXIT_BTN) );
 
 		m_DialogNumOptions = 4;
 
 		// initialize the dialog for the options
 		Dialogue.SetStaticDialogue(new Dialogue(options, DialogueStyles.NO_BOX,
 						(Graphics.TOP | Graphics.HCENTER), 0, true, true ), -1);
 
 		InitPauseExitSoftKeyText(true, true);
 
 	} // InitDemoPauseMenu
 
//#endif

	/**
	 * Initializes the Call menu
	 *
	 */
	private void InitCallMenu()
	{
		int numOptions = GameDefines.NUM_CALL_MENU_OPTIONS;
		Vector 	options = new Vector();
		Vector 	disabledOptions = new Vector();

		// set the initial submenu state to the maximum for the call menu
		m_SubMenuState = GameDefines.NUM_CALL_MENU_OPTIONS;

		// Set up the call selection menu
		for (int i = 0; i < GameDefines.NUM_CALL_MENU_OPTIONS; i++)
		{
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.CALL_OPTION_0 + i) );
		}

		if (m_NpcFlags == 0)
		{
			// Deactivate the call sim, invite and throw party options.
			disabledOptions.addElement(new Integer(0) );
			disabledOptions.addElement(new Integer(1) );
			disabledOptions.addElement(new Integer(2) );
			numOptions -= 3;
		}
		// if there are too many npcs in the house already, then don't let them
		// in
		else if ( (m_ActionQueue.size() + m_NpcsInHouse) >= WorldData.NUM_NPCS_ALLOWED_IN_HOUSE)
		{
			disabledOptions.addElement(new Integer(1) );
			disabledOptions.addElement(new Integer(2) );
			numOptions -= 2;
		}
		// also, if the party room hasn't been purchased, remove the throw party
		// option
		else if( ( (m_LockFlags & ( (long)1 << SimAttributes.ROOM_PARTYROOM) ) != 0) ||
				 ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_HAVE_THROWN_PARTY_TODAY) != 0 ) )
		{
			disabledOptions.addElement(new Integer(2) );
			numOptions--;
		}

		// Grey out the construction and emporium options if nothing is there to
		// buy
		boolean roomAvailable = false;
		boolean itemAvailable = false;

		// draw all available rooms to the screen
		for (Enumeration e = m_BuyList.elements(); e.hasMoreElements(); )
		{
			int itemId = ( (Integer)e.nextElement() ).intValue();

			// make sure it is a room that can be bought, if so, then display
			// the option
			if ( !roomAvailable &&
				 (itemId >= SimAttributes.ROOM_LIVINGROOM) &&
				 (itemId < SimAttributes.NUM_ROOMS) )
			{
				roomAvailable = true;
			}

			// make sure it is a item that can be bought, if so, then display
			// the option
			if ( !itemAvailable &&
				 (itemId >= SimAttributes.NUM_ROOMS) )
			{
				itemAvailable = true;
			}

			if (roomAvailable && itemAvailable)
			{
				break;
			}
		}

		if (!roomAvailable)
		{
			disabledOptions.addElement(new Integer(3) );
			numOptions--;
		}

		if (!itemAvailable)
		{
			disabledOptions.addElement(new Integer(4) );
			numOptions--;
		}

		m_DialogNumOptions = GameDefines.NUM_CALL_MENU_OPTIONS;

		// initialize the dialog for the options
		Dialogue.SetStaticDialogue(new Dialogue( options, disabledOptions, DialogueStyles.NO_BOX,
						(Graphics.TOP | Graphics.HCENTER), 0, true, true ), -1);

		// add the selected option text to the lower portion of the screen if
		// there is any options
		if (numOptions == 0)
		{
			m_GameFlags |= GameDefines.GAME_FLAG_MASK_NO_OPTIONS_AVAIL;
		}

		InitPauseExitSoftKeyText( (numOptions > 0) ? true : false, true);

	} // end InitCallMenu

	/**
	 * Initializes the Call Sim, Invite Sim and Throw Party menus
	 *
	 * @param selectedOption
	 */
	private void InitCallSimMenus(int selectedOption)
	{
		Vector 	options = new Vector();
		Vector 	disabledOptions = new Vector();
		int numSimsAvailable = WorldData.NUM_NPCS;
		int j = 0;
		int i;
		int numNpcsAlreadyHere = (m_NumNpcsComing + m_ActionQueue.size() + m_NpcsInHouse);

		// Set up the call selection menu
		m_SubMenuState = selectedOption;

		for (i = 0; i < WorldData.NUM_NPCS; i++)
		{
			if ( (m_NpcFlags & (1 << i) ) != 0)
			{
				m_DialogStringIds[j] = (short)(StringId.SOCIAL_GOSSIP_0 + i);
				options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_GOSSIP_0 + i) );

				if(selectedOption == GameDefines.CALL_OPTION_2)
				{
					if ( (m_NpcsComing[i] == WorldData.NPC_COMING_PARTY) ||
						 (m_NpcsComing[i] == WorldData.NPC_PARTY_REJECT) ||
						 (m_NpcLocations[i] != WorldData.NPC_LOC_INVALID) ||
						 ( (numNpcsAlreadyHere) >= WorldData.NUM_NPCS_ALLOWED_IN_HOUSE) )
					{
						// Disable option if NPC already coming to party
						disabledOptions.addElement(new Integer(j) );
					}
				}
				else
				{
					if ( (m_NpcsComing[i] != WorldData.NPC_COMING_NONE) ||
						 (m_NpcLocations[i] != WorldData.NPC_LOC_INVALID) ||
						 ( (selectedOption == GameDefines.CALL_OPTION_2) &&
						   (numNpcsAlreadyHere >= WorldData.NUM_NPCS_ALLOWED_IN_HOUSE) ) )
					{
						// Disable option if already coming over or in lot
						disabledOptions.addElement(new Integer(j) );
						numSimsAvailable--;
					}
				}

				j++;
			}
			else
			{
				numSimsAvailable--;
			}
		}

		if (numSimsAvailable > 0)
		{
			if (selectedOption == GameDefines.CALL_OPTION_2)
			{
				m_DialogStringIds[j++] = (short)StringId.YES;
				options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.YES) );
			}

			InitPauseExitSoftKeyText(true, true);
		}
		else
		{
			m_GameFlags |= GameDefines.GAME_FLAG_MASK_NO_OPTIONS_AVAIL;
			InitPauseExitSoftKeyText(false, true);
		}

		m_DialogNumOptions = j;

		// initialize the dialog for the options
		Dialogue.SetStaticDialogue(new Dialogue(options, disabledOptions, DialogueStyles.NO_BOX,
						(Graphics.TOP | Graphics.HCENTER), 0, true, true ), -1);

	} // end InitCallSimMenu

	/**
	 * Initializes the purchasing menu
	 *
	 */
	private void InitPurchaseMenu()
	{
		Vector 		options = new Vector();
		String[] 	headerText;
		int 		numAvailItems = 0;

		// draw all available rooms to the screen using a selection dialog
		// system
		for (Enumeration e = m_BuyList.elements(); e.hasMoreElements(); )
		{
			int itemId = ( (Integer)e.nextElement() ).intValue();

			// if we are doing the house upgrade, then the object is the string
			// value minus the starting string value for the room
			if (m_SubMenuState == GameDefines.CALL_OPTION_3)
			{
				if (itemId < SimAttributes.NUM_ROOMS)
				{
					// make sure it is a room that can be bought, if so, then
					// display it as an available upgrade
					m_DialogStringIds[numAvailItems++] = (short)(StringId.ROOM_NAME_0 + itemId);
					options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.ROOM_NAME_0 + itemId) );
				}
			}
			else
			{
				if (itemId >= SimAttributes.NUM_ROOMS)
				{
					m_DialogStringIds[numAvailItems++] = (short)(StringId.ROOM_NAME_0 + itemId);
					options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.ROOM_NAME_0 + itemId) );
				}

				// if we have reached the limit of items we can display in the
				// selection, then beak out
				if (numAvailItems >= GameDefines.NUM_OBJECTS_TO_DISPLAY)
				{
					break;
				}
			}
		}

		// store out the number of options that will be in the selection dialog
		// (if 0, there won't be one)
		m_DialogNumOptions = numAvailItems;

		// purchasing the item, then we need to set up the purchase text using
		// the items
		headerText = new String[2];
		headerText[0] = SimsCanvas.s_Canvas.getStringById(StringId.PURCHASE_TEXT);

		// if we are doing the house upgrade, then the object is the string
		// value minus the starting string value for the room
		if (m_SubMenuState == GameDefines.CALL_OPTION_3)
		{
			headerText[1] = "" + ROOM_COST[m_DialogStringIds[0] - StringId.ROOM_NAME_0];
		}
		else
		{
			headerText[1] = "" + ITEM_COST[m_DialogStringIds[0] - StringId.OBJECT_NAME_0];
		}

		// add the selection dialog
		Dialogue.SetStaticDialogue(new Dialogue(options, DialogueStyles.NO_BOX,
						(Graphics.TOP | Graphics.HCENTER), 0, true, true ), -1);

		// draw the header information
		m_Dialogs[GameDefines.DIALOG_ID_0] =
			new Dialogue(Utility.GetExpandedTokenString(headerText), false, 0,
							GameDefines.CALL_MENU_TITLE_OFFSET, (Graphics.TOP | Graphics.HCENTER) );

	} // end InitPurchaseMenu

	/**
	 * Initializes the skill menu
	 *
	 */
	private void InitSkillMenu()
	{
		Vector 	options = new Vector();

		// load the skill names
		for (int i = 0; i < SimAttributes.NUM_SKILLS; i++)
		{
			String s = SimsCanvas.s_Canvas.getStringById(StringId.SKILL_0 + i) ;

			// add the skill values as well while here (plus 2 decimal places)
			s += " - " + GetSkillString( (SimAttributes.SKILL_COOKING + i), 2);
			s +=  "/" + (SimAttributes.MAX_SKILL_VALUE >> SimAttributes.FIXED_4_12_POS);

			options.addElement(s);
		}

		m_DialogNumOptions = SimAttributes.NUM_SKILLS;

		// initialize the dialog for the options
		Dialogue.SetStaticDialogue(new Dialogue(options, DialogueStyles.NO_BOX,
						(Graphics.TOP | Graphics.LEFT), 0, true, true ), -1);
		Dialogue.s_dialogue.Move(Dialogue.s_dialogue.m_x, GameDefines.CALL_MENU_TITLE_OFFSET);

		// add the selected option text to the lower portion of the screen
		m_Dialogs[GameDefines.DIALOG_ID_0] =
			new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.SKILL_INFO_0), false, 0,
							(Dialogue.s_dialogue.m_y + Dialogue.s_dialogue.m_height + GameDefines.FRIEND_SKILL_INFO_OFFSET),
							(Graphics.TOP | Graphics.HCENTER) );

		InitPauseExitSoftKeyText(false, true);

	} // end InitSkillMenu

	/**
	 * Initializes the friends menu
	 *
	 */
	private void InitFriendsMenu()
	{
		Vector 	options = new Vector();
		Vector 	disabledOptions = new Vector();
		boolean	showDescription	= false;

		// load the skill names
		for (int i = 0; i < WorldData.NUM_NPCS; i++)
		{
			String s = SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_GOSSIP_0 + i);
			s += " - " + String.valueOf(m_Relationships[i] >> SimAttributes.FIXED_POS) +
						"/" + String.valueOf(SimAttributes.RELATIONSHIP_MAX >> SimAttributes.FIXED_POS);

			options.addElement(s);

			// if the NPC is not unlocked, then don't show them as a selectable
			// option
			if ( (m_NpcFlags & (1 << i) ) == 0)
			{
				disabledOptions.addElement(new Integer(i) );
			}
			else
			{
				showDescription = true;
			}
		}

		m_DialogNumOptions = WorldData.NUM_NPCS;

		// initialize the dialog for the options
		Dialogue.SetStaticDialogue(new Dialogue(options, disabledOptions, DialogueStyles.NO_BOX,
						(Graphics.TOP | Graphics.HCENTER), 0, true, true ), -1);
		Dialogue.s_dialogue.Move(Dialogue.s_dialogue.m_x, GameDefines.CALL_MENU_TITLE_OFFSET);

		int yPos = (Dialogue.s_dialogue.m_y + Dialogue.s_dialogue.m_height + GameDefines.FRIEND_SKILL_INFO_OFFSET);

		// add the selected option text to the lower portion of the screen if
		// there are friends available
		if (showDescription)
		{
			m_Dialogs[GameDefines.DIALOG_ID_0] =
				new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.BIO_BEN), false, 0, yPos,
								(Graphics.TOP | Graphics.HCENTER) );
		}

		yPos = Dialogue.s_dialogue.m_y;

		// now go through the menu and set up the relation ship icons for each
		// NPC
		for (int i = 0; i < WorldData.NUM_NPCS; i++)
		{
			// set up the sprite
			SetFriendhipIcons(i, GameDefines.FRIEND_REL_SPR_X_OFFSET, yPos);
			yPos += (Dialogue.s_dialogue.m_font.getHeight() + Dialogue.s_dialogue.m_lineSpacing);
		}

		InitPauseExitSoftKeyText(false, true);

	} // end InitFriendsMenu

	/**
	 * Initializes the Option Menu
	 *
	 */
	private void InitOptionMenu()
	{
		Vector options = new Vector();
		Vector disabledOptions = new Vector();

		if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_SOUND_ON) != 0)
		{
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.START_MENU_OPTION_4) );
		}
		else
		{
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.START_MENU_OPTION_2) );
		}

		// load the help options
		for (int i = 0; i < (GameDefines.NUM_GAME_OPTIONS - 1); i++)
		{
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.GAME_OPTION_CREDITS + i) );
		}

		// don't allow saving when the player is at work
		if ( isDemo || (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_WORKING) != 0)
		{
			disabledOptions.addElement(new Integer(GameDefines.GAME_OPTION_SAVE_GAME) );
		}

		m_DialogNumOptions = GameDefines.NUM_GAME_OPTIONS;

		// initialize the dialog for the options
		Dialogue.SetStaticDialogue(new Dialogue(options, disabledOptions, DialogueStyles.NO_BOX,
						(Graphics.TOP | Graphics.HCENTER), 0, true, true ), -1);
		InitPauseExitSoftKeyText(true, true);

	} // InitOptionMenu

	/**
	 * Initializes the Want menu (really the goal and want menu)
	 *
	 */
	private void InitGoalWantMenu()
	{
		int numOptions = 0;
		int stringFlags = (Graphics.TOP | Graphics.HCENTER) ;
		int yPos = GameDefines.WANT_MENU_TITLE_OFFSET;

		// add the skill values as well while here
		String s = null;

		// display the current goal if there is one
		if (m_CurrGoal < SimAttributes.NUM_GOALS)
		{
			s = SimsCanvas.s_Canvas.getStringById(StringId.GOAL_TEXT_0 + m_CurrGoal);
			m_Dialogs[numOptions] = new Dialogue(s, false, 0, yPos, Style.DIALOGUE_TEXT_COLOR, stringFlags);
			yPos += m_Dialogs[numOptions++].m_height;
		}

		// now go through the wants and display those that are available
		for (int i = 0; i < SimAttributes.NUM_POSSIBLE_WANTS; i++)
		{
			if (m_CurrWants[i] != SimAttributes.WANT_INVALID)
			{
				s = SimsCanvas.s_Canvas.getStringById(m_CurrWants[i]);
				m_Dialogs[numOptions] = new Dialogue(s, false, 0, yPos, Style.DIALOGUE_TEXT_COLOR, stringFlags);
				yPos += m_Dialogs[numOptions++].m_height;
			}
		}

		if (numOptions == 0)
		{
			s = SimsCanvas.s_Canvas.getStringById(StringId.NONE);
			m_Dialogs[numOptions++] = new Dialogue(s, false, 0, yPos, Style.DIALOGUE_TEXT_COLOR, stringFlags);
		}

		InitPauseExitSoftKeyText(false, true);

	} // end InitGoalWantMenu

	/**
	 * Initializes the job menu
	 *
	 */
	private void InitJobMenu()
	{
		String	tempString 		= null;
		int 	stringFlags		= (Graphics.TOP | Graphics.HCENTER);
		int 	yPos 			= GameDefines.CALL_MENU_TITLE_OFFSET;
		int		numOptions		= 0;

		// Current Job header row
		m_Dialogs[numOptions] =
			new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.CURRENT_JOB), false, 0, yPos,
							Style.DIALOGUE_MAIN_TEXT_COLOR, stringFlags);

		// increase the y position by the height of the string
		yPos += m_Dialogs[numOptions++].m_height;

		// Display the current job data if there is one
		if (m_CurrJob != WorldData.JOB_NONE)
		{
			numOptions = DrawJobData(yPos, m_CurrJob, numOptions);
		}
		else
		{
			m_Dialogs[numOptions] =
				new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.NONE), false, 0, yPos,
								Style.DIALOGUE_TEXT_COLOR, stringFlags);
			m_Dialogs[numOptions].m_font = Dialogue.FONT_PROP_SMALL;
			m_Dialogs[numOptions].DoLayout();
		}

		yPos = (m_Dialogs[numOptions].m_y + m_Dialogs[numOptions].m_height);
		numOptions++;

		// Next Job header row
		m_Dialogs[numOptions] =
			new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.NEXT_JOB), false, 0, yPos,
							Style.DIALOGUE_MAIN_TEXT_COLOR, stringFlags);

		// increase the y position by the height of the string
		yPos += m_Dialogs[numOptions++].m_height;

		if (m_NextJob != WorldData.JOB_NONE)
		{
			numOptions = DrawJobData(yPos, m_NextJob, numOptions);
			yPos = (m_Dialogs[numOptions].m_y + m_Dialogs[numOptions].m_height);
			numOptions++;

			// requirement header
			m_Dialogs[numOptions] =
				new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.REQUIREMENTS), false, 0, yPos,
								Style.DIALOGUE_MAIN_TEXT_COLOR, stringFlags);

			// increase the y position by the height of the string
			yPos += m_Dialogs[numOptions++].m_height;

			// used for the placement of the job pre-requisites
			int skillNum = 0;

			// requirements (there may be more than one)
			for (int i = 0; i < SimAttributes.NUM_SKILLS; i++)
			{
				// display the skill if it is needed
				if (JOB_DATA[m_NextJob][WorldData.JOB_DATA_SKILL_START + i] > 0)
				{
					// make the string to display
					tempString = SimsCanvas.s_Canvas.getStringById(StringId.SKILL_0 + i) + " " +
					JOB_DATA[m_NextJob][WorldData.JOB_DATA_SKILL_START + i];

					m_Dialogs[numOptions] =
						new Dialogue(tempString, false, (skillNum % 2 == 0) ? 0 : SKUConsts.ISO_VIEW_WIDTH, yPos,
										Style.DIALOGUE_TEXT_COLOR, (skillNum % 2 == 0) ?
											(Graphics.TOP | Graphics.LEFT) : (Graphics.TOP | Graphics.RIGHT) );
					m_Dialogs[numOptions].m_font = Dialogue.FONT_PROP_SMALL;
					m_Dialogs[numOptions].DoLayout();

					skillNum++;

					if (skillNum == 2)
					{
						yPos += m_Dialogs[numOptions].m_height;
					}

					numOptions++;
				}
			}

			// if there is a friends pre-requisite, show it as well
			if (JOB_DATA[m_NextJob][WorldData.JOB_DATA_NUM_FRIENDS] > 0)
			{
				// make the string to display
				tempString = SimsCanvas.s_Canvas.getStringById(StringId.PAUSE_MAIN_OPTION_3) + " " +
				JOB_DATA[m_NextJob][WorldData.JOB_DATA_NUM_FRIENDS];

				m_Dialogs[numOptions] =
					new Dialogue(tempString, false, (skillNum % 2 == 0) ? 0 : SKUConsts.ISO_VIEW_WIDTH, yPos,
									Style.DIALOGUE_TEXT_COLOR, (skillNum % 2 == 0) ?
										(Graphics.TOP | Graphics.LEFT) : (Graphics.TOP | Graphics.RIGHT) );
				m_Dialogs[numOptions].m_font = Dialogue.FONT_PROP_SMALL;
				m_Dialogs[numOptions].DoLayout();
			}
		}
		else
		{
			m_Dialogs[numOptions] =
				new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.NONE), false, 0, yPos,
								Style.DIALOGUE_TEXT_COLOR, stringFlags);
			m_Dialogs[numOptions].m_font = Dialogue.FONT_PROP_SMALL;
			m_Dialogs[numOptions].DoLayout();
		}

		InitPauseExitSoftKeyText(false, true);

	} // end InitJobMenu

	/**
	 * Draws the job data for the job screen NOTE: Consolidating code to make it
	 * cleaner and less code space
	 *
	 * @param yPos
	 * @param jobId
	 * @param stringHandleId
	 * @return
	 */
	private int DrawJobData(int yPos, int jobId, int currDialogPos)
	{
		String 	tempString 		= SimsCanvas.s_Canvas.getStringById(StringId.JOB_TITLE_0 + jobId);
		int 	newYPos		 	= yPos;
		int		newDialogPos	= currDialogPos;
		int 	stringFlags		= (Graphics.TOP | Graphics.HCENTER);

		// title
		m_Dialogs[newDialogPos] =
			new Dialogue(tempString, false, 0, newYPos, Style.DIALOGUE_TEXT_COLOR, stringFlags);
		m_Dialogs[newDialogPos].m_font = Dialogue.FONT_PROP_SMALL;
		m_Dialogs[newDialogPos].DoLayout();

		// increase the y position by the height of the string
		newYPos += m_Dialogs[newDialogPos++].m_height;

		// time of day
		tempString = "";

		// determine what the starting hour time frame is
		if ( (JOB_DATA[jobId][WorldData.JOB_DATA_START_HOUR] - 12) >= 0)
		{
			tempString += (JOB_DATA[jobId][WorldData.JOB_DATA_START_HOUR] - 12);
			tempString += SimsCanvas.s_Canvas.getStringById(StringId.EVENING);
		}
		else
		{
			tempString += JOB_DATA[jobId][WorldData.JOB_DATA_START_HOUR];
			tempString += SimsCanvas.s_Canvas.getStringById(StringId.MORNING);
		}

		tempString += "-";

		// determine what the ending hour time frame is
		if ( (JOB_DATA[jobId][WorldData.JOB_DATA_END_HOUR] - 12) >= 0)
		{
			tempString += (JOB_DATA[jobId][WorldData.JOB_DATA_END_HOUR] - 12);
			tempString += SimsCanvas.s_Canvas.getStringById(StringId.EVENING);
		}
		else
		{
			tempString += JOB_DATA[jobId][WorldData.JOB_DATA_END_HOUR];
			tempString += SimsCanvas.s_Canvas.getStringById(StringId.MORNING);
		}

		m_Dialogs[newDialogPos] =
			new Dialogue(tempString, false, 0, newYPos, Style.DIALOGUE_TEXT_COLOR, stringFlags);
		m_Dialogs[newDialogPos].m_font = Dialogue.FONT_PROP_SMALL;
		m_Dialogs[newDialogPos].DoLayout();

		// increase the y position by the height of the string
		newYPos += m_Dialogs[newDialogPos++].m_height;

		// salary
		tempString = (SimsCanvas.s_Canvas.getStringById(StringId.SIMOLEANS) +
						(JOB_DATA[jobId][WorldData.JOB_DATA_SALARY] * WorldData.JOB_SALARY_MULTIPLIER) );

		m_Dialogs[newDialogPos] =
			new Dialogue(tempString, false, 0, newYPos, Style.DIALOGUE_TEXT_COLOR, stringFlags);
		m_Dialogs[newDialogPos].m_font = Dialogue.FONT_PROP_SMALL;
		m_Dialogs[newDialogPos].DoLayout();

		return(newDialogPos);

	} // end DrawJobData

	/**
	 * Initializes the Help Menu
	 *
	 */
	private void InitHelpMenu()
	{
		Vector options = new Vector();

		// load the help options
		for (int i = 0; i < GameDefines.NUM_HELP_MENU_OPTIONS; i++)
		{
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.HELP_OPTION_0 + i) );
		}

		m_DialogNumOptions = GameDefines.NUM_HELP_MENU_OPTIONS;

		// initialize the dialog for the options
		Dialogue.SetStaticDialogue(new Dialogue(options, DialogueStyles.NO_BOX,
						(Graphics.TOP | Graphics.HCENTER), 0, true, true ), -1);

		InitPauseExitSoftKeyText(true, true);

	} // InitHelpMenu

	/**
	 * Sets the current game menu to the new state
	 *
	 * @param newState
	 */
	public void SwitchGameState(int newState)
	{
		// Special handling for switching states.
		if(newState == GameDefines.GAME_MODE_PAUSE_MENU)
		{
			if( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_SMOKE_ALARM_RINGING) != 0)
			{
				// Stop the alarm (it will restart automatically)
				// Stop the sound regardless of the state.
				Utility.stopSound(SoundId.SOUND_ALARMCLOCK );
				m_SaveFlags &= ~(GameDefines.SAVE_FLAG_MASK_SMOKE_ALARM_RINGING);
			}
		}

		if (newState == GameDefines.GAME_MODE_RUN_GAME)
		{
			m_GameTimer = System.currentTimeMillis();
			InitPauseExitSoftKeyText(false, false);
		}

		// if we are in a pause state, then we can't change the actual state, so
		// shuffle things around a bit
		if (m_CurrGameState == GameDefines.GAME_MODE_PAUSE_APP)
		{
			m_PrevGameState = m_PauseGameState;
			m_PauseGameState = newState;

			s_OldBG = s_CurrBG;
			s_CurrBG = Utility.loadImage("splashscreens/Sims2Logo", true);
		}
		else
		{
			m_PrevGameState = m_CurrGameState;
			m_CurrGameState = newState;

			// Do a bit of clean up
			CallGC();
		}

		m_SubMenuState = 0;

	} // end SwitchGameState

	/**
	 * Sets the sprite information for the friendship icons
	 *
	 * @param npcId
	 * @param baseX
	 * @param baseY
	 */
	private void SetFriendhipIcons(int npcId, int baseX, int baseY)
	{
		// Set up the Spouse/Roommate icon
		if (npcId == m_SpouseNpcId)
		{
			s_RoommateSpriteIcons[npcId] = Utility.loadImage("in_game_menus/Relationships_Joined", true);
		}
		else if (npcId == m_RoommateNpcId)
		{
			s_RoommateSpriteIcons[npcId] = Utility.loadImage("in_game_menus/Roommates", true);
		}
		else
		{
			s_RoommateSpriteIcons[npcId] = null;
		}

		// Set up the Friend/Lover icon
		if (m_Relationships[npcId] >= SimAttributes.RELATIONSHIP_LOVER)
		{
			s_FriendshipSpriteIcons[npcId] = Utility.loadImage("in_game_menus/Relationships_Love", true);
		}
		else if (m_Relationships[npcId] >= SimAttributes.RELATIONSHIP_FRIEND)
		{
			s_FriendshipSpriteIcons[npcId] = Utility.loadImage("in_game_menus/Relationships_Friends", true);
		}
		else
		{
			s_FriendshipSpriteIcons[npcId] = null;
		}

		// set the sprite positions
		if (s_RoommateSpriteIcons[npcId] != null)
		{
			s_RoommateSpritePos[npcId][0] = (baseX + GameDefines.ROOMMATE_SPR_X_OFFSET);
			s_RoommateSpritePos[npcId][1] = baseY;
		}

		if (s_FriendshipSpriteIcons[npcId] != null)
		{
			s_FriendshipSpritePos[npcId][0] = baseX;
			s_FriendshipSpritePos[npcId][1] = baseY;
		}

	} // end SetFriendhipIcons

	/*
	 * Input methods for menus, etc.
	 */

	/**
	 * Handles the option selection for the main pause mode
	 *
	 * @param optionSelected
	 */
	private void DoMainPauseSelection(boolean optionSelected)
	{
		// if the exit button was pressed, then exit the pause menu
		if (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK) )
		{
			SwitchGameState(GameDefines.GAME_MODE_RUN_GAME);
			InvalidateStrings();
			m_DoubleCursorTimer = (m_GameTime - 1);
			return;
		}

		if (optionSelected)
		{
			InvalidateStrings();
			m_MenuState = m_DialogSelectedOption;
			m_SubMenuState = 0;

			// draw the title
			DrawTitleText(StringId.PAUSE_MAIN_OPTION_0 + m_MenuState);

			// set up the the sub menu chosen
			switch(m_DialogSelectedOption)
			{
			case GameDefines.PAUSED_MODE_CALL:
				InitCallMenu();
				break;

			case GameDefines.PAUSED_MODE_SKILLS:
				InitSkillMenu();
				break;

			case GameDefines.PAUSED_MODE_OPTIONS:
				InitOptionMenu();
				break;

			case GameDefines.PAUSED_MODE_FRIENDS:
				InitFriendsMenu();
				break;

			case GameDefines.PAUSED_MODE_WANTS:
				InitGoalWantMenu();
				break;

			case GameDefines.PAUSED_MODE_JOB_DATA:
				InitJobMenu();
				break;

			case GameDefines.PAUSED_MODE_HELP:
				InitHelpMenu();
				break;

			default:
				break;
			}
		}
		// otherwise update the option text
		else
		{
			if (m_MainPauseMenuSelection != m_DialogSelectedOption)
			{
				m_MainPauseMenuSelection = m_DialogSelectedOption;
			}
		}

	} // end DoMainPauseSelection

//#ifdef ENABLE_VODAFONE_DEMO
 	/**
 	 * Handles the option selection for the main pause mode
 	 *
 	 * @param optionSelected
 	 */
 	private void DoDemoPauseSelection(boolean optionSelected)
 	{
 		// if the exit button was pressed, then exit the pause menu
 		if (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK) )
 		{
 			SwitchGameState(GameDefines.GAME_MODE_RUN_GAME);
 			InvalidateStrings();
 			m_DoubleCursorTimer = (m_GameTime - 1);
 			return;
 		}
 
 		if (optionSelected)
 		{
 
 			// set up the the sub menu chosen
 			System.out.println("Selected option:" + m_DialogSelectedOption);
 			switch(m_DialogSelectedOption)
 			{
 				//Resume
 			case 0:
 				SwitchGameState(GameDefines.GAME_MODE_RUN_GAME);
 				InvalidateStrings();
 				m_DoubleCursorTimer = (m_GameTime - 1);
 				//return;
 				break;
 			//Virtual Mobile
 			case 1:
 				GoToPauseMenu();
 				break;
 			//Restart
 			case 2:
                InitGameVariables();
 				SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_DEMO_SPLASH);
 				break;
 			//EXIT
 			case 3:
 				exitMain = true;
 				SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_VODAFONE_DEMOOVER);
 				break;
 
 			default:
 				break;
 			}
 		}
 		// otherwise update the option text
 		else
 		{
 			if (m_MainPauseMenuSelection != m_DialogSelectedOption)
 			{
 				m_MainPauseMenuSelection = m_DialogSelectedOption;
 			}
 		}
 
 	} // end DoDemoPauseSelection
//#endif

	/**
	 * Handles the option selection for the call menu
	 *
	 * @param optionSelected
	 */
	private boolean DoCallMenuSelection(boolean optionSelected)
	{
		boolean revertToMainOptions = false;
		boolean revertToCallOptions = false;

		// if we are in help selection state, then do that mode
		switch (m_SubMenuState)
		{
		case GameDefines.CALL_OPTION_0:	// Call Sim
		case GameDefines.CALL_OPTION_1:	// Invite Sim Over
			revertToCallOptions = DoCallSimsSelection(optionSelected);
			break;

		case GameDefines.CALL_OPTION_2:	// Throw a party
			revertToCallOptions = DoThrowPartySelection(optionSelected);
			break;

		case GameDefines.CALL_OPTION_3:	// Call Sims Construction (House
										// Upgrades)
		case GameDefines.CALL_OPTION_4:	// Call Sims Co. (Objects)
			revertToCallOptions = DoPurchaseSelection(optionSelected);
			break;

		case GameDefines.NUM_CALL_MENU_OPTIONS:
			// if the exit button was pressed, then go back to the main pause
			// menu
			if (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK))
			{
				revertToMainOptions = true;
			}
			else if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_NO_OPTIONS_AVAIL) != 0)
			{
				if ( (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.FIRE) ) ||
					 (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.ACCEPT) ) )
				{
					revertToMainOptions = true;
				}
			}
			// if the fire button was pressed, go to the selected help text
			else if (optionSelected)
			{
				InvalidateStrings();

				// draw the title
				DrawTitleText(StringId.CALL_OPTION_0 + m_DialogSelectedOption);
				m_SubMenuState = m_DialogSelectedOption;

				// set up the the sub menu chosen
				switch(m_DialogSelectedOption)
				{
				case GameDefines.CALL_OPTION_0:	// Call Sim
					InitCallSimMenus(m_DialogSelectedOption);
					break;

				case GameDefines.CALL_OPTION_1:	// Invite Sim Over
					InitCallSimMenus(m_DialogSelectedOption);
					break;

				case GameDefines.CALL_OPTION_2:	// Throw a party
// m_LargeDeactivatedFontPalette = SimsCanvas.FONT_PAL_INVALID_LG_2;
					InitCallSimMenus(m_DialogSelectedOption);
					break;

				case GameDefines.CALL_OPTION_3:	// Call Sims Construction (House
												// Upgrades)
				case GameDefines.CALL_OPTION_4:	// Call Sims Co. (Objects)
					InitPurchaseMenu();
					PlaySound(SoundId.SOUND_MOBILE, 1);
					InitPauseExitSoftKeyText(m_DialogNumOptions == 0 ? false : true, true);
					break;

				default:
					break;
				}
			}
			break;

		case GameDefines.CALL_MENU_YES_NO_UPGRADE:
		case GameDefines.CALL_MENU_YES_NO_OBJECT:
			String s = "";

			// if the option was selected and it was yes, then do the selection
			if ( (optionSelected) &&
				 (Dialogue.s_dialogue.GetSelection() == 1) )
			{
				boolean purchaseFailed = false;

				if (m_SubMenuState == GameDefines.CALL_MENU_YES_NO_UPGRADE)
				{
					if (AttemptPurchase(m_PurchaseSelection) )
					{
						// if the purchase was successful
						s = SimsCanvas.s_Canvas.getStringById(StringId.UPGRADE_HOUSE_0);

						// Play the upgrade sound.
						PlaySound(SoundId.SOUND_UPGRADE, 1);
					}
					else
					{
						purchaseFailed = true;
					}
				}
				else
				{
					if (AttemptPurchase(m_PurchaseSelection + SimAttributes.NUM_ROOMS) )
					{
						// if the purchase was successful
						s = SimsCanvas.s_Canvas.getStringById(StringId.DELIVER_OBJECT);

						// Play the object sound.
						PlaySound(SoundId.SOUND_UNLOCK, 1);
					}
					else
					{
						purchaseFailed = true;
					}
				}

				// otherwise show can't afford text
				if (purchaseFailed)
				{
					s = SimsCanvas.s_Canvas.getStringById(StringId.SIMCO_CANNOT_AFFORD_UPGRADE);
				}
			}
			// if the sim has decided not to purchase the upgrade
			else if (optionSelected)
			{
				if (m_SubMenuState == GameDefines.CALL_MENU_YES_NO_UPGRADE)
				{
					s = SimsCanvas.s_Canvas.getStringById(StringId.SIMCO_PLEAD_UPGRADE);
				}
				else
				{
					s = SimsCanvas.s_Canvas.getStringById(StringId.SIMCO_PLEAD_OBJECT);
				}
			}
			// otherwise move back
			else if (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK) )
			{
				revertToCallOptions = true;
			}

			if (!s.equals("") )
			{
				InvalidateStrings();

				// draw the title and and set up the dialog
				if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PURCHASE_OBJECT) != 0)
				{
					DrawTitleText(StringId.CALL_OPTION_4);
				}
				else
				{
					DrawTitleText(StringId.CALL_OPTION_3);
				}

				Dialogue.CreateModalDialogue(s, Dialogue.BUTTONS_CONFIRM);
				m_SubMenuState = GameDefines.CALL_MENU_TEXT_DISPLAY;
				InitPauseExitSoftKeyText(false, true);
				m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_PURCHASE_OBJECT);
			}
			break;

		case GameDefines.CALL_MENU_TEXT_DISPLAY:
		default:
			// if the exit button was pressed, then go back to the main pause
			// menu
			if (optionSelected ||
				SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK) )
			{
				revertToCallOptions = true;
				m_DoubleCursorTimer = (m_GameTime - 1);
			}
			break;
		}

		if (revertToMainOptions || revertToCallOptions)
		{
			m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_NO_OPTIONS_AVAIL);
		}

		if (revertToCallOptions)
		{
			m_SubMenuState = GameDefines.NUM_CALL_MENU_OPTIONS;
			InvalidateStrings();

			// draw the title and re-initialize the call menu
			DrawTitleText(StringId.PAUSE_MAIN_OPTION_0 + m_MenuState);
			InitCallMenu();
		}

		return (revertToMainOptions);

	} // end DoCallMenuSelection

	/**
	 * Handles the option setting selection in option screen
	 *
	 * @param optionSelected
	 * @return
	 */
	private boolean DoGameOptionSelection(boolean optionSelected)
	{
		boolean exitOption = false;

		// if the exit button was pressed, then exit the options menu
		if (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK) )
		{
			exitOption = true;
		}

		if (optionSelected)
		{
			int yPos = GameDefines.CALL_MENU_TITLE_OFFSET;

			if (m_SubMenuState == 0)
			{
				// set up the the sub menu chosen
				switch(m_DialogSelectedOption)
				{
				case GameDefines.GAME_OPTION_SOUND:
					ToggleSound();
					InitOptionMenu();
					break;

				case GameDefines.GAME_OPTION_CREDITS:
					InvalidateStrings();

					// draw the title
					DrawTitleText(StringId.GAME_OPTION_CREDITS);
					m_SubMenuState = m_DialogSelectedOption;

					Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.CREDITS),
									Dialogue.BUTTONS_NONE, DialogueStyles.NO_BOX, true, false);

					InitPauseExitSoftKeyText(false, true);
					break;

				case GameDefines.GAME_OPTION_SAVE_GAME:
				case GameDefines.GAME_OPTION_QUIT_GAME:
					String question = SimsCanvas.s_Canvas.getStringById(StringId.QUIT_MESSAGE);

					InvalidateStrings();

					// draw the title
					DrawTitleText(StringId.GAME_OPTION_CREDITS + m_DialogSelectedOption - 1);
					m_SubMenuState = m_DialogSelectedOption;

					if (m_DialogSelectedOption == GameDefines.GAME_OPTION_SAVE_GAME)
					{
						question = SimsCanvas.s_Canvas.getStringById(StringId.SAVE_MESSAGE_0);
					}

					Dialogue.CreateModalDialogue(question, Dialogue.BUTTONS_YESNO);
					InitPauseExitSoftKeyText(true, true);
					break;

				case GameDefines.GAME_OPTION_ABOUT:
					InvalidateStrings();

					// draw the title
					DrawTitleText(StringId.GAME_OPTION_ABOUT);
					m_SubMenuState = m_DialogSelectedOption;
					yPos = GameDefines.ABOUT_MENU_TITLE_OFFSET;

					String s = new String();
					s += SimsCanvas.s_Canvas.getStringById(StringId.SIMS_TITLE);
					s += " ";
					s += SimsCanvas.s_Canvas.getStringById(StringId.TITLE_LEGAL_TEXT);

					// draw the legal information
					m_Dialogs[GameDefines.DIALOG_ID_0] =
						new Dialogue(s, false, 0, yPos, (Graphics.TOP | Graphics.HCENTER) );

					yPos += (m_Dialogs[GameDefines.DIALOG_ID_0].m_height + GameDefines.ABOUT_MENU_TEXT_OFFSET);

					// draw the email
					m_Dialogs[GameDefines.DIALOG_ID_1] =
						new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.ABOUT_EMAIL), false, 0, yPos, (Graphics.TOP | Graphics.HCENTER) );

					yPos += (m_Dialogs[GameDefines.DIALOG_ID_0].m_height + GameDefines.ABOUT_MENU_TEXT_OFFSET);

					// draw the version number
					s = SimsCanvas.s_Canvas.getStringById(StringId.VERSION_TEXT) + getAppProperty("MIDlet-Version");
					m_Dialogs[GameDefines.DIALOG_ID_2] =
						new Dialogue(s, false, 0, yPos, (Graphics.TOP | Graphics.HCENTER) );

					// add the exit options
					InitPauseExitSoftKeyText(false, true);
					break;

				default:
					break;
				}
			}
			else
			{
				// set up the the sub menu chosen
				switch(m_SubMenuState)
				{
				case GameDefines.GAME_OPTION_ABOUT:
				case GameDefines.GAME_OPTION_CREDITS:
					exitOption = true;
					break;

				case GameDefines.GAME_OPTION_SAVE_GAME:
					exitOption = DoSaveOptionSelection(optionSelected);
					break;

				case GameDefines.GAME_OPTION_QUIT_GAME:
					if (Dialogue.s_dialogue.GetSelection() == 1)
					{
						// Send everyone home to clean up the game
						for (int i = 0; i < WorldData.NUM_NPCS; ++i)
						{
							if(m_NpcObjects[i] != null)
							{
								RemoveNPCFromMap(i);
							}
						}

						ExitGame(true);
					}
					else
					{
						exitOption = true;
					}
					break;

				default:
					break;
				}

			}
		}

		return(exitOption);

	} // end DoGameOptionSelection

	/**
	 * Turns the sound on or off depending on its current state
	 *
	 */
	public void ToggleSound()
	{
		m_SaveFlags ^= GameDefines.SAVE_FLAG_MASK_SOUND_ON;

		// if the sound was turned on, play a noise
		if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_SOUND_ON) != 0)
		{
			PlaySound(SoundId.SOUND_GENERAL, 1);
			
			try{
				RecordStore.deleteRecordStore("SimsSoundPref");
			}catch(Exception e ){}
		}
		else
		{
			Utility.stopAllSound();


			
			try{
				RecordStore store = RecordStore.openRecordStore("SimsSoundPref", true);
				store.closeRecordStore();
				store = null;
			}catch(Exception e){}
		}
	}

	/**
	 * Handles the save game option selection
	 *
	 * @param optionSelected
	 * @return
	 */
	private boolean DoSaveOptionSelection(boolean optionSelected)
	{
		boolean exitOption = true;

		// if it is the yes/no question state, do normal input
		// if yes was selected, save the game and display the save game dialog
		if (optionSelected &&
			(Dialogue.s_dialogue.GetSelection() == 1) )
		{
			InvalidateStrings();

			// draw the title
			DrawTitleText(StringId.GAME_OPTION_SAVE);

			// display game saved text
			Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.SAVE_MESSAGE_1), Dialogue.BUTTONS_CONFIRM);

			InitPauseExitSoftKeyText(false, true);

			// save the game, and move to the next generic exit sub menu state
			// (credits)
			SaveGameState();
			m_SubMenuState = GameDefines.GAME_OPTION_CREDITS;
			exitOption = false;
		}

		return(exitOption);
	}

	/**
	 * Do the call sim menu selection
	 *
	 * @param optionSelected
	 * @return
	 */
	private boolean DoCallSimsSelection(boolean optionSelected)
	{
		boolean 	revertToCallOptions = false;
		String	 	s = "";

		// if the exit button was pressed, then go back to the main pause menu
		if (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK))
		{
			revertToCallOptions = true;
		}
		else if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_NO_OPTIONS_AVAIL) != 0)
		{
			if ( (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.FIRE) ) ||
				 (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.ACCEPT) ) )
			{
				revertToCallOptions = true;
			}
		}
		// if the fire button was pressed, go to the selected help text
		else if (optionSelected)
		{
			// ++/--
			boolean plusplus = false;
			boolean atWork = false;

			// set up the the sub menu chosen
			// We need to find the right npc.
			int npcId = m_DialogStringIds[m_DialogSelectedOption] - StringId.SOCIAL_GOSSIP_0;

			// play the mobile sound
			PlaySound(SoundId.SOUND_MOBILE, 1);

			if ( (m_CurrDay != WorldData.DAY_SATURDAY) &&
				 (m_CurrDay != WorldData.DAY_SUNDAY) &&
				 (m_CurrHour >= NPC_JOB_DATA[npcId][WorldData.NPC_JOB_DATA_START_HOUR]) &&
				 (m_CurrHour < NPC_JOB_DATA[npcId][WorldData.NPC_JOB_DATA_END_HOUR]) )
			{
				atWork = true;
				s = Utility.GetExpandedTokenString(new String[] {SimsCanvas.s_Canvas.getStringById(StringId.NPC_AT_WORK), SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_GOSSIP_0 + npcId)} );
			}
			else
			{
				boolean accepts = DecideOnAccept(npcId, false);

				// If it's late then make them grouchy.
				if ( (m_CurrHour > 22) ||
					 (m_CurrHour < 6) )
				{
					accepts = accepts && DecideOnAccept(npcId, false);
				}

				// do call type specific code here
				if (m_SubMenuState == GameDefines.CALL_OPTION_0)
				{
					// Add to the social need.
					UpdateSimTrait(SimAttributes.NEED_SOCIAL, SimAttributes.SOCIAL_INC);
				}
				else if (m_SubMenuState == GameDefines.CALL_OPTION_1)
				{
					if ( (m_CurrHour >= 2) &&
						 (m_CurrHour < 6) )
					{
						accepts = false;
					}

					if ( (npcId == WorldData.NPC_BEN) ||
						 (m_GoalPosition < GameDefines.GOAL_TEXT_3_C) )
					{
						accepts = true;
					}
				}

				plusplus = accepts;

				if (accepts)
				{
					// Change the friendship.
					UpdateSimRelationship(npcId, +1 << SimAttributes.FIXED_POS);

					if (m_SubMenuState == GameDefines.CALL_OPTION_1)
					{
						RequestAddNpc(npcId, WorldData.INITIAL_NPC_LOC, WorldData.NPC_COMING_INVITE);
					}

					// Display a message.
					s = Utility.GetExpandedTokenString(new String[] {SimsCanvas.s_Canvas.getStringById(StringId.NPC_ACCEPT), SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_GOSSIP_0 + npcId)});
				}
				else
				{
					// Change the friendship.
					UpdateSimRelationship(npcId, -1 << SimAttributes.FIXED_POS);

					// Display a message.
					s = Utility.GetExpandedTokenString(new String[] {SimsCanvas.s_Canvas.getStringById(StringId.NPC_REJECT), SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_GOSSIP_0 + npcId)});
				}
			}

			// draw the message if there is one to draw
			if (!s.equals("") )
			{
				InvalidateStrings();

				// draw the title
				DrawTitleText(StringId.CALL_OPTION_0 + m_SubMenuState);

				// display the string
				Dialogue.CreateModalDialogue(s, Dialogue.BUTTONS_CONFIRM);

				if (!atWork)
				{
					if (!plusplus)
					{
						m_DoubleCursorType = GameDefines.CURSOR_MINUSMINUS;
					}
					else
					{
						m_DoubleCursorType = GameDefines.CURSOR_PLUSPLUS;
					}

					m_DoubleCursorTimer = (m_GameTime + WorldData.DOUBLE_CURSOR_DISPLAY_TIME_MS);
					s_GeneralSpriteImage = null;
				}

				m_SubMenuState = GameDefines.CALL_MENU_TEXT_DISPLAY;
				InitPauseExitSoftKeyText(false, true);
			}
		}

		return(revertToCallOptions);

	} // DoCallSimsSelection

	/**
	 * Handles the throw party selection code
	 *
	 * @param optionSelected
	 * @return
	 */
	private boolean DoThrowPartySelection(boolean optionSelected)
	{
		boolean revertToCallOptions = false;
		int 	i;

		// if the exit button was pressed, then go back to the main pause menu
		if (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK) )
		{
			// Reset those coming ~ maybe should revert to state before
			// DoThrowPartySelection
			for(i = 0; i < WorldData.NUM_NPCS; ++i)
			{
				if ( (m_NpcsComing[i] == WorldData.NPC_COMING_PARTY) ||
					 (m_NpcsComing[i] == WorldData.NPC_PARTY_REJECT) )
				{
					m_NpcsComing[i] = WorldData.NPC_COMING_NONE;
				}
			}

			revertToCallOptions = true;
			m_Dialogs[GameDefines.DIALOG_ID_0] = null;
			m_NumNpcsComing = 0;
		}
		else if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_NO_OPTIONS_AVAIL) != 0)
		{
			if ( (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.FIRE) ) ||
				 (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.ACCEPT) ) )
			{
				revertToCallOptions = true;
			}
		}
		// if the fire button was pressed, try to invite the NPC
		else if (optionSelected)
		{
			if (m_DialogSelectedOption < (m_DialogNumOptions - 1) )
			{
				// Get the npcId.
				int npcId = m_DialogStringIds[m_DialogSelectedOption] - StringId.SOCIAL_GOSSIP_0;

				boolean accepts = DecideOnAccept(npcId, false);
				String[] strings = new String[2];

				if(accepts)
				{
					m_NpcsComing[npcId] = WorldData.NPC_COMING_PARTY;
					m_NumNpcsComing++;
				}
				else
				{
					m_NpcsComing[npcId] = WorldData.NPC_PARTY_REJECT;
				}

				// An npc name has been selected, record this list by
				// deactivating the option.
				// update the NPC list to display again
				InitCallSimMenus(m_SubMenuState);

				if(accepts)
				{
					strings[0] = SimsCanvas.s_Canvas.getStringById(StringId.NPC_ACCEPT);
				}
				else
				{
					strings[0] = SimsCanvas.s_Canvas.getStringById(StringId.NPC_REJECT);
				}

				strings[1] = SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_GOSSIP_0 + npcId);

				// Display whether the invitation was accepted.
				if (strings != null)
				{
					m_Dialogs[GameDefines.DIALOG_ID_0] = null;
					m_Dialogs[GameDefines.DIALOG_ID_0] =
						new Dialogue(Utility.GetExpandedTokenString(strings), false, 0,
										GameDefines.THROW_PARTY_RESPONSE_Y_POS, Colors.RED,
										(Graphics.TOP | Graphics.HCENTER) );
				}
			}
			else
			{
				// OK was selected.

				// Add all of the required NPCs to the party room.
				// First count the cost.
				int j = 0;

				for(i = 0; i < WorldData.NUM_NPCS; ++i)
				{
					if(m_NpcsComing[i] == WorldData.NPC_COMING_PARTY)
					{
						j++;
					}
				}

				if(j > 0)
				{
					// Check for funds.
					if(UpdateSimoleans(WorldData.PARTY_COST_PP * j, true, false))
					{
						revertToCallOptions = true;
						j = 0;

						for(i = 0; i < m_DialogNumOptions - 1; ++i)
						{
							int npcId = Math.abs(m_DialogStringIds[i]) - StringId.SOCIAL_GOSSIP_0;

							if(m_NpcsComing[npcId] == WorldData.NPC_COMING_PARTY)
							{
								RequestAddNpc(npcId, WorldData.NPC_LOC_PARTYROOM_1 + j++, WorldData.NPC_COMING_PARTY);
							}
							else if (m_NpcsComing[i] == WorldData.NPC_PARTY_REJECT)
							{
								m_NpcsComing[i] = WorldData.NPC_COMING_NONE;
							}
						}

						PlaySound(SoundId.SOUND_MOBILE, 1);

						// if all the other NPCs are showing up and we are on
						// the right goal, bring Ian in
						if ( (m_CurrGoal == SimAttributes.GOAL_12) &&
							 (j >= WorldData.NUM_NPCS_NEEDED_FOR_IAN) )
						{
							m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED;
						}

						// Finally record that today was party day.
						// We call it the same day until 2am.
						m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_HAVE_THROWN_PARTY_TODAY;
					}
					else // Couldnt afford party
					{
						m_Dialogs[GameDefines.DIALOG_ID_0] = null;
						m_Dialogs[GameDefines.DIALOG_ID_0] =
							new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.CANNOT_AFFORD), false, 0,
											GameDefines.THROW_PARTY_RESPONSE_Y_POS, Colors.RED,
											(Graphics.TOP | Graphics.HCENTER) );

						// Reset those coming ~ maybe should revert to state
						// before DoThrowPartySelection
						for(i = 0; i < WorldData.NUM_NPCS; ++i)
						{
							if ( (m_NpcsComing[i] == WorldData.NPC_COMING_PARTY) ||
								 (m_NpcsComing[i] == WorldData.NPC_PARTY_REJECT) )
							{
								m_NpcsComing[i] = WorldData.NPC_COMING_NONE;
							}
						}
					}
				}
				else // Nobody accepted
				{
					m_Dialogs[GameDefines.DIALOG_ID_0] = null;
					m_Dialogs[GameDefines.DIALOG_ID_0] =
						new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.NOBODY_ACCEPTS), false, 0,
										GameDefines.THROW_PARTY_RESPONSE_Y_POS, Colors.RED,
										(Graphics.TOP | Graphics.HCENTER) );
				}

				m_NumNpcsComing = 0;
			}
		}

		return(revertToCallOptions);

	} // DoThrowPartySelection

	/**
	 * Handles the upgrade purchase selection in option screen
	 *
	 * @param optionSelected
	 * @return
	 */
	private boolean DoPurchaseSelection(boolean optionSelected)
	{
		boolean revertToCallOptions = false;

		// if there are no upgrades available, then revert to the main game
		if (m_DialogNumOptions == 0)
		{
			// if the exit button was pressed, then exit the options menu
			if (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK) ||
				SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.ACCEPT) ||
				SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.FIRE) )
			{
				revertToCallOptions = true;
			}
		}
		else if (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK) )
		{
			revertToCallOptions = true;
		}
		// otherwise do the option selection
		else
		{
			// if the option was selected, attempt to purchase the object
			if (optionSelected)
			{
				int itemStringOffsetId;

				InvalidateStrings();

				// draw the title again
				DrawTitleText(StringId.CALL_OPTION_0 + m_SubMenuState);

				// if we are doing the house upgrade, then the object is the
				// string value minus the starting string value for the room
				if (m_SubMenuState == GameDefines.CALL_OPTION_3)
				{
					itemStringOffsetId = StringId.ROOM_NAME_0;
					m_SubMenuState = GameDefines.CALL_MENU_YES_NO_UPGRADE;
				}
				else
				{
					itemStringOffsetId = StringId.OBJECT_NAME_0;
					m_SubMenuState = GameDefines.CALL_MENU_YES_NO_OBJECT;
					m_GameFlags |= GameDefines.GAME_FLAG_MASK_PURCHASE_OBJECT;
				}

				m_PurchaseSelection = (m_DialogStringIds[m_DialogSelectedOption] - itemStringOffsetId);

				// add the purchase text question
				Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.PURCHASE_TEXT_2), Dialogue.BUTTONS_YESNO);

				// add the options for yes/no and exit
				InitPauseExitSoftKeyText(true, true);
			}
			// otherwise update the selection text if the selection has changed
			else if (m_DialogPreviousOption != m_DialogSelectedOption)
			{
				String[] headerText = new String[2];
				headerText[0] = SimsCanvas.s_Canvas.getStringById(StringId.PURCHASE_TEXT);

				// if we are doing the house upgrade, then the object is the
				// string value minus the starting string value for the room
				if (m_SubMenuState == GameDefines.CALL_OPTION_3)
				{
					headerText[1] = "" + ROOM_COST[m_DialogStringIds[m_DialogSelectedOption] - StringId.ROOM_NAME_0];
				}
				else
				{
					headerText[1] = "" + ITEM_COST[m_DialogStringIds[m_DialogSelectedOption] - StringId.OBJECT_NAME_0];
				}

				m_Dialogs[GameDefines.DIALOG_ID_0] = null;
				m_Dialogs[GameDefines.DIALOG_ID_0] =
					new Dialogue(Utility.GetExpandedTokenString(headerText), false, 0,
									GameDefines.CALL_MENU_TITLE_OFFSET, (Graphics.TOP | Graphics.HCENTER) );
			}
		}

		return(revertToCallOptions);

	} // end DoPurchaseUpgradeSelection

	/**
	 * Handle the keys for the game.
	 */
	private void HandleGameInput()
	{
		if(SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.KEY_NUM0))
			SimsCanvas.s_Canvas.CyclePanels();

		// go to pause mode if the button was pressed
		if (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.BACK))
		{
			if (shell.Build.VODAFONE) {
				GoToDemoPauseMenu();
			}
			else {
				GoToPauseMenu();
			}
		}
	}

	/**
	 * Handle the keys for the colour selection menu.
	 */
	private void HandleSelectSimMenuInput()
	{
		boolean	updatePlayer = false;
		int currentOption = Dialogue.s_dialogue.m_selectionState;

		if (!Dialogue.s_dialogueActive)
		{
			s_RoommateSpriteIcons[0] = null;
			s_FriendshipSpriteIcons[0] = null;

			if (m_DialogSelectedOption < 0)
			{
				SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_START_MENU);
				m_SaveFlags &= ~GameDefines.SAVE_FLAG_MASK_PLAYER_MALE;
				m_PlayerPalette = 0;
			}
			else
			{
				// go through the wants to see if they've been satisfied, and if
				// so, get a new one
				for (int i = 0; i < SimAttributes.NUM_POSSIBLE_WANTS; i++)
				{
					if (m_CurrWants[i] == SimAttributes.WANT_INVALID)
					{
						m_CurrWants[i] = GetNewWant();
					}
				}

				SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_GAME);
				InvalidateStrings();
				SetUpLoadingScreen();
				return;
			}
		}
		else if ( (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.LEFT) ) ||
				  (SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.RIGHT) ) )
		{

			if (currentOption == GameDefines.SIM_SELECT_GENDER)
			{
				// update the text for the option
				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_PLAYER_MALE) != 0)
				{
					m_SaveFlags &= ~GameDefines.SAVE_FLAG_MASK_PLAYER_MALE;
					m_PlayerName += GameDefines.SIM_SELECT_NUM_OPTIONS;
					Dialogue.s_dialogue.m_textLines.setElementAt(SimsCanvas.s_Canvas.getStringById(StringId.GENDER_MENU_OPTION_1),
									GameDefines.SIM_SELECT_GENDER);
				}
				else
				{
					m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_PLAYER_MALE;
					m_PlayerName -= GameDefines.SIM_SELECT_NUM_OPTIONS;
					Dialogue.s_dialogue.m_textLines.setElementAt(SimsCanvas.s_Canvas.getStringById(StringId.GENDER_MENU_OPTION_0),
									GameDefines.SIM_SELECT_GENDER);
				}

				Dialogue.s_dialogue.m_textLines.setElementAt(SimsCanvas.s_Canvas.getStringById(m_PlayerName),
								GameDefines.SIM_SELECT_NAME);
				updatePlayer = true;
			}
			else if (currentOption == GameDefines.SIM_SELECT_PALETTE)
			{
//#ifdef ENABLE_VODAFONE_DEMO
//# 				return;
//#else
				m_PlayerPalette = GetLeftRightOption(m_PlayerPalette, 0,
								GameDefines.SIM_SELECT_NUM_OPTIONS, true);
				updatePlayer = true;
//#endif
			}
			else if (currentOption == GameDefines.SIM_SELECT_SIGN)
			{
//#ifdef ENABLE_VODAFONE_DEMO
//# 				return;
//#else

				m_PlayerSign = GetLeftRightOption(m_PlayerSign, StringId.CAPRICORN,
								GameDefines.SIM_SELECT_NUM_OPTIONS, true);
				Dialogue.s_dialogue.m_textLines.setElementAt(SimsCanvas.s_Canvas.getStringById(m_PlayerSign),
								GameDefines.SIM_SELECT_SIGN);
//#endif
			}
			else
			{
//#ifdef ENABLE_VODAFONE_DEMO
//# 				return;
//#else

				int startOption = StringId.PLAYER_NAME_0;

				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_PLAYER_MALE) == 0)
				{
					startOption += GameDefines.SIM_SELECT_NUM_OPTIONS;
				}

				m_PlayerName = GetLeftRightOption(m_PlayerName, startOption,
								GameDefines.SIM_SELECT_NUM_OPTIONS, true);
				Dialogue.s_dialogue.m_textLines.setElementAt(SimsCanvas.s_Canvas.getStringById(m_PlayerName),
								GameDefines.SIM_SELECT_NAME);
//#endif
			}
		}

		if ( Dialogue.s_dialogueActive &&
			 (currentOption != Dialogue.s_dialogue.m_prevSelectionState) )
		{
			int yPos = Dialogue.s_dialogue.m_y + GameDefines.SIM_SELECT_ARROW_Y_OFFSET;
			yPos += (currentOption * (Dialogue.s_dialogue.m_font.getHeight() + Dialogue.s_dialogue.m_lineSpacing) );

			s_RoommateSpritePos[0][0] =
				(Dialogue.s_dialogue.m_x - s_RoommateSpriteIcons[0].getWidth() - GameDefines.SIM_SELECT_ARROW_X_OFFSET);
			s_RoommateSpritePos[0][1] = yPos;

			s_FriendshipSpritePos[0][0] =
				(Dialogue.s_dialogue.m_x + Dialogue.s_dialogue.m_width + GameDefines.SIM_SELECT_ARROW_X_OFFSET);
			s_FriendshipSpritePos[0][1] = yPos;
		}

		if (updatePlayer)
		{
			// load the player again
			LoadPlayer();
			m_PlayerSim.ControlAnimation(SimObject.ANIM_ID_DANCE, true, AnimationEffect.NONE);

			// force a garbage collection to get rid of extraneous boot up data
			// and
			// clears out the Sim data from the Create-A-Sim menu
			CallGC();
		}
	}

	/**
	 * Key handling for the start menu.
	 */
	private void HandleStartMenuInput()
	{
		InvalidateStrings();
		
		int option = m_DialogSelectedOption;
		
		if (!shell.Build.VODAFONE) option++; 
		

		switch(option)
		{

		//#ifdef ENABLE_VODAFONE_DEMO
 		case 0: // Demo
            shell.BuyScene.autoBuy = true;
			ExitGame(false);
//# 			String buyURI = getAppProperty("BUY-URI");
//# 			launchBrowser(buyURI, true);
 			break;
		//#endif
		case 1:	// New game
			String[] records = RecordStore.listRecordStores();

			// if the save game exists, display the overwrite message
			if ( (records != null) &&
				 (records[0].equals(GameDefines.SAVE_GAME_NAME_1)) )
			{
				// add the overwrite data text question
				s_CurrBG = Utility.loadImage("in_game_menus/Soc_Default", true);
				Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.OVERWRITE_MESSAGE), Dialogue.BUTTONS_YESNO);
				InitPauseExitSoftKeyText(true, true);
				m_SubMenuState = 1;
			}
			// otherwise, just move to the sim selection menu
			else
			{
				if (shell.Build.VODAFONE) {
					SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_DEMO_SPLASH);
				}
				else {
					SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_INTRODUCTION);
				}
			}
			break;
		case 2: // Load game
			// only load the game if there is save data to load
			if (LoadGameState() )
			{
				SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_GAME);
				SetUpLoadingScreen();
			}
			else
			{
				// save game data is invalid, so delete it and move on
				DeleteRMSValue(GameDefines.SAVE_GAME_NAME_1);

				// initialize the dialog for the options
				s_CurrBG = Utility.loadImage("in_game_menus/Soc_Default", true);
				Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.LOAD_FAILURE), Dialogue.BUTTONS_YESNO);
				InitPauseExitSoftKeyText(false, true);
				m_SubMenuState = 2;
			}
			break;
		case 3: // Sound on/off
			ToggleSound();
			SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_START_MENU);
			break;
		//#ifdef ENABLE_GAMELOBBY
//# 		case 3: // Game Lobby
//# 
//# 	 		gameLobbyCanvas.startGameLobbyMenu( );
//# 			m_CurrGameState = GameDefines.GAME_MODE_EXTERNAL;
//# 
		//#else
 		case 4:
		//#endif
			// add the 'do you want to quit' text question
			s_CurrBG = Utility.loadImage("in_game_menus/Soc_Default", true);
			Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.QUIT_MESSAGE), Dialogue.BUTTONS_YESNO);
			InitPauseExitSoftKeyText(true, true);
			m_SubMenuState = 3;
// ExitGame(false);
			break;

		default:
			SwitchGameState(GameDefines.GAME_MODE_INITIALIZE_START_MENU);
			break;
		}
	}

	/**
	 * Handle input for the cutscenes.
	 */
	private void HandleCutsceneInput()
	{
		if (!Dialogue.s_dialogueActive)
		{
			// Clean up the call menu.
			InvalidateStrings();

			// Kill the cursor now.
			m_DoubleCursorTimer = m_GameTime - 1;
			s_GeneralSpriteImage = null;

			// invalidate all the relationship sprites
			for (int i = 0; i < WorldData.NUM_NPCS; i++)
			{
				s_RoommateSpriteIcons[i] = null;
				s_FriendshipSpriteIcons[i] = null;
			}

			SwitchGameState(GameDefines.GAME_MODE_RUN_GAME);
		}
	}

	public void ActivateObject(EdithObject eObject)
	{
		// Identify this object.
		int itemId = eObject.m_GuId;

		if(eObject instanceof SimObject)
		{
			// Are activating a different object
			// or not already going over to the current Sim
			if((eObject != m_CurrentObject) ||
				(!m_PlayerSim.IsWalking()))
			{
				// Clear any current object interactions
				StopAction(true, true);

				// Set the npc for the current interaction.
				m_CurrentObject = eObject;

				// Get object Ids
				m_SelectedNpc = (itemId - WorldData.NPC_ID_START_OFFSET);
				m_CurrItemId = itemId;

				// move the player to the NPC
				m_PlayerSim.AddWalkToAction(eObject);
				m_PlayerSim.AddTurnTowardsAction(eObject, true);

				// Only socialise with a sim if it is not locked
				// stops you getting involved with a sim which is leaving!
				if(!( (m_LockFlags & ( (long)1 << eObject.m_GuId) ) != 0) )
				{
					m_PlayerSim.AddGenericAction(SimObject.ACTION_SOCIALIZE);
				}
			}
		}
		// otherwise it is an item so show the dialog
		else
		{
			Vector options = new Vector();
			int numOptions = 0;

			// check to see if the Sim is happy enough with specific objects
			boolean happySim = true;

			// if it is the kitchen door for going to work, do the special case
			// code here
			if (itemId == WorldData.ITEM_FRONT_DOOR)
			{
				// Does the Sim even have a job?
				if (m_CurrJob != WorldData.JOB_NONE)
				{
					// if it is time to go to work, display the go to work
					// option
					if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_WORK_WARNING_DONE) != 0)
					{
						// display the go to work option
						numOptions++;
						options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.WORK) );
					}
				}

				if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_ANSWER_DOOR) != 0)
				{
					// if a random door event has been set up, and the sim has
					// enough Simoleans, then display this
					if ( ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_DOOR_EVENT) == 0) ||
						 (m_Simoleans > WorldData.RANDOM_DOOR_BAD_EVENT_AMT) )
					{
						// display the go to greet option
						numOptions++;
						options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.GREET) );
					}
				}
			}
			else
			{
				if ( (itemId == WorldData.ITEM_MIRROR) ||
					 (itemId == WorldData.ITEM_BOOKCASE) ||
					 (itemId == WorldData.ITEM_GUITAR) ||
					 (itemId == WorldData.ITEM_EXERCISE_BIKE) ||
					 (itemId == WorldData.ITEM_CHESS_TABLE) )
				{
					happySim = DoesSimWantToDoAction(false);
				}

				if (happySim)
				{
					// create the dialog box with the actions available
					int itemTableOffset = (itemId - SimAttributes.NUM_ROOMS);
					numOptions = ITEM_DATA_TABLE[itemTableOffset][WorldData.ITEM_DATA_NUM_ACTIONS];

					for (int i = 0; i < numOptions; i++)
					{
						options.addElement(SimsCanvas.s_Canvas.getStringById(ITEM_DATA_TABLE[itemTableOffset][WorldData.ITEM_DATA_STRING_ID] + i) );
					}
				}
			}

			if (happySim)
			{
				// Add cancel
				options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.CANCEL_ACTION) );
				numOptions++;

				// Dialog uses m_NextObject to update the current object as
				// needed
				m_NextObject = eObject;

				// Setup dialog
				m_DialogNumOptions = numOptions;
				Dialogue.SetStaticDialogue(new Dialogue(options, DialogueStyles.GRAPHIC_BOX,
								(Graphics.TOP | Graphics.HCENTER), 0, true, true ), -1);

				SwitchGameState(GameDefines.GAME_MODE_OBJECT_DIALOG);
			}
		}
	}

	/**
	 * Run handling for the social menu options depending on the social menu
	 * state.
	 */
	private void HandleSocialMenuOptions()
	{
		// if the selection button was pressed, do the selection
		switch(m_SocialMenuState)
		{
		case GameDefines.SOCIAL_MODE_ROOT:
			HandleSocialRootSelection();
			break;

		case GameDefines.SOCIAL_MODE_TALK:
			HandleSocialTalkSelection();
			break;

		case GameDefines.SOCIAL_MODE_GOSSIP:
			HandleSocialGossipSelection();
			break;

		case GameDefines.SOCIAL_MODE_FRIENDLY:
			HandleSocialFriendlySelection();
			break;

		case GameDefines.SOCIAL_MODE_ROMANTIC:
			HandleSocialRomanticSelection();
			break;

		case GameDefines.SOCIAL_MODE_RELATIONSHIP:
			HandleSocialRelationshipSelection();
			break;

		case GameDefines.SOCIAL_MODE_WAIT:
			InitSocialRootMenu(false);
			break;

		default:
			break;
		}
	}

	/**
	 * Draws the title text for the menus
	 *
	 * @param titleStringId
	 */
	private void DrawTitleText(int titleStringId)
	{
		String 	title = SimsCanvas.s_Canvas.getStringById(titleStringId);
		title = title.toUpperCase();

		m_Dialogs[GameDefines.DIALOG_ID_DAY] = new Dialogue(title, false, 0, 10,
						Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.HCENTER) );

	} // end DrawTitleText

    private void DrawDemoFreeTrialText(int titleStringId,boolean showFreeTrial)
	{
		String 	title = SimsCanvas.s_Canvas.getStringById(titleStringId);
		title = title.toUpperCase();
		m_Dialogs[GameDefines.DIALOG_ID_5] = new Dialogue(title, false, 0, GameDefines.START_MENU_TEXT_Y_OFFSET- 25,
                        Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.HCENTER) );
		if (showFreeTrial)
		{
			m_Dialogs[GameDefines.DIALOG_ID_6] = new Dialogue(SimsCanvas.s_Canvas.sFreeTrial, false, 0, GameDefines.START_MENU_TEXT_Y_OFFSET- 10,
					Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.HCENTER) );
		}

    } // end DrawTitleText
	private void DrawDemoStartText(int titleStringId)
	{
		String 	title = SimsCanvas.s_Canvas.getStringById(titleStringId);
		title = title.toUpperCase();
		m_Dialogs[GameDefines.DIALOG_ID_7] = new Dialogue(title, false, 0, GameDefines.START_MENU_TEXT_Y_OFFSET+20,
						Style.DIALOGUE_TEXT_COLOR, (Graphics.TOP | Graphics.HCENTER) );
	} // end DrawDemoFreeTrialText
    
 	private void DrawDemoOverText(int titleStringId)
 	{
 		String 	title = SimsCanvas.s_Canvas.getStringById(titleStringId);
 		title = title.toUpperCase();
 
 		m_Dialogs[GameDefines.DIALOG_ID_5] = new Dialogue(title, false, 0, GameDefines.DICE_HEIGHT,
 						Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.HCENTER) );
 
 	} // end DrawTitleText
 
	/*
	 * Social Menu methods
	 */

	/**
	 * Exit the social menu
	 */
	private void ExitSocialMenu()
	{
		m_SocialMenuState = GameDefines.SOCIAL_MODE_INVALID;
		InvalidateStrings();
		SwitchGameState(m_PrevGameState);

		// Kill the cursor now.
		m_DoubleCursorTimer = m_GameTime - 1;
		s_GeneralSpriteImage = null;

		// make the Player and NPC face the correct direction and stand
		m_PlayerSim.SetFacing(m_PreviousPlayerFacing);
		m_CurrentObject.SetFacing(m_PreviousNPCFacing);

		// kill off the relationship icons
		s_RoommateSpriteIcons[m_SelectedNpc] = null;
		s_FriendshipSpriteIcons[m_SelectedNpc] = null;

	} // end ExitSocialMenu

	/**
	 * Handling for the initial social menu selection.
	 */
	private void HandleSocialRootSelection()
	{
		switch(m_DialogSelectedOption)
		{
		case SimAttributes.SOCIAL_ROOT_OP_TALK:
			InitSocialTalkMenu(true);
			break;

		case SimAttributes.SOCIAL_ROOT_OP_GOSSIP:
			InitSocialGossipMenu(true);
			break;

		case SimAttributes.SOCIAL_ROOT_OP_FRIENDLY:
			InitSocialFriendlyMenu(true);
			break;

		case SimAttributes.SOCIAL_ROOT_OP_ROMANTIC:
			InitSocialRomanticMenu(true);
			break;

		case SimAttributes.SOCIAL_ROOT_OP_RELATIONSHIP:
			InitSocialRelationshipMenu();
			break;

		case SimAttributes.SOCIAL_ROOT_OP_ASK_TO_LEAVE:
			// They never refuse.
			ExitSocialMenu();

			// We have to stop talking to them.
// m_CurrentObject = null;
			RemoveNpc(m_SelectedNpc);
			break;

		default:
			// Cancel - no cancel exists
// ExitSocialMenu();
			break;
		}

	} // end HandleSocialRootSelection

	/**
	 * Handling for the social talk menu selection.
	 */
	private void HandleSocialTalkSelection()
	{
		int interest = m_DialogSelectedOption;

// if(interest > SimAttributes.SOCIAL_TALK_OP_LOVE)
// {
// // Cancel - no cancel exists
// ExitSocialMenu();
// return;
// }

		int socialType = SimAttributes.SOCIAL_TALK;
		boolean accept = UpdateRelationshipAndSetCursor(interest, socialType);

		PlaySoundInSocial(SoundId.SIMLISH_FEMALE_TALK_NEG, SoundId.SIMLISH_MALE_TALK_NEG,
						SoundId.SIMLISH_FEMALE_TALK_POS, SoundId.SIMLISH_MALE_TALK_POS,
						accept);

		// Add the cursor.
		m_DoubleCursorTimer = (m_GameTime + WorldData.DOUBLE_CURSOR_DISPLAY_TIME_MS);

		// Update the social trait.
		UpdateSimTrait(SimAttributes.NEED_SOCIAL, SimAttributes.SOCIAL_INC);

		if ( (m_CurrGameState != GameDefines.GAME_MODE_CUTSCENE) &&
			 !UpdateGoalsInSocials() )
		{
			// Restart this menu
			InitSocialTalkMenu(false);
		}

	} // end HandleSocialTalkSelection

	/**
	 * Handling for the social gossip menu selection.
	 */
	private void HandleSocialGossipSelection()
	{
		int interest = SimAttributes.INTEREST_BEN + m_DialogSelectedOption;

// if(interest > SimAttributes.INTEREST_IAN)
// {
// // Cancel - no cancel exists
// ExitSocialMenu();
// return;
// }

		int socialType = SimAttributes.SOCIAL_GOSSIP;
		boolean accept = UpdateRelationshipAndSetCursor(interest, socialType);

		PlaySoundInSocial(SoundId.SIMLISH_FEMALE_GOSSIP_NEG, SoundId.SIMLISH_MALE_GOSSIP_NEG,
						SoundId.SIMLISH_FEMALE_GOSSIP_POS, SoundId.SIMLISH_MALE_GOSSIP_POS,
						accept);

		// Add the cursor.
		m_DoubleCursorTimer = (m_GameTime + WorldData.DOUBLE_CURSOR_DISPLAY_TIME_MS);

		// Update the social trait.
		UpdateSimTrait(SimAttributes.NEED_SOCIAL, SimAttributes.SOCIAL_INC);

		SatisfyWant(SimAttributes.WANT_SOCIAL_START_OFFSET + SimAttributes.WANT_SOCIAL_GOSSIP);

		if ( (m_CurrGameState != GameDefines.GAME_MODE_CUTSCENE) &&
			 !UpdateGoalsInSocials() )
		{
			// if the friendship level has dropped below a friend, then go back
			// to the root menu
			if (m_Relationships[m_SelectedNpc] < SimAttributes.RELATIONSHIP_AQUAINTANCE)
			{
				InitSocialRootMenu(false);
			}
			// Restart this menu.
			else
			{
				InitSocialGossipMenu(false);
			}
		}

	} // end HandleSocialGossipSelection

	/**
	 * Handling for the social friendly menu selection.
	 */
	private void HandleSocialFriendlySelection()
	{
		// Decide whether we should accept a hug or peck.
		boolean accept = DecideOnAccept(m_SelectedNpc, true);
		int socialScoreIndex = 0;
		int interest = 0;

		switch(m_DialogSelectedOption)
		{
		case SimAttributes.SOCIAL_FRIENDLY_OP_HUG:
			SatisfyWant(SimAttributes.WANT_SOCIAL_START_OFFSET + SimAttributes.WANT_SOCIAL_HUG);
			socialScoreIndex = accept ? SimAttributes.SOCIAL_SCORE_INC : SimAttributes.SOCIAL_SCORE_DEC;

			UpdateSimRelationship(m_SelectedNpc,
							SOCIAL_SCORES[SimAttributes.SOCIAL_FRIENDLY_HUG][socialScoreIndex] << SimAttributes.FIXED_POS );

			m_DoubleCursorType = socialScoreIndex;
			s_GeneralSpriteImage = null;
			break;

		case SimAttributes.SOCIAL_FRIENDLY_OP_PECK:
			SatisfyWant(SimAttributes.WANT_SOCIAL_START_OFFSET + SimAttributes.WANT_SOCIAL_KISS);
			socialScoreIndex = accept ? SimAttributes.SOCIAL_SCORE_INC : SimAttributes.SOCIAL_SCORE_DEC;

			UpdateSimRelationship(m_SelectedNpc,
							SOCIAL_SCORES[SimAttributes.SOCIAL_FRIENDLY_PECK][socialScoreIndex] << SimAttributes.FIXED_POS );

			m_DoubleCursorType = socialScoreIndex;
			s_GeneralSpriteImage = null;
			break;

		case SimAttributes.SOCIAL_FRIENDLY_OP_CLEAN_JOKE:
			SatisfyWant(SimAttributes.WANT_SOCIAL_START_OFFSET + SimAttributes.WANT_SOCIAL_CLEAN_JOKE);
			interest = (m_DialogSelectedOption == SimAttributes.SOCIAL_FRIENDLY_OP_CLEAN_JOKE) ?
							SimAttributes.INTEREST_CLEAN : SimAttributes.INTEREST_TOILET;
			UpdateRelationshipAndSetCursor(interest, SimAttributes.SOCIAL_JOKE);
			break;

		case SimAttributes.SOCIAL_FRIENDLY_OP_DIRTY_JOKE:
			SatisfyWant(SimAttributes.WANT_SOCIAL_START_OFFSET + SimAttributes.WANT_SOCIAL_DIRTY_JOKE);
			interest = (m_DialogSelectedOption == SimAttributes.SOCIAL_FRIENDLY_OP_CLEAN_JOKE) ?
							SimAttributes.INTEREST_CLEAN : SimAttributes.INTEREST_TOILET;
			UpdateRelationshipAndSetCursor(interest, SimAttributes.SOCIAL_JOKE);
			break;

		default:
			// Cancel - no cancel exists
// ExitSocialMenu();
			return;
		}

		PlaySoundInSocial(SoundId.SIMLISH_FEMALE_FRIENDLY_NEG, SoundId.SIMLISH_MALE_FRIENDLY_NEG,
						SoundId.SIMLISH_FEMALE_FRIENDLY_POS, SoundId.SIMLISH_MALE_FRIENDLY_POS,
						accept);

		// Add the cursor.
		m_DoubleCursorTimer = (m_GameTime + WorldData.DOUBLE_CURSOR_DISPLAY_TIME_MS);

		// Update the social trait.
		UpdateSimTrait(SimAttributes.NEED_SOCIAL, SimAttributes.SOCIAL_INC);

		if ( (m_CurrGameState != GameDefines.GAME_MODE_CUTSCENE) &&
			 !UpdateGoalsInSocials() )
		{
			// if the friendship level has dropped below a friend, then go back
			// to the root menu
			if (m_Relationships[m_SelectedNpc] < SimAttributes.RELATIONSHIP_FRIEND)
			{
				InitSocialRootMenu(false);
			}
			// Restart this menu.
			else
			{
				InitSocialFriendlyMenu(false);
			}
		}

	} // end HandleSocialFriendlySelection

	/**
	 * Updates the relationship with the player and moves the cursor
	 *
	 * @param interest
	 * @param socialType
	 */
	private boolean UpdateRelationshipAndSetCursor(int interest, int socialType)
	{
		boolean accepted = false;

		if(m_DiscussedTopics[interest][m_SelectedNpc] < SimAttributes.BOREDOM_THRESHOLD)
		{
			m_DiscussedTopics[interest][m_SelectedNpc]++;

			accepted = ( (PLAYER_INTERESTS[m_SelectedNpc]& (1 << interest) ) != 0);
			int socialScoreIndex = accepted ? SimAttributes.SOCIAL_SCORE_INC : SimAttributes.SOCIAL_SCORE_DEC;

			UpdateSimRelationship(m_SelectedNpc, (SOCIAL_SCORES[socialType][socialScoreIndex] << SimAttributes.FIXED_POS) );
			m_DoubleCursorType = socialScoreIndex;
		}
		else
		{
			m_DoubleCursorType = GameDefines.CURSOR_DOTDOTDOT;
		}

		s_GeneralSpriteImage = null;
		return(accepted);

	} // end UpdateRelationshipAndSetCursor

	/**
	 * Handling for the social romantic menu selection.
	 */
	private void HandleSocialRomanticSelection()
	{
		// Decide whether we should accept advances.
		boolean accept = DecideOnAccept(m_SelectedNpc, true);
		int socialScoreIndex = accept ? SimAttributes.SOCIAL_SCORE_INC : SimAttributes.SOCIAL_SCORE_DEC;

		switch(m_DialogSelectedOption)
		{
		case SimAttributes.SOCIAL_ROMANTIC_OP_FLIRT:
			SatisfyWant(SimAttributes.WANT_SOCIAL_START_OFFSET + SimAttributes.WANT_SOCIAL_FLIRT);
			UpdateSimRelationship(m_SelectedNpc,
							SOCIAL_SCORES[SimAttributes.SOCIAL_FLIRT][socialScoreIndex] << SimAttributes.FIXED_POS );
			break;

		case SimAttributes.SOCIAL_ROMANTIC_OP_HUG:
			SatisfyWant(SimAttributes.WANT_SOCIAL_START_OFFSET + SimAttributes.WANT_SOCIAL_HUG);
			UpdateSimRelationship(m_SelectedNpc,
							SOCIAL_SCORES[SimAttributes.SOCIAL_ROMANTIC_HUG][socialScoreIndex] << SimAttributes.FIXED_POS );
			break;

		case SimAttributes.SOCIAL_ROMANTIC_OP_KISS:
			SatisfyWant(SimAttributes.WANT_SOCIAL_START_OFFSET + SimAttributes.WANT_SOCIAL_KISS);
			UpdateSimRelationship(m_SelectedNpc,
							SOCIAL_SCORES[SimAttributes.SOCIAL_ROMANTIC_KISS][socialScoreIndex] << SimAttributes.FIXED_POS );
			break;

		case SimAttributes.SOCIAL_ROMANTIC_OP_SPEND_THE_NIGHT:
			UpdateSimRelationship(m_SelectedNpc,
							SOCIAL_SCORES[SimAttributes.SOCIAL_SPEND_THE_NIGHT][socialScoreIndex] << SimAttributes.FIXED_POS );
			break;

		default:
			// Cancel - no cancel exists
// ExitSocialMenu();
			return;
		}

		PlaySoundInSocial(SoundId.SIMLISH_FEMALE_ROMANTIC_NEG, SoundId.SIMLISH_MALE_ROMANTIC_NEG,
						SoundId.SIMLISH_FEMALE_ROMANTIC_POS, SoundId.SIMLISH_MALE_ROMANTIC_POS,
						accept);

		// Add the cursor.
		m_DoubleCursorType = socialScoreIndex;
		m_DoubleCursorTimer = m_GameTime + WorldData.DOUBLE_CURSOR_DISPLAY_TIME_MS;
		s_GeneralSpriteImage = null;

// START:HandleSocialRomanticSelection#
		if ( accept &&
			 (m_DialogSelectedOption == SimAttributes.SOCIAL_ROMANTIC_OP_SPEND_THE_NIGHT) )
		{
			InitCutscene( m_SelectedNpc, StringId.CUTSCENE_WOO_HOO);

			// Kick the clock!
			m_CurrHour += SimAttributes.SOCIAL_SPEND_THE_NIGHT_HOUR_INC;
			m_GameFlags |= GameDefines.GAME_FLAG_MASK_WOO_HOO_HAPPENED;

			// update the Sim Needs
			UpdateSimTrait(SimAttributes.NEED_HUNGER, SimAttributes.SOCIAL_WOO_HOO_HUNGER_DEC);
			UpdateSimTrait(SimAttributes.NEED_ENERGY, SimAttributes.SOCIAL_WOO_HOO_ENERGY_DEC);
			UpdateSimTrait(SimAttributes.NEED_BLADDER, SimAttributes.SOCIAL_WOO_HOO_BLADDER_DEC);
			UpdateSimTrait(SimAttributes.NEED_HYGIENE, SimAttributes.SOCIAL_WOO_HOO_HYGIENE_DEC);
			UpdateSimTrait(SimAttributes.NEED_SOCIAL, SimAttributes.SOCIAL_WOO_HOO_SOCIAL_INC);
			UpdateSimTrait(SimAttributes.NEED_FUN, SimAttributes.SOCIAL_WOO_HOO_FUN_INC);
		}
// END
		// Update the social trait.
		UpdateSimTrait(SimAttributes.NEED_SOCIAL, SimAttributes.SOCIAL_INC);

		if ( (m_CurrGameState != GameDefines.GAME_MODE_CUTSCENE) &&
			 !UpdateGoalsInSocials() )
		{
			// if the friendship level has dropped below a friend, then go back
			// to the root menu
			if (m_Relationships[m_SelectedNpc] < SimAttributes.RELATIONSHIP_LOVER)
			{
				InitSocialRootMenu(false);
			}
			// Restart this menu.
			else
			{
				InitSocialRomanticMenu(false);
			}
		}
// END

	} // end HandleSocialRomanticSelection

	/**
	 * Handling for the social relationship menu selection.
	 */
	private void HandleSocialRelationshipSelection()
	{
		String string = "";

		// Decide whether we should accept to move in or get married.
		boolean accept = DecideOnAccept(m_SelectedNpc, true);

		int socialScoreIndex = -1;

		switch(m_DialogSelectedOption)
		{
		case SimAttributes.SOCIAL_RELATIONSHIP_OP_MOVE_IN:
			socialScoreIndex = accept ? SimAttributes.SOCIAL_SCORE_INC : SimAttributes.SOCIAL_SCORE_DEC;
			UpdateSimRelationship(m_SelectedNpc,
							SOCIAL_SCORES[SimAttributes.SOCIAL_MOVE_IN][socialScoreIndex] << SimAttributes.FIXED_POS );

			if (accept)
			{
				string = Utility.GetExpandedTokenString(new String[] {SimsCanvas.s_Canvas.getStringById(StringId.NPC_ACCEPT),
								SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_GOSSIP_0 + m_SelectedNpc)} );
			}
			else
			{
				string = Utility.GetExpandedTokenString(new String[] {SimsCanvas.s_Canvas.getStringById(StringId.NPC_REJECT),
								SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_GOSSIP_0 + m_SelectedNpc)} );
			}
			break;

		case SimAttributes.SOCIAL_RELATIONSHIP_OP_MOVE_OUT:
			// We always dislike moving out.
			socialScoreIndex = SimAttributes.SOCIAL_SCORE_DEC;
			UpdateSimRelationship(m_SelectedNpc,
							SOCIAL_SCORES[SimAttributes.SOCIAL_MOVE_OUT][socialScoreIndex] << SimAttributes.FIXED_POS );

			m_RoommateNpcId = WorldData.NPC_INVALID;

			// force a false accept to make sure the roommate doesn't get set
			// again and play bad sound
			accept = false;
			break;

		case SimAttributes.SOCIAL_RELATIONSHIP_OP_PROPOSE:
			socialScoreIndex = accept ? SimAttributes.SOCIAL_SCORE_INC : SimAttributes.SOCIAL_SCORE_DEC;
			UpdateSimRelationship(m_SelectedNpc,
							SOCIAL_SCORES[SimAttributes.SOCIAL_PROPOSE][socialScoreIndex] << SimAttributes.FIXED_POS );

			if (accept)
			{
				m_SpouseNpcId = m_SelectedNpc;

				// Wedding gift!
				UpdateSimoleans(750, true, false);
// START:HandleSocialRelationshipSelection1#
				InitCutscene(m_SelectedNpc, StringId.CUTSCENE_MARRIED);
// END
				SatisfyWant(SimAttributes.WANT_SOCIAL_START_OFFSET + SimAttributes.WANT_SOCIAL_GET_MARRIED_OFFSET);
			}
			else
			{
				string = Utility.GetExpandedTokenString(new String[] {SimsCanvas.s_Canvas.getStringById(StringId.NPC_REJECT),
								SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_GOSSIP_0 + m_SelectedNpc)} );
			}
			break;

		case SimAttributes.SOCIAL_RELATIONSHIP_OP_DIVORCE:
			// only allow a divorce if you can afford it
			if (UpdateSimoleans(-800, true, false) )
			{
				// We always dislike being divorced.
				socialScoreIndex = SimAttributes.SOCIAL_SCORE_DEC;
				UpdateSimRelationship(m_SelectedNpc,
								SOCIAL_SCORES[SimAttributes.SOCIAL_DIVORCE][socialScoreIndex] << SimAttributes.FIXED_POS );

				m_SpouseNpcId = WorldData.NPC_INVALID;
				m_RoommateNpcId = WorldData.NPC_INVALID;
// START:HandleSocialRelationshipSelection2#
				InitCutscene(m_SelectedNpc, StringId.CUTSCENE_DIVORCE);
// END
				SatisfyWant(SimAttributes.WANT_SOCIAL_START_OFFSET + SimAttributes.WANT_SOCIAL_GET_DIVORCED_OFFSET);
			}
			else
			{
				string = SimsCanvas.s_Canvas.getStringById(StringId.CANNOT_AFFORD);
			}

			// force a false accept to make sure the roommate doesn't get set
			// again and play bad sound
			accept = false;
			break;

		default:
			// Cancel - no cancel exists
// ExitSocialMenu();
			return;
		}

		if (socialScoreIndex >= 0)
		{
			// Add the cursor.
			m_DoubleCursorType = socialScoreIndex;
			m_DoubleCursorTimer = m_GameTime + WorldData.DOUBLE_CURSOR_DISPLAY_TIME_MS;
			s_GeneralSpriteImage = null;

			// Update the social trait.
			UpdateSimTrait(SimAttributes.NEED_SOCIAL, SimAttributes.SOCIAL_INC);
		}

		if ( (m_CurrGameState != GameDefines.GAME_MODE_CUTSCENE) &&
			 !UpdateGoalsInSocials() )
		{
			if (accept)
			{
				m_RoommateNpcId = m_SelectedNpc;
				PlaySound(SoundId.WANTS_GOLD, 1);
			}
			else
			{
				PlaySound(SoundId.WANTS_RED, 1);
			}

			if(!string.equals("") )
			{
				m_SocialMenuState = GameDefines.SOCIAL_MODE_WAIT;
				Dialogue.CreateModalDialogue(string, Dialogue.BUTTONS_CONFIRM);

				// Add the softkey text.
				InitPauseExitSoftKeyText(false, true);
			}
			else
			{
				InitSocialRootMenu(false);
			}
		}

	} // end HandleSocialRelationshipSelection

	/**
	 * Plays the positive or negative sounds for the social menu based on those
	 * sent in
	 *
	 * @param femalNegative
	 * @param maleNegative
	 * @param femalePositive
	 * @param malePositive
	 * @param accepted
	 */
	private void PlaySoundInSocial(int femalNegative, int maleNegative, int femalePositive, int malePositive, boolean accepted)
	{

		boolean maleNPC = ( (m_SelectedNpc == WorldData.NPC_BEN) ||
							(m_SelectedNpc == WorldData.NPC_JOHN) ||
							(m_SelectedNpc == WorldData.NPC_IAN) );

		int soundId = femalNegative;

		// if the npc accepted the advance, then play an accepted sound effect
		if (accepted)
		{
			if (maleNPC)
			{
				soundId = malePositive;
			}
			else
			{
				soundId = femalePositive;
			}
		}
		// if the npc accepted the advance, then play an negative sound effect
		else if (maleNPC)
		{
			soundId = maleNegative;
		}

		PlaySound(soundId, 1);

	} // end PlaySoundInSocial

	/**
	 * Handle the goals when a social is started with an npc.
	 *
	 * @return Have we triggered a dialog?
	 */
	private boolean UpdateGoalsInSocials()
	{
		boolean exitSocial = false;
		int jobId = -1;

		// Special functionality depending on the current goal.
		switch(m_CurrGoal)
		{
		case SimAttributes.GOAL_1: // Talk to Ben
			if (m_SelectedNpc == WorldData.NPC_BEN)
			{
				// make sure you talked to ben (every option will give you an
				// increase in relationship)
				if(m_Relationships[WorldData.NPC_BEN] >= SimAttributes.FIXED_ONE)
				{
					// update the goal, mark it as achieved for the tutorial
					m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED;
					exitSocial = true;
				}
			}
			break;

		case SimAttributes.GOAL_2: // Make relationship 15 with Ben
			if( (m_SelectedNpc == WorldData.NPC_BEN) &&
				(m_GoalPosition == GameDefines.GOAL_TEXT_2_A) )
			{
				if(m_Relationships[WorldData.NPC_BEN] >= SimAttributes.RELATIONSHIP_AQUAINTANCE)
				{
					// update the goal, mark it as achieved for the tutorial
					m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED;
					exitSocial = true;
				}
			}
			break;

		case SimAttributes.GOAL_3: // Gain 2 skill points in cookery and 2 in
									// logic for Chefs job
			jobId = WorldData.JOB_CHEF;
			break;

		case SimAttributes.GOAL_5: // Get 4 skill points in cookery and 2 in
									// charisma for Head Chefs job
			jobId = WorldData.JOB_HEAD_CHEF;
			break;

		case SimAttributes.GOAL_7: // Get 2 skill points in body and 2 in
									// charisma, plus make 2 friends for the
									// Personal Trainer Job
			jobId = WorldData.JOB_TRAINER;
			break;

		case SimAttributes.GOAL_9: // Get 4 skill points in charisma, 2 in
									// logic and make 5 friends to get the job
									// as a Party DJ
			jobId = WorldData.JOB_DJ;
			break;

		case SimAttributes.GOAL_13: // Get 5 skill points in charisma, 5 in
									// creativity, 5 in body and make 5 friends
									// to join Ians band as a guitarist
			jobId = WorldData.JOB_GUITARIST;
			break;

		default:
			break;
		}

		if ( (jobId >= 0) || (m_NextJob != WorldData.JOB_NONE) )
		{
			int jobTitleId = StringId.JOB_TITLE_0 + jobId;
			int newJobId = jobId;

			if ( (jobId != m_NextJob) &&
				 (m_NextJob >= 0) )
			{
				jobTitleId = StringId.JOB_TITLE_0 + m_NextJob;
				newJobId = m_NextJob;
			}

			if (m_SelectedNpc == JOB_DATA[newJobId][WorldData.JOB_DATA_RECRUITING_NPC])
			{
// START:HandleGoalsInSocials1#
				if (m_Relationships[JOB_DATA[newJobId][WorldData.JOB_DATA_RECRUITING_NPC]] >= SimAttributes.RELATIONSHIP_AQUAINTANCE)
				{
// END
					if (m_NextJob == WorldData.JOB_NONE)
					{
						// switch back to Run mode, as we need the dialog to go
						// into the run mode
						ExitSocialMenu();

						// Propose the job.
						String offer = SimsCanvas.s_Canvas.getStringById(StringId.OFFER_JOB_0);
						String title = SimsCanvas.s_Canvas.getStringById(jobTitleId);

						String strings = Utility.GetExpandedTokenString(new String[] { offer, title });
						Dialogue.CreateModalDialogue(strings, Dialogue.BUTTONS_CONFIRM);

						m_NextJob = newJobId;
						return true;
					}
					else
					{
						// Job already proposed - can it be offered?
						// Check all of the skills.
						boolean offerJob = true;

						for(int i = 0; i < SimAttributes.NUM_SKILLS; ++i)
						{
							if ( (m_SimTraits[i + SimAttributes.FIRST_SKILL] >> SimAttributes.FIXED_4_12_POS) <
								 JOB_DATA[newJobId][i + WorldData.JOB_DATA_SKILL_START])
							{
								offerJob = false;
								break;
							}
						}

						// now check to see if he/she has enough friends
						if (offerJob)
						{
							if (GetNumFriends() < JOB_DATA[newJobId][WorldData.JOB_DATA_NUM_FRIENDS])
							{
								offerJob = false;
							}
						}

						if(offerJob)
						{
							// switch back to Run mode, as we need the dialog to
							// go into the run mode
							ExitSocialMenu();

							// give them the previous job
							if (jobId == m_NextJob)
							{
								// We've succeeded in our goal!!
								m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED;
							}

							// We've got a new job!!
							m_CurrJob = newJobId;
							m_NextJob = WorldData.JOB_NONE;

							String offer = SimsCanvas.s_Canvas.getStringById(StringId.OFFER_JOB_1);
							String title = SimsCanvas.s_Canvas.getStringById(jobTitleId);

							String strings = Utility.GetExpandedTokenString(new String[] { offer, title });
							Dialogue.CreateModalDialogue(strings, Dialogue.BUTTONS_CONFIRM);

							// make sure to reset the missed work flag
							m_SaveFlags &= ~(GameDefines.SAVE_FLAG_MASK_PLAYER_MISSED_WORK);

							// if this is the last job, and we are have never
							// missed a day of work, give them a cash bonus
// if ( (jobId == WorldData.JOB_GUITARIST) &&
// CheckFlag(m_SaveFlags, GameDefines.SAVE_FLAG_PLAYER_NEVER_MISSED_WORK) &&
// CheckFlag(m_SaveFlags, GameDefines.SAVE_FLAG_GOAL_ACHIEVED) )
// {
// UpdateSimoleans(SimAttributes.WORK_RELIABILTY_BONUS, true, false);
//
// // make sure this doesn't happen again if they lose the job
// m_SaveFlags = (int)ResetFlag(m_SaveFlags,
// GameDefines.SAVE_FLAG_PLAYER_NEVER_MISSED_WORK);
// }

							return true;
						}
					}
				}
			}
		}

		// if a goal was completed, then exit the social menu
		if (exitSocial)
		{
			ExitSocialMenu();
		}

		return(exitSocial);

	} // end UpdateGoalsInSocials

	/**
	 * Create the dialog for the socials menu.
	 *
	 * m_CurrItemId must have been set to the selected NPC location.
	 * m_SelectedNpc must have been set to the selected NPC id.
	 *
	 * @param initialise
	 *            Is the social menu being initialised?
	 */
	public void InitSocialRootMenu(boolean initialise)
	{
		// check to see if the Sim is happy enough to talk
		if (DoesSimWantToDoAction(true) )
		{
			// HACK: Timing issues when we select an object just before social
			// is initialised
			// may result in this being set to a non-sim object
			m_CurrentObject = m_NpcObjects[m_SelectedNpc];
			((SimObject) m_CurrentObject).ClearActions();

			InitSocialScreen(m_SelectedNpc, initialise);

			if(initialise)
			{
				SwitchGameState(GameDefines.GAME_MODE_SOCIAL_MENU);
				m_PreviousPlayerFacing = m_PlayerSim.GetFacing();
				m_PreviousNPCFacing = m_CurrentObject.GetFacing();
			}

			m_SocialMenuState = GameDefines.SOCIAL_MODE_ROOT;
			m_DialogNumOptions = 6;
			Vector options = new Vector();
			Vector disabledOptions = new Vector();

			// unrolling above loop to remove a table from game and see if we
			// can save some bytes
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_INIT_0) );
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_INIT_1) );
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_INIT_2) );
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_INIT_3) );

			// Find the relationship score.
			int relationship = m_Relationships[m_SelectedNpc];

			// Deactivate the gossip option if the threshold hasn't been met.
			if(relationship < SimAttributes.RELATIONSHIP_AQUAINTANCE)
			{
				disabledOptions.addElement(new Integer(1) );
			}

			// Deactivate the gossip option if the threshold hasn't been met.
			if(relationship < SimAttributes.RELATIONSHIP_FRIEND)
			{
				disabledOptions.addElement(new Integer(2) );
			}

			// Deactivate the gossip option if the threshold hasn't been met.
			if(relationship < SimAttributes.RELATIONSHIP_LOVER)
			{
				disabledOptions.addElement(new Integer(3) );
			}

			// adjust the relationship score to be an integer
			relationship = relationship >> SimAttributes.FIXED_POS;

			// Decide whether to deactivate the relationship option.
			boolean activate = false;

			// Check for move in option.
			if ( (m_RoommateNpcId == WorldData.NPC_INVALID) &&
				 (NPC_RELATIONSHIP_THRESHOLDS[m_SelectedNpc][SimAttributes.THRESHOLD_MOVE_IN] <= relationship) )
			{
				activate = true;
			}

			// Check for move out option.
			if (m_RoommateNpcId == m_SelectedNpc && m_SpouseNpcId != m_SelectedNpc)
			{
				activate = true;
			}

			// Check for propose option.
			if ( (m_SpouseNpcId == WorldData.NPC_INVALID) &&
				 (NPC_RELATIONSHIP_THRESHOLDS[m_SelectedNpc][SimAttributes.THRESHOLD_PROPOSE] <= relationship) )
			{
				activate = true;
			}

			// Check for divorce option.
			if (m_SpouseNpcId == m_SelectedNpc)
			{
				activate = true;
			}

			// Add the relationship option.
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_INIT_4) );

			if (!activate)
			{
				disabledOptions.addElement(new Integer(4) );
			}

			// Always add ask to leave.
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.ASK_NPC_TO_LEAVE) );

			// Make it invalid if it's a spouse.
			if(m_SpouseNpcId == m_SelectedNpc)
			{
				disabledOptions.addElement(new Integer(5) );
			}

			Dialogue.SetStaticDialogue(new Dialogue(options, disabledOptions, DialogueStyles.NO_BOX, (Graphics.TOP | Graphics.HCENTER), 0, true, true ), -1);

			// Update the Sprites so they are facing the correct direction, etc.
			m_PlayerSim.SetFacing(Facing.SE);
			m_PlayerSim.ControlAnimation(SimObject.ANIM_ID_IDLE, true, AnimationEffect.NONE);
			m_CurrentObject.SetFacing(Facing.SW);
			m_CurrentObject.ControlAnimation(SimObject.ANIM_ID_IDLE, true, AnimationEffect.NONE);
		}

	} // end InitSocialRootMenu

	/**
	 * Initiate a social screen.
	 *
	 * @param npcId
	 *            NPC with whom to have the cutscene
	 */
	private void InitSocialScreen(int npcId, boolean initialise)
	{
		if (initialise)
		{
			InvalidateStrings();

// START:InitSocialScreen#
			// Draw the names at the top of the screen.
			String s = SimsCanvas.s_Canvas.getStringById(m_PlayerName);

			m_Dialogs[GameDefines.DIALOG_ID_0] =
				new Dialogue(s, false, GameDefines.PLAYER_NAME_X_OFFSET, GameDefines.NAME_Y_OFFSET,
								Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.LEFT) );

			s = SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_GOSSIP_0 + npcId);

			m_Dialogs[GameDefines.DIALOG_ID_1] =
				new Dialogue(s, false, GameDefines.NPC_NAME_X_OFFSET-3, GameDefines.NAME_Y_OFFSET,
								Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.RIGHT) );
		}

		// figure out which BG and icons to draw
		UpdateSocialBG(npcId, initialise);

		// draw the updated relationship score
		UpdateSocialRelationshipScore();

		// Add the softkey text.
		InitPauseExitSoftKeyText(true, true);
// END

	} // end InitSocialScreen

	private void UpdateSocialBG(int npcId, boolean firstUpdate)
	{
		Image oldBG = s_CurrBG;

		if (npcId == m_SpouseNpcId)
		{
			s_CurrBG = Utility.loadImage("in_game_menus/Soc_Marraige", true);
		}
		else if (m_Relationships[npcId] >= SimAttributes.RELATIONSHIP_LOVER)
		{
			s_CurrBG = Utility.loadImage("in_game_menus/Soc_Love", true);
		}
		else if (m_Relationships[npcId] >= SimAttributes.RELATIONSHIP_FRIEND)
		{
			s_CurrBG = Utility.loadImage("in_game_menus/Soc_Friend", true);
		}
		else
		{
			s_CurrBG = Utility.loadImage("in_game_menus/Soc_Default", true);
		}

		// Set up the friendship icons if the status has changed
		if ( firstUpdate ||
			 (s_CurrBG != oldBG) )
		{
			SetFriendhipIcons(npcId, GameDefines.SOCIAL_REL_SPR_X_OFFSET, GameDefines.SOCIAL_SPRITE_Y_OFFSET);
		}

	} // end UpdateSocialBG

	/**
	 * Create the dialog for the talk social menu.
	 */
	private void InitSocialTalkMenu(boolean init)
	{
		UpdateSocialBG(m_SelectedNpc, false);
		UpdateSocialRelationshipScore();

		m_SocialMenuState = GameDefines.SOCIAL_MODE_TALK;
		m_DialogNumOptions = 6;
		Vector options = new Vector();

		for(int i = 0; i < m_DialogNumOptions; i++)
		{
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_TALK_0 + i) );
		}

		int startOption = 0;

		if (!init)
		{
			startOption = Dialogue.s_dialogue.m_selectionState;
		}

		Dialogue.SetStaticDialogue(new Dialogue(options, DialogueStyles.NO_BOX,
						(Graphics.TOP | Graphics.HCENTER), startOption, true, true ), -1);

	} // end InitSocialTalkMenu

	/**
	 * Create the dialog for the gossip social menu.
	 */
	private void InitSocialGossipMenu(boolean init)
	{
		UpdateSocialBG(m_SelectedNpc, false);
		UpdateSocialRelationshipScore();

		m_SocialMenuState = GameDefines.SOCIAL_MODE_GOSSIP;
		m_DialogNumOptions = 6;
		Vector options = new Vector();

		for(int i = 0; i < m_DialogNumOptions; i++)
		{
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_GOSSIP_0 + i) );
		}

		int startOption = 0;

		if (!init)
		{
			startOption = Dialogue.s_dialogue.m_selectionState;
		}

		Dialogue.SetStaticDialogue(new Dialogue(options, DialogueStyles.NO_BOX,
						(Graphics.TOP | Graphics.HCENTER), startOption, true, true ), -1);

	} // end InitSocialGossipMenu

	/**
	 * Create the dialog for the friendly social menu.
	 */
	private void InitSocialFriendlyMenu(boolean init)
	{
		UpdateSocialBG(m_SelectedNpc, false);
		UpdateSocialRelationshipScore();

		m_SocialMenuState = GameDefines.SOCIAL_MODE_FRIENDLY;
		m_DialogNumOptions = 4;
		Vector options = new Vector();

		// Set the string ids. Negate to deactivate.
		for(int i = 0; i < m_DialogNumOptions; i++)
		{
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_FRIENDLY_0 + i) );
		}

		int startOption = 0;

		if (!init)
		{
			startOption = Dialogue.s_dialogue.m_selectionState;
		}

		Dialogue.SetStaticDialogue(new Dialogue(options, DialogueStyles.NO_BOX,
						(Graphics.TOP | Graphics.HCENTER), startOption, true, true ), -1);

	} // end InitSocialFriendlyMenu

	/**
	 * Create the dialog for the romantic social menu.
	 */
	private void InitSocialRomanticMenu(boolean init)
	{
		UpdateSocialRelationshipScore();

		m_SocialMenuState = GameDefines.SOCIAL_MODE_ROMANTIC;
		m_DialogNumOptions = 4;
		Vector options = new Vector();

		// Possibly use negative string ids here to deactivate the options.
		for(int i = 0; i < m_DialogNumOptions; i++)
		{
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_ROMANTIC_0 + i) );
		}

		int startOption = 0;

		if (!init)
		{
			startOption = Dialogue.s_dialogue.m_selectionState;
		}

		Dialogue.SetStaticDialogue(new Dialogue(options, DialogueStyles.NO_BOX,
						(Graphics.TOP | Graphics.HCENTER), startOption, true, true ), -1);

	} // end InitSocialRomanticMenu

	/**
	 * Create the dialog for the relationship social menu.
	 */
	private void InitSocialRelationshipMenu()
	{
		UpdateSocialRelationshipScore();

		m_SocialMenuState = GameDefines.SOCIAL_MODE_RELATIONSHIP;
		m_DialogNumOptions = 4;
		Vector options = new Vector();
		Vector disabledOptions = new Vector();

		// Find the relationship score.
		int relationship = m_Relationships[m_SelectedNpc] >> SimAttributes.FIXED_POS;

		// Possibly use negative string ids here to deactivate the options.
		for(int i = 0; i < m_DialogNumOptions; i++)
		{
			options.addElement(SimsCanvas.s_Canvas.getStringById(StringId.SOCIAL_RELATIONSHIP_0 + i) );
		}

		if ( (m_RoommateNpcId != WorldData.NPC_INVALID) ||
			 (NPC_RELATIONSHIP_THRESHOLDS[m_SelectedNpc][SimAttributes.THRESHOLD_MOVE_IN] > relationship ) )
		{
			disabledOptions.addElement(new Integer(0) );
		}

		if (m_RoommateNpcId != m_SelectedNpc || m_SpouseNpcId == m_SelectedNpc)
		{
			disabledOptions.addElement(new Integer(1) );
		}

		if ( (m_SpouseNpcId != WorldData.NPC_INVALID) ||
			 (NPC_RELATIONSHIP_THRESHOLDS[m_SelectedNpc][SimAttributes.THRESHOLD_PROPOSE] > relationship) )
		{
			disabledOptions.addElement(new Integer(2) );
		}

		if (m_SpouseNpcId != m_SelectedNpc)
		{
			disabledOptions.addElement(new Integer(3) );
		}

		Dialogue.SetStaticDialogue(new Dialogue(options, disabledOptions, DialogueStyles.NO_BOX,
						(Graphics.TOP | Graphics.HCENTER), 0, true, true ), -1);

	} // end InitSocialRelationshipMenu

	private void UpdateSocialRelationshipScore()
	{
		m_Dialogs[GameDefines.DIALOG_ID_2] = null;

		String s = "" + String.valueOf(m_Relationships[m_SelectedNpc] >> SimAttributes.FIXED_POS) +
			"/" + String.valueOf(SimAttributes.RELATIONSHIP_MAX >> SimAttributes.FIXED_POS);


		// the text crowds on some screens, account for that
		int r = GameDefines.PLAYER_NAME_X_OFFSET + Dialogue.DIALOGUE_FONT.stringWidth( SimsCanvas.s_Canvas.getStringById(m_PlayerName) );
		int l = SKUConsts.SCREEN_HALF_WIDTH - (Dialogue.DIALOGUE_FONT.stringWidth(s)/2);

		int xOff = 0;
		if( l - r < 6 ) xOff = r - l + 6;
		System.out.println("xOff "+xOff+"  r "+r+"  l "+l);

		if( xOff > 0 ){
			m_Dialogs[GameDefines.DIALOG_ID_2] =
				new Dialogue(s, false, l + xOff, GameDefines.NAME_Y_OFFSET,
								Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.LEFT) );
		}else{
			m_Dialogs[GameDefines.DIALOG_ID_2] =
				new Dialogue(s, false, GameDefines.RELATIONSHIP_X_OFFSET + xOff, GameDefines.NAME_Y_OFFSET,
								Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.HCENTER) );
		}

	} // end UpdateSocialRelationshipScore

	/*
	 * Dialog methods
	 */

	/**
	 * Do the job notification and failure states
	 *
	 */
	private boolean DoJobNotification()
	{
		boolean dialogRunning = false;

		// only do this if the player isn't at work
		if ( (m_CurrJob != WorldData.JOB_NONE) &&
			 ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_WORKING) == 0) )
		{
			// if the work warning hasn't been set, then check to see if it is
			// time to go to work
			if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_WORK_WARNING_DONE) == 0)
			{
				// is it time to go to work? If, so, how about the right day?
				if ( ( (m_CurrHour >= (JOB_DATA[m_CurrJob][WorldData.JOB_DATA_START_HOUR] - 1) ) &&
					   (m_CurrHour < JOB_DATA[m_CurrJob][WorldData.JOB_DATA_START_HOUR]) ) &&
					 (m_CurrDay < WorldData.DAY_SATURDAY) )
				{
					// mark the warning as done
					m_GameFlags |= GameDefines.GAME_FLAG_MASK_WORK_WARNING_DONE;

					// Kill any social at the time.
					m_SocialMenuState = GameDefines.SOCIAL_MODE_INVALID;

					// Play the car horn.
					PlaySound(SoundId.SOUND_CARHORN, 2);

					// set up the dialog to let the player know that it is time
					// to go to work
					dialogRunning = true;
					Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.CAR_POOL), Dialogue.BUTTONS_CONFIRM);
				}
				else if ( (m_CurrDay < WorldData.DAY_SATURDAY) &&
						  ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_WOO_HOO_HAPPENED) != 0) &&
						  (m_CurrHour >= (JOB_DATA[m_CurrJob][WorldData.JOB_DATA_START_HOUR] - 1) ) &&
						  (m_CurrHour < ( (JOB_DATA[m_CurrJob][WorldData.JOB_DATA_START_HOUR] - 1) +
										  SimAttributes.SOCIAL_SPEND_THE_NIGHT_HOUR_INC) ) )
				{
					// mark the warning as done
					// Note: There will be a single game tick where the player
					// will be able to go to work
					m_GameFlags |= GameDefines.GAME_FLAG_MASK_WORK_WARNING_DONE;
				}

				m_WorkStartDay = m_CurrDay;
			}
			// otherwise, the warning has been given and the player hasn't gone
			// to work
			else if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_WORK_WARNING_DONE) != 0)
			{
				// is it time for the carpool to go away?
				if ( (m_CurrDay > m_WorkStartDay) ||
					 ( (m_CurrHour >= JOB_DATA[m_CurrJob][WorldData.JOB_DATA_START_HOUR]) &&
					   (m_CurrMin > 0) ) )
				{
					String s = "";
					m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_WORK_WARNING_DONE);

					// if the player missed work once already in the last day,
					// then fire them
					if ( (m_SaveFlags& GameDefines.SAVE_FLAG_MASK_PLAYER_MISSED_WORK) != 0)
					{
						m_SaveFlags &= ~(GameDefines.SAVE_FLAG_MASK_PLAYER_MISSED_WORK);
						s = SimsCanvas.s_Canvas.getStringById(StringId.MISS_WORK_1);

						// make the current the next job, and mark the current
						// job as none
						m_NextJob = m_CurrJob;
						m_CurrJob = WorldData.JOB_NONE;
					}
					// or give the proper warning for missing work if it is the
					// first time
					else
					{
						m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_PLAYER_MISSED_WORK;
						s = SimsCanvas.s_Canvas.getStringById(StringId.MISS_WORK_0);
					}

					Dialogue.CreateModalDialogue(s, Dialogue.BUTTONS_CONFIRM);

					// Make the phone ring for this....
					m_GameFlags |= GameDefines.GAME_FLAG_MASK_PHONE_RINGING;
					dialogRunning = true;
				}
			}
		}

		return(dialogRunning);

	} // end DoJobNotification

	/**
	 * Updates the frame based on the timer, and returns the new timer and frame
	 * number
	 *
	 * @param frame
	 * @param numFrames
	 * @param frameTime
	 * @param timer
	 * @return
	 */
	private void UpdatePhoneFrame()
	{
		// add the mobile phone sprite
		if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PHONE_RINGING) != 0)
		{
			long	now = System.currentTimeMillis();

			if (m_PhoneSpriteTimer < now)
			{
				m_PhoneSpriteTimer = (now + SimAttributes.GLOBAL_PHONE_FRAME_TIMER);
				m_PhoneSpriteFrame++;

				if (m_PhoneSpriteFrame >= SimAttributes.GLOBAL_NUM_PHONE_FRAMES)
				{
					m_PhoneSpriteFrame = 0;
				}
			}
		}
		else
		{
			m_PhoneSpriteFrame = 0;
		}

	} // end UpdatePhoneFrame

	/**
	 * Displays the 'new goal' text
	 *
	 */
	private void DisplayNewGoalText(boolean updateGoal)
	{
		if (updateGoal)
		{
			m_CurrGoal++;
		}

		Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.NEW_GOAL), Dialogue.BUTTONS_CONFIRM);

	} // end DisplayNewGoalText

	/**
	 * Wrapper function to remove all the strings in the game and invalidate the
	 * handles
	 *
	 */
	private void InvalidateStrings()
	{
		for(int i = 0; i < GameDefines.NUM_DIALOG_IDS; i++)
		{
			m_Dialogs[i] = null;
		}

	} // InvalidateStrings

	/*
	 * Sim methods
	 */

	/**
	 * Decrement the Sim's needs based on a timer
	 *
	 */
	private boolean DecrementSimNeeds()
	{
		// update all the needs for if it is time
		if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_DECREMENT_NEEDS) != 0)
		{
			int decDivisor = SimAttributes.NORMAL_NEED_DECREMENT;

			if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING) != 0)
			{
				decDivisor = SimAttributes.SLEEP_NEED_DECREMENT;
			}
			else if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_WORKING) != 0)
			{
				decDivisor = SimAttributes.WORK_NEED_DECREMENT;
			}

			UpdateSimTrait(SimAttributes.NEED_HUNGER, 	(SimAttributes.NEED_HUNGER_DEC_VAL / decDivisor) );
			UpdateSimTrait(SimAttributes.NEED_HYGIENE, 	(SimAttributes.NEED_HYGIENE_DEC_VAL / decDivisor) );
			UpdateSimTrait(SimAttributes.NEED_BLADDER, 	(SimAttributes.NEED_BLADDER_DEC_VAL / decDivisor) );
			UpdateSimTrait(SimAttributes.NEED_FUN, 		(SimAttributes.NEED_FUN_DEC_VAL / decDivisor) );
			UpdateSimTrait(SimAttributes.NEED_SOCIAL, 	(SimAttributes.NEED_SOCIAL_DEC_VAL / decDivisor) );

			if ( (m_GameFlags &GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING) == 0)
			{
				UpdateSimTrait(SimAttributes.NEED_ENERGY, 	(SimAttributes.NEED_ENERGY_DEC_VAL / decDivisor) );
			}

			// reset the need decrement flag
			m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_DECREMENT_NEEDS);

			// decrement the need warning timer
			m_NeedWarningWaitTimer--;

			// warning or failure time (if we aren't in one already)?
			if ( ((m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_FAILING) == 0) &&
				 ((m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_ACTION) == 0) )
			{
				return DoNeedWarningFailure();
			}
		}

		return false;

	} // end DecrementSimNeeds

	/**
	 * Does the need warning failure checking and initialization
	 *
	 */
	private boolean DoNeedWarningFailure()
	{
		if (m_NeedWarningWaitTimer < 0)
		{
			int animId = SimObject.ANIM_ID_INVALID;
			int cloudId = AnimationEffect.DISABLE;
			int stringId = StringId.INVALID;
			int soundId = SoundId.INVALID;
			int needId = -1;
			m_NeedWarningWaitTimer = SimAttributes.NEED_WARNING_WAIT_TIME;

			// Special case - we need oxygen.
			if( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_SMOKE_ALARM_RINGING) != 0)
			{
				m_SuffocationCounter++;

				// hack to force the system to set up the timer, and stop it for
				// suffocation
				m_WarningFailureState = SimAttributes.NUM_NEEDS + SimAttributes.NEED_HUNGER;
				m_NeedWarningTimer = SimAttributes.ENERGY_FAILURE_TIME;

				if(m_SuffocationCounter >= SimAttributes.SUFFOCATION_DEATH_COUNT)
				{
					// Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.SUFFOCATED),
					// Dialogue.BUTTONS_CONFIRM);
					animId = SimObject.ANIM_ID_LAY_DOWN;
					stringId = StringId.SUFFOCATED;
					soundId = SoundId.WANTS_RED;

					m_GameFlags |= GameDefines.GAME_FLAG_MASK_PLAYER_DYING;
					// return true;
				}
				else
				{
					animId = SimObject.ANIM_ID_WAVE;
					stringId = StringId.SUFFOCATION_WARNING;
					soundId = SoundId.SKILLS_LOW;
				}
			}
			// next check for failure states as they differ from trait to trait
			// and should be checked first
			else if (m_SimTraits[SimAttributes.NEED_HUNGER] <= SimAttributes.MIN_NEED_VALUE)
			{
				// increase the starvation counter
				m_HungerCounter++;

				// do hunger failure (set up the timer for checking death)
				m_WarningFailureState = SimAttributes.NUM_NEEDS + SimAttributes.NEED_HUNGER;
				m_NeedWarningTimer = SimAttributes.ENERGY_FAILURE_TIME;

				// if the sim has starved to death, then mark it as such, and
				// move on...
				if (m_HungerCounter >= SimAttributes.STARVATION_DEATH_COUNT)
				{
					// Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.STARVED_TO_DEATH),
					// Dialogue.BUTTONS_CONFIRM);
					animId = SimObject.ANIM_ID_LAY_DOWN;
					stringId = StringId.STARVED_TO_DEATH;
					soundId = SoundId.WANTS_RED;

					m_GameFlags |= GameDefines.GAME_FLAG_MASK_PLAYER_DYING;
					// return true;
				}
				// display the starvation failure dialog
				else
				{
					animId = SimObject.ANIM_ID_WAVE;
					stringId = StringId.HUNGER_FAILURE;
					soundId = SoundId.SKILLS_LOW;
				}

				// Show the hunger thought bubble.
				needId = SimAttributes.NEED_HUNGER;
			}
			else if (m_SimTraits[SimAttributes.NEED_BLADDER] <= SimAttributes.MIN_NEED_VALUE)
			{
				// do bladder failure (pee your self - sit down and puddle)
				m_WarningFailureState = SimAttributes.NUM_NEEDS + SimAttributes.NEED_BLADDER;

				animId = SimObject.ANIM_ID_SIT_DOWN;
				cloudId = AnimationEffect.MOSAIC;
				stringId = StringId.BLADDER_FAILURE;
				soundId = SoundId.SKILLS_LOW;

				// Show the bladder thought bubble.
				needId = SimAttributes.NEED_BLADDER;
			}
			else if (m_SimTraits[SimAttributes.NEED_HYGIENE] <= SimAttributes.MIN_NEED_VALUE)
			{
				// do hygiene failure (??)
				m_WarningFailureState = SimAttributes.NUM_NEEDS + SimAttributes.NEED_HYGIENE;
				m_NeedWarningTimer = SimAttributes.NEED_WARNING_TIME;

				animId = SimObject.ANIM_ID_WAVE;
				stringId = StringId.HYGIENE_FAILURE;
				soundId = SoundId.SKILLS_LOW;

				// Show the hygiene thought bubble.
				needId = SimAttributes.NEED_HYGIENE;
			}
			else if (m_SimTraits[SimAttributes.NEED_FUN] <= SimAttributes.MIN_NEED_VALUE)
			{
				// do fun failure (??)
				m_WarningFailureState = SimAttributes.NUM_NEEDS + SimAttributes.NEED_FUN;
				m_NeedWarningTimer = SimAttributes.NEED_WARNING_TIME;

				animId = SimObject.ANIM_ID_WAVE;
				stringId = StringId.FUN_FAILURE;
				soundId = SoundId.SKILLS_LOW;

				// Show the hunger thought bubble.
				needId = SimAttributes.NEED_FUN;
			}
			else if (m_SimTraits[SimAttributes.NEED_SOCIAL] <= SimAttributes.MIN_NEED_VALUE)
			{
				// do social failure
				m_WarningFailureState = SimAttributes.NUM_NEEDS + SimAttributes.NEED_SOCIAL;
				m_NeedWarningTimer = SimAttributes.NEED_WARNING_TIME;

				animId = SimObject.ANIM_ID_WAVE;
				stringId = StringId.SOCIAL_FAILURE;
				soundId = SoundId.SKILLS_LOW;

				// Show the hunger thought bubble.
				needId = SimAttributes.NEED_SOCIAL;
			}
			else if (m_SimTraits[SimAttributes.NEED_ENERGY] <= SimAttributes.MIN_NEED_VALUE)
			{
				// do energy failure (fall asleep where you are)
				m_WarningFailureState = SimAttributes.NUM_NEEDS + SimAttributes.NEED_ENERGY;
				m_NeedWarningTimer = SimAttributes.ENERGY_FAILURE_TIME;

				animId = SimObject.ANIM_ID_LAY_DOWN;
				stringId = StringId.ENERGY_FAILURE;
				soundId = SoundId.SKILLS_LOW;

				// Show the energy thought bubble.
				needId = SimAttributes.NEED_ENERGY;
				m_GameFlags |= GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING;
			}
			// otherwise check for a warning state
			else
			{
				// check warning/failure states
				for(int i = 0; i < SimAttributes.NUM_NEEDS; i++)
				{
					if (m_SimTraits[i] < SimAttributes.NEED_WARNING_MIN)
					{
						m_WarningFailureState = i;
						m_NeedWarningTimer = SimAttributes.NEED_WARNING_TIME;

						animId = SimObject.ANIM_ID_WAVE;
						stringId = StringId.HUNGER_WARNING + i;
						soundId = SoundId.SKILLS_LOW;
						break;
					}
				}
			}

			if (m_WarningFailureState < SimAttributes.WARN_FAILURE_MAX)
			{
				m_GameFlags |= GameDefines.GAME_FLAG_MASK_PLAYER_FAILING;

				// play any sound
				if (soundId != SoundId.INVALID)
				{
					PlaySound(soundId, 1);
				}

				// if there is an animation to play do it here
				if(animId != SimObject.ANIM_ID_INVALID)
				{
					// Stop the player walking to make sure we don't mess up the
					// animation
					m_PlayerSim.ClearActions();
					m_PlayerSim.ControlAnimation(animId, true, cloudId);
				}

				// if there is a dialog, display it
				if (stringId != StringId.INVALID)
				{
					Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(stringId),
							Dialogue.BUTTONS_CONFIRM);
				}

				// if we need a thought bubble, dispaly it
				if(needId != -1)
				{
					m_PlayerSim.HaveFailThought( GetGainId(needId) );
				}

				return true;
			}
		}

		return false;

	} // end DoNeedWarningFailure

	/**
	 * Updates/Finishes the failure states
	 *
	 */
	private void FinishFailureState()
	{
		boolean failureFinished = false;
		int animID = SimObject.ANIM_ID_STAND;

		// check special case failure states as they differ from trait to trait
		// and should be checked first
		if (m_WarningFailureState == (SimAttributes.NUM_NEEDS + SimAttributes.NEED_BLADDER) )
		{
			// update the peeing sim bladder and hygiene meters
			UpdateSimTrait(SimAttributes.NEED_BLADDER, SimAttributes.NEED_BLADDER_FAIL_INC);
			UpdateSimTrait(SimAttributes.NEED_HYGIENE, SimAttributes.NEED_BLADDER_FAIL_DEC);

			// is bladder failure finished
			if ( (m_SimTraits[SimAttributes.NEED_HYGIENE] <= SimAttributes.MIN_NEED_VALUE) &&
				 (m_SimTraits[SimAttributes.NEED_BLADDER] >= SimAttributes.MAX_NEED_VALUE) )
			{
				failureFinished = true;
				animID = SimObject.ANIM_ID_STAND_UP;
			}
		}
		else if (m_WarningFailureState == (SimAttributes.NUM_NEEDS + SimAttributes.NEED_ENERGY) )
		{
			// update the sleeping sim energy meter
			UpdateSimTrait(SimAttributes.NEED_ENERGY, SimAttributes.NEED_ENERGY_FAIL_INC);

			// is energy failure finished
			if (m_NeedWarningTimer < 0)
			{
				// now allow a button press to break out
				if ( (m_SimTraits[SimAttributes.NEED_ENERGY] > SimAttributes.FAIL_NEED_MAX_VALUE) ||
					  SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.FIRE) ||
					  SimsCanvas.s_Canvas.getKeyPressed(SimsCanvas.ACCEPT) )
				{
					failureFinished = true;
					animID = SimObject.ANIM_ID_LAY_DOWN_TO_STAND;
					m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING;
				}
			}

		}
		else
		{
			// is social failure finished
			if (m_NeedWarningTimer < 0)
			{
				failureFinished = true;
			}
		}

		if (failureFinished)
		{
			m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_PLAYER_FAILING);
			m_WarningFailureState = SimAttributes.WARN_FAILURE_MAX;
			m_PlayerSim.ControlAnimation(animID, true, AnimationEffect.DISABLE);
		}

	} // end FinishFailureState

	/**
	 * Updates needs from an action stored in local vars
	 *
	 * @param updateSkills
	 *            Update the skills?
	 * @param updateNeeds
	 *            Update the needs?
	 *
	 * @return Have finished?
	 */
	private boolean UpdateSkillsAndNeedsFromAction(boolean updateSkills, boolean updateNeeds)
	{
		boolean actionFinished = false;
		boolean update = false;
		int mainTrait = -1;

		m_CurrActionLastUpdate += m_GameTimeElapsed;
		m_CurrActionEndTime -= m_GameTimeElapsed;

		// if the timer is finished, do the last update and go
		int itemTableOffset = (m_CurrItemId - SimAttributes.NUM_ROOMS);
		if ( (ITEM_ACTION_TABLE[itemTableOffset][m_CurrActionNum][WorldData.ITEM_ACTION_MAX_TIME] != SimAttributes.MAX_NEED) &&
			 (m_CurrActionEndTime < 0) )
		{
			actionFinished = true;
			update = true;
		}
		// or if it is time to update for the
		else if (m_CurrActionLastUpdate > WorldData.ACTION_UPDATE_TIME)
		{
			update = true;
		}

		if (update)
		{
			// update the score based on the difference since last update
			int updateMultiplier = (int)(m_CurrActionLastUpdate / WorldData.ACTION_UPDATE_TIME);
			m_CurrActionLastUpdate = 0;

			int updateValue = 0;

			// now go through all the traits for this object and update them
			// accordingly
			for (int i = 0; i < ITEM_DATA_TABLE[itemTableOffset][WorldData.ITEM_DATA_NUM_NEEDS_0 + m_CurrActionNum]; i++)
			{
				int trait = ITEM_ACTION_TABLE[itemTableOffset][m_CurrActionNum][WorldData.ITEM_ACTION_NEED_1 + (i * 2)];

				if( (trait < SimAttributes.NUM_NEEDS && updateNeeds) ||
								(trait >= SimAttributes.NUM_NEEDS && updateSkills) )
				{
					int value = ITEM_ACTION_TABLE[itemTableOffset][m_CurrActionNum][WorldData.ITEM_ACTION_NEED_VAL_1 + (i * 2)];

					// update the trait, and save the result
					boolean traitMaxed = UpdateSimTrait(trait, value*updateMultiplier);

					// if it is the first trait in the action (the primary
					// trait) and the trait is maxed, end action
					if ( (i == 0) && traitMaxed)
					{
						actionFinished = true;
					}

					if(actionFinished)
						if(trait < SimAttributes.NUM_NEEDS && mainTrait == -1)
						{
							mainTrait = trait;
							updateValue = value;
						}
						else if (mainTrait < SimAttributes.NUM_NEEDS && trait >= SimAttributes.NUM_NEEDS)
						{
							mainTrait = trait;
							updateValue = value;
						}

				}
			}

			if ( (actionFinished) && (mainTrait >= 0) )
			{
				if( mainTrait < SimAttributes.NUM_NEEDS )
				{
					if(updateValue > 0)
						m_PlayerSim.HaveGainThought( GetGainId(mainTrait) );
					else if(updateValue < 0)
						m_PlayerSim.HaveFailThought( GetGainId(mainTrait) );
					PlaySound(SoundId.NEEDS_HUNGER + mainTrait, 1);
				}
				else
				{
					m_PlayerSim.HaveSkillThought( GetGainId(mainTrait) );
				}
			}
		}


		return(actionFinished);

	}

	/**
	 * Updates the Sim's simoleans with the given value
	 *
	 * @param simoleanChange
	 */
	private boolean UpdateSimoleans(int simoleanChange, boolean updateFunds, boolean displayNoFunds)
	{
		boolean transactionOk = ( (m_Simoleans + simoleanChange) >= 0);

		if (simoleanChange != 0)
		{
			if (transactionOk && updateFunds)
			{
				m_Simoleans += simoleanChange;

				// set the timer for the simolean display to flash
				m_SimoleanTimer = GameDefines.SIMOLEAN_FLASH_TIME;
			}

			// display the not enough funds dialog if requested
			if (displayNoFunds && !transactionOk)
			{
				String s = SimsCanvas.s_Canvas.getStringById(StringId.CANNOT_AFFORD);

				// if the player is out of money, and they've not received the
				// friend bonus, give it to them
				if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_FRIEND_HELP_RECEIEVED) == 0)
				{
					m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_FRIEND_HELP_RECEIEVED;
					UpdateSimoleans(SimAttributes.FRIEND_ASSISTANCE_BONUS, true, false);
					s = SimsCanvas.s_Canvas.getStringById(StringId.HELP_FROM_FRIEND);
				}

				Dialogue.CreateModalDialogue(s, Dialogue.BUTTONS_CONFIRM);
			}
		}

		return(transactionOk);

	} // end UpdateSimoleans

	/**
	 * Updates the relationship with the specified npc.
	 *
	 * @param npcId
	 *            NPC with whom to change the relationship
	 * @param change
	 *            The change to the relationship score (1.7.8 format)
	 */
	private void UpdateSimRelationship(int npcId, int change)
	{
		// save the old relationship to check if it is time for a cut scene
		int oldRelationShip = m_Relationships[npcId];

		m_Relationships[npcId] += change;
		m_Relationships[npcId] = (short) Math.max(SimAttributes.RELATIONSHIP_MIN, m_Relationships[npcId]);
		m_Relationships[npcId] = (short) Math.min(SimAttributes.RELATIONSHIP_MAX, m_Relationships[npcId]);

		// check the relationship has gone above the lover line and do the
		// proper cutscene if it has
		// as long as we are coming from the socials screen only (as NPCs don't
		// exist in the wolrd if calling)
		if (m_CurrGameState == GameDefines.GAME_MODE_SOCIAL_MENU)
		{
			if ( (oldRelationShip < SimAttributes.RELATIONSHIP_LOVER) &&
				 (m_Relationships[npcId] >= SimAttributes.RELATIONSHIP_LOVER) )
			{
// START:UpdateSimRelationship1#
				InitCutscene(npcId, StringId.CUTSCENE_LOVE);
// END
			}
			// check the relationship has gone above the friend line and do the
			// proper cutscene if it has
			else if ( (oldRelationShip < SimAttributes.RELATIONSHIP_FRIEND) &&
					  (m_Relationships[npcId] >= SimAttributes.RELATIONSHIP_FRIEND) )
			{
// START:UpdateSimRelationship2#
				InitCutscene(npcId, StringId.CUTSCENE_FRIEND);
// END
				SatisfyWant(SimAttributes.WANT_SOCIAL_START_OFFSET + SimAttributes.WANT_SOCIAL_MAKE_FRIEND_OFFSET);
			}
		}
	}

	/**
	 * Updates the given need by the given amount
	 *
	 * @param need
	 * @param amountToChange
	 */
	private boolean UpdateSimTrait(int trait, int amountToChange)
	{
		// If we are updating the social trait then update the schedule.
		if(trait == SimAttributes.NEED_SOCIAL)
		{
			if(amountToChange > 0)
			{
				// Set the schedule.
				m_NpcSchedule[m_SelectedNpc] = (m_GameTime +  WorldData.SIM_SCHEDULE_TIME_MS);
			}
		}

		boolean traitMaxed = false;

		// if it is a need, then make sure it doesn't go over/under the min/max
		// values
		if (trait < SimAttributes.NUM_NEEDS)
		{
			m_SimTraits[trait] += amountToChange;

			// make sure we don't go below zero
			if (m_SimTraits[trait] < SimAttributes.MIN_NEED_VALUE)
			{
				m_SimTraits[trait] = SimAttributes.MIN_NEED_VALUE;
			}

			// make sure we don't go above the maximum
			if (m_SimTraits[trait] > SimAttributes.MAX_NEED_VALUE)
			{
				m_SimTraits[trait] = SimAttributes.MAX_NEED_VALUE;
				traitMaxed = true;
			}

			// reset the starvation timer if need be
			if ( (trait == SimAttributes.NEED_HUNGER) &&
				 (amountToChange > 0) )
			{
				m_HungerCounter = 0;

				// also update the goal if it is hunger related
				if (m_CurrGoal == SimAttributes.GOAL_0)
				{
					m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED;
				}
			}
		}
		// it is a skill then, and it isn't already maxed out, then update it
		else if (m_SimTraits[trait] < SimAttributes.MAX_SKILL_VALUE)
		{
			// skills take longer to build each level
			m_SimTraits[trait] += (amountToChange >> (m_SimTraits[trait] >> SimAttributes.FIXED_4_12_POS) );

			// make sure we don't go below zero
			if (m_SimTraits[trait] < SimAttributes.MIN_SKILL_VALUE)
			{
				m_SimTraits[trait] = SimAttributes.MIN_SKILL_VALUE;
			}

			// check to see if the skill has increased a level
			if ( (m_SimTraits[trait] & SimAttributes.FIXED_4_12_FRAC_BITS) >= SimAttributes.SKILL_INC_VALUE)
			{
				m_SimTraits[trait] = (short)( ( (m_SimTraits[trait] >> SimAttributes.FIXED_4_12_POS) + 1) << SimAttributes.FIXED_4_12_POS);
				traitMaxed = true;

				// display the you've earned a skill point text
				Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.GAIN_SKILL), Dialogue.BUTTONS_CONFIRM);

				// Play fulfilled need sound.
				if (m_SimTraits[trait] == SimAttributes.MAX_SKILL_VALUE)
				{
					PlaySound(SoundId.SKILLS_MAX, 1);
				}
				else
				{
					PlaySound(SoundId.SKILLS_GENERAL, 1);
				}

				// satisfy a skill want if it can be
				SatisfyWant(trait - SimAttributes.FIRST_SKILL + SimAttributes.WANT_SKILL_START_OFFSET);
			}
			else
			{
				// The system uses the fractional bits to store the progress. It
				// maxes at 320
				int fracBits = (m_SimTraits[trait] & SimAttributes.FIXED_4_12_FRAC_BITS);
// oldFrame = m_SkillBarSpriteFrames;

				m_SkillBarSpriteFrames = (byte)( (GameDefines.NUM_NEED_BAR_FRAMES * fracBits) / SimAttributes.SKILL_INC_VALUE);

				// cap the frame at the top frame
				if (m_SkillBarSpriteFrames >= GameDefines.NUM_NEED_BAR_FRAMES)
				{
					m_SkillBarSpriteFrames = (GameDefines.NUM_NEED_BAR_FRAMES - 1);
				}
			}

			// make sure we don't go above the maximum
			if (m_SimTraits[trait] > SimAttributes.MAX_SKILL_VALUE)
			{
				m_SimTraits[trait] = SimAttributes.MAX_SKILL_VALUE;
				traitMaxed = true;
			}
		}

		return(traitMaxed);

	} // end UpdateSimTraits

	/**
	 * Gets the gain id for the traits/need thought gain image strips
	 *
	 * @param trait
	 * @return gain id, or -1 if one doesn't exist
	 */
	private int GetGainId(int trait)
	{
		// Fast id translation.

		// This will be slower but more
		// compact if it's moved to an array.

		switch(trait)
		{
		case SimAttributes.NEED_HUNGER:
			return 0;
		case SimAttributes.NEED_ENERGY:
			return 1;
		case SimAttributes.NEED_BLADDER:
			return 2;
		case SimAttributes.NEED_HYGIENE:
			return 4;
		case SimAttributes.NEED_SOCIAL:
			return 5;
		case SimAttributes.NEED_FUN:
			return 6;

		case SimAttributes.SKILL_BODY:
			return 2;
		case SimAttributes.SKILL_CHARISMA:
			return 1;
		case SimAttributes.SKILL_COOKING:
			return 0;
		case SimAttributes.SKILL_CREATIVITY:
			return 4;
		case SimAttributes.SKILL_LOGIC:
			return 3;
		}

		return -1;
	}

	/**
	 * Checks to see if the Sim is willing to do an action based on his/her
	 * needs
	 *
	 * @return
	 */
	private boolean DoesSimWantToDoAction(boolean ignoreSocial)
	{
		boolean actionOk = true;
		int		needAverage = 0;

		// If any need is failing, exit, otherwise add it to the Average
		for (int i = 0; i < SimAttributes.NUM_NEEDS; i++)
		{
			if (m_SimTraits[i] < SimAttributes.NEED_WARNING_MIN)
			{
				if ( (i == SimAttributes.NEED_SOCIAL) &&
								ignoreSocial)
				{
					needAverage += m_SimTraits[i];
				}
				else
				{
					actionOk = false;
					break;
				}
			}
			else
			{
				needAverage += m_SimTraits[i];
			}
		}

		// If a need is not failing, then check against the average needs
		if (actionOk)
		{
			needAverage /= SimAttributes.NUM_NEEDS;

			if (needAverage < SimAttributes.NEED_AVERAGE_MIN)
			{
				actionOk = false;
			}
		}

		// now if the Sim is too unhappy, display the unhappy text
		if (!actionOk)
		{
			Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.TOO_UNHAPPY), Dialogue.BUTTONS_CONFIRM);
		}

		return (actionOk);

	} // end DoesSimWantToDoAction

	/**
	 * Gets the skill value in a string NOTE: Designed for up to 2 decimal
	 * places only
	 *
	 * @param skillId
	 * @return
	 */
	private String GetSkillString(int skillId, int numDecimalPlaces)
	{
		int intValue = (m_SimTraits[skillId] >> SimAttributes.FIXED_4_12_POS);
		int fracBits = (m_SimTraits[skillId] & SimAttributes.FIXED_4_12_FRAC_BITS);
		int multiplier = 10;
		String s = "";

		if (numDecimalPlaces == 1)
		{
			fracBits *= multiplier;
			fracBits /= SimAttributes.SKILL_INC_VALUE;

			if (fracBits >= 10)
			{
				intValue++;
				fracBits -= 10;
			}

			s += intValue + "." + fracBits;
		}
		else
		{
			multiplier = 100;
			fracBits *= multiplier;
			fracBits /= SimAttributes.SKILL_INC_VALUE;

			if (fracBits >= 100)
			{
				intValue++;
				fracBits -= 100;
			}

			s += intValue + ".";

			if (fracBits < 10)
			{
				s += "0"+ fracBits;
			}
			else
			{
				s += fracBits;
			}
		}

		return s;

	} // end GetSkillString

	/**
	 * Get the number of friends the player currently has
	 *
	 * @return
	 */
	private int GetNumFriends()
	{
		int numFriends = 0;

		for (int i = 0; i < WorldData.NUM_NPCS; i++)
		{
			if (m_Relationships[i] >= SimAttributes.RELATIONSHIP_FRIEND)
			{
				numFriends++;
			}
		}

		return(numFriends);

	} // end GetNumFriends

	/*
	 * NPC methods
	 */

	private int GetNextAction()
	{
		int action = ACTION_INVALID;

		if(!m_ActionQueue.isEmpty())
		{
			// Get the vector.
			Enumeration params = ((Vector) m_ActionQueue.elementAt(0)).elements();
			m_ActionQueue.removeElementAt(0);

			action = ((Integer)params.nextElement()).intValue();
			switch(action)
			{
			case ACTION_INVALID:
				//Debug.debugAssert(false);
				break;

			// Actions with two integer parameters.
			case ACTION_ADD_NPC:
				m_Param1 = ((Integer)params.nextElement()).intValue();
				m_Param2 = ((Integer)params.nextElement()).intValue();
				break;
			}
		}

		return action;
	}

	/**
	 * Add an NPC to the world.
	 *
	 * @param npcId
	 *            NPC to be added
	 * @param locationId
	 *            Location in which to be added
	 * @return Success?
	 */
	private void RequestAddNpc(int npcId, int locationId, short reason)
	{
		if (m_NpcLocations[npcId] == WorldData.NPC_LOC_INVALID)
		{
			// Record latest reason npc is coming to house
			m_NpcsComing[npcId] = reason;

			// Add to the action queue.
			Vector params = new Vector();
			params.addElement(new Integer(ACTION_ADD_NPC));
			params.addElement(new Integer(npcId));
			params.addElement(new Integer(locationId));
			m_ActionQueue.addElement(params);
		}
	}

	private void AddNpc(int npcId, int locationId)
	{
		// If the npc is not already in the lot
		if(m_NpcLocations[npcId] == WorldData.NPC_LOC_INVALID)
		{
			// Create the sim (using the last npc location value to determine
			// the NPCs unique id)
			SimObject newNPC = new SimObject( (npcId + WorldData.NPC_ID_START_OFFSET), NPC_APP_DATA[npcId],
													false, (StringId.SOCIAL_GOSSIP_0 + npcId) );

			m_NpcObjects[npcId] = newNPC;

			// Unlock NPC for interaction
			m_LockFlags &= ~( (long)1 << newNPC.m_GuId);

			// Set the schedule.
			m_NpcSchedule[npcId] = (m_GameTime + WorldData.SIM_SCHEDULE_TIME_MS);

			// start the NPC at the front door
			newNPC.SetFacing(WorldData.NPC_FRONT_DOOR_FACING);
			newNPC.SetXPos(WorldData.NPC_FRONT_DOOR_X_POS);
			newNPC.SetYPos(WorldData.NPC_FRONT_DOOR_Y_POS);

			House.s_LotSingleton.AddObject(newNPC);
			newNPC.UpdateBillboards();

			// Set dummy value to make MoveNpc Happy
			m_NpcLocations[npcId] = WorldData.NPC_LOC_DUMMY;
			m_NpcsInHouse++;
		}

		// If our desired location is filled find first available
		int locationToMoveTo = locationId;
		while(GetNPCAtLocation(locationToMoveTo) != WorldData.NPC_INVALID)
		{
			locationToMoveTo++;

			// We'll infinite loop if there are no free spaces.
			// Fortunately there are more spaces than NPCs
			if (locationToMoveTo > WorldData.LAST_NPC_LOC)
			{
				locationToMoveTo = WorldData.FIRST_NPC_LOC;
			}

		}

		// Move to our desired location
		MoveNpc(npcId, locationToMoveTo);

		// NPC has arrived so no longer coming over
		m_NpcsComing[npcId] = WorldData.NPC_COMING_NONE;
	}

	/**
	 * Decide whether to an npc accepts a proposal.
	 *
	 * @param npcId
	 *            The npc id
	 * @return true = accept, false = reject
	 */
	private boolean DecideOnAccept(int npcId, boolean useHygiene)
	{
		// Get a random number and set the probability to the minimum
		int probability = SimAttributes.SOCIAL_STARTING_PROBABILITY;
		int percentile = Math.abs(Utility.m_Random.nextInt() );

		// Convert to a percentile
		percentile %= 100;

		// Add 10% for the A/R index.
		probability += 10 * EvaluateAcceptIndex(npcId, useHygiene);

		// Use the percentile to see if our condition is met.
		if(percentile < probability)
		{
			return true;
		}
		else
		{
			return false;
		}

	} // end DecideOnAccept

	/**
	 * Evaluate the accept reject index for this sim.
	 *
	 * @param npcId
	 *            The other sim
	 * @return The accept/reject index
	 */
	private int EvaluateAcceptIndex(int npcId, boolean useHygiene)
	{
		// Get the relationship.
		int acceptValue = (m_Relationships[npcId] >> SimAttributes.FIXED_POS);
		int index = 0;

		// Hygiene modification.
		if (useHygiene)
		{
			int hygiene = (m_SimTraits[SimAttributes.NEED_HYGIENE] >> SimAttributes.FIXED_POS);
			hygiene -= (SimAttributes.MAX_NEED_VALUE >> SimAttributes.FIXED_POS);

			// Add the modifiers.
			acceptValue += hygiene;
		}

		// Return the index, the range is from -20 to 100
		if (acceptValue  < SimAttributes.SOCIAL_MIN_INDEX_VALUE_1)
		{
			index = SimAttributes.SOCIAL_INDEX_VALUE_1;
		}
		else if (acceptValue < SimAttributes.SOCIAL_MIN_INDEX_VALUE_2)
		{
			index = SimAttributes.SOCIAL_INDEX_VALUE_2;
		}
		else if (acceptValue < SimAttributes.SOCIAL_MIN_INDEX_VALUE_3)
		{
			index = SimAttributes.SOCIAL_INDEX_VALUE_3;
		}
		else if (acceptValue < SimAttributes.SOCIAL_MIN_INDEX_VALUE_4)
		{
			index = SimAttributes.SOCIAL_INDEX_VALUE_4;
		}
		else if (acceptValue < SimAttributes.SOCIAL_MIN_INDEX_VALUE_5)
		{
			index = SimAttributes.SOCIAL_INDEX_VALUE_5;
		}
		else if (acceptValue < SimAttributes.SOCIAL_MIN_INDEX_VALUE_6)
		{
			index = SimAttributes.SOCIAL_INDEX_VALUE_6;
		}
		else if (acceptValue < SimAttributes.SOCIAL_MIN_INDEX_VALUE_7)
		{
			index = SimAttributes.SOCIAL_INDEX_VALUE_7;
		}
		else if (acceptValue < SimAttributes.SOCIAL_MIN_INDEX_VALUE_8)
		{
			index = SimAttributes.SOCIAL_INDEX_VALUE_8;
		}
		else if (acceptValue < SimAttributes.SOCIAL_MIN_INDEX_VALUE_9)
		{
			index = SimAttributes.SOCIAL_INDEX_VALUE_9;
		}
		else
		{
			index = SimAttributes.SOCIAL_INDEX_VALUE_10;
		}

		return(index);

	} // end EvaluateAcceptIndex

	/**
	 * Is the location occupied by a character?
	 *
	 * @param roomId
	 *            The room to check
	 * @param locationId
	 *            The location to check
	 * @return Is occupied?
	 */
	private int GetNPCAtLocation(int locationId)
	{
		// Check the npcs.
		for(int i = 0; i < m_NpcLocations.length; ++i)
		{
			if(m_NpcLocations[i] == locationId)
			{
				return i;
			}
		}

		// Location vacant.
		return WorldData.NPC_INVALID;

	} // end GetNPCAtLocation

	/**
	 * Move an NPC within the world.
	 *
	 * @param npcId
	 *            NPC to be moved
	 * @param locationId
	 *            Location into which to be moved
	 * @return
	 */
	private boolean MoveNpc(int npcId, int locationId)
	{
		// If the npc is placed.
		if(m_NpcLocations[npcId] != WorldData.NPC_LOC_INVALID)
		{
			if(GetNPCAtLocation(locationId) == WorldData.NPC_INVALID)
			{
				m_LockFlags |= (long)1 << m_NpcLocations[npcId];
				m_NpcLocations[npcId] = (short)locationId;
				m_LockFlags &= ~( (long)1 << locationId);

				SimObject npc = m_NpcObjects[npcId];

				// make the NPC walk there (need to get the object)
				npc.AddWalkToAction(NPC_POSITION_DATA[(locationId - WorldData.FIRST_NPC_LOC)][WorldData.NPC_POSITION_X_POS],
										NPC_POSITION_DATA[(locationId - WorldData.FIRST_NPC_LOC)][WorldData.NPC_POSITION_Y_POS]);
				// and face the correct direction
				npc.AddSetFacingToAction(NPC_POSITION_DATA[(locationId - WorldData.FIRST_NPC_LOC)][WorldData.NPC_POSITION_FACING]);

				return true;
			}
		}

		// Failed.
		return false;

	} // end MoveNpc

	/**
	 * Remove and NPC from the world.
	 *
	 * @param npcId
	 *            NPC to be removed
	 * @return Success?
	 */
	private boolean RemoveNpc(int npcId)
	{
		// If the npc is placed.
		if(m_NpcLocations[npcId] != WorldData.NPC_LOC_INVALID)
		{
// if(m_CurrentObject != m_NpcObjects[npcId])
			{
				// for now just remove the NPC
				m_NpcObjects[npcId].AddWalkToAction(WorldData.NPC_FRONT_DOOR_X_POS, WorldData.NPC_FRONT_DOOR_Y_POS);
				m_NpcObjects[npcId].AddGenericAction(SimObject.ACTION_NPC_LEAVE);

				// Lock NPC so player can no longer interact with them
				m_LockFlags |= (long)1 << m_NpcObjects[npcId].m_GuId;
			}
			return true;
		}

		// Failed.
		return false;
	}

	/**
	 * Update the boredom of the npcs to allow repeat discussion.
	 *
	 * @return Are the npcs less bored?
	 */
	private boolean UpdateNightlyTasks()
	{
		boolean dialogInitiated = false;
		int 	i;

		if ( ( (m_CurrMin == 0) && (m_CurrHour == 2) ) ||
			 ( ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_WOO_HOO_HAPPENED) != 0) &&
			   (m_CurrHour >= 2) &&
			   (m_CurrHour < (2 + SimAttributes.SOCIAL_SPEND_THE_NIGHT_HOUR_INC) ) ) )
		{
			// Clean out the discussed topics.
			for (i = 0; i < m_DiscussedTopics.length; ++i)
			{
				for (int j = 0; j < m_DiscussedTopics[i].length; ++j)
				{
					m_DiscussedTopics[i][j] = 0;
				}
			}

			// Degrade the social value of each sim now
			for (i = 0; i < WorldData.NUM_NPCS; i++)
			{
				UpdateSimRelationship(i, SimAttributes.RELATIONSHIP_DECLINE);
			}

			// Allow another party
			m_SaveFlags &= ~(GameDefines.SAVE_FLAG_MASK_HAVE_THROWN_PARTY_TODAY);

			// do random event calculation for the day (as long as we've past
			// the intro wants)
			if (m_GoalPosition > GameDefines.GOAL_TEXT_3_C)
			{
				boolean doEvent = false;

				// Get a random number.
				int percentile = Math.abs(Utility.m_Random.nextInt() );

				// Convert to a percentile.
				percentile %= 100;

				// now check to see if an event has happened
				if (percentile < WorldData.RANDOM_DOOR_GOOD_EVENT_PCT)
				{
					m_GameFlags |= GameDefines.GAME_FLAG_MASK_DOOR_EVENT_GOOD;
					doEvent = true;
				}
				else if ( (m_Simoleans > WorldData.RANDOM_DOOR_BAD_EVENT_AMT) &&
								(percentile < (WorldData.RANDOM_DOOR_BAD_EVENT_PCT + WorldData.RANDOM_DOOR_GOOD_EVENT_PCT) ) )
				{
					m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_DOOR_EVENT_GOOD);
					doEvent = true;
				}

				if (doEvent)
				{
					// Get a random number for the start hour.
					percentile = Math.abs(Utility.m_Random.nextInt() );

					// Convert to a percentile.
					percentile %= WorldData.RANDOM_DOOR_NUM_HOURS;
					m_DoorEventHour = (WorldData.RANDOM_DOOR_START_HOUR + percentile);
				}
			}

			boolean toBed = false;

			// Send all the npcs home.
			for (i = 0; i < WorldData.NUM_NPCS; ++i)
			{
				if (i != m_RoommateNpcId)
				{
					toBed = (RemoveNpc(i) || toBed);
				}
			}

			if (toBed)
			{
				Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(StringId.VISITOR_LEAVES), Dialogue.BUTTONS_CONFIRM);
			}

			dialogInitiated = toBed;
		}

		return(dialogInitiated);
	}

	/**
	 * Update the schedule of the npcs to arrive and depart.
	 */
	private boolean UpdateNpcSchedule()
	{
		boolean dialogInitiated = false;

		// Send the scheduled NPCs home if the boredom time has hit
		for (int i = 0; i < WorldData.NUM_NPCS; ++i)
		{
			if ( (m_NpcSchedule[i] != 0) &&
				 (m_NpcSchedule[i] < m_GameTime) )
			{
				if (i != m_RoommateNpcId)
				{
					RemoveNpc(i);
				}
			}
		}

		// If an npc is due to arrive then let them turn up
		if ( (NPC_VISITING_TIME[m_CurrDay][WorldData.NPC_VISITING_TIME_HOUR] == m_CurrHour) &&
			 (m_CurrMin == 0) )
		{
			int npcId = NPC_VISITING_TIME[m_CurrDay][WorldData.NPC_VISITING_TIME_NPC];

			// Say that the NPC is at the door if the player has met them
			// already
			// Have to check for valid npcId as nobody turns up on Sunday but
			// NPC_VISITING_TIME holds a dummy entry for that day with a valid
			// time & npcId = -1
			if ((npcId > 0) && (npcId < WorldData.NUM_NPCS) && ((m_NpcFlags & (1 << npcId) ) != 0))
			{
				// If they aren't in the house already and there is room
				if ( (m_NpcLocations[npcId] == WorldData.NPC_LOC_INVALID) &&
					 ( (m_ActionQueue.size() + m_NpcsInHouse) < WorldData.NUM_NPCS_ALLOWED_IN_HOUSE) )
				{
					if (m_NPCAtDoor == WorldData.NPC_INVALID)
					{
						Dialogue.CreateModalDialogue(SimsCanvas.s_Canvas.getStringById(UpdateNPCAtDoor(npcId) ), Dialogue.BUTTONS_CONFIRM);
						dialogInitiated = true;
					}
				}
			}
		}

		if (m_RoommateNpcId != WorldData.NPC_INVALID)
		{
			// Get the roommate to turn up after work (if he/she isn't there
			// already and there is room)
			if ( (m_CurrHour >= NPC_JOB_DATA[m_RoommateNpcId][WorldData.NPC_JOB_DATA_END_HOUR]) &&
				 ( (m_ActionQueue.size() + m_NpcsInHouse) < WorldData.NUM_NPCS_ALLOWED_IN_HOUSE) )
			{
				// Add this npc to the world.
				RequestAddNpc(m_RoommateNpcId, WorldData.INITIAL_NPC_LOC, WorldData.NPC_COMING_AUTO);
			}

			// Get the roommate to leave for work.
			if ( (m_CurrHour == NPC_JOB_DATA[m_RoommateNpcId][WorldData.NPC_JOB_DATA_START_HOUR]) &&
				 (m_CurrMin == 0) )
			{
				if(m_CurrDay != WorldData.DAY_SATURDAY && m_CurrDay != WorldData.DAY_SUNDAY)
				{
					RemoveNpc(m_RoommateNpcId);
				}
			}
		}

		return(dialogInitiated);

	} // end UpdateNpcSchedule

	/*
	 * Item methods
	 */

	/**
	 * Attempts to buy the given item, returns true if successful, false if not.
	 *
	 * @param item
	 * @return
	 */
	private boolean AttemptPurchase(int item)
	{
		int price;
		boolean purchased;
		boolean buyingRoom = item < SimAttributes.NUM_ROOMS;

		// if the object is a room, then look at the cost for rooms
		if (buyingRoom)
		{
			price = ROOM_COST[item];
		}
		// then it must be an object, so grab its price
		else
		{
			price = ITEM_COST[(item - SimAttributes.NUM_ROOMS)];
		}

		// now see if the player has enough simoleans, if so make the purchase
		purchased = UpdateSimoleans(-price, true, false);

// START:AttemptPurchase#
		// if the purchase was successful, do the necessary items
		if (purchased)
		{
			// mark the item as unlocked
			m_LockFlags &= ~( (long)1 << item);

			// Add the objects purchased.
			House.s_LotSingleton.LoadScriptedObjects();

			if((item == WorldData.ITEM_COFFEE_MACHINE) || (item == WorldData.ITEM_ALARM_CLOCK))
			{
				House.s_LotSingleton.GetItem(item).ForceSetFacing(1);
			}

			// remove the element from the buyable objects
			m_BuyList.removeElement(new Integer(item) );

			// if the item was a room, add the objects to the list for the room
			// that can be unlocked later
			if (buyingRoom)
			{
				if (SKUConsts.LOADING_SCREEN_IN_BUY_UPGRADE)
				{
					SetUpLoadingScreen();
					InitPauseExitSoftKeyText(false, false);
					SimsCanvas.s_Canvas.repaint();
				}

				// Send everyone home, the constructors are in.
				for (int i = 0; i < WorldData.NUM_NPCS; ++i)
				{
					if(m_NpcObjects[i] != null)
					{
						RemoveNPCFromMap(i);
					}
				}

				// Get the next room.
				m_Level++;
				LoadHouse();

				// Welcome to your new(er) home.
				LoadPlayer();
				House.s_LotSingleton.AddObject(m_PlayerSim);

				m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_GOAL_ACHIEVED;

				switch(item)
				{
				case SimAttributes.ROOM_LIVINGROOM:
					m_BuyList.addElement(new Integer(WorldData.ITEM_FLAT_SCREEN_TV) );
					break;

				case SimAttributes.ROOM_RECROOM:
					m_BuyList.addElement(new Integer(WorldData.ITEM_GUITAR) );
					m_BuyList.addElement(new Integer(WorldData.ITEM_CHESS_TABLE) );
					break;

				case SimAttributes.ROOM_PARTYROOM:
					m_BuyList.addElement(new Integer(WorldData.ITEM_DECKS) );
					m_BuyList.addElement(new Integer(WorldData.ITEM_JUICE_BAR) );
					break;

				case SimAttributes.ROOM_GARDEN:
					m_BuyList.addElement(new Integer(WorldData.ITEM_HOT_TUB) );
					break;

				default:
					break;
				}

				if (SKUConsts.LOADING_SCREEN_IN_BUY_UPGRADE)
				{
					s_CurrBG = Utility.loadImage("in_game_menus/Soc_Default", true);
				}
			}
			// set the bought satisfy want for the item
			else
			{
				switch(item)
				{
				case WorldData.ITEM_GAS_COOKER:
					SatisfyWant(SimAttributes.WANT_ITEM_PURCHASE_OVEN);
					break;

				case WorldData.ITEM_COFFEE_MACHINE:
					SatisfyWant(SimAttributes.WANT_ITEM_PURCHASE_COFFEE_MAKER);
					break;

				case WorldData.ITEM_ALARM_CLOCK:
					SatisfyWant(SimAttributes.WANT_ITEM_PURCHASE_ALARM_CLOCK);
					break;

				case WorldData.ITEM_BATH:
					SatisfyWant(SimAttributes.WANT_ITEM_PURCHASE_BATH);
					break;

				case WorldData.ITEM_FLAT_SCREEN_TV:
					SatisfyWant(SimAttributes.WANT_ITEM_PURCHASE_FLAT_SCREEN);
					break;

				case WorldData.ITEM_GUITAR:
					SatisfyWant(SimAttributes.WANT_ITEM_PURCHASE_GUITAR);
					break;

				case WorldData.ITEM_CHESS_TABLE:
					SatisfyWant(SimAttributes.WANT_ITEM_PURCHASE_CHESS_TABLE);
					break;

				case WorldData.ITEM_DECKS:
					SatisfyWant(SimAttributes.WANT_ITEM_PURCHASE_DECKS);
					break;

				case WorldData.ITEM_JUICE_BAR:
					SatisfyWant(SimAttributes.WANT_ITEM_PURCHASE_JUICE_BAR);
					break;

				case WorldData.ITEM_HOT_TUB:
					SatisfyWant(SimAttributes.WANT_ITEM_PURCHASE_HOT_TUB);
					break;

				default:
					break;
				}
			}
		}
// END

		return(purchased);

	} // end AttemptPurchase

	/**
	 * See whether the sim has caused a fire by cooking.
	 *
	 * @param fireHazardRating
	 *            Hazard rating 0-5
	 * @return Is there a fire?
	 */
	private boolean CheckForFire(int fireHazardRating)
	{
		// Chances of causing a fire are dictated by cooking skill.
		// We subtract the cooking skill from the hazard rating.
		// This means that:
		// - An expert cook will never cause a fire
		// - An object with a zero rating will never cause a fire
		int fireRating = fireHazardRating << SimAttributes.FIXED_4_12_POS;
		fireRating -= m_SimTraits[SimAttributes.SKILL_COOKING];
		fireRating = Math.max(0, fireRating);

		int fireProbability = (fireRating * ONE_TENTH) >> SimAttributes.FIXED_4_12_POS;

		// Get a random number.
		int random = Utility.m_Random.nextInt();
		// Normalise.
		random &= SimAttributes.FIXED_4_12_FRAC_BITS;

		// Check for fire.
		return fireProbability > random;
	}

	/**
	 * Function to translate object guids into secondary item guids.
	 *
	 * MAX_VALUE is used where the guid doesn't yet exist.
	 *
	 * @param itemGuid
	 *            Guid of the item
	 * @return The secondary item guid
	 */
	private int GetSecondaryItemGuid(int itemGuid)
	{
		switch(itemGuid)
		{
		case WorldData.ITEM_BLACK_N_WHITE_TV:
			return WorldData.ITEM_BED;
		case WorldData.ITEM_FLAT_SCREEN_TV:
			return WorldData.ITEM_SOFA_2;
		case WorldData.ITEM_FIRE_EXTINGUISHER:
			// Find the fire.
			if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_OVEN_ON_FIRE) != 0)
			{
				return WorldData.ITEM_GAS_COOKER;
			}
			else if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_MICROWAVE_ON_FIRE) != 0)
			{
				return WorldData.ITEM_MICROWAVE;
			}
		}

		return WorldData.INVALID_ITEM_ID;
	}

	/**
	 * Calls the proper item function given the id of the item.
	 *
	 */
	private void DoItemAction()
	{
		boolean actionFinished = false;

		// No function pointers easily accomplished here, so a massive switch
		// statement :(
		// If GetAction name is true, it will create the list of actions....to
		// avoid another huge switch
// START:DoItemAction#
		switch(m_CurrItemId)
		{
		case WorldData.ITEM_FRONT_DOOR:
			actionFinished = false;
			break;

		case WorldData.ITEM_FRIDGE:
			actionFinished = PerformAction(m_CurrentObject, WorldData.FRIDGE_FOOD_COST, true, -1, -1,
							SimObject.ANIM_ID_STAND, AnimationEffect.CLOUD_COOKING, -1, -1, -1);
			m_GameFlags |= GameDefines.GAME_FLAG_MASK_FRIDGE_IN_USE;
			break;

		case WorldData.ITEM_GAS_COOKER:
			actionFinished = PerformAction(m_CurrentObject, WorldData.OVEN_FOOD_COST, true, -1, -1,
							SimObject.ANIM_ID_STAND, AnimationEffect.CLOUD_COOKING, -1, -1, -1);
			break;

		case WorldData.ITEM_MICROWAVE:
			actionFinished = PerformAction(m_CurrentObject, WorldData.MICROWAVE_FOOD_COST, true, -1, -1,
							SimObject.ANIM_ID_STAND, AnimationEffect.CLOUD_COOKING, -1, -1, -1);
			break;

		case WorldData.ITEM_FIRE_EXTINGUISHER:
			actionFinished = PerformAction(m_SecondaryObject, 0, true, -1, -1, SimObject.ANIM_ID_STAND,
							AnimationEffect.CLOUD_EXTINGUISHER, -1, -1, -1);

			// Remove the extinguisher from the map while in use to avoid
			// drawing it.
			if ((m_GameFlags & GameDefines.GAME_FLAG_MASK_EXTINGUISHER_IN_USE) == 0)
			{
				m_GameFlags |= GameDefines.GAME_FLAG_MASK_EXTINGUISHER_IN_USE;
				// House.s_LotSingleton.RemoveObject(m_CurrentObject);
				m_CurrentObject.RemoveFromMap(House.s_LotSingleton);
			}
			break;

		case WorldData.ITEM_COFFEE_MACHINE:
			actionFinished = PerformAction(m_CurrentObject, WorldData.COFFEE_COST, true, -1, -1,
							SimObject.ANIM_ID_STAND, AnimationEffect.CLOUD_COOKING, -1, -1, -1);
			break;

		case WorldData.ITEM_BARBEQUE:
			actionFinished = PerformAction(m_CurrentObject, WorldData.BBQ_COST, true, -1, -1,
							SimObject.ANIM_ID_STAND, AnimationEffect.CLOUD_COOKING, -1, -1, -1);
			break;

		case WorldData.ITEM_FLAT_SCREEN_TV:
			actionFinished = PerformAction(m_SecondaryObject, 0, false, SimObject.ANIM_ID_SIT_DOWN,
							SimObject.ANIM_ID_STAND_UP, -1, AnimationEffect.NONE, -1, -1, -1);
			break;

		case WorldData.ITEM_TOILET:
			actionFinished = PerformAction(m_CurrentObject, 0, false, SimObject.ANIM_ID_SIT_DOWN,
							SimObject.ANIM_ID_STAND_UP, -1, AnimationEffect.MOSAIC, -1, -1, -1);
			break;

		case WorldData.ITEM_CHAIR:
		case WorldData.ITEM_GARDEN_FURNITURE:
			actionFinished = PerformAction(m_CurrentObject, 0, false, SimObject.ANIM_ID_SIT_DOWN,
							SimObject.ANIM_ID_STAND_UP, -1, AnimationEffect.NONE, -1, -1, -1);
			break;

		case WorldData.ITEM_ARCADE_MACHINE:
			actionFinished = PerformAction(m_CurrentObject, 0, true, -1, -1, SimObject.ANIM_ID_STAND,
							AnimationEffect.CLOUD_ARCADE, -1, -1, -1);
			break;

		case WorldData.ITEM_CHESS_TABLE:
			if ( ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_ACTION_CANCELLED) != 0) ||
							 DoesSimWantToDoAction(false) )
			{
				actionFinished = PerformAction(m_CurrentObject, 0, true, SimObject.ANIM_ID_SIT_DOWN,
				SimObject.ANIM_ID_STAND_UP, -1, AnimationEffect.CLOUD_LOGIC, -1, -1, -1);
			}
			else
			{
				CancelAction();
				m_GameFlags |= GameDefines.GAME_FLAG_MASK_ACTION_CANCELLED;
			}
			break;

		case WorldData.ITEM_BLACK_N_WHITE_TV:
			actionFinished = PerformAction(m_SecondaryObject, 0, false, SimObject.ANIM_ID_LAY_DOWN,
							SimObject.ANIM_ID_LAY_DOWN_TO_STAND, -1, AnimationEffect.NONE, -1, -1, -1);
// actionFinished = PerformAction(m_SecondaryObject, 0, false,
// SimObject.ANIM_ID_SIT_DOWN,
// SimObject.ANIM_ID_STAND_UP, -1, AnimationEffect.NONE, -1, -1);

			// Shift player over a tile to make animation look right
			if((m_CurrActionState == WorldData.ACTION_STATE_PREANIM_SETUP) &&
				((m_GameFlags & GameDefines.GAME_FLAG_MASK_BWTV_IN_USE) == 0))
			{
				m_PlayerSim.SetXPos(m_PlayerSim.m_TilePosX - 1);
				m_GameFlags |= GameDefines.GAME_FLAG_MASK_BWTV_IN_USE;
			}
// else if((m_CurrActionState == WorldData.ACTION_STATE_POSTANIM_SETUP) &&
// ((m_GameFlags & GameDefines.GAME_FLAG_MASK_BWTV_IN_USE) != 0))
// {
// m_PlayerSim.SetXPos(m_PlayerSim.m_TilePosX + 1);
// m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_BWTV_IN_USE;
// }
			break;

		case WorldData.ITEM_MIRROR:
			if ( ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_ACTION_CANCELLED) != 0) ||
				 DoesSimWantToDoAction(false) )
			{
				actionFinished = PerformAction(m_CurrentObject, 0, true, -1, -1, SimObject.ANIM_ID_IDLE,
								AnimationEffect.NONE, -1, -1, -1);
			}
			else
			{
				CancelAction();
				m_GameFlags |= GameDefines.GAME_FLAG_MASK_ACTION_CANCELLED;
			}
			break;

		case WorldData.ITEM_BED:
			actionFinished = PerformAction(m_CurrentObject, 0, false, SimObject.ANIM_ID_LAY_DOWN,
							SimObject.ANIM_ID_LAY_DOWN_TO_STAND, -1, AnimationEffect.NONE, -1, -1, -1);

			// Shift player over a tile to make animation look right
			if((m_CurrActionState == WorldData.ACTION_STATE_PREANIM_SETUP) &&
				((m_GameFlags & GameDefines.GAME_FLAG_MASK_BED_IN_USE) == 0))
			{
				m_PlayerSim.SetXPos(m_PlayerSim.m_TilePosX - 1);
				m_GameFlags |= GameDefines.GAME_FLAG_MASK_BED_IN_USE;
			}
// else if((m_CurrActionState == WorldData.ACTION_STATE_POSTANIM_SETUP) &&
// ((m_GameFlags & GameDefines.GAME_FLAG_MASK_BED_IN_USE) != 0))
// {
// m_PlayerSim.SetXPos(m_PlayerSim.m_TilePosX + 1);
// m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_BED_IN_USE;
// }

			// Set whether the sim is sleeping based on the state of the action.
			if(m_CurrActionState == WorldData.ACTION_STATE_MAIN)
				m_GameFlags |= GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING;
			else
				m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING);


			// We force a finish if the alarm has been set.
			// The time is set to progress in minute resolution
			// so we can test for the exact time.
			if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_ALARM_SET) != 0)
			{
				if (m_CurrMin == 0)
				{
					boolean finish = false;

					if(m_CurrJob == WorldData.JOB_NONE)
					{
						if (m_CurrHour == 10)
						{
							// Note that the sim only turns off the alarm when
							// it wakes him up.
							finish = true;
						}
					}
					else
					{
						if (m_CurrHour == JOB_DATA[m_CurrJob][WorldData.JOB_DATA_START_HOUR] - 1)
						{
							// Note that the sim only turns off the alarm when
							// it wakes him up.
							finish = true;
						}
					}

					if (finish)
					{
						m_CurrActionTimer = -1;
						m_SaveFlags &= ~(GameDefines.SAVE_FLAG_MASK_ALARM_SET);
						PlaySound(SoundId.SOUND_ALARMCLOCK, 5);
						CancelAction();
					}
				}
			}
			break;

		case WorldData.ITEM_ALARM_CLOCK:
			actionFinished = PerformAction(m_CurrentObject, 0, true, -1, -1,
							SimObject.ANIM_ID_SWITCH, AnimationEffect.NONE, -1, -1, SoundId.SOUND_GENERAL);
			break;

		case WorldData.ITEM_SINK:
			actionFinished = PerformAction(m_CurrentObject, 0, true, -1, -1,
							SimObject.ANIM_ID_SWITCH, AnimationEffect.NONE, -1, -1, -1);
			break;

		case WorldData.ITEM_SHOWER:
			actionFinished = PerformAction(m_CurrentObject, 0, true, -1, -1,
							SimObject.ANIM_ID_STAND, AnimationEffect.CLOUD_BATHING, -1, -1, -1);
			break;

		case WorldData.ITEM_HOT_TUB:
		case WorldData.ITEM_BATH:
			actionFinished = PerformAction(m_CurrentObject, 0, true, -1, -1, SimObject.ANIM_ID_STAND,
							AnimationEffect.CLOUD_BATHING, -1, -1, -1);
			break;

		case WorldData.ITEM_BOOKCASE:
			if (m_CurrActionNum == 0)
			{
				if ( ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_ACTION_CANCELLED) != 0) ||
					 DoesSimWantToDoAction(false) )
				{
					actionFinished = PerformAction(m_CurrentObject, 0, true, SimObject.ANIM_ID_SWITCH,
									SimObject.ANIM_ID_SWITCH, SimObject.ANIM_ID_STAND,
									AnimationEffect.CLOUD_LOGIC, -1, -1, -1);
				}
				else
				{
					CancelAction();
					m_GameFlags |= GameDefines.GAME_FLAG_MASK_ACTION_CANCELLED;
				}
			}
			else
			{
				actionFinished = PerformAction(m_CurrentObject, 0, true, SimObject.ANIM_ID_SWITCH, SimObject.ANIM_ID_SWITCH,
								SimObject.ANIM_ID_IDLE, AnimationEffect.NONE, -1, -1, -1);
			}
			break;

		case WorldData.ITEM_STEREO:
			if (m_CurrActionNum == 0)
			{
				actionFinished = PerformAction(m_CurrentObject, 0, true, -1, -1,
								SimObject.ANIM_ID_SWITCH, AnimationEffect.NONE, -1, -1, SoundId.SOUND_GENERAL);
			}
			else
			{
				actionFinished = PerformAction(m_CurrentObject, 0, false, -1, -1,
								SimObject.ANIM_ID_DANCE, AnimationEffect.NONE, -1, -1, -1);
			}
			break;

		case WorldData.ITEM_SOFA_1:
			if (m_CurrActionNum == 0)
			{
				actionFinished = PerformAction(m_CurrentObject, 0, false, SimObject.ANIM_ID_SIT_DOWN,
								SimObject.ANIM_ID_STAND_UP, -1, AnimationEffect.NONE, -1, -1, -1);
			}
			else
			{
				actionFinished = PerformAction(m_CurrentObject, 0, false, SimObject.ANIM_ID_LAY_DOWN,
								SimObject.ANIM_ID_LAY_DOWN_TO_STAND, -1, AnimationEffect.NONE, -1, -1, -1);

				// Set whether the sim is sleeping based on the state of the
				// action.
				if(m_CurrActionState == WorldData.ACTION_STATE_MAIN)
					m_GameFlags |= GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING;
				else
					m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING);
			}
			break;

		case WorldData.ITEM_GUITAR:
			if ( ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_ACTION_CANCELLED) != 0) ||
							 DoesSimWantToDoAction(false) )
			{
				actionFinished = PerformAction(m_CurrentObject, 0, true, -1, -1,
				SimObject.ANIM_ID_STAND, AnimationEffect.CLOUD_MUSIC, -1, -1, -1);
			}
			else
			{
				CancelAction();
				m_GameFlags |= GameDefines.GAME_FLAG_MASK_ACTION_CANCELLED;
			}

			// Remove the guitar from the map while in use to avoid drawing it.
			if (((m_GameFlags & GameDefines.GAME_FLAG_MASK_GUITAR_IN_USE) == 0)
				&& (!m_PlayerSim.IsBusy())) // Wait until sim has walked to
											// guitar
			{
				m_GameFlags |= GameDefines.GAME_FLAG_MASK_GUITAR_IN_USE;
				m_CurrentObject.RemoveFromMap(House.s_LotSingleton);
			}
			break;

		case WorldData.ITEM_EXERCISE_BIKE:
			if ( ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_ACTION_CANCELLED) != 0) ||
							 DoesSimWantToDoAction(false) )
			{
				actionFinished = PerformAction(m_CurrentObject, 0, true, -1, -1,
								SimObject.ANIM_ID_STAND, AnimationEffect.CLOUD_EXERCISING, -1, -1, -1);
			}
			else
			{
				CancelAction();
				m_GameFlags |= GameDefines.GAME_FLAG_MASK_ACTION_CANCELLED;
			}
			break;

		case WorldData.ITEM_DANCE_FLOOR:
			actionFinished = PerformAction(m_CurrentObject, 0, false, -1, -1,
							SimObject.ANIM_ID_DANCE, AnimationEffect.NONE, -1, -1, -1);
			break;

		case WorldData.ITEM_DECKS:
			if (m_CurrActionNum == 0)
			{
				actionFinished = PerformAction(m_CurrentObject, 0, true, -1, -1,
								SimObject.ANIM_ID_STAND, AnimationEffect.CLOUD_MUSIC, -1, -1, -1);
			}
			else
			{
				actionFinished = PerformAction(m_CurrentObject, 0, true, -1, -1,
								SimObject.ANIM_ID_SWITCH, AnimationEffect.NONE, -1, -1, SoundId.SOUND_GENERAL);
			}
			break;

		case WorldData.ITEM_JUICE_BAR:
			actionFinished = PerformAction(m_CurrentObject, WorldData.JUICE_COST, true, -1, -1,
							SimObject.ANIM_ID_STAND, AnimationEffect.CLOUD_COOKING, -1, -1, -1);
			break;

		case WorldData.ITEM_SOFA_2:
			if (m_CurrActionNum == 0)
			{
				actionFinished = PerformAction(m_CurrentObject, 0, false, SimObject.ANIM_ID_SIT_DOWN,
								SimObject.ANIM_ID_STAND_UP, -1, AnimationEffect.NONE, -1, -1, -1);
			}
// else
// {
// actionFinished = PerformAction(m_CurrentObject, 0, false,
// SimObject.ANIM_ID_LAY_DOWN,
// SimObject.ANIM_ID_LAY_DOWN_TO_STAND, -1, AnimationEffect.NONE, -1, -1);
//
// // Set whether the sim is sleeping based on the state of the action.
// if(m_CurrActionState == WorldData.ACTION_STATE_MAIN)
// m_GameFlags |= GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING;
// else
// m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING);
// }
			break;

		default:
			actionFinished = true;
			break;
		}
// END

		if(m_CurrActionState == WorldData.ACTION_STATE_MAIN_SETUP)
		{
			MainItemAction(false);
		}

		// do clean up code if the action ended
		if (actionFinished)
		{
			CompletedItemAction();
			StopAction(true, false); // Calls CompleteItemAction()
		}

	} // end DoItemAction

	/**
	 * Call only when an action is completed, not if cancelled or stopped Can
	 * move into StopAction?
	 */
	private void CompletedItemAction()
	{
		switch(m_CurrItemId)
		{
		case WorldData.ITEM_GAS_COOKER:
			if (CheckForFire(WorldData.GAS_COOKER_FIRE_RATING) )
			{
				m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_OVEN_ON_FIRE;

				// Show the correct graphic.
				m_CurrentObject.ForceSetFacing(1);
			}
			break;

		case WorldData.ITEM_MICROWAVE:
			if (CheckForFire(WorldData.MICROWAVE_FIRE_RATING) )
			{
				m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_MICROWAVE_ON_FIRE;

				// Show the correct graphic.
				m_CurrentObject.ForceSetFacing(1);
			}
			break;

		case WorldData.ITEM_FIRE_EXTINGUISHER:
			// Put the fire out.
			// Ensure that these are in the same order as in GetSecondaryItem
			if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_OVEN_ON_FIRE) != 0)
			{
				m_SaveFlags &= ~(GameDefines.SAVE_FLAG_MASK_OVEN_ON_FIRE);
			}
			else if ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_MICROWAVE_ON_FIRE) != 0)
			{
				m_SaveFlags &= ~(GameDefines.SAVE_FLAG_MASK_MICROWAVE_ON_FIRE);
			}
			m_SecondaryObject.ForceSetFacing(0);
			break;
		}
	} // CompletedItemAction

	/**
	 * Clean-up to be called when actions complete, are cancelled or stopped Can
	 * move into StopAction?
	 */
	private void FinishItemAction()
	{
		MainItemAction(true);

		switch(m_CurrItemId)
		{
		case WorldData.ITEM_FRIDGE:
			m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_FRIDGE_IN_USE);
			break;

		case WorldData.ITEM_FIRE_EXTINGUISHER:
			if ((m_GameFlags & GameDefines.GAME_FLAG_MASK_EXTINGUISHER_IN_USE) != 0)
			{
				m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_EXTINGUISHER_IN_USE;
				m_CurrentObject.AddToMap(House.s_LotSingleton);
			}
			break;

		case WorldData.ITEM_GUITAR:
			if ((m_GameFlags & GameDefines.GAME_FLAG_MASK_GUITAR_IN_USE) != 0)
			{
				m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_GUITAR_IN_USE;
				m_CurrentObject.AddToMap(House.s_LotSingleton);
			}
			break;

		case WorldData.ITEM_BLACK_N_WHITE_TV:
			if((m_GameFlags & GameDefines.GAME_FLAG_MASK_BWTV_IN_USE) != 0)
			{
				m_PlayerSim.SetXPos(m_PlayerSim.m_TilePosX + 1);
				m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_BWTV_IN_USE;
			}
			break;

		case WorldData.ITEM_BED:
			if((m_GameFlags & GameDefines.GAME_FLAG_MASK_BED_IN_USE) != 0)
			{
				m_PlayerSim.SetXPos(m_PlayerSim.m_TilePosX + 1);
				m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_BED_IN_USE;
			}
			break;
		}
	} // end FinishItemAction

	/**
	 * Called when: Main item animation is about to start: finished = true Also
	 * when actions complete, are cancelled or stopped: finished = false
	 */
	private void MainItemAction(boolean finished)
	{
		switch(m_CurrItemId)
		{
		case WorldData.ITEM_STEREO:
			if (m_CurrActionNum == 0)
			{
				if(!finished)
				{
					m_SaveFlags = (int)(m_SaveFlags ^ GameDefines.SAVE_FLAG_MASK_STEREO_ON_ROCK);
				}
			}
			else
			{
				PlayMusicOption(SoundId.SOUND_HIFI_ROCK, SoundId.SOUND_HIFI_POP,
						( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_STEREO_ON_ROCK) != 0), finished);
			}
			break;

		case WorldData.ITEM_GUITAR:
			PlayMusicOption(SoundId.SOUND_GUITAR, 0, true, finished);
			break;

		case WorldData.ITEM_DANCE_FLOOR:
			PlayMusicOption(SoundId.SOUND_DECKS_DANCE, SoundId.SOUND_DECKS_TRANCE,
							( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_DECKS_ON_DANCE) != 0), finished);
			break;

		case WorldData.ITEM_DECKS:
			if (m_CurrActionNum == 0)
			{
				PlayMusicOption(SoundId.SOUND_DECKS_DANCE, SoundId.SOUND_DECKS_TRANCE,
						( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_DECKS_ON_DANCE) != 0), finished);
			}
			else
			{
				if(!finished)
				{
					m_SaveFlags = (int)(m_SaveFlags ^ GameDefines.SAVE_FLAG_MASK_DECKS_ON_DANCE);
				}
			}
			break;

		case WorldData.ITEM_ALARM_CLOCK:
			if(!finished)
			{
				m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_ALARM_SET;
			}
			break;
		}
	}

	/**
	 * Stops immediately any action player sim is currently doing
	 *
	 */
	public void StopAction(boolean removeSkillBar, boolean clearSimActions)
	{
		if(removeSkillBar)
		{
			// remove the old sprite (need to temporarily remove the sprite from
			// the from buffer)
			m_SkillBarSpriteFrames = -1;
		}

		if(clearSimActions)
		{
			m_PlayerSim.ClearActions();
		}

		if((m_GameFlags & GameDefines.GAME_FLAG_MASK_ACTION_STOPPED) == 0)
		{
			FinishItemAction();

			if (m_CurrItemId == WorldData.ITEM_FRONT_DOOR)
			{
				m_GameFlags &= ~GameDefines.GAME_FLAG_MASK_DOOR_OPTION_SELECTED;
				m_WalkingToDoor = false;
			}

			m_CurrentObject = null;
			m_SecondaryObject = null;
			m_CurrItemId = WorldData.INVALID_ITEM_ID;
			m_CurrActionNum = WorldData.ACTION_0;
			m_CurrActionState = WorldData.ACTION_STATE_PRE_INIT;
			m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_PLAYER_ACTION | GameDefines.GAME_FLAG_MASK_PLAYER_SLEEPING);
		}

		m_GameFlags |= GameDefines.GAME_FLAG_MASK_ACTION_STOPPED;
	}

	/**
	 * Cancel any action player sim is currently doing
	 *
	 */
	private void CancelAction()
	{
		if(m_CurrItemId == WorldData.ITEM_FRONT_DOOR)
		{
			StopAction(true, true);
		}

		if(m_CurrActionState == WorldData.ACTION_STATE_PRE_INIT)
		{
			m_CurrActionState = WorldData.ACTION_STATE_CANCEL;
		}
		else if(m_CurrActionState == WorldData.ACTION_STATE_INIT)
		{
			StopAction(true, true);
		}
		else if((m_CurrActionState == WorldData.ACTION_STATE_PREANIM_SETUP) ||
				(m_CurrActionState == WorldData.ACTION_STATE_PREANIM) ||
				(m_CurrActionState == WorldData.ACTION_STATE_MAIN_SETUP) ||
				(m_CurrActionState == WorldData.ACTION_STATE_MAIN))
		{
			m_CurrActionState = WorldData.ACTION_STATE_POSTANIM_SETUP;
		}
	}

	/**
	 * Added to make the music switching for stereo, decks and dance floor
	 * easier
	 *
	 * @param option1
	 * @param option2
	 * @param playOption1
	 * @param finished
	 */
	private void PlayMusicOption(int option1, int option2, boolean playOption1, boolean finished)
	{
		int musicToPlay = option1;

		if (!playOption1)
		{
			musicToPlay = option2;
		}

		if (finished)
		{
			// Stop the sound regardless of the state.
			Utility.stopSound(musicToPlay );
			m_GameFlags &= ~(GameDefines.GAME_FLAG_MASK_MUSIC_PLAYING);
		}
		else if ( (m_GameFlags & GameDefines.GAME_FLAG_MASK_MUSIC_PLAYING) == 0)
		{
			PlaySound(musicToPlay, -1);
			m_GameFlags |= GameDefines.GAME_FLAG_MASK_MUSIC_PLAYING;
		}
	} // end PlayMusicOption

	/**
	 * Is the selected position a valid position in the room
	 *
	 * @param pos
	 * @return true is object is selectable
	 */
	public boolean IsObjectSelectable(int id)
	{
		// assume position is valid
		boolean invalid = false;

		// if it is not the work door, do the check flag
		if (id > 0)
		{
			invalid = ( (m_LockFlags & ( (long)1 << id) ) != 0);

			if(!invalid)
			{
				// Special case for the fire extinguisher.
				if(id == WorldData.ITEM_FIRE_EXTINGUISHER)
				{
					invalid =
						( (m_SaveFlags & (GameDefines.SAVE_FLAG_MASK_MICROWAVE_ON_FIRE | GameDefines.SAVE_FLAG_MASK_OVEN_ON_FIRE) ) == 0);
				}
				// Special cases for the ovens when on fire.
				else if(id == WorldData.ITEM_MICROWAVE)
				{
					invalid = ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_MICROWAVE_ON_FIRE) != 0);
				}
				else if(id == WorldData.ITEM_GAS_COOKER)
				{
					invalid = ( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_OVEN_ON_FIRE) != 0);
				}
				else if(id == WorldData.ITEM_TABLE)
				{
					invalid = true;
				}
				else if(id == WorldData.ITEM_SMOKE_ALARM)
				{
					invalid = true;
				}
			}
		}

		return invalid;
	}

	/**
	 * Generic action function to encapsulate object use animations.
	 *
	 * @param cost
	 *            cost in simoleans (or zero)
	 * @param facing
	 *            direction to face
	 * @param preanim
	 *            animation to play before object use (or -1)
	 * @param postanim
	 *            animation to play after object use (or -1)
	 * @param mainanim
	 *            animation to play whilst using the object (or -1)
	 * @param maincloud
	 *            cloud effect to play whilst using the object (or NONE)
	 * @param preanimTime
	 *            time to play the pre-anim (or -1 to use end of anim)
	 * @param postanimTime
	 *            time to play the post-anim (or -1 to use end of anim)
	 * @param soundId
	 *            sound to play
	 *
	 * @return
	 */
	private boolean PerformAction(EdithObject object, int cost, boolean facing, int preanim, int postanim,
					int mainanim, int maincloud, int preanimTime, int postanimTime, int soundId)
	{
		boolean actionFinished = false;
		boolean allFinished = false;

		switch(m_CurrActionState)
		{
		case WorldData.ACTION_STATE_PRE_INIT:
			// Move the player.
			// Before using any item we have to walk to it and face it.
			m_PlayerSim.AddWalkToAction(object);
			m_CurrActionState = WorldData.ACTION_STATE_INIT;

			// special case code for the bed and the B&W TV
			if ( (object.m_GuId == WorldData.ITEM_BED) ||
				 (object.m_GuId == WorldData.ITEM_BLACK_N_WHITE_TV) )
			{
				m_PlayerSim.AddSetFacingToAction(3);
			}
			else
			{
				m_PlayerSim.AddTurnTowardsAction(object, facing);
			}
			break;

		case WorldData.ACTION_STATE_INIT:
			// Wait until we've reached the object.
			if(!m_PlayerSim.IsBusy())
			{
				if( m_PlayerSim.m_staticScriptVars[StaticVariables.STAT_CURRENT_CONTAINER_SLOT] !=
					EdithObject.INVALID_INSTANCE_ID )
				{
					// remove the proper amount of Simoleans if the player has
					// enough
					if (UpdateSimoleans(cost, true, true) )
					{
						// go to the do anim state setup
						m_CurrActionState = WorldData.ACTION_STATE_PREANIM_SETUP;
						break;
					}
				}
				allFinished = true;
			}
			break;

		case WorldData.ACTION_STATE_PREANIM_SETUP:
			if(preanim != -1)
			{
				// Set the animation.
				m_PlayerSim.ControlAnimation(preanim, true, maincloud);
				m_CurrActionTimer = preanimTime;

				// go to the do anim state
				m_CurrActionState = WorldData.ACTION_STATE_PREANIM;
			}
			else
			{
				// go to the main state setup
				m_CurrActionState = WorldData.ACTION_STATE_MAIN_SETUP;
			}
			break;

		case WorldData.ACTION_STATE_PREANIM:
			if(m_CurrActionTimer >= 0)
			{
				m_CurrActionTimer -= m_GameTimeElapsed;
				if(m_CurrActionTimer < 0)
				{
					// go to the main state setup
					m_CurrActionState = WorldData.ACTION_STATE_MAIN_SETUP;
				}
			}
			else if(!m_PlayerSim.GetIsAnimRunning())
			{
				// go to the main state setup
				m_CurrActionState = WorldData.ACTION_STATE_MAIN_SETUP;
			}
			break;

		case WorldData.ACTION_STATE_POSTANIM_SETUP:
			if(postanim != -1)
			{
				// Set the animation.
				m_PlayerSim.ControlAnimation(postanim, true, AnimationEffect.DISABLE);
				m_CurrActionTimer = postanimTime;

				// go to the do anim state
				m_CurrActionState = WorldData.ACTION_STATE_POSTANIM;
			}
			else
			{
				// Move to stand - we won't worry if there's a post-anim.
				m_PlayerSim.ControlAnimation(SimObject.ANIM_ID_STAND, true, AnimationEffect.DISABLE);

				allFinished = true;
			}
			break;

		case WorldData.ACTION_STATE_POSTANIM:
			if(m_CurrActionTimer >= 0)
			{
				m_CurrActionTimer -= m_GameTimeElapsed;
				if(m_CurrActionTimer < 0)
					allFinished = true;
			}
			else
			{
				if(!m_PlayerSim.GetIsAnimRunning())
					allFinished = true;
			}
			break;

		case WorldData.ACTION_STATE_MAIN_SETUP:
			if(soundId != -1)
				PlaySound(soundId, 1);

			if(mainanim != -1)
			{
				// start the animation
				m_PlayerSim.ControlAnimation(mainanim, true, maincloud);
			}

			// Set up the initial data used by UpdateSkillsAndNeedsFromAction()
			SetInitialActionData();

			// Always go to the main state
			m_CurrActionState = WorldData.ACTION_STATE_MAIN;

		case WorldData.ACTION_STATE_MAIN:
			// update the Sim needs until done
			actionFinished = UpdateSkillsAndNeedsFromAction(true, true);
			if(actionFinished)
			{
				if( (mainanim == SimObject.ANIM_ID_DANCE) || !m_PlayerSim.GetIsAnimRunning())
				{
					// Quick hack to clean up looping animations.
// if(AnimationLoops(mainanim))
// {
// // Move to stand - we won't worry if there's a post-anim.
// m_PlayerSim.ControlAnimation(SimObject.ANIM_ID_STAND, true,
// AnimationEffect.DISABLE);
// }
// else
// {
// // Stop the main animation.
// m_PlayerSim.ControlAnimation(mainanim, false, AnimationEffect.DISABLE);
// }

					// go to the do anim state
					m_CurrActionState = WorldData.ACTION_STATE_POSTANIM_SETUP;
				}
			}
			break;
		case WorldData.ACTION_STATE_CANCEL:
		// default is to finish (usually set when a cancel is hit)
		default:
			allFinished = true;
			break;
		}

		// Finish.
		if(allFinished)
		{
			if(postanim != -1)
				m_PlayerSim.ControlAnimation(postanim, false, AnimationEffect.DISABLE);
			else if (mainanim != -1)
				m_PlayerSim.ControlAnimation(mainanim, false, AnimationEffect.DISABLE);
			else if (preanim != -1)
				m_PlayerSim.ControlAnimation(preanim, false, AnimationEffect.DISABLE);
		}

		return allFinished;
	}

	/**
	 * Does this animation loop?
	 *
	 * @return Whether this anim loops
	 */
	/*
	 * private boolean AnimationLoops(int animid) { switch(animid) { case
	 * SimObject.ANIM_ID_SIT_DOWN: return false; case
	 * SimObject.ANIM_ID_STAND_UP: return false; case SimObject.ANIM_ID_SWITCH:
	 * return false; case SimObject.ANIM_ID_WAVE: return false; case
	 * SimObject.ANIM_ID_DANCE: return true; case SimObject.ANIM_ID_WALK: return
	 * true; case SimObject.ANIM_ID_STAND: return false; case
	 * SimObject.ANIM_ID_IDLE: return false; case SimObject.ANIM_ID_ADMIRE:
	 * return false; case SimObject.ANIM_ID_LAY_DOWN: return false; case
	 * SimObject.ANIM_ID_LAY_DOWN_TO_STAND: return false; } return false; }
	 */

	/**
	 * Sets the inital action data
	 *
	 */
	private void SetInitialActionData()
	{
		int itemTableOffset = (m_CurrItemId - SimAttributes.NUM_ROOMS);
		int timeToWait = ITEM_ACTION_TABLE[itemTableOffset][m_CurrActionNum][WorldData.ITEM_ACTION_MAX_TIME];
		m_CurrActionEndTime = timeToWait;
		m_CurrActionLastUpdate = 0;

	}// end SetInitialActionTimer

	/**
	 * Carry out the smoke alarm tests.
	 */
	private void UpdateSmokeAlarm()
	{
		if( (m_SaveFlags & GameDefines.SAVE_FLAG_MASK_SMOKE_ALARM_RINGING) == 0)
		{
			if ( (m_SaveFlags & (GameDefines.SAVE_FLAG_MASK_MICROWAVE_ON_FIRE | GameDefines.SAVE_FLAG_MASK_OVEN_ON_FIRE) ) != 0)
			{
				PlaySound(SoundId.SOUND_ALARMCLOCK, 0);
				m_SaveFlags |= GameDefines.SAVE_FLAG_MASK_SMOKE_ALARM_RINGING;
			}
		}
		else // m_IsSmokeAlarmRinging
		{
			if( (m_SaveFlags & (GameDefines.SAVE_FLAG_MASK_MICROWAVE_ON_FIRE | GameDefines.SAVE_FLAG_MASK_OVEN_ON_FIRE) ) == 0)
			{
				// Stop the sound regardless of the state.
				Utility.stopSound(SoundId.SOUND_ALARMCLOCK );
				m_SaveFlags &= ~(GameDefines.SAVE_FLAG_MASK_SMOKE_ALARM_RINGING);
				m_SuffocationCounter = 0;
			}
		}
	}

	public boolean IsItemAvailable(int itemId)
	{
		if(itemId == WorldData.ITEM_FRONT_DOOR)
		{
			return true;
		}
		else
		{
			return ( (m_LockFlags & ( (long)1 << itemId) ) == 0);
		}
	}

	// The fire rating is now between 0 & 5.
	// We divide by 10 to give the probability of fire.
	// This makes the worst case a fifty/fifty though
	// an object with a hazard rating of 5 is dangerous!
	private final static int ONE_TENTH 			= (SimAttributes.FIXED_4_12_ONE / 10);

	public static final int	ACTION_INVALID		= -1;
	public static final int	ACTION_ADD_NPC		= 0;

	// appearance guids for the the player Sim with the different palettes
	private final static int[][] appearanceGuids =
	{
		// removed the default palettes as the code isn't loading them for some
		// reason
		{800385, 800387, 800390, 800392, 800394, 800396, 800398, 800400, 800402, 800404, 800406}, // 800389,
		{800408, 800410, 800412, 800414, 800416, 800419, 800421, 800423, 800425, 800427, 800429}, // 800418,
	};

	/** Animations around the action */
// private final static int ANIM_MODE_0 = 0;
	/** Animation before and during action */
// private final static int ANIM_MODE_1 = 1;
// private final static int ANIM_MODE_2 = 2;

// private final static int PRIMARY_OBJECT = 0;
// private final static int SECONDARY_OBJECT = 1;

	/*
	 * Static variables
	 */
	public static SimsApp 	s_MIDlet;
	public static Image 	s_CurrBG;
	public static Image 	s_OldBG;
	public static Image		s_GeneralSpriteImage;
	public static Image[]	s_RoommateSpriteIcons;
	public static Image[]	s_FriendshipSpriteIcons;

	public static int		s_GeneralSpriteXPos;
	public static int		s_GeneralSpriteYPos;
	public static int		s_GeneralSpriteSatartYPos;
	public static int[][]	s_RoommateSpritePos;
	public static int[][]	s_FriendshipSpritePos;

	/*
	 * Public Data tables - stored in the t file located in the resource
	 * directory
	 */
	public int[] 			ITEM_APP_DATA;
	public int[] 			NPC_APP_DATA;

	/** current state of the game */
	public byte				m_SkillBarSpriteFrames;
	public int 				m_CurrGameState;
	public int				m_PhoneSpriteFrame;
	/** Simolean update flash timer */
	public int				m_SimoleanTimer;
	public SimObject		m_PlayerSim;
	public EdithObject		m_NextObject;
	public EdithObject		m_CurrentObject;
	public Dialogue[]		m_Dialogs;

	/*
	 * Public Data tables - stored in the t file located in the resource
	 * directory
	 */
	private short[][][] 	ITEM_ACTION_TABLE;

// private short[][] ROOM_POSITION_STRING_DATA;

	private short[]			ITEM_COST;
	private short[] 		ROOM_COST;
	private short[] 		PLAYER_INTERESTS;

// private byte[][][] ROOM_POSITION_DATA;

	private byte[][] 		NPC_POSITION_DATA;
	private byte[][] 		ITEM_DATA_TABLE;
// private byte[][] ROOM_NUM_DATA;
	private byte[][] 		JOB_DATA;
	private byte[][] 		NPC_JOB_DATA;
	private byte[][] 		NPC_VISITING_TIME;
	private byte[][] 		SOCIAL_SCORES;
	private byte[][] 		NPC_RELATIONSHIP_THRESHOLDS;

	/*
	 * Private variables
	 */
	/** game thread */
	private Thread 			m_Thread;
	/** request to stop thread flag */
	private boolean			m_RequestThreadStop;
	/** paused flag */
	private boolean 		m_IsPaused;
	private boolean			m_WalkingToDoor;

	// TODO: Remove these as they are debug variables
// private long m_MillisThisSecond;
// private int m_FramesPerSecond;
// private int m_FramesThisSecond;

// private long m_TotalHeap;
// private long m_CurrentHeap;

	/*
	 * Game logic variables
	 */

	/** previous state of the game */
	private int 			m_PrevGameState;
	/** state of the game before the pause interrupt */
	private int 			m_PauseGameState;
	/** Game and Engine related flags. */
	public int				m_GameFlags;
	/** current item performing an action */
	private int				m_CurrItemId;
	/** current item offset into item tables (zero based) */
	// private int m_CurrItemTableOffset;
	/** current action id */
	private int				m_CurrActionNum;
	/** current action state */
	private int				m_CurrActionState;
	/** warning or failure state id */
	private int				m_WarningFailureState;
	/** last VM selection */
	private int				m_LastVMSelection;
	/** current menu state */
	private int				m_MenuState;
	/** current sub menu state */
	private int				m_SubMenuState;
	/** item selected for purchase */
	private int				m_PurchaseSelection;
	/** Double plus or double minus or dotdotdot */
	private int				m_DoubleCursorType;
	/** The npc that the player is interacting with */
	private int				m_SelectedNpc;
	/** social menu state */
	private int				m_SocialMenuState;
	/** player facing before the social menu began */
	private int				m_PreviousPlayerFacing;
	/** NPC facing before the social menu began */
	private int				m_PreviousNPCFacing;
	/** social menu state */
	private int				m_MainPauseMenuSelection;
	/** if there is a door event happening, it will be at this hour */
	private int				m_DoorEventHour;
	/** if there is a door event happening, this is the minute it will end */
	private int				m_DoorEventMin;
	/** The id of the NPC at the door */
	private int				m_NPCAtDoor;
	/** timer to keep track of action states */
	private int				m_CurrActionTimer;
	/** timer to keep track of when to stop the item updating */
	private int				m_CurrActionEndTime;
	/** timer to keep track of last time an update occured in the item */
	private int				m_CurrActionLastUpdate;
	/** timer to keep track of when a warning can happen again */
	private int				m_NeedWarningWaitTimer;
	/** timer to keep track of when warnings/failures must finish */
	private int				m_NeedWarningTimer;
	/** keeps track of how many ms have passed since the last minute update */
	private int				m_TimeTimer;
	/** Goal delay timer */
	private int				m_GoalTimer;
	private int				m_Level;
	private int				m_Param1;
	private int				m_Param2;
	private int				m_CurrentAction;
	private int				m_NpcsInHouse;
	private int				m_NumNpcsComing;

	/** The game time in milliseconds */
	private long			m_GameTime;
	/** time at the beginning of the run frame */
	private long			m_GameTimer;
	/** how long the pause action took */
	private long			m_GameTimeElapsed;
	/** Double plus or double minus counter. */
	private long			m_DoubleCursorTimer;
	private long			m_PhoneSpriteTimer;
	private long 			m_LastFrameStart;

	private Vector			m_ActionQueue;

	// Sims 250K variables.
	private EdithObject		m_SecondaryObject;
	private SimObject[]		m_NpcObjects;

	/** The npc locations in the game */
	private short[]			m_NpcLocations;

	/** Npcs invited over or coming to the party */
	private short[]			m_NpcsComing;
	private int[]			m_NpcTimers;
	private int[]			m_NpcCount;

	/*
	 * Dialogue variables
	 */
	/** number of options in the current dialog */
	private int				m_DialogNumOptions;
	/** currently selected dialog option */
	private int				m_DialogSelectedOption;
	/** previously selected dialog option */
	private int				m_DialogPreviousOption;

	/** string ids for the current dialog */
	private short[]			m_DialogStringIds;

	/*
	 * Data to be saved
	 */
	/**
	 * Separate flags for NPC to avoid multiple defines. These can perhaps be
	 * merged into m_LockFlags.
	 */
	private int				m_NpcFlags;

	/** Save flags for game */
	private int				m_SaveFlags;
	/** current day of the week */
	private int				m_CurrDay;
	/** current hour */
	private int				m_CurrHour;
	/** current minute */
	private int				m_CurrMin;
	/** Simoleans player has */
	public int				m_Simoleans;
	/** Current goal the player has */
	private int				m_CurrGoal;
	/** Current job the player has */
	private int				m_CurrJob;
	/** Next available job the player can get */
	private int				m_NextJob;
	/** The day the player started work, for jobs that wrap days */
	private int				m_WorkStartDay;
	/** The player variant (including simwear) */
	private int				m_PlayerName;
	/** The player variant (including simwear) */
	private int				m_PlayerSign;
	/** The player variant (including simwear) */
	private int				m_PlayerPalette;
	/** The npc id of the player's spouse (NPC_INVALID if none) */
	private int				m_SpouseNpcId;
	/** The npc id of the player's roommate (NPC_INVALID if none */
	private int				m_RoommateNpcId;
	/** keeps track of how long the sim has been starving */
	private int				m_HungerCounter;
	/** Fire timer (min) - this counts up to suffocation */
	private int				m_SuffocationCounter;
	/** Tutorial position */
	private int 			m_GoalPosition;

	/** bit field for locked objects */
	private long			m_LockFlags;

	/**
	 * The number of times the same topic has been discussed with an npc. This
	 * is used to determine boredom.
	 */
	private byte[][]		m_DiscussedTopics;

	/** The current wants the Sim needs to fulfill */
	private short[]			m_CurrWants;
	/** the sim need/skill values - fixed point 1.7.8 */
	private short[]			m_SimTraits;
	/** The player relationship values - fixed point 1.7.8 */
	private short[]			m_Relationships;

	/** Npc schedule */
	private long[]			m_NpcSchedule;

	/** objects/rooms that are available to purchase */
	private Vector			m_BuyList;

	/** Demo Arributes*/

	private boolean isDemo;
	private boolean demoOver;
	//This variable is used to draw "Trial over" text only if the user completes the full Demo and if the user is exiting before completion of demo the Trail over text will not be displayed.
	private boolean exitMain;

	}

