package tetris;



import javax.microedition.lcdui.Graphics;

import javax.microedition.lcdui.Image;

import java.util.Random;

import java.io.IOException;



public class teBG {



//	static public final int LEFT = 0;

//	static public final int CENTER = 1;

//	static public final int RIGHT = 2;



	static Random rand;



	public static blFont alpha3,alpha5,alpha8,alpha8y,alpha10;



	public static void draw(Image img, int variant) {

		draw(img.getGraphics(), img.getWidth(), img.getHeight(), variant);

	}



	public static void draw(Graphics g, int width, int height, int variant) {

		int i;

		int ri, gi, bi;

		int sr, sg, sb;

		int dr, db, dr1, db1;

		int x, y, w, squaresize;

		final int steps = 12;

		final int cycle = 5;



		if(rand==null) {

			rand = new Random();

		}

//		rand.setSeed(variant);



		variant--;

		if(variant<0) {

			variant = 0;

		}



		//get colors

		i = variant%cycle;

		sr = (i * (40/cycle));

		sb = 40 - (i * (40/cycle));

		dr1 = (i * (255/cycle));

		db1 = 255 - (i * (255/cycle));



		// draw gradient

		dr = dr1;

		db = db1;

		ri = ((dr-sr)<<16)/height;

		bi = ((db-sb)<<16)/height;

		sr<<=16;

		sb<<=16;

		for(i=0;i<height;i++) {

			g.setColor(sr>>16, 0, sb>>16);

			g.drawLine(0, i, width, i);

			sr+=ri;

			sb+=bi;

		}



		// draw blocks

		sr = dr1 - (dr1/5);

		sg = 0;

		sb = db1 - (db1/5);

		dr = dr1;

		db = db1;

		ri = ((dr-sr)<<16)/steps;

		gi = (60<<16)/steps;

		bi = ((db-sb)<<16)/steps;

		sr<<=16;

		sb<<=16;

		squaresize = height/(steps-1);

		w = squaresize-2;

		y = 1;

		for(int n=0;n<=steps;n++) {

			g.setColor(sr>>16, sg>>16, sb>>16);

			sr+=ri;

			if(sr>0x00ff0000) {

				sr = 0x00ff0000;

			} else if(sr<0) {

				sr = 0;

			}

			sg+=gi;

			if(sg>0x00ff0000) {

				sg = 0x00ff0000;

			} else if(sg<0) {

				sg = 0;

			}

			sb+=bi;

			if(sb>0x00ff0000) {

				sb = 0x00ff0000;

			} else if(sb<0) {

				sb = 0;

			}

			x = 1;

			for(i=0;i<=width/squaresize;i++) {

				if(rand.nextInt() > 0) {

					g.fillRect(x, y, w, w);

				}

				x+=squaresize;

			}

			y+=squaresize;

		}

		rand = null;

	}



	static void drawRecordsClassic(String title, int score, int level, int lines, int eff, int power) {

		draw(bluelava.bg,1);

		Graphics g=bluelava.bg.getGraphics();



		int w=bluelava.getWidth();

		int h=bluelava.getHeight();

		int y=((h-62)/2)+6 - 25;

		int c=w/2;

		int q=c/2;



		//minor adjust

		q +=2;



/*

		try {

			Image game=Image.createImage("/game.png");

			int x=c-(game.getWidth()/2)+1;

			g.setClip(x,4,game.getWidth(),10);

			g.drawImage(game,x,4,Graphics.TOP|Graphics.LEFT);

		} catch(IOException e) {

		}

*/

		//localize SC

		alpha10.draw(g, localString.texts[localString.MARATHON], c, 2, blFont.CENTER);

		if (localString.gameLang.compareTo("fr") != 0) {

			alpha10.draw(g,title,c,19,blFont.CENTER);

		}

		else {

			alpha8y.draw(g,title,c,19,blFont.CENTER);

		}



		// score

		alpha8.draw(g,"SCORE",c,y,blFont.CENTER);

		y+=12;

		alpha10.draw(g,Integer.toString(score),c,y,blFont.CENTER);

		y+=16 + 15;



		// level + lines

		alpha8.draw(g,"LEVEL",q,y,blFont.CENTER);

		alpha8.draw(g,"LINES",c+q,y,blFont.CENTER);

		y+=12;

		alpha10.draw(g,Integer.toString(level),q,y,blFont.CENTER);

		alpha10.draw(g,Integer.toString(lines),c+q,y,blFont.CENTER);

		y+=16 + 15;



		// efficiency + power

		alpha8.draw(g,"EFFICIENCY",q,y,blFont.CENTER);

		alpha8.draw(g,"POWER",c+q,y,blFont.CENTER);

		y+=12;

		alpha10.draw(g,Integer.toString(eff)+"%",q,y,blFont.CENTER);

		alpha10.draw(g,Integer.toString(power),c+q,y,blFont.CENTER);



		//alpha5.draw(g,"PRESS ANY KEY",c,h-9,blFont.CENTER);

	}



	static void drawRecordsCountdown(String title, int score, int level, int lines) {

		draw(bluelava.bg,1);

		Graphics g=bluelava.bg.getGraphics();



		int w=bluelava.getWidth();

		int h=bluelava.getHeight();

		int y=((h-40)/2)+6 - 30;

		int c=w/2;

		int q=c/2;



		/*

		try {

			Image game=Image.createImage("/game.png");

			int x=c-(game.getWidth()/2)+1;

			g.setClip(x,4,game.getWidth(),10);

			g.drawImage(game,x,4-10,Graphics.TOP|Graphics.LEFT);

		} catch(IOException e) {

		}

		*/



		alpha10.draw(g, localString.texts[localString.ULTRA], c, 2, blFont.CENTER);

		if (localString.gameLang.compareTo("fr") != 0) {

			alpha10.draw(g,title,c,19,blFont.CENTER);

		}

		else {

			alpha8y.draw(g,title,c,19,blFont.CENTER);

		}



		// score

		alpha8.draw(g,"SCORE",c,y,blFont.CENTER);

		y+=12;

		alpha10.draw(g,Integer.toString(score),c,y,blFont.CENTER);

		y+=16 + 15;



		// level +lines

		alpha8.draw(g,"LEVEL",q,y,blFont.CENTER);

		alpha8.draw(g,"LINES",c+q,y,blFont.CENTER);

		y+=12;

		alpha10.draw(g,Integer.toString(level),q,y,blFont.CENTER);

		alpha10.draw(g,Integer.toString(lines),c+q,y,blFont.CENTER);



		//alpha5.draw(g,"PRESS ANY KEY",c,h-9,blFont.CENTER);

	}



	static void drawRecordsFast40(String title, int score, int time) {

		draw(bluelava.bg,1);

		Graphics g=bluelava.bg.getGraphics();



		int w=bluelava.getWidth();

		int h=bluelava.getHeight();

		int y=((h-40)/2)+6 - 30;

		int c=w/2;



		/*

		try {

			Image game=Image.createImage("/game.png");

			int x=c-(game.getWidth()/2)+1;

			g.setClip(x,4,game.getWidth(),10);

			g.drawImage(game,x,4-20,Graphics.TOP|Graphics.LEFT);

		} catch(IOException e) {

		}

		*/

		alpha10.draw(g, localString.texts[localString.FORTY_LINES], c, 2, blFont.CENTER);

		if (localString.gameLang.compareTo("fr") != 0) {

			alpha10.draw(g,title,c,19,blFont.CENTER);

		}

		else {

			alpha8y.draw(g,title,c,19,blFont.CENTER);

		}



		// time

		alpha8.draw(g,"TIME",c,y,blFont.CENTER);

		y+=12;

		String s=Integer.toString(time/10)+"."+Integer.toString(time%10);

		alpha10.draw(g,s,c,y,blFont.CENTER);

		y+=16 + 15;



		// score

		alpha8.draw(g,"SCORE",c,y,blFont.CENTER);

		y+=12;

		alpha10.draw(g,Integer.toString(score),c,y,blFont.CENTER);



		//alpha5.draw(g,"PRESS ANY KEY",c,h-9,blFont.CENTER);

	}

}



