package tetris;



import javax.microedition.lcdui.*;



public class teRenderer {



    static teRenderer inst;



	static int MINO_SIZE;



	int CANVAS_WIDTH;

	int CANVAS_HEIGHT;



	int WELL_X;

	int WELL_DX;

	int WELL_DY;

	int WELL_W;

	int WELL_DW;

	int WELL_DH;



	int HOLD_PX;

	int HOLD_PY;



	int STATS_Y;

	int STATS_DY;

	int STATS_PX;

	int STATS_PY1;

	int STATS_PY2;



	int NEXT_X;

	int NEXT_PX;

	int NEXT_PY;

	int NEXT_GAP;



	int SCORE_X;

	int SCORE_Y;

	int SCORE_PX;

	int SCORE_PY;



	public static Image[][] minos = new Image[7][16];

	public static Image[] ghosts = new Image[16];



	blFont alpha8b;



	Image activeSliceHold;

	Image activeSliceStats;

	Image activeSliceNext;

	Image activeSliceWell;

	Image activeSliceScore;



	boolean ready;



	public teRenderer() {

		inst=this;

	}



	public void destroy() {

		inst=null;

		for(int i=0;i<16;i++) {

			ghosts[i]=null;

		}

		for(int i=0;i<7;i++) {

			for(int x=0;x<16;x++) {

				minos[i][x]=null;

			}

		}

	}



	public void init(int wide, int high) {

		Image digitsrc;



		int leftsize,rightsize;

		for(int sz=3;sz<=12;sz++) {

			leftsize=(sz*4)+4;

			if(leftsize<29) {

				leftsize=29;

			}

			rightsize=(sz*4)+4;

			if(rightsize<41) {

				rightsize=41;

			}

			if((sz*teWell.WELL_WIDTH)+leftsize+rightsize<=wide) {

				if((sz*teWell.WELL_HEIGHT)+2<=high) {

					MINO_SIZE=sz - 1;//v300 hack

				}

			}

		}



		// load the image files

		bluelava.updateLoading();

		if(alpha8b==null) {

			alpha8b = new blFont("/alpha8b.fnt");

		}

		bluelava.updateLoading();



		// slice the mino images

		for(int c=0;c<7;c++) {

			bluelava.updateLoading();

			int r,g,b;

			switch(c) {

			case 0:		// blue

				r=85;

				g=85;

				b=255;

				break;

			case 1:

				r=255;

				g=128;

				b=0;

				break;

			case 2:		// green

				r=0;

				g=192;

				b=0;

				break;

			case 3:		// red

				r=255;

				g=0;

				b=0;

				break;

			case 4:

				r=0;

				g=240;

				b=240;

				break;

			case 5:

				r=240;

				g=240;

				b=0;

				break;

			case 6:

				r=252;

				g=0;

				b=252;

				break;

			default:

				r=0;

				g=0;

				b=0;

				break;

			}

			for(int i=0;i<16;i++) {

				minos[c][i] = Image.createImage(MINO_SIZE, MINO_SIZE);

				createmino(minos[c][i],r,g,b,i,MINO_SIZE);

			}

		}



		// generate the ghost images

		bluelava.updateLoading();

		for(int i=0;i<16;i++) {

			ghosts[i] = Image.createImage(MINO_SIZE, MINO_SIZE);

			boolean west=((i&0x1)==0);

			boolean south=((i&0x2)==0);

			boolean east=((i&0x4)==0);

			boolean north=((i&0x8)==0);

			Graphics g=ghosts[i].getGraphics();

			g.setColor(0,0,0);

			g.fillRect(0,0,MINO_SIZE,MINO_SIZE);

			g.setColor(255,0,0);

			int ex=MINO_SIZE-1;

			int se=MINO_SIZE-2;

			// do the sides

			if(west) {

				drawLine(g,0,0,0,south?se:ex);

			}

			if(south) {

				drawLine(g,0,se,east?se:ex,se);

			}

			if(east) {

				drawLine(g,se,0,se,south?se:ex);

			}

			if(north) {

				drawLine(g,0,0,east?se:ex,0);

			}

			// fix the corners

			if((!north)&&(!west)) {

				drawLine(g,0,0,0,0);

			}

			if((!north)&&(!east)) {

				drawLine(g,se,0,ex,0);

			}

			if((!south)&&(!west)) {

				drawLine(g,0,se,0,ex);

			}

			if((!south)&&(!east)) {

				drawLine(g,se,se,ex,se);

				drawLine(g,se,se,se,ex);

			}

		}



		CANVAS_WIDTH = wide;

		CANVAS_HEIGHT = high;



		bluelava.updateLoading();

		generate(1);

	}



	void createmino(Image m, int r, int g, int b, int stick, int size) {

		Graphics gr=m.getGraphics();

		boolean west=((stick&0x1)==0);

		boolean south=((stick&0x2)==0);

		boolean east=((stick&0x4)==0);

		boolean north=((stick&0x8)==0);

		// calc the hilite color

		int hr=(r>=135)?255:r+120;

		int hg=(g>=135)?255:g+120;

		int hb=(b>=135)?255:b+120;

		// calc the shadow color

		int sr=(r<=120)?0:r-120;

		int sg=(g<=120)?0:g-120;

		int sb=(b<=120)?0:b-120;

		// calc the extent and shadow edge

		int ex=size-1;

		int se=size-2;

		// fill the block with base color

		gr.setColor(r,g,b);

		gr.fillRect(0,0,size,size);

		// do the hilites first

		gr.setColor(hr,hg,hb);

		if(west) {

			drawLine(gr,0,0,0,ex);

		}

		if(north) {

			drawLine(gr,0,0,ex,0);

		}

		// do the shadows

		if(south) {

			gr.setColor(0,0,0);

			drawLine(gr,0,ex,ex,ex);

			gr.setColor(sr,sg,sb);

			if(east) {

				drawLine(gr,0,se,se,se);

			} else {

				drawLine(gr,0,se,ex,se);

			}

		}

		if(east) {

			gr.setColor(0,0,0);

			drawLine(gr,ex,0,ex,ex);

			gr.setColor(sr,sg,sb);

			if(south) {

				drawLine(gr,se,0,se,se);

			} else {

				drawLine(gr,se,0,se,ex);

			}

		}

		// do the corners

		// northwest

		if(!(north&&west)) {

			gr.setColor(hr,hg,hb);

			drawLine(gr,0,0,0,0);

		}

		// southwest

		if(south&&west) {

			gr.setColor(r,g,b);

			drawLine(gr,0,se,0,se);

		}

		// northeast

		if(north&&east) {

			gr.setColor(r,g,b);

			drawLine(gr,se,0,se,0);

		}

		// southeast

		if((!south)&&(!east)) {

			gr.setColor(0,0,0);

			drawLine(gr,ex,ex,ex,ex);

			gr.setColor(sr,sg,sb);

			drawLine(gr,se,se,ex,se);

			drawLine(gr,se,se,se,ex);

		}

	}



	public void drawLine(Graphics g, int x1, int y1, int x2, int y2) {

		g.drawLine(x1,y1,x2,y2);

		g.drawLine(x1,y1,x1,y1);

		g.drawLine(x2,y2,x2,y2);

	}



	public void paint(Graphics g, teSim sim) {

		Graphics ag;



		if(!ready) {

			return;

		}



		if(sim.isHoldDirty()) {

			ag = activeSliceHold.getGraphics();

			ag.drawImage(bluelava.bg, 0, 0, Graphics.TOP|Graphics.LEFT);

			if(sim.holdPiece!=null && !sim.isPaused()) {

				teTetri t = sim.holdPiece.tetri;

				int f = sim.holdPiece.face;

				t.paintFrame(ag, HOLD_PX+t.centerX(f), HOLD_PY+t.centerY(f), f);

				t.paint(ag, t.minoType, HOLD_PX+t.centerX(f), HOLD_PY+t.centerY(f), f);

			}

			sim.cleanHold();

		}

		g.drawImage(activeSliceHold, 0, 0, Graphics.TOP|Graphics.LEFT);



		if(sim.theStats.isDirty()) {

			ag = activeSliceStats.getGraphics();

			ag.drawImage(bluelava.bg, 0, -STATS_Y, Graphics.TOP|Graphics.LEFT);

			sim.theStats.paintStats(ag, STATS_PX, STATS_PY1-12 - 6, STATS_PY2-12);

			ag = activeSliceScore.getGraphics();

			ag.drawImage(bluelava.bg, -SCORE_X, -SCORE_Y, Graphics.TOP|Graphics.LEFT);

			sim.theStats.paintScore(ag, SCORE_PX, SCORE_PY-12);

			sim.theStats.clean();

		}

		g.drawImage(activeSliceStats, 0, STATS_Y, Graphics.TOP|Graphics.LEFT);

		g.drawImage(activeSliceScore, SCORE_X, SCORE_Y, Graphics.TOP|Graphics.LEFT);



		if(sim.theWell.isDirty()) {

			ag = activeSliceWell.getGraphics();

			ag.drawImage(bluelava.bg, -WELL_X, 0, Graphics.TOP|Graphics.LEFT);

			sim.theWell.paint(ag, WELL_DX, WELL_DY, MINO_SIZE);

		}

		g.drawImage(activeSliceWell, WELL_X, 0, Graphics.TOP|Graphics.LEFT);



		if(sim.nextQueue.isDirty()) {

			ag = activeSliceNext.getGraphics();

			ag.drawImage(bluelava.bg, -NEXT_X, 0, Graphics.TOP|Graphics.LEFT);

			sim.nextQueue.paint(ag, NEXT_PX, NEXT_PY, NEXT_GAP);

		}

		g.drawImage(activeSliceNext, NEXT_X, 0, Graphics.TOP|Graphics.LEFT);



		if(sim.thePiece!=null && !sim.isPaused()) {

			g.setClip(WELL_X+WELL_DX, WELL_DY, WELL_DW, WELL_DH);

			sim.thePiece.paint(g, WELL_X+WELL_DX, WELL_DY, MINO_SIZE);

		}

	}



	public static void gen(int level) {

		inst.generate(level);

	}



	void generate(int level) {

		int w,h;

		Graphics g=bluelava.bg.getGraphics();



		// create a temp bg

		teBG.draw(bluelava.bg, level);

		// create the well slices

		if(activeSliceWell==null) {

			WELL_DW = MINO_SIZE*teWell.WELL_WIDTH;

			WELL_DH = MINO_SIZE*teWell.WELL_HEIGHT;

			WELL_W = WELL_DW+3;

			WELL_X = ((CANVAS_WIDTH-(WELL_W))/2)-3;

			WELL_DX = 2;

			WELL_DY = (CANVAS_HEIGHT-WELL_DH)/2;

			activeSliceWell = Image.createImage(WELL_W, CANVAS_HEIGHT);

		}

		g.setColor(0, 0, 0);

		g.fillRect(WELL_X+WELL_DX-1, WELL_DY, WELL_DW+1, WELL_DH);

		g.setColor(0, 200, 255);

		g.drawRect(WELL_X+WELL_DX-2, WELL_DY-1, WELL_DW+2, WELL_DH+1);

		// create the hold slices

		if(activeSliceHold==null) {

			w = WELL_X;

			h = WELL_DY+7+(MINO_SIZE*4)+2;

			HOLD_PX = w/2;

			HOLD_PY = h-(MINO_SIZE*2);

			activeSliceHold = Image.createImage(w, h);

		}

		alpha8b.draw(g, "HOLD", HOLD_PX, WELL_DY-1, blFont.CENTER);

		// create the stats slices

		if(activeSliceStats==null) {

			w = activeSliceHold.getWidth();

			STATS_Y = activeSliceHold.getHeight();

			STATS_PX = w/2;

			h = CANVAS_HEIGHT-STATS_Y;

			STATS_DY=WELL_DY+WELL_DH-38-STATS_Y;

			STATS_PY1 = STATS_DY;

			STATS_PY2 = STATS_DY+25;

			activeSliceStats = Image.createImage(w, h);

		}

//		g.drawImage(bluelava.bg, 0, -STATS_Y, Graphics.TOP|Graphics.LEFT);

		if(tetris.gametype==tetris.GAMETYPE_CLASSIC) {

			alpha8b.draw(g, "LVL", STATS_PX, STATS_Y+STATS_PY1-24 - 6, blFont.CENTER);

		} else {

			alpha8b.draw(g, "TIME", STATS_PX, STATS_Y+STATS_PY1-24 - 6, blFont.CENTER);

		}

		alpha8b.draw(g, "GOAL", STATS_PX, STATS_Y+STATS_PY2-24, blFont.CENTER);

		// create the next slices

		if(activeSliceNext==null) {

			NEXT_X = WELL_X+WELL_W;

			w = CANVAS_WIDTH-NEXT_X;

			NEXT_PX = w/2;

			NEXT_PY = WELL_DY+7+4+MINO_SIZE;

			NEXT_GAP = (MINO_SIZE*2)+3;

			h = NEXT_PY+(NEXT_GAP*teNext.NEXT_QSIZE);

			activeSliceNext = Image.createImage(w, h);

		}

		alpha8b.draw(g, "NEXT", NEXT_X+NEXT_PX, WELL_DY-1, blFont.CENTER);

		// create the score slices

		if(activeSliceScore==null) {

			w = activeSliceNext.getWidth();

			SCORE_X = NEXT_X;

			SCORE_Y = activeSliceNext.getHeight();

			h = CANVAS_HEIGHT-SCORE_Y;

			SCORE_PX=w/2;

			SCORE_PY=STATS_Y+STATS_PY2-SCORE_Y;

			activeSliceScore = Image.createImage(w, h);

		}

		alpha8b.draw(g, "SCORE", SCORE_X+SCORE_PX, SCORE_Y+SCORE_PY-24, blFont.CENTER);



		ready = true;

	}

}

