package com.bejeweled2_j2me;

/**
    Build options and functions that vary depending on Vodafone demo pack (embeds2_j2me) or
    standalone (bejeweled2_j2me)
*/
public class Build {
    
    /** If true, writes debug info to the console. */
    public static boolean DEBUG = false;
    
    /** If true, this is a Vodafone demo build. */
    public static boolean VODAFONE = shell.Build.VODAFONE;
    
    /** If true, the flag select screen is shown before the EA logo */
    public static boolean SHOW_FLAG_SELECT = false;

    /** Path to the EA logo splash image */
    public static String EA_LOGO = "/tetris/ealogo.png";
    
    /** Path to the Vodafone dice splash image */
    public static String VODAFONE_BACKGROUND = "/shell/voda.png";
    
    /** Root of all the Bejeweled resources. */
    public static String FILE_ROOT = "/bejeweled/";
    
    
    /**
        Launches the Buy URI and exits Bejeweled
    */
    public static void showBuyURIAndExit(GameEngine gameEngine) {
        /*
            String demoBuyURI = gameEngine.getProperty(StringTable.PROP_BUY_URI);
            try {
                gameEngine.getMIDlet().platformRequest(demoBuyURI);
            } catch(Exception exception) {
                
            }
            gameEngine.exit();
        */
        
        // Launch the URL defined in the shell
        shell.BuyScene.autoBuy = true;
        
        gameEngine.exit();
    }
}