/**
 * Created by IntelliJ IDEA.
 * User: bhawkins
 * Date: Jul 17, 2003
 * Time: 1:44:25 PM
 * To change this template use Options | File Templates.
 */

package com.bejeweled2_j2me;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Canvas;

abstract class GuiElement
{

    // Canvas this element interacts with and renders to.
    protected Canvas canvas;

    // Location and size.
    protected int x, y, wd, ht;

    /**
     * Create a new element.
     *
     * @param canvas this element interacts with and renders to
     * @param x origin
     * @param y origin
     * @param wd width
     * @param ht height
     */
    GuiElement(Canvas canvas, int x, int y, int wd, int ht) {
        this.canvas = canvas;
        this.x = x;
        this.y = y;
        this.wd = wd;
        this.ht = ht;
    }

    /**
     * Override to provide element specific drawing.
     *
     * @param gc graphics context to render to
     */
    abstract void draw(Graphics gc);

    /**
     * Render this element to the canvas.
     *
     * @param gc graphics context of canvas to render to
     * @param x current clip origin of gc (performance optimization)
     * @param y current clip origin of gc (performance optimization)
     * @param wd current clip width of gc (performance optimization)
     * @param ht current clip height of gc (performance optimization)
     */
    void paint(Graphics gc, int x, int y, int wd, int ht) {
        if(isVisible(x, y, wd, ht)) {
            //gc.clipRect(this.x, this.y, this.wd, this.ht);
            gc.setClip(0 ,0, DeviceSpecific.WIDTH, DeviceSpecific.HEIGHT);
            draw(gc);
            //gc.setClip(x, y, wd, ht);
            gc.setClip(0 ,0, DeviceSpecific.WIDTH, DeviceSpecific.HEIGHT);
        }
    }

    /**
     * Tell the canvas this element requires redrawing.
     */
    protected void repaint() {
        canvas.repaint(x, y, wd, ht);
    }

    /**
     * Check if a clip rectangle intersects with this element.
     *
     * @param x clip origin
     * @param y clip origin
     * @param wd clip width
     * @param ht clip height
     * @return true if intersection exist, false if disjoint
     */
    protected boolean isVisible(int x, int y, int wd, int ht) {
        return(doesIntersect(x, y, wd, ht, this.x, this.y, this.wd, this.ht));
    }

    /**
     * Check if two rectangles intersect. General utility, can be used
     * separate from elements.
     *
     * @param x1 origin of first rectangle
     * @param y1 origin of first rectangle
     * @param wd1 width of first rectangle
     * @param ht1 height of first rectangle
     * @param x2 origin of second rectangle
     * @param y2 origin of second rectangle
     * @param wd2 width of second rectangle
     * @param ht2 height of second rectangle
     * @return true if intersection exists, false if disjoint
     */
    static boolean doesIntersect(
        int x1, int y1, int wd1, int ht1, int x2, int y2, int wd2, int ht2) {
        int fullSpanX = Math.max(x1 + wd1, x2 + wd2) - Math.min(x1, x2);
        int fullSpanY = Math.max(y1 + ht1, y2 + ht2) - Math.min(y1, y2);
        return ((fullSpanX < (wd1 + wd2)) && (fullSpanY < (ht1 + ht2)));
    }

}
