/**
 * Created by IntelliJ IDEA.
 * User: bhawkins
 * Date: Jul 17, 2003
 * Time: 7:57:56 PM
 * To change this template use Options | File Templates.
 */

package com.bejeweled2_j2me;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Canvas;

class ProgressElement extends GuiElement
{

    // Color of progress bar. (0xRRGGBB where R,G, and B [0x00-0xFF])
    private static final int BAR_COLOR = 0xF981DD;

    // Color of border enclosing full length of progress bar.
    // (0xRRGGBB where R,G, and B [0x00-0xFF])
    private static final int BORDER_COLOR = 0x77005B;

    // Maximum value this progress bar can be set to.
    private int maximum;

    // Current value.
    private int value;

    /**
     * Create a new image element.
     *
     * @param canvas this element interacts with and renders to
     * @param maximum value bar can be set to
     * @param x origin
     * @param y origin
     * @param wd width
     * @param ht height
     */
    ProgressElement(Canvas canvas, int maximum, int x, int y, int wd, int ht) {
        super(canvas, x, y, wd, ht);
        this.maximum = maximum;
        repaint();
    }

    /**
     * Change bar value.
     *
     * @param value [0,maximum]
     */
    void setValue(int value) {
        this.value = Math.max(0, Math.min(value, maximum));
        repaint();
    }

    /**
     * Render current progress bar according to value surrounded by a border
     * to illustrate the relative size compared to the maximum.
     *
     * @param gc graphics context to render to
     */
    void draw(Graphics gc) {
        gc.setColor(BAR_COLOR);
        gc.fillRect(x + 1, y + 1, ((wd - 3) * value) / maximum, ht - 3);
        gc.setColor(BORDER_COLOR);
        gc.drawRect(x, y, wd - 1, ht - 1);
    }

}
