package shell;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import shell.core.App;
import shell.core.Scene;
import shell.core.ImageFont;
import shell.core.Visual;
import shell.core.Device;


public class HelpScene extends Scene implements Layout {
    
    
    public void load() {
        setBackground(0x000000);
        
        ImageFont helpFont = new ImageFont("help-font");
        String text = Local.HELP1 + " " + Local.HELP2 + "\n\n" + Local.LEGAL + "\n\n" +
            Local.SUPPORT + "\n\n" + Local.VERSION + " " + App.getProperty("MIDlet-Version");
        String[] wrappedText = helpFont.wordWrapText(text, Device.WIDTH - Device.WIDTH / 10);
        int y = HELP_Y;
        for (int i = 0; i < wrappedText.length; i++) {
            Image image = helpFont.renderText(wrappedText[i]);
            Visual visual = new Visual(image, Device.WIDTH/2, y);
            visual.setAnchor(Graphics.TOP | Graphics.HCENTER);
            add(visual);
            y += HELP_DY;
        }
        
        ImageFont normalFont = new ImageFont("softkey-font");
        ImageFont selectFont = new ImageFont("softkey-select-font");
        setSoftKey1(ImageFont.createButton(Local.OK, normalFont, selectFont));
          
    }
    
    
    public void update(int elapsedTime) {
        
        if (App.isPressed(App.VK_OK) || App.isPressed(App.VK_SOFT1) || 
            App.isPressed(App.VK_5))
        {
            setSoftKey1Highlight(true);
            App.popScene();
        }
    }
}
