package sims2;



/* Copyright Ideaworks3D Ltd. 2005 */





import javax.microedition.lcdui.Graphics;

// import javax.microedition.lcdui.*;

import javax.microedition.lcdui.Image;



import javax.microedition.lcdui.game.*;



//import com.ideaworks3d.debug.Debug;





import java.util.*;



public abstract class Engine 

{

   public static final int BIAS = 2;

   

   /*

      maximum value (inclusive) of 'h' ever passed to getFloor() or getWall()

   */

   

   public static final int MAXHEIGHT = /*Debug.ENABLED ? 9 :*/ 9;



   private static final boolean OVER_DRAW_TILES = true;

   

   private static final boolean RENDER_ANY_TILES = true ;//|| !Debug.ENABLED;

   

   // test data

   public int m_NumCallsPerFrame = 0;



   /*

      image

   */



   private Image img0;

   private Graphics gfx0;



   private int img_width_blocks;

   private int img_height_blocks;



   private int img_width_pixels;

   private int img_height_pixels;



   /*

      depth buffer

   */



   private int[] depth;

   

   /*

      position

   */



   private int img_x;

   private int img_y;



   public int pos_x;

   public int pos_y;



   /*

      data

   */



   public Image floor;

   public Image walls;



   public abstract int getAll(int wall);

   public abstract int getAllFloor(int floor);

   public abstract int getAny(int wall);

   public abstract int getWall(int x, int y, int h, int side);

   public abstract int getFloor(int x, int y, int h);



   int[] queue;



   Billboard[] bqueue;



   public void drawTile(Graphics gfx, int x, int y, int map_x, int map_y, int ythresh, boolean writedepth)

   {   

	   if (!RENDER_ANY_TILES)

		   return;

	   	   

	   int bpos = 0;

      

      int ymax = 0x80000000;

      // debugging code to see how often this is called per frame

      ++m_NumCallsPerFrame;

      /*

         find static billboards overlapping tile with y > ythresh

      */



      for(Billboard b = front; b != null; b = b.next) {

      	if (b.dynamic)

      		continue;

      	

         int yb = b.getY((map_x<<3)+4);

         

//         if (!writedepth)

//         {

//	         gfx.setColor(0x808080);

//	         gfx.drawRect(

//	         		(b.x-b.anchor_x)  - pos_x,

//					b.y-b.anchor_y - pos_y,

//					b.width,

//					b.height

//					);

//	         gfx.setColor(0x40ffff);

//	         gfx.drawRect(

//	         		b.x-2  - pos_x,

//					b.y-2 - pos_y,

//					4,

//					4

//					);

//	         

//	         gfx.setColor(0xff0000);

//	         gfx.drawLine(b.x-pos_x, b.y-pos_y, (map_x<<3)+4-pos_x, yb-pos_y);

//	         gfx.setColor(0xffff00);

//	         gfx.drawLine((map_x<<3)+4-pos_x, yb-pos_y, (map_x<<3)+4-pos_x, yb-pos_y+2);

//         }

         

         if (yb > ythresh) 

         {



            /*

               find extent of billboard

            */

         	if (b.x+/*b.getRight()*/b.width-b.anchor_x > map_x<<3 && b.y+(b.height-b.anchor_y) > map_y<<3 && b.x-/*b.getLeft()*/b.anchor_x < map_x+1<<3 && b.y-(b.anchor_y) < map_y+1<<3) 

         	{

               bqueue[bpos++] = b;



               if (yb > ymax)

                  ymax = yb;

            }

         }

      }



      /*

         sort static billboards in increasing y

      */



      for(int i = bpos-1; i > 0; i--)

         for(int j = 0; j < i; j++)

            if (bqueue[j].getY((map_x<<3)+4) < bqueue[j+1].getY((map_x<<3)+4)) {

               Billboard tmp = bqueue[j];

               bqueue[j] = bqueue[j+1];

               bqueue[j+1] = tmp;

            }



      int xdepth = 0;

      int ydepth = 0;



      if (!writedepth) {

         xdepth = map_x%img_width_blocks;

         ydepth = map_y%img_height_blocks;

         

         if (xdepth < 0)

             xdepth += img_width_blocks;

         if (ydepth < 0)

             ydepth += img_height_blocks;

      }

      

      int pos = 0;



      int xm = (map_x>>1)+map_y;

      int ym = -(map_x>>1)+map_y;



      int lsb = map_x&1;



      int all = 0;



      int ycur = ((xm+MAXHEIGHT+1)+(ym+MAXHEIGHT))*4+BIAS;

      

      for(int i = MAXHEIGHT; i >= 0 && ycur > ythresh; i--) {

         int floora = getFloor(xm+i+1, ym+i, i);

         if (floora != -1 && (all&1) != 0x1 && ycur > ythresh) {

            queue[pos++] = ycur;

            queue[pos++] = 0;

            queue[pos++] = 7*lsb;

            queue[pos++] = floora*8;

            queue[pos++] = 7;

            queue[pos++] = 4;

            queue[pos++] = x+(1-lsb);

            queue[pos++] = y+4;

            

            if (ycur > ymax)

               ymax = ycur;



            if ((all |= (getAllFloor(floora) & 0x1)) == 0xf)

               break;

         }



         ycur -= 4;



         int walla = getWall(xm+i+lsb, ym+i-lsb, i, 1-lsb);

         int anya = getAny(walla);

         if (walla != -1 && (all&anya) != anya && ycur > ythresh) {

            queue[pos++] = ycur;

            queue[pos++] = 1;

            queue[pos++] = 0;

            queue[pos++] = walla*8;

            queue[pos++] = 8;

            queue[pos++] = 8;

            queue[pos++] = x;

            queue[pos++] = y;



            if (ycur > ymax)

               ymax = ycur;

            

            if ((all |= getAll(walla)) == 0xf)

               break;

         }



         int floorb = getFloor(xm+i+lsb, ym+i-lsb, i);

         if (floorb != -1 && (all&6) != 0x6 && ycur > ythresh) {

            queue[pos++] = ycur;

            queue[pos++] = 0;

            queue[pos++] = 7*(1-lsb);

            queue[pos++] = floorb*8;

            queue[pos++] = 7;

            queue[pos++] = 8;

            queue[pos++] = x+lsb;

            queue[pos++] = y;



            if (ycur > ymax)

               ymax = ycur;



            if ((all |= (getAllFloor(floorb) & 0x6)) == 0xf)

               break;

         }



         ycur -= 4;



         int wallb = getWall(xm+i, ym+i-1, i-1, lsb);

         int anyb = getAny(wallb)>>2;

         if (wallb != -1 && (all&anyb) != anyb && ycur > ythresh) {

            queue[pos++] = ycur;

            queue[pos++] = 1;

            queue[pos++] = 0;

            queue[pos++] = wallb*8;

            queue[pos++] = 8;

            queue[pos++] = 4;

            queue[pos++] = x;

            queue[pos++] = y+4;



            if (ycur > ymax)

               ymax = ycur;



            if ((all |= getAll(wallb)>>2) == 0xf)

               break;

         }

         int wallc = getWall(xm+i, ym+i-1, i, lsb);

         int anyc = getAny(wallc)<<2&0xc;

         if (wallc != -1 && (all&anyc) != anyc && ycur > ythresh) {

            queue[pos++] = ycur;

            queue[pos++] = 1;

            queue[pos++] = 0;

            queue[pos++] = wallc*8+4;

            queue[pos++] = 8;

            queue[pos++] = 4;

            queue[pos++] = x;

            queue[pos++] = y;



            if (ycur > ymax)

               ymax = ycur;



            if ((all |= getAll(wallc)<<2&0xc) == 0xf)

               break;

         }               



         int floorc = getFloor(xm+i, ym+i-1, i);

         if (floorc != -1 && (all&8) != 0x8 && ycur > ythresh) {

            queue[pos++] = ycur;

            queue[pos++] = 0;

            queue[pos++] = 7*lsb;

            queue[pos++] = floorc*8+4;

            queue[pos++] = 7;

            queue[pos++] = 4;

            queue[pos++] = x+(1-lsb);

            queue[pos++] = y;



            if (ycur > ymax)

               ymax = ycur;



            if ((all |= (getAllFloor(floorc) & 0x8)) == 0xf)

               break;

         }

      }

      

      if (writedepth)

         depth[(x>>3)+(y>>3)*img_width_blocks] = ymax;



      if (bpos > 0)

      {

      		gfx.setClip(x, y, 8, 8);

    	

//      		int w=8, h=8;

//      		int xc=x, yc=y;

//      		if ((x & 7)!=0 || (y & 7)!=0)

//      		{

//	      		if (xc<0) { w+=xc; xc=0; }

//	      		if (yc<0) { h+=yc; yc=0; }

//	      		if (xc+w > SKUConsts.SCREEN_WIDTH) w = SKUConsts.SCREEN_WIDTH - xc;

//	      		if (yc+h > SKUConsts.SCREEN_HEIGHT) h = SKUConsts.SCREEN_HEIGHT - yc;

//	      		if (w<=0 || h<=-0) return;

//      		}

//        	gfx.setClip(xc,yc,w,h);

      }

      

      while(pos > 0) {

         int yd = queue[--pos];

         int xd = queue[--pos];

         int h = queue[--pos];

         int w = queue[--pos];

         int ys = queue[--pos];

         int xs = queue[--pos];

         int i = queue[--pos];

         int yc = queue[--pos];



         while(bpos > 0 && bqueue[bpos-1].getY((map_x<<3)+4) < yc) {

            Billboard b = bqueue[--bpos];



            int xmin2 = b.x-/*b.getLeft()*/b.anchor_x;

            int ymin2 = b.y-/*b.getTop()*/(b.anchor_y);

									

            Utility.drawRegion(gfx, b.image, b.left, b.top, b.width, b.height, b.mirror ? Sprite.TRANS_MIRROR : Sprite.TRANS_NONE, x-((map_x<<3)-xmin2), y-((map_y<<3)-ymin2), Graphics.TOP|Graphics.LEFT);

         }

		 	

         Utility.drawRegion(gfx, (i == 0 ? floor : walls), xs, ys, w, h, Sprite.TRANS_NONE, xd, yd, Graphics.TOP|Graphics.LEFT);

      }



      while(bpos > 0) {

         Billboard b = bqueue[--bpos];



         int xmin2 = b.x-/*b.getLeft()*/(b.anchor_x);

         int ymin2 = b.y-/*b.getTop()*/(b.anchor_y);		 

		 

         Utility.drawRegion(gfx, b.image, b.left, b.top, b.width, b.height, b.mirror ? Sprite.TRANS_MIRROR : Sprite.TRANS_NONE, x-((map_x<<3)-xmin2), y-((map_y<<3)-ymin2), Graphics.TOP|Graphics.LEFT); 		 

      }



      gfx.setClip(0, 0, img_width_pixels, img_height_pixels);

   }

   

   /*

      billboard list anchors

   */



   private Billboard front;

//   private Billboard back;



   public Engine()

   {

      queue = new int[256];

      bqueue = new Billboard[64];



      sort = new Vector();

   }



   public void acquire(int width, int height)

   {

      /*

        width and height

      */



      img_width_blocks = width+2;

      img_height_blocks = height+2;



      img_width_pixels = width+2<<3;

      img_height_pixels = height+2<<3;

   

      /*

         images and graphics

      */



      release();



      // TB hack - make image slightly bigger than we need (trying to work around bugs in DrawRGB) 

      img0 = Utility.CreateImage(img_width_pixels+8, img_height_pixels+8);

      gfx0 = img0.getGraphics();

      

      /*

         depth buffer

      */

      

      depth = new int[img_width_blocks*img_height_blocks];

   }



   public void release()

   {

      img0 = null;

      gfx0 = null;



      depth = null;

   }



   private void validateRect(int x, int y, int w, int h)

   {	   

      if (x < 0)

         x += img_width_pixels;

      if (y < 0)

         y += img_height_pixels;



      int split_x = (img_x>>3)%img_width_blocks;

      int split_y = (img_y>>3)%img_height_blocks;



      if (split_x < 0)

         split_x += img_width_blocks;

      if (split_y < 0)

         split_y += img_height_blocks;



      int notch_x = (img_x&7)*img_height_blocks>>3;

      int notch_y = (img_y&7)*img_width_blocks>>3;



      int tx = (img_x>>3)-split_x;

      int ty = (img_y>>3)-split_y;



      for (int cy = y; h > 0; ) {

         int nextheight = 8-(cy&7);



         if (nextheight > h)

            nextheight = h;



         int w2 = w;



         for (int cx = x; w2 > 0; ) {

            int nextwidth = 8-(cx&7);



            if (nextwidth > w2)

               nextwidth = w2;



            int map_x = tx+(cx>>3);

            int map_y = ty+(cy>>3);



            if (cx>>3 < split_x || cx>>3 == split_x && cy>>3 < notch_x)

               map_x += img_width_blocks;

            if (cy>>3 < split_y || cy>>3 == split_y && cx>>3 < notch_y)

               map_y += img_height_blocks;



            drawTile(gfx0, cx&0xfffffff8, cy&0xfffffff8, map_x, map_y, -1024, true);



            cx += nextwidth;

            if (cx >= img_width_pixels)

               cx -= img_width_pixels;



            w2 -= nextwidth;

         }



         cy += nextheight;

         if (cy >= img_height_pixels)

            cy -= img_height_pixels;



         h -= nextheight;

      }

   }



   public void redrawRect(int x, int y, int w, int h)

   {

      if (x < pos_x-16) {

         w -= pos_x-16-x;

         x = pos_x-16;

      }

      if (x+w > pos_x+img_width_pixels)

         w = pos_x+img_width_pixels-x;



      if (w <= 0)

         return;



      if (y < pos_y-16) {

         h -= pos_y-16-y;

         y = pos_y-16;

      }

      if (y+h > pos_y+img_height_pixels)

         h = pos_y+img_height_pixels-x;



      if (h <= 0)

         return;



      validateRect(x%img_width_pixels, y%img_height_pixels, w, h);

   }



   public void moveTo(int x, int y)

   {

      pos_x = x;

      pos_y = y;



      img_x = x-8;

      img_y = y-8;



      validateRect(0, 0, img_width_pixels, img_height_pixels);

   }



   public void scrollTo(int x, int y)

   {

      while (pos_x > x) {

         int dec = pos_x-(pos_x-1&0xfffffff8);



         if (dec > pos_x-x)

            dec = pos_x-x;



         pos_x -= dec;

         img_x -= dec;



         int start = (img_x&7)*img_height_blocks&0xfffffff8;

         int end = ((img_x&7)+dec)*img_height_blocks&0xfffffff8;



         validateRect((img_x&0xfffffff8)%img_width_pixels, start, 8, end-start);

      }



      while (pos_x < x) {

         int inc = (pos_x+8&0xfffffff8)-pos_x;



         if (inc > x-pos_x)

            inc = x-pos_x;



         pos_x += inc;



         int start = (img_x&7)*img_height_blocks&0xfffffff8;

         int end = ((img_x&7)+inc)*img_height_blocks&0xfffffff8;



         int old_img_x = img_x;



         img_x += inc; 



         validateRect((old_img_x&0xfffffff8)%img_width_pixels, start, 8, end-start);

      }



      while (pos_y > y) {

         int dec = pos_y-(pos_y-1&0xfffffff8);



         if (dec > pos_y-y)

            dec = pos_y-y;



         pos_y -= dec;

         img_y -= dec;



         int start = (img_y&7)*img_width_blocks&0xfffffff8;

         int end = ((img_y&7)+dec)*img_width_blocks&0xfffffff8;



         validateRect(start, (img_y&0xfffffff8)%img_height_pixels, end-start, 8);

      }



      while (pos_y < y) {

         int inc = (pos_y+8&0xfffffff8)-pos_y;



         if (inc > y-pos_y)

            inc = y-pos_y;



         pos_y += inc;



         int start = (img_y&7)*img_width_blocks&0xfffffff8;

         int end = ((img_y&7)+inc)*img_width_blocks&0xfffffff8;



         int old_img_y = img_y;



         img_y += inc; 



         validateRect(start, (old_img_y&0xfffffff8)%img_height_pixels, end-start, 8);

      }

   }



   public synchronized void addBillboard(Billboard b, boolean redraw)

   {

      if (front == null)

         ;//back = b;

      else

         front.prev = b;

      b.next = front;



      b.prev = null;

      front = b;



      if (redraw && !b.dynamic) {



         int xmin2 = b.x-/*b.getLeft()*/(b.anchor_x);

         int ymin2 = b.y-/*b.getTop()*/(b.anchor_y);



         redrawRect(xmin2, ymin2, b.width, b.height);

      }

   }



   public synchronized void removeBillboard(Billboard b, boolean redraw)

   {

      if (b.next == null)

         ;//back = b.prev;

      else

         b.next.prev = b.prev;



      if (b.prev == null)

         front = b.next;

      else

         b.prev.next = b.next;



      if (redraw && !b.dynamic) {



         int xmin2 = b.x-/*b.getLeft()*/(b.anchor_x);

         int ymin2 = b.y-/*b.getTop()*/(b.anchor_y);



         redrawRect(xmin2, ymin2, b.width, b.height);

      }

   }



   public synchronized void removeBillboards()

   {

      front = null;

      //back = null;

   }



   private int compare(Billboard b1, Billboard b2)

   {

      /*

         find extents of billboards

      */



      int xmin1 = b1.x-/*b1.getLeft()*/(b1.anchor_x);

      int xmax1 = b1.x+/*b1.getRight()*/(b1.width-b1.anchor_x)-1;

      int ymin1 = b1.y-/*b1.getTop()*/(b1.anchor_y);

      int ymax1 = b1.y+/*b1.getBottom()*/(b1.height-b1.anchor_y)-1;



      int xmin2 = b2.x-/*b2.getLeft()*/(b2.anchor_x);

      int xmax2 = b2.x+/*b2.getRight()*/(b2.width-b2.anchor_x)-1;

      int ymin2 = b2.y-/*b2.getTop()*/(b2.anchor_y);

      int ymax2 = b2.y+/*b2.getBottom()*/(b2.height-b2.anchor_y)-1;



      /*

         check for overlap

      */



      if (xmax1 < xmin2 || xmax2 < xmin1 || ymax1 < ymin2 || ymax2 < ymin1)

         return 0;



      /*

         find x in centre of overlap

      */



      int x;

      if (xmin1>=xmin2 && xmax1<=xmax2)

      	x = xmin1 + xmax1;

      else if (xmin1<=xmin2 && xmax1>=xmax2)

      	x = xmin2 + xmax2;

      else if (xmax1 < xmax2)

      	x = xmin2 + xmax1;

      else

      	x = xmin1 + xmax2;

      

      x >>= 1;	// Take average

      

      /*

         find billboard depths at centre of overlap

      */



      int y1 = b1.getY(x);

      int y2 = b2.getY(x);



//      //Debug.println("("+xmin1+","+xmax1+")vs("+xmin2+","+xmax2+")->"+x+" y1="+y1+" y2="+y2);

      

      /*

         compare

      */



      if (y1 < y2)

         return -1;

      if (y1 > y2)

         return 1;



      return 0;

   }



   /*

      sorted vector of billboards

   */



   private Vector sort;



   /*

      compute sorted vector of dynamic billboards into 'sort'

   */



   public synchronized void sortBillboards()

   {

      sort.removeAllElements();



      /*

         build list of onscreen dynamic billboards

      */



      Billboard frontv = null;



      for(Billboard b = front; b != null; b = b.next) {



         int xmin = b.x-/*b.getLeft()*/(b.anchor_x);

         int xmax = b.x+/*b.getRight()*/(b.width-b.anchor_x);

         int ymin = b.y-/*b.getTop()*/(b.anchor_y);

         int ymax = b.y+/*b.getBottom()*/(b.height-b.anchor_y);



         if (b.dynamic && xmax > pos_x && xmin < pos_x+img_width_pixels-16 && ymax > pos_y && ymin < pos_y+img_height_pixels-16) {

            /*

               clear topsort workspace

            */



            b.children.removeAllElements();

            b.incount = 0;



            /*

               add to v

            */



            b.nextv = frontv;

            frontv = b;

         }

      }



      /*

         build partial order through pairwise comparisons

      */



      for(Billboard b1 = frontv; b1 != null; b1 = b1.nextv)

         for(Billboard b2 = b1.nextv; b2 != null; b2 = b2.nextv) {

            int c = compare(b1, b2);



            if (c < 0) {

               b1.children.addElement(b2);

               b2.incount++;

            }

            if (c > 0) {

               b2.children.addElement(b1);

               b1.incount++;

            }

         }



      /*

         build initial queue

      */



      Billboard qFront=null;

      Billboard qBack=null;	

      // Note: the value of qBack is undefined if qFront is null (i.e. when the queue is empty)

      // Note: we assume billboards have nextq set to null unless they're in the queue.

      //		so it's sufficient to set nextq to null when we remove one from the queue.



      for(Billboard b = frontv; b != null; b = b.nextv)

         if (b.incount == 0)

         {

         	// q.push(b)

         	if (qFront!=null) 

         		qBack.nextq = b;

         	else

         		qFront = b;

            qBack = b;

         }



      /*

         process queue

      */



      while(qFront!=null) {

      	 // b = q.pop()

         Billboard b = qFront;

         qFront = qFront.nextq;

         b.nextq = null;



         /*

            add to sort

         */



         b.index = sort.size();



         sort.addElement(b);



         /*

            add topological sort children to queue

         */



         for(int i = 0; i < b.children.size(); i++) {

            Billboard b2 = (Billboard)b.children.elementAt(i);



            if (--b2.incount == 0)

            {

             	// q.push(b2)

             	if (qFront!=null) 

             		qBack.nextq = b2;

             	else

             		qFront = b2;

                qBack = b2;

            }

         }

      }    

   }



   public synchronized void paint(Graphics g)

   {

      int initi = pos_y%img_height_pixels;

      int initj = pos_x%img_width_pixels;



      if (initi < 0)

         initi += img_height_pixels;

      if (initj < 0)

         initj += img_width_pixels;



      for(int i = -initi; i < img_height_pixels-16; i += img_height_pixels)

         for(int j = -initj; j < img_width_pixels-16; j += img_width_pixels)

            Utility.DrawImage(g, img0, j, i, Graphics.LEFT|Graphics.TOP);



      /*

         draw all onscreen dynamic billboards

      */



      sortBillboards();



//      g.setColor(0);

//      g.fillRect(0,0,176,208);

      

      for(Enumeration enu = sort.elements(); enu.hasMoreElements(); ) {

         Billboard b = (Billboard)enu.nextElement();



         if (b.dynamic) {

            /*

               find extent of billboard

            */



            int xmin = b.x-/*b.getLeft()*/(b.anchor_x);

            int xmax = b.x+/*b.getRight()*/(b.width-b.anchor_x);

            int ymin = b.y-/*b.getTop()*/(b.anchor_y);

            int ymax = b.y+/*b.getBottom()*/(b.height-b.anchor_y);



            if (xmax > pos_x && ymax > pos_y && xmin < pos_x+img_width_pixels-16 && ymin < pos_y+img_height_pixels-16) {

               /*

                  draw billboard

               */

      

            	Utility.drawRegion(g, b.image, b.left, b.top, b.width, b.height, b.mirror ? Sprite.TRANS_MIRROR : Sprite.TRANS_NONE, b.x-b.anchor_x-pos_x, b.y-b.anchor_y-pos_y, Graphics.LEFT|Graphics.TOP);

				            	

				/*

				   overdraw with tiles where necessary

				   */



				if (OVER_DRAW_TILES)

				{

				

					xmin = xmin&0xfffffff8;

					xmax = xmax-1&0xfffffff8;

					ymin = ymin&0xfffffff8;

					ymax = ymax-1&0xfffffff8;

	

	               for(int xt = xmin; xt <= xmax; xt+=8) 

	                  if (xt > pos_x-8 && xt < pos_x+img_width_pixels-16) {

	                     int xdepth = (xt>>3)%img_width_blocks;

	                     if (xdepth < 0)

	                         xdepth += img_width_blocks;

	   

	                     int d = b.getY(xt+4);

	                     

//	                     g.setColor(0x00ff00);

//	                     g.drawLine(b.x-pos_x, b.y-pos_y, xt+4-pos_x, d-pos_y);

//	                     g.drawLine(b.x-pos_x, b.y-pos_y+1, xt+4-pos_x, d-pos_y+1);



	                     for(int yt = ymin; yt <= ymax; yt+=8)

	                        if (yt > pos_y-8 && yt < pos_y+img_height_pixels-16) {

	                           int ydepth = (yt>>3)%img_height_blocks;

	                           if (ydepth < 0)

	                               ydepth += img_height_blocks;

	                           

	                            if (d < depth[xdepth+ydepth*img_width_blocks])

	                               drawTile(g, xt-pos_x, yt-pos_y, xt>>3, yt>>3, d, false);

	                        }

	                  }

				}

            }

         }

      }    

   }

}

