package sims2;



/* Copyright Ideaworks3D Ltd. 2005 */

/* 

 * @author benw

 * 

 * Created on 23-May-2005

 *

 */







import javax.microedition.lcdui.Image;





//import com.ideaworks3d.debug.Debug;



/**

 * Container for the graphical tile set for the block.

 */

public class MapTileSet

{

	/** Number of rendered tiles in a super tile */

	public static final int TILES_IN_SUPER_TILE = 4;

	

	/** Number of overlay tiles stored */

	private static final int NUM_OVERLAY_SUPER_TILES = 8;

	

	/**

	 * Create a block tile set from the given GUID

	 */

	public MapTileSet(int guid)

	{

		m_Guid = guid;

		//Debug.println("new MapTileSet: " + m_Guid, //Debug.CHAN_CORE);

			

		try

		{

			byte[] tileData = Utility.GetGlobalResource(m_Guid);

			//Debug.println("Type: MapTileSet", //Debug.CHAN_GLOBAL_RESOURCE);

			ParseTileData(m_Guid, tileData);

		}

		catch (Exception ex)

		{

			// Failed to load tile set

			//Debug.assertPrintln(false, "MapTileSet(): " + ex.getMessage());

		}

	}



	public Image GetFloor()

	{

		return floor;

	}

	

	public int GetNumNonOverlayFloorTiles()

	{

		return m_NumNonOverlayFloorTiles;

	}

	

	public int GetNumTopAndMiddleWallTiles()

	{

		return m_NumTopAndMiddleWallTiles;

	}

	

	public int GetNumTopWallTiles()

	{

		return m_NumTopWallTiles;

	}

	

	public byte GetSuperTileDescription(int i)

	{

		return m_SuperTileDescriptions[i];

	}

	

	public byte GetWallHeight(int type)

	{

		return m_WallHeights[type];

	}



	public Image GetWalls()

	{

		return walls;

	}

	

	public byte[] GetWallSectionDescription(int type)

	{

		return m_WallSectionDescriptions[type];

	}

	

	public byte GetWallTileTransparency(int i)

	{

		return m_WallTileTransparencies[i];

	}

	

	/**

	 * Parse input binary tile data

	 * 

	 * @param tileData	Byte array containing tile data

	 */

	private void ParseTileData(int guid, byte[] tileData)

	{

		int imageSize;	// Size of image being read

		int pos;		// Position in input data

		int wallHeight;	// Height of this wall section

		int numWalls;	// Number of wall sections

		int count;		// Used to iterate

		int dataSize;	// Number of bytes for element being serialised

		

		pos = 0;

		

		// Read size of floor tile image

		// Read floor tile image (store reference in Engine)

		imageSize = Utility.ByteSerializeType(0, tileData, pos, 2, false);

		pos += 2;

//		/*super.*/floor = Utility.createImage(0, guid, tileData, pos, imageSize, false);

		/*super.*/floor = Utility.createImage(0, guid, tileData, pos, imageSize, true);

		pos += imageSize;

		

		// Get number of floor tiles from size of image

		m_NumNonOverlayFloorTiles = /*super.*/floor.getHeight() / SKUConsts.TILE_HALF_HEIGHT;

		m_NumNonOverlayFloorTiles -= NUM_OVERLAY_SUPER_TILES * TILES_IN_SUPER_TILE;

		

		// Read size of wall tile image

		// Read wall tile image (store reference in Engine)

		imageSize = Utility.ByteSerializeType(0, tileData, pos, 2, false);

		pos += 2;

		/*super.*/walls = Utility.createImage(0, guid-1, tileData, pos, imageSize, false); // TODO: Remove hack for guid

		pos += imageSize;

		

		// Read number of top wall sections.

		// Read number of middle wall sections.

		// Store these as boundary limits.

		m_NumTopWallTiles = Utility.ByteSerializeType(0, tileData, pos, 2, false);

		pos += 2;

		m_NumTopAndMiddleWallTiles = m_NumTopWallTiles + 

			Utility.ByteSerializeType(0, tileData, pos, 2, false);

		pos += 2;

		

		// Read the number of bottom walls to discover the size of the

		// transparency bit array.

		int numBottomWallTiles = Utility.ByteSerializeType(0, tileData, pos, 2, false);

		pos += 2;

		dataSize = m_NumTopAndMiddleWallTiles + numBottomWallTiles;

		dataSize = (dataSize+7)/8;

		

		// Read in the transparency bit array.

		m_WallTileTransparencies = new byte[dataSize];

		System.arraycopy(tileData, pos, m_WallTileTransparencies, 0, dataSize);

		pos += dataSize;

		

		// Read number of super tiles.

		// Then read super tile data.

		dataSize = Utility.ByteSerializeType(0, tileData, pos++, 1, false);

		dataSize *= TILES_IN_SUPER_TILE;

		

		//Debug.assertPrintln(dataSize > 0, "No floor supertile data.  Invalid tileset.");

		m_SuperTileDescriptions = new byte[dataSize];

		System.arraycopy(tileData, pos, m_SuperTileDescriptions, 0, dataSize);

		pos += dataSize;

		

		// Read number of wall tiles.

		// Then read wall tile data.

		numWalls = Utility.ByteSerializeType(0, tileData, pos++, 1, false);

		

		//Debug.assertPrintln(numWalls > 0, "No wall section data.  Invalid tileset.");

		m_WallSectionDescriptions = new byte[numWalls][];

		m_WallHeights = new byte[numWalls];

		for (count = 0; count < numWalls; count++)

		{

			// Read height.

			wallHeight = Utility.ByteSerializeType(0, tileData, pos, 1, false);

			pos++;

			

			// Store height to heights array

			Utility.ByteSerializeType(wallHeight, m_WallHeights, count, 1, true);

			

			// Assign array big enough to represent.

			// 1 to store height + 2 x(1 per height) + 1 for top most tile.

			// Store each wall tile as a short, not a byte

			dataSize = (4 * wallHeight) + 1;

			m_WallSectionDescriptions[count] = new byte[dataSize];

			

			// Copy over all data.

			System.arraycopy(tileData, pos, m_WallSectionDescriptions[count], 0, dataSize);

			pos += dataSize;			

		}

	}



	int m_Guid;

	

	private Image floor;

	

	/** Number of floor tiles within tile image */

	private int m_NumNonOverlayFloorTiles;

	

	/** Boundary check for bottom of wall section tiles */

	private int m_NumTopAndMiddleWallTiles;

	

	/** Boundary check for middle of wall section tiles */

	private int m_NumTopWallTiles;

	

	/** Horizontal/floor super tile descriptions */

	private byte[] m_SuperTileDescriptions;

	

	/** Heights of each wall type */

	private byte[] m_WallHeights;

	

	/** Vertical/wall section descriptions

	 * 1st-(height * 2)th short contains the tile at this height (both sides)

	 * (1 + height * 2)th short contains the tile on top of this wall (horizontal)

	 */

	private byte[][] m_WallSectionDescriptions;

	

	/** Array of the wall tile transparencies to control drawing */

	private byte[]	m_WallTileTransparencies;

	private Image walls;

}

