package sims2;



//package root;



/**

 * Enumeration class - will be removed upon obfuscation

 */

public final class SimAttributes

{

	/*

	 rooms

	 */

	

	public static final int ROOM_KITCHEN = 0;

	public static final int ROOM_BATHROOM = 1;

	public static final int ROOM_BEDROOM = 2;

	public static final int ROOM_LIVINGROOM = 3;

	public static final int ROOM_RECROOM = 4;

	public static final int ROOM_PARTYROOM = 5;

	public static final int ROOM_GARDEN = 6;

	

	public static final int NUM_ROOMS = 7;

	public static final int ROOM_INVALID = -1;

	

	public static final int LAST_ROOM = (NUM_ROOMS - 1);



	// Special rooms (screens)

//	public static final int ROOM_MENU_BACKGROUND = 7;

//	public static final int ROOM_TITLE_BACKGROUND = 8;

//	public static final int ROOM_TITLE_EA_LOGO = 9;

	

	public static final int ROOM_LOGO_DISPLAY_TIME = 3000;

	

	public static final int GLOBAL_NUM_PHONE_FRAMES = 3;

	public static final int GLOBAL_PHONE_FRAME_TIMER = 30;



   /*

      moved from SimsApp by ECU to support Tab.java

   */



	/** Number of binary points used in a fixed point number */

	public static final int FIXED_POS = 8;

	public static final int FIXED_4_12_POS = 12;



	/** Fixed point representation of ONE */

	public static final int FIXED_ONE = 1 << FIXED_POS;

	public static final int FIXED_4_12_ONE = 1 << FIXED_4_12_POS;

	

	/** Fixed point representation of HALF */

	public static final int FIXED_HALF = FIXED_ONE >> 1;

	public static final int FIXED_4_12_HALF = FIXED_4_12_ONE >> 1;

	

	/** Mask for fractional bits */

	public static final int FIXED_FRAC_BITS = ~(~0 << FIXED_POS);

	public static final int FIXED_4_12_FRAC_BITS = ~(~0 << FIXED_4_12_POS);



	/*

	 * Sim Goal Defines

	 */

	public static final int GOAL_0 		= 0;	// Go to fridge and have some food 

	public static final int GOAL_1 		= 1;	// Talk to Ben

	public static final int GOAL_2 		= 2;	// Make friends with Ben

	public static final int GOAL_3 		= 3;	// Gain 2 skill points in cookery and 2 in logic for Chefs job

	public static final int GOAL_4 		= 4;	// Getting Living Room House Upgrade

	public static final int GOAL_5 		= 5;	// Get 4 skill points in cookery and 2 in charisma for Head Chefs job

	public static final int GOAL_6 		= 6;	// Getting Recreation Room Upgrade

	public static final int GOAL_7 		= 7;	// Get 2 skill points in body and 2 in charisma, plus make 2 friends for the Personal Trainer Job

	public static final int GOAL_8 		= 8;	// Make friends with 4 Sims to meet Lorna

	public static final int GOAL_9 		= 9;	// Get 4 skill points in charisma, 2 in logic and make 5 friends to get the job as a Party DJ

	public static final int GOAL_10 	= 10;	// Buy Party Room

	public static final int GOAL_11 	= 11;	// Unlock juice bar and decks

	public static final int GOAL_12 	= 12;	// Throw party to meet Ian

	public static final int GOAL_13 	= 13;	// Get 5 skill points in charisma, 5 in creativity, 5 in body and make 5 friends to join Ians band as a guitarist

	public static final int GOAL_14 	= 14;	// Unlock Garden

	public static final int NUM_GOALS 	= 15;



	/*

	 * Sim Need Defines

	 */

	public static final int NEED_HUNGER				= 0;

	public static final int NEED_ENERGY				= 1;

	public static final int NEED_BLADDER			= 2;

	public static final int NEED_HYGIENE			= 3;

	public static final int NEED_SOCIAL				= 4;

	public static final int NEED_FUN				= 5;

	public static final int NUM_NEEDS				= 6;

	public static final int FIRST_NEED				= 0;

	public static final int LAST_NEED				= (NUM_NEEDS - 1);

	

	public static final int RELATIONSHIP_MIN			= 0 << FIXED_POS;

	public static final int RELATIONSHIP_MAX			= +100 << FIXED_POS;

	public static final int RELATIONSHIP_AQUAINTANCE	= +15 << FIXED_POS;

	public static final int RELATIONSHIP_FRIEND			= +45 << FIXED_POS;

	public static final int RELATIONSHIP_LOVER			= +70 << FIXED_POS;

	public static final int RELATIONSHIP_DECLINE 		= -1 << FIXED_POS;

	

	public static final int MIN_NEED_VALUE			= 0;

	public static final int MAX_NEED_VALUE			= (20 << FIXED_POS);

	public static final int FAIL_NEED_MAX_VALUE		= (10 << FIXED_POS);

	public static final int NEED_DECREMENT_TIME		= 1;

	public static final int MAX_NEED				= 0;

	

	public static final int NEED_HUNGER_INIT_VAL	= 15 << FIXED_POS;

	public static final int NEED_ENERGY_INIT_VAL	= MAX_NEED_VALUE;

	public static final int NEED_BLADDER_INIT_VAL	= 10 << FIXED_POS;

	public static final int NEED_HYGIENE_INIT_VAL	= MAX_NEED_VALUE;

	public static final int NEED_SOCIAL_INIT_VAL	= MAX_NEED_VALUE;

	public static final int NEED_FUN_INIT_VAL		= MAX_NEED_VALUE;

	

	// remember these are fixed point values (decrement these every minute)

	public static final int NEED_HUNGER_DEC_VAL		= -12;	// (.047 * 256)

	public static final int NEED_HYGIENE_DEC_VAL	= -10;	// (.047 * 256)

	public static final int NEED_BLADDER_DEC_VAL	= -12;	// (.047 * 256)

	public static final int NEED_FUN_DEC_VAL		= -10;	// (.047 * 256)

	public static final int NEED_SOCIAL_DEC_VAL		= -10;	// (.047 * 256)

	public static final int NEED_ENERGY_DEC_VAL		= -6;	// (.002 * 256)

	

	public static final int NORMAL_NEED_DECREMENT	= 1;	// normal Sim need divisor

	public static final int SLEEP_NEED_DECREMENT	= 2;	// sleep Sim need divisor

	public static final int WORK_NEED_DECREMENT		= 4;	// work Sim need divisor

	

	// failure increases/decreases over time

	public static final int NEED_BLADDER_FAIL_INC	= 128;	// (.5 * 256)

	public static final int NEED_BLADDER_FAIL_DEC	= -128;	// (.5 * 256)

	public static final int NEED_ENERGY_FAIL_INC	= 4;	// (.1 * 256)

	public static final int SOCIAL_INC				= 1024;	// (4 * 256)

	

	// need warning/failure defines

	public static final int NEED_AVERAGE_MIN		= 4 << FIXED_POS;

	public static final int NEED_WARNING_MIN		= 4 << FIXED_POS;

	public static final int WARN_FAILURE_MAX		= (SimAttributes.NUM_NEEDS * 2);	/** maximum number of warning/failure states is double the need values */

	public static final int NEED_WARNING_WAIT_TIME	= 15;

	public static final int NEED_WARNING_TIME		= 0;

	public static final int ENERGY_FAILURE_TIME		= 1000;

	public static final int STARVATION_DEATH_COUNT	= 10;

	public static final int SUFFOCATION_DEATH_COUNT	= 10;

	

	public static final int GOAL_DELAY_TIME_MS		= 15000;

	

	/** The number of times a topic can be discussed before boredom sets in */

	public static final int BOREDOM_THRESHOLD		= 3;

	

	/*

	 * Sim Skill Defines

	 */

	public static final int SKILL_COOKING			= NUM_NEEDS;

	public static final int SKILL_CHARISMA			= (SKILL_COOKING + 1);

	public static final int SKILL_BODY				= (SKILL_CHARISMA + 1);

	public static final int SKILL_LOGIC				= (SKILL_BODY + 1);

	public static final int SKILL_CREATIVITY		= (SKILL_LOGIC + 1);

	public static final int NUM_SKILLS				= (SKILL_CREATIVITY - NUM_NEEDS + 1);

	public static final int FIRST_SKILL				= SKILL_COOKING;

	public static final int LAST_SKILL				= SKILL_CREATIVITY;

	

	public static final int MIN_SKILL_VALUE			= 0;

	public static final int MAX_SKILL_VALUE			= (5 << FIXED_4_12_POS);

	public static final int SKILL_INC_VALUE			= 320;



	/*

	 * Sim Social Defines

	 */

	public static final int SOCIAL_TALK				= 0;

	public static final int SOCIAL_FRIENDLY_HUG		= 1;

	public static final int SOCIAL_FRIENDLY_PECK	= 2;

	public static final int SOCIAL_GOSSIP			= 3;

	public static final int SOCIAL_JOKE				= 4;

	public static final int SOCIAL_FLIRT			= 5;

	public static final int SOCIAL_ROMANTIC_HUG		= 6;

	public static final int SOCIAL_ROMANTIC_KISS	= 7;

	public static final int SOCIAL_MOVE_IN			= 8;

	public static final int SOCIAL_MOVE_OUT			= 9;

	public static final int SOCIAL_SPEND_THE_NIGHT	= 10;

	public static final int SOCIAL_PROPOSE			= 11;

	public static final int SOCIAL_DIVORCE			= 12;

	

	public static final int SOCIAL_SCORE_INC		= 0;

	public static final int SOCIAL_SCORE_DEC		= 1;

	public static final int SOCIAL_SCORE_THRESHOLD	= 2;

	

	public static final int SOCIAL_LIST_OFFSET		= 24;

	

	public static final int THRESHOLD_MOVE_IN		= 0;

	public static final int THRESHOLD_PROPOSE		= 1;

	

	public static final int INTEREST_MUSIC			= 0;

	public static final int INTEREST_POLITICS		= 1;

	public static final int INTEREST_EXERCISE		= 2;

	public static final int INTEREST_FOOD			= 3;

	public static final int INTEREST_MONEY			= 4;

	public static final int INTEREST_LOVE			= 5;

	public static final int INTEREST_CLEAN			= 6;

	public static final int INTEREST_TOILET			= 7;

	public static final int INTEREST_BEN			= 8;

	public static final int INTEREST_PENNY			= 9;

	public static final int INTEREST_JOHN			= 10;

	public static final int INTEREST_KITTY			= 11;

	public static final int INTEREST_LORNA			= 12;

	public static final int INTEREST_IAN			= 13;

	public static final int NUM_INTERESTS			= 14;

	

	public static final int INTEREST_MASK_MUSIC		= (1 << 0);

	public static final int INTEREST_MASK_POLITICS	= (1 << 1);

	public static final int INTEREST_MASK_EXERCISE	= (1 << 2);

	public static final int INTEREST_MASK_FOOD		= (1 << 3);

	public static final int INTEREST_MASK_MONEY		= (1 << 4);

	public static final int INTEREST_MASK_LOVE		= (1 << 5);

	public static final int INTEREST_MASK_CLEAN		= (1 << 6);

	public static final int INTEREST_MASK_TOILET	= (1 << 7);

	public static final int INTEREST_MASK_BEN		= (1 << 8);

	public static final int INTEREST_MASK_PENNY		= (1 << 9);

	public static final int INTEREST_MASK_JOHN		= (1 << 10);

	public static final int INTEREST_MASK_KITTY		= (1 << 11);

	public static final int INTEREST_MASK_LORNA		= (1 << 12);

	public static final int INTEREST_MASK_IAN		= (1 << 13);

	

	public static final int TRAIT_NEAT				= 0;

	public static final int TRAIT_OUTGOING			= 1;

	public static final int TRAIT_ACTIVE			= 2;

	public static final int TRAIT_PLAYFUL			= 3;

	public static final int TRAIT_NICE				= 4;

	

	public static final int SIGN_CAPRICORN			= 0;

	public static final int SIGN_AQUARIUS			= 1;

	public static final int SIGN_PISCES				= 2;

	public static final int SIGN_ARIES				= 3;

	public static final int SIGN_TAURUS				= 4;

	public static final int SIGN_GEMINI				= 5;

	public static final int SIGN_CANCER				= 6;

	public static final int SIGN_LEO				= 7;

	public static final int SIGN_VIRGO				= 8;

	public static final int SIGN_LIBRA				= 9;

	public static final int SIGN_SCORPIO			= 10;

	public static final int SIGN_SAGITTARIUS		= 11;

	

	// Initial social options - change these to rearrange.

	public final static int SOCIAL_ROOT_OP_TALK			= 0;

	public final static int SOCIAL_ROOT_OP_GOSSIP		= 1;

	public final static int SOCIAL_ROOT_OP_FRIENDLY		= 2;

	public final static int SOCIAL_ROOT_OP_ROMANTIC		= 3;

	public final static int SOCIAL_ROOT_OP_RELATIONSHIP	= 4;

	public final static int SOCIAL_ROOT_OP_ASK_TO_LEAVE	= 5;

	

	// Social talk options - change these to rearrange.

	public final static int SOCIAL_TALK_OP_MUSIC		= 0;

	public final static int SOCIAL_TALK_OP_POLITICS		= 1;

	public final static int SOCIAL_TALK_OP_EXERCISE		= 2;

	public final static int SOCIAL_TALK_OP_FOOD			= 3;

	public final static int SOCIAL_TALK_OP_MONEY		= 4;

	public final static int SOCIAL_TALK_OP_LOVE			= 5;

	

	// Social gossip options - change these to rearrange.

	public final static int SOCIAL_GOSSIP_OP_BEN		= 0;

	public final static int SOCIAL_GOSSIP_OP_PENNY		= 1;

	public final static int SOCIAL_GOSSIP_OP_JOHN		= 2;

	public final static int SOCIAL_GOSSIP_OP_KITTY		= 3;

	public final static int SOCIAL_GOSSIP_OP_LORNA		= 4;

	public final static int SOCIAL_GOSSIP_OP_IAN		= 5;

	

	// Social friendly options - change these to rearrange.

	public final static int SOCIAL_FRIENDLY_OP_HUG			= 0;

	public final static int SOCIAL_FRIENDLY_OP_PECK			= 1;

	public final static int SOCIAL_FRIENDLY_OP_CLEAN_JOKE	= 2;

	public final static int SOCIAL_FRIENDLY_OP_DIRTY_JOKE	= 3;

	

	// Social gossip options - change these to rearrange.

	public final static int SOCIAL_ROMANTIC_OP_FLIRT			= 0;

	public final static int SOCIAL_ROMANTIC_OP_HUG				= 1;

	public final static int SOCIAL_ROMANTIC_OP_KISS				= 2;

	public final static int SOCIAL_ROMANTIC_OP_SPEND_THE_NIGHT	= 3;

	

	public final static int SOCIAL_SPEND_THE_NIGHT_HOUR_INC		= 3;

	public final static int SOCIAL_WOO_HOO_HUNGER_DEC			= -3 << FIXED_POS;

	public final static int SOCIAL_WOO_HOO_ENERGY_DEC			= -3 << FIXED_POS;

	public static final int SOCIAL_WOO_HOO_BLADDER_DEC			= -2 << FIXED_POS;

	public static final int SOCIAL_WOO_HOO_HYGIENE_DEC			= -2 << FIXED_POS;

	public static final int SOCIAL_WOO_HOO_SOCIAL_INC			= 3 << FIXED_POS;

	public static final int SOCIAL_WOO_HOO_FUN_INC				= 3 << FIXED_POS;

	

	// Social gossip options - change these to rearrange.

	public final static int SOCIAL_RELATIONSHIP_OP_MOVE_IN		= 0;

	public final static int SOCIAL_RELATIONSHIP_OP_MOVE_OUT		= 1;

	public final static int SOCIAL_RELATIONSHIP_OP_PROPOSE		= 2;

	public final static int SOCIAL_RELATIONSHIP_OP_DIVORCE		= 3;

	

	// Social gossip options - change these to rearrange.

	public final static int SOCIAL_STARTING_PROBABILITY			= 20;

	public final static int SOCIAL_MIN_INDEX_VALUE_1			= -15;

	public final static int SOCIAL_MIN_INDEX_VALUE_2			= 0;

	public final static int SOCIAL_MIN_INDEX_VALUE_3			= 10;

	public final static int SOCIAL_MIN_INDEX_VALUE_4			= 20;

	public final static int SOCIAL_MIN_INDEX_VALUE_5			= 40;

	public final static int SOCIAL_MIN_INDEX_VALUE_6			= 60;

	public final static int SOCIAL_MIN_INDEX_VALUE_7			= 80;

	public final static int SOCIAL_MIN_INDEX_VALUE_8			= 90;

	public final static int SOCIAL_MIN_INDEX_VALUE_9			= 95;

	

	public final static int SOCIAL_INDEX_VALUE_1				= -1;

	public final static int SOCIAL_INDEX_VALUE_2				= 0;

	public final static int SOCIAL_INDEX_VALUE_3				= 1;

	public final static int SOCIAL_INDEX_VALUE_4				= 2;

	public final static int SOCIAL_INDEX_VALUE_5				= 3;

	public final static int SOCIAL_INDEX_VALUE_6				= 4;

	public final static int SOCIAL_INDEX_VALUE_7				= 5;

	public final static int SOCIAL_INDEX_VALUE_8				= 6;

	public final static int SOCIAL_INDEX_VALUE_9				= 7;

	public final static int SOCIAL_INDEX_VALUE_10				= 8;

	

	/*

	 * Miscellaneous defines

	 */

	public final static int FRIEND_ASSISTANCE_BONUS = 200;

//	public final static int WORK_RELIABILTY_BONUS	= 1000000;

	

	/*

	 * Random Want defines

	 */

	public final static int WANT_SKILL_START_OFFSET			= StringId.WANT_0;

	public final static int WANT_ITEM_PURCHASE_OVEN			= StringId.WANT_5;

	public final static int WANT_ITEM_PURCHASE_COFFEE_MAKER	= StringId.WANT_6;

	public final static int WANT_ITEM_PURCHASE_ALARM_CLOCK	= StringId.WANT_7;

	public final static int WANT_ITEM_PURCHASE_BATH			= StringId.WANT_8;

	public final static int WANT_ITEM_PURCHASE_FLAT_SCREEN	= StringId.WANT_9;

	public final static int WANT_ITEM_PURCHASE_GUITAR		= StringId.WANT_10;

	public final static int WANT_ITEM_PURCHASE_CHESS_TABLE	= StringId.WANT_11;

	public final static int WANT_ITEM_PURCHASE_DECKS		= StringId.WANT_12;

	public final static int WANT_ITEM_PURCHASE_JUICE_BAR	= StringId.WANT_13;

	public final static int WANT_ITEM_PURCHASE_HOT_TUB		= StringId.WANT_14;

	public final static int WANT_SOCIAL_START_OFFSET		= StringId.WANT_15;

	

	public final static int NUM_AVAILABLE_WANTS				= 24;

	public final static int NUM_POSSIBLE_WANTS				= 3;

	public final static int WANT_SIMOLEAN_INC				= 10;

	

	public final static int NUM_SOCIAL_WANTS				= 9;

	public final static int WANT_SOCIAL_MAKE_FRIEND_OFFSET	= 0;

	public final static int WANT_SOCIAL_GET_MARRIED_OFFSET	= 1;

	public final static int WANT_SOCIAL_DIRTY_JOKE			= 2;

	public final static int WANT_SOCIAL_CLEAN_JOKE			= 3;

	public final static int WANT_SOCIAL_GOSSIP				= 4;

	public final static int WANT_SOCIAL_FLIRT				= 5;

	public final static int WANT_SOCIAL_HUG					= 6;

	public final static int WANT_SOCIAL_KISS				= 7;

	public final static int WANT_SOCIAL_GET_DIVORCED_OFFSET	= 8;

	

	public final static int WANT_INVALID					= -1;

	public static final int	IDLE_DELAY						= 4000;

	public static final int	ITCHY_FEET_COUNT_MIN			= 20;

	public static final int	ITCHY_FEET_COUNT_MAX			= 30;



} // End of class SimAttributes

