package tetris;



import javax.microedition.lcdui.Graphics;



public class teWell {



    public static final int WELL_WIDTH = 10;

    public static final int WELL_HEIGHT = 20;

    public static final int WELL_SKYLINE = 10;

    public static final int WELL_ACTUAL_HEIGHT = WELL_HEIGHT + WELL_SKYLINE;

    public static final int WELL_WMAX = WELL_WIDTH - 1;

    public static final int WELL_HMAX = WELL_ACTUAL_HEIGHT - 1;



	int elimState;



	boolean dirty;

	boolean paused;



	teLine lines[];



    public class teLine {



        short blockFlags;



        byte blocks[];

        byte sticky[];



        teLine() {

            blocks = new byte[WELL_WIDTH];

            sticky = new byte[WELL_WIDTH];

			clear();

        }



        public boolean isComplete() {

            return blockFlags==0x03ff;

        }



        public void setBlock(int column, byte type, byte stick) {

            blocks[column]=type;

			sticky[column]=stick;

            blockFlags|=1<<column;

        }



        public boolean isBlockUsed(int column) {

            return (blockFlags&(1<<column))!=0;

        }



        public boolean isMaskUsed(int mask) {

            return (blockFlags&mask)!=0;

        }



        public byte getBlock(int column) {

            return blocks[column];

        }



		public byte getSticky(int column) {

			return sticky[column];

		}



		public void wipeSticky(byte stick) {

			stick=(byte)~stick;

			for(int i=0;i<WELL_WIDTH;i++) {

				sticky[i]&=stick;

			}

		}



		public void clear() {

			blockFlags=0;

			for(int i=0;i<WELL_WIDTH;i++) {

				blocks[i]=0;

				sticky[i]=0;

			}

		}



		public void copy(teLine src) {

			blockFlags=src.blockFlags;

			for(int i =0;i<WELL_WIDTH;i++) {

				blocks[i]=src.blocks[i];

				sticky[i]=src.sticky[i];

			}

		}



		public boolean hasBlock() {

			return blockFlags!=0;

		}

    }



    teWell() {

        paused = false;

        elimState = 0;



		lines = new teLine[WELL_ACTUAL_HEIGHT];

		for(int i=0;i<WELL_ACTUAL_HEIGHT;i++) {

			lines[i] = new teLine();

		}



		touch();

    }



	public void paint(Graphics g, int wx, int wy, int minosize) {

		teLine ln;

		byte m;

		int px;



		if(paused) {

			clean();

			return;

		}



		for(int y=WELL_SKYLINE;y<WELL_ACTUAL_HEIGHT;y++) {

			ln = getLine(y);

			if(ln.isComplete() && (elimState>0)) {

				g.setColor(elimState, elimState, elimState);

				g.fillRect(wx, wy, WELL_WIDTH*minosize, minosize);

			} else {

				px = wx;

				for(int x=0;x<WELL_WIDTH;x++) {

					m = ln.getBlock(x);

					if(m>0) {

						g.drawImage(teRenderer.minos[m-1][ln.getSticky(x)], px, wy, Graphics.TOP|Graphics.LEFT);

					}

					px+=minosize;

				}

			}

			wy+=minosize;

		}

		clean();

	}



	public void collapseLine(int row) {

		for(int i=row;i>0;i--) {

			lines[i].copy(lines[i-1]);

		}

		lines[0].clear();

		// recalc the sticky values

		lines[row].wipeSticky((byte)0x2);

		if(row<WELL_HMAX) {

			lines[row+1].wipeSticky((byte)0x8);

		}

		touch();

    }



	public int needsCleaning() {

		int c = 0;

		for(int i=0;i<WELL_ACTUAL_HEIGHT;i++) {

			if(lines[i].isComplete()) {

				c++;

			}

		}

		return c;

	}



	public int eliminate() {

		int c = 0;

		for(int i=0;i<WELL_ACTUAL_HEIGHT;i++) {

			if(lines[i].isComplete()) {

				collapseLine(i);

				c++;

			}

		}

		return c;

	}





	public boolean isBlockUsed(int column, int row) {

		if(row<0) {

			return false;

		}

		return lines[row].isBlockUsed(column);

	}



	public boolean isMaskUsed(int mask, int row) {

		if(row<0) {

			return false;

		}

		return lines[row].isMaskUsed(mask);

	}



    public teLine getLine(int row) {

        return lines[row];

    }



	public void setElimState(int es) {

		elimState = es;

		touch();

	}



	public boolean isDirty() {

		return dirty;

	}



	public void touch() {

		dirty = true;

	}



	public void clean() {

		dirty = false;

	}



	public void setPaused(boolean p) {

		paused = p;

		touch();

	}

}

