/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient;

import java.util.Vector;
import javax.microedition.io.Connector;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;
import se.tactel.tvclient.Controller;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.CurrentContent;
import se.tactel.tvclient.data.Folder;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.Observer;
import se.tactel.tvclient.data.interactivity.InteractivityData;
import se.tactel.tvclient.data.interactivity.OneInteractivity;
import se.tactel.tvclient.gui.interactivity.FullScreenSVGWindow;
import se.tactel.tvclient.gui.interactivity.SVGWindow;
import se.tactel.tvclient.gui.screen.wait.WaitWindow;
import se.tactel.tvclient.gui.userdialog.AnchorContainerView;
import se.tactel.tvclient.gui.userdialog.Command;
import se.tactel.tvclient.gui.userdialog.UserDialogContainerView;
import se.tactel.tvclient.gui.userdialog.UserDialogView;
import se.tactel.tvclient.notificationcenter.Notification;
import se.tactel.tvclient.notificationcenter.NotificationCenter;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class InteractivityController
implements Observer {
    private SVGWindow rootUserDialogWindow = null;
    private WaitWindow waitWindow = null;
    private Controller controller = null;
    private String blockedSVG;

    private synchronized void requestInteractivityFromServer() {
        String interactivityUrl = ServiceRegistry.instance().getDataProvider().getConfig().getInteractivityRequestUrl();
        if (interactivityUrl != null) {
            Log.log(128L, "requestInteractivityFromServer, url: " + interactivityUrl);
            while (!ServiceRegistry.instance().getComm().processUrl(interactivityUrl, 0)) {
                Log.log(0x40000080L, "Failed downloading interactivity, will try again soon: " + interactivityUrl);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void lookForPendingRootUserDialogs() {
        boolean pendingRootUserDialogsExist = ServiceRegistry.instance().getDataProvider().getInteractivityData().hasPendingRootUserDialogs();
        if (pendingRootUserDialogsExist) {
            UserDialogView udView = ServiceRegistry.instance().getDataProvider().getInteractivityData().getNextRootUserDialog();
            this.processRootUserDialog(udView);
        }
    }

    public void update(ObservableData data) {
        if (data instanceof InteractivityData) {
            Log.log(128L, "*Updating interactivity since the InteractivityData has changed.");
            InteractivityData iData = (InteractivityData)data;
            if (iData != null) {
                if (iData.hasPendingRootUserDialogs() && !this.isDisplayingRootUserDialog()) {
                    UserDialogView udv = iData.getNextRootUserDialog();
                    this.processRootUserDialog(udv);
                } else {
                    OneInteractivity nextInteractivity = iData.getNextInteractivity();
                    ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().setCurrentInteractivityContext(nextInteractivity);
                }
            }
        }
    }

    private void showWaitWindow() {
        if (this.waitWindow != null) {
            this.waitWindow.close();
            this.waitWindow = null;
        }
        this.waitWindow = new WaitWindow();
        this.waitWindow.setAutoClose(false);
        this.waitWindow.makeKeyAndOrderFront();
    }

    private void closeWaitWindow() {
        if (this.waitWindow != null) {
            this.waitWindow.close();
            this.waitWindow = null;
        }
    }

    public InteractivityController(Controller c) {
        this.controller = c;
        NotificationCenter.defaultCenter().addObserver(new ButtonResponse(), "clicked", null);
        NotificationCenter.defaultCenter().addObserver(new AdControllerResponse(), "INTERACTIVITY_DONE", null);
    }

    private synchronized void processRootUserDialog(UserDialogView udView) {
        Vector v;
        if (udView == null) {
            return;
        }
        Log.log(128L, "Trying to show root userdialog: " + udView + " from url: " + udView.getUrl() + " current block: " + this.blockedSVG);
        if (udView.getUrl() != null && this.blockedSVG != null && udView.getUrl().startsWith(this.blockedSVG)) {
            this.blockedSVG = null;
            return;
        }
        if (udView.getSubviews() != null && udView.getSubviews().size() > 0) {
            SVGWindow oldRootUserDialogWindow = this.rootUserDialogWindow;
            this.rootUserDialogWindow = new FullScreenSVGWindow(udView);
            this.rootUserDialogWindow.makeKeyAndOrderFront();
            this.rootUserDialogWindow.display();
            if (oldRootUserDialogWindow != null) {
                oldRootUserDialogWindow.close();
            }
        }
        if ((v = udView.getRootCommands()) != null) {
            Command c = null;
            for (int x = 0; x < v.size(); ++x) {
                c = (Command)v.elementAt(x);
                Log.log(128L, "Processing root command in \"head less\" user dialog: " + c.getCommand());
                this.processUserdialogCommand(c, null, true);
            }
        }
    }

    public void setBlockedSVG(String blockedSVG) {
        this.blockedSVG = blockedSVG;
    }

    public void processUserDialogRootCommmands(UserDialogView userDialogView) {
        Vector v;
        if (userDialogView != null && (v = userDialogView.getRootCommands()) != null) {
            Command c = null;
            for (int x = 0; x < v.size(); ++x) {
                c = (Command)v.elementAt(x);
                Log.log(128L, "Processing Root command in Interactivitycontroller: " + c.getCommand());
                this.processUserdialogCommand(c, null, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUserdialogCommand(Command dlgCommand, UserDialogContainerView udContainerView, boolean isRootUserDialog) {
        block94: {
            try {
                Log.log(128L, " ----------Processing command in interactivityController: " + dlgCommand.getCommand());
                String command = dlgCommand.getCommand();
                if (command == null || command.length() <= 0) break block94;
                if (command.equals("mtv:closeDialog")) {
                    if (isRootUserDialog) {
                        if (this.rootUserDialogWindow != null) {
                            this.rootUserDialogWindow.close();
                            this.rootUserDialogWindow = null;
                        }
                        this.lookForPendingRootUserDialogs();
                    } else if (this.controller.getFullScreenInteractivityHandler().isDisplayingFullScreenInteractivity()) {
                        this.controller.getFullScreenInteractivityHandler().closeWindow();
                        if (this.controller.getSplitScreenInteractivityHandler().isDisplayingSplitScreenInteractivity()) {
                            this.controller.getSplitScreenInteractivityHandler().closeWindow();
                        }
                    } else if (this.controller.getSplitScreenInteractivityHandler().isDisplayingSplitScreenInteractivity()) {
                        this.controller.getSplitScreenInteractivityHandler().closeWindow();
                    }
                    break block94;
                }
                if (command.equals("mtv:closeApp")) {
                    if (this.controller != null) {
                        this.showWaitWindow();
                        this.controller.processUserdialogCommand(dlgCommand);
                        this.closeWaitWindow();
                    }
                    if (this.rootUserDialogWindow != null) {
                        this.rootUserDialogWindow.close();
                        this.rootUserDialogWindow = null;
                    }
                    break block94;
                }
                if (command.equals("mtv:browse") || command.equals("mtv:download")) {
                    if (this.rootUserDialogWindow != null) {
                        this.rootUserDialogWindow.close();
                        this.rootUserDialogWindow = null;
                    }
                    if (this.controller != null) {
                        this.showWaitWindow();
                        this.controller.processUserdialogCommand(dlgCommand);
                        this.closeWaitWindow();
                    }
                    break block94;
                }
                if (command.equals("mtv:go")) {
                    if (this.controller != null) {
                        this.showWaitWindow();
                        this.controller.processUserdialogCommand(dlgCommand);
                        this.closeWaitWindow();
                    }
                    break block94;
                }
                if (command.equals("mtv:redirect")) {
                    String url = dlgCommand.getAttribute("xlink:href");
                    String appendUrl = dlgCommand.getAttribute("appendUrl");
                    if (url != null && url.length() > 0) {
                        String textFromTextarea;
                        if (udContainerView != null && appendUrl != null && (textFromTextarea = udContainerView.getTextareaText(appendUrl)) != null) {
                            url = url + Utils.urlEncodeString(textFromTextarea);
                        }
                        this.showWaitWindow();
                        ServiceRegistry.instance().getComm().processUrl(url);
                        this.closeWaitWindow();
                        this.lookForPendingRootUserDialogs();
                    }
                    break block94;
                }
                if (command.equals("mtv:switchOrPurchaseChannel")) {
                    String cId = dlgCommand.getAttribute("channelId");
                    if ("current_content_id".equals(cId)) {
                        cId = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().getCurrentContent().getId();
                    }
                    try {
                        if (cId != null && cId.length() > 0) {
                            Channel c = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(cId);
                            CurrentContent cc = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent();
                            if (cc != null && c != null) {
                                int result;
                                if (this.rootUserDialogWindow != null) {
                                    this.rootUserDialogWindow.close();
                                    this.rootUserDialogWindow = null;
                                }
                                if ((result = cc.requestContentSwitch(c)) != 3) {
                                    this.controller.getTvScreenWindow().makeKeyAndOrderFront();
                                }
                            }
                            break block94;
                        }
                        Log.log(0x40000000L, "could not switch channel, channelId = null");
                    }
                    catch (Exception e) {
                        Log.exception(this, e);
                    }
                    break block94;
                }
                if (command.equals("mtv:fastSwitchChannel")) {
                    String cId = dlgCommand.getAttribute("channelId");
                    try {
                        if (cId != null && cId.length() > 0) {
                            Channel c = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(cId);
                            CurrentContent cc = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent();
                            if (cc != null && c != null) {
                                if (!ServiceRegistry.instance().getPlayer().isRunning()) {
                                    cc.restartStreamDueToStoppedPlayer(c);
                                } else {
                                    cc.performContentSwitch(c);
                                }
                            }
                            break block94;
                        }
                        Log.log(0x40000000L, "could not switch channel, channelId = null");
                    }
                    catch (Exception e) {
                        Log.exception(this, e);
                    }
                    break block94;
                }
                if (command.equals("mtv:switchChannel")) {
                    String cId = dlgCommand.getAttribute("channelId");
                    try {
                        if (cId != null && cId.length() > 0) {
                            Channel c = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(cId);
                            CurrentContent cc = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent();
                            if (cc != null && c != null) {
                                if (!c.isUserVisible()) {
                                    c.setUserVisible(true);
                                }
                                if (!ServiceRegistry.instance().getPlayer().isRunning()) {
                                    cc.restartStreamDueToStoppedPlayer(c);
                                } else if (!(cc.getCurrentContent() == null || c.getCodecType().equals(((Channel)cc.getCurrentContent()).getCodecType()) && c.getTokenType().equals(((Channel)cc.getCurrentContent()).getTokenType()))) {
                                    cc.restartStreamDueToDifferentCodecOrTokenTypes(c);
                                } else {
                                    cc.performContentSwitch(c);
                                }
                            }
                            break block94;
                        }
                        Log.log(0x40000000L, "could not switch channel, channelId = null");
                    }
                    catch (Exception e) {
                        Log.exception(this, e);
                    }
                    break block94;
                }
                if (command.equals("mtv:startPlayer")) {
                    String cId = dlgCommand.getAttribute("channelId");
                    try {
                        if (cId != null && cId.length() > 0) {
                            Channel c = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(cId);
                            CurrentContent cc = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent();
                            if (cc != null && c != null) {
                                String token;
                                String displayText;
                                if (!c.isUserVisible()) {
                                    c.setUserVisible(true);
                                }
                                if ((displayText = dlgCommand.getAttribute("displayText")) != null && displayText.length() > 0) {
                                    ServiceRegistry.instance().getDataProvider().getConfig().setDisplayText(displayText);
                                }
                                if ((token = dlgCommand.getAttribute("token")) != null && token.length() > 0) {
                                    ServiceRegistry.instance().getDataProvider().getConfig().setToken(token);
                                    ServiceRegistry.instance().getPlayer().setPlayerNeedsRestart();
                                }
                                cc.performContentSwitch(c);
                            }
                            break block94;
                        }
                        Log.log(0x40000000L, "could not switch channel, channelId = null");
                    }
                    catch (Exception e) {
                        Log.exception(this, e);
                    }
                    break block94;
                }
                if (command.equals("mtv:stopPlayer")) {
                    try {
                        ServiceRegistry.instance().getPlayer().stopPlayer();
                        ServiceRegistry.instance().getPlayer().setPlayerNeedsRestart();
                    }
                    catch (Exception e) {
                        Log.exception(this, e);
                    }
                    break block94;
                }
                if (command.equals("mtv:event")) {
                    String url = dlgCommand.getAttribute("xlink:href");
                    if (url != null && url.length() > 0) {
                        if (url.startsWith("#")) {
                            if (!isRootUserDialog) {
                                String eventId = url.substring(1);
                                if (ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().isCurrentInteractivityContextBanner()) {
                                    ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().activateBannerContextEvent(eventId);
                                } else {
                                    ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().activateOtherContextEvent(eventId);
                                }
                            }
                        } else {
                            this.showWaitWindow();
                            ServiceRegistry.instance().getComm().processUrl(url);
                            this.closeWaitWindow();
                        }
                    }
                    break block94;
                }
                if (command.equals("mtv:notify")) {
                    final String url = dlgCommand.getAttribute("xlink:href");
                    if (url != null) {
                        new Thread(){

                            public void run() {
                                ServiceRegistry.instance().getComm().getByteArray(url);
                            }
                        }.start();
                    }
                    break block94;
                }
                if (command.equals("mtv:update")) {
                    String db = dlgCommand.getAttribute("db");
                    if ("contentInfo".equalsIgnoreCase(db)) {
                        ServiceRegistry.instance().getComm().processUrl(ServiceRegistry.instance().getDataProvider().getConfig().getContentInfoUrlWithLang(), 0);
                    }
                    break block94;
                }
                if (command.equals("mtv:key")) {
                    String name = dlgCommand.getAttribute("name");
                    String value = dlgCommand.getAttribute("value");
                    String store = dlgCommand.getAttribute("store");
                    if (value != null && !"".equals(value)) {
                        ServiceRegistry.instance().getComm().addKey(name, value);
                    } else {
                        ServiceRegistry.instance().getLocalConfiguration().removeInteractivityKey(name);
                    }
                    if ("true".equalsIgnoreCase(store) && value != null && !"".equals(value)) {
                        ServiceRegistry.instance().getLocalConfiguration().addInteractivityKey(name, value);
                    }
                    break block94;
                }
                if (command.equals("mtv:sms")) {
                    String url = dlgCommand.getAttribute("xlink:href");
                    String prefix = dlgCommand.getAttribute("prefix");
                    String msisdn = dlgCommand.getAttribute("msisdn");
                    String textFromTextarea = null;
                    if (udContainerView != null && url != null) {
                        textFromTextarea = udContainerView.getTextareaText(url);
                    }
                    if (msisdn == null || msisdn.length() <= 0 || prefix == null && textFromTextarea == null) break block94;
                    MessageConnection conn = null;
                    try {
                        this.showWaitWindow();
                        String text = prefix == null ? "" : prefix.trim();
                        text = (textFromTextarea == null ? text + "" : text + " " + textFromTextarea.trim()).trim();
                        String address = "sms://" + msisdn;
                        conn = (MessageConnection)Connector.open((String)address);
                        TextMessage msg = (TextMessage)conn.newMessage("text");
                        msg.setPayloadText(text);
                        conn.send((Message)msg);
                        Log.log(128L, "SMS sent to: '" + msisdn + "' with text: '" + msg.getPayloadText() + "'");
                        break block94;
                    }
                    catch (Exception e) {
                        Log.exception(this, e);
                        break block94;
                    }
                    finally {
                        this.closeWaitWindow();
                        if (conn != null) {
                            conn.close();
                        }
                    }
                }
                if (command.equals("mtv:gotoScreen")) {
                    String screen = dlgCommand.getAttribute("screen");
                    String focus = dlgCommand.getAttribute("focus");
                    if (this.rootUserDialogWindow != null) {
                        this.rootUserDialogWindow.close();
                        this.rootUserDialogWindow = null;
                    }
                    if (screen != null && screen.length() > 0) {
                        if ("channels".equals(screen)) {
                            Channel c;
                            if (focus != null && (c = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(focus)) != null) {
                                this.controller.getChannelsWindow().scrollToChannel(c);
                            }
                            this.controller.getChannelsWindow().makeKeyAndOrderFront();
                        } else if ("tv".equals(screen)) {
                            this.controller.getTvScreenWindow().makeKeyAndOrderFront();
                        } else if ("shop".equals(screen)) {
                            Folder f = null;
                            if (focus != null) {
                                f = ServiceRegistry.instance().getDataProvider().getFolderList().getFolder(focus);
                            }
                            if (f != null) {
                                this.controller.getStoreController().getPackWindow(f).makeKeyAndOrderFront();
                            } else {
                                this.controller.getStoreController().getStartWindow().makeKeyAndOrderFront();
                            }
                        } else if (screen.equals("about")) {
                            ServiceRegistry.instance().getComm().processUrlASync("res://about.xml");
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
        }
    }

    private boolean isDisplayingRootUserDialog() {
        return this.rootUserDialogWindow != null;
    }

    class AdControllerResponse
    implements se.tactel.tvclient.notificationcenter.Observer {
        AdControllerResponse() {
        }

        public void notifiedWithNotification(Notification notification) {
            Log.log(128L, "Ending interactivity: " + notification.object() + " : " + notification.name());
            InteractivityController.this.requestInteractivityFromServer();
        }
    }

    class ButtonResponse
    implements se.tactel.tvclient.notificationcenter.Observer {
        ButtonResponse() {
        }

        public void notifiedWithNotification(Notification notification) {
            Log.log(128L, "Receiving notification from: " + notification.object() + " : " + notification.name());
            String name = notification.name();
            if (name == "clicked") {
                if (notification.object() != null && notification.object() instanceof UserDialogContainerView) {
                    AnchorContainerView a;
                    String url;
                    UserDialogContainerView b = (UserDialogContainerView)notification.object();
                    Log.log(128L, "Processing command vector for " + b + ": " + b.getAnchorCommands());
                    for (int x = 0; x < b.getAnchorCommands().size(); ++x) {
                        Command c = (Command)b.getAnchorCommands().elementAt(x);
                        InteractivityController.this.processUserdialogCommand(c, b, b.getUserDialogView().isMtvRootUserDialog());
                    }
                    Utils.sleep(300L);
                    if (notification.object() instanceof AnchorContainerView && (url = (a = (AnchorContainerView)notification.object()).getXLink()) != null && url.length() > 0) {
                        InteractivityController.this.showWaitWindow();
                        Log.log(128L, "Processing href url: " + url);
                        ServiceRegistry.instance().getComm().processUrl(url);
                        InteractivityController.this.closeWaitWindow();
                    }
                }
                InteractivityController.this.lookForPendingRootUserDialogs();
            }
        }
    }
}

