/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.ChannelList;
import se.tactel.tvclient.data.Content;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.persistence.Persister;
import se.tactel.tvclient.util.Log;

public class ChannelConfiguration
extends ObservableData {
    private final Persister persister;

    public ChannelConfiguration(Persister p) {
        this.persister = p;
        Log.log(0x40200000000L, "Creating channel configuration");
        this.deserialize(this.persister.load());
    }

    public Channel getFavoriteChannelData(int order) {
        Vector v = ServiceRegistry.instance().getDataProvider().getChannelList().getAllChannels();
        for (int i = 0; i < v.size(); ++i) {
            Channel c = (Channel)v.elementAt(i);
            if (c.getOrder() != order) continue;
            return c;
        }
        return null;
    }

    public void setChannelVisible(String id, boolean visible) {
        if (ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(id) == null) {
            return;
        }
        Channel movechannel = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(id);
        if (!visible) {
            Enumeration e = ServiceRegistry.instance().getDataProvider().getChannelList().getAllChannels().elements();
            while (e.hasMoreElements()) {
                Channel c = (Channel)e.nextElement();
                if (c.getOrder() <= movechannel.getOrder()) continue;
                c.setOrder(c.getOrder() - 1);
            }
            movechannel.setOrder(ServiceRegistry.instance().getDataProvider().getChannelList().getAllChannels().size());
            this.compressOrder();
        }
        this.persister.save(this.serialize());
    }

    public void unHideAllChannels() {
        Enumeration e = ServiceRegistry.instance().getDataProvider().getChannelList().getAllChannels().elements();
        while (e.hasMoreElements()) {
            Channel c = (Channel)e.nextElement();
            c.setUserVisible(true);
        }
    }

    public synchronized void compressOrder() {
        Vector v = ServiceRegistry.instance().getDataProvider().getChannelList().getAllChannels();
        for (int i = 0; i < v.size(); ++i) {
            Channel c = (Channel)v.elementAt(i);
            if (c == null) continue;
            c.setOrder(i + 1);
        }
        this.persister.save(this.serialize());
    }

    public int getLastVisibleContent() {
        int numVisible = 0;
        Enumeration e = ServiceRegistry.instance().getDataProvider().getChannelList().getSortedVisibleChannels().elements();
        if (e != null) {
            while (e.hasMoreElements()) {
                if (!((Channel)e.nextElement()).isUserVisible()) continue;
                ++numVisible;
            }
        }
        return numVisible > 10 ? 10 : numVisible;
    }

    public void insertContentAt(Content c, int pos) {
        if (c.getOrder() == pos) {
            return;
        }
        boolean movingtolower = c.getOrder() > pos;
        Enumeration e = ServiceRegistry.instance().getDataProvider().getChannelList().getAllChannels().elements();
        if (pos == ServiceRegistry.instance().getDataProvider().getChannelList().getAllChannels().size()) {
            ++pos;
        }
        if (e != null) {
            while (e.hasMoreElements()) {
                Channel cc = (Channel)e.nextElement();
                if (cc.getOrder() > pos) {
                    cc.setOrder(cc.getOrder() + 1);
                    continue;
                }
                if (!movingtolower && cc.getOrder() <= pos) {
                    cc.setOrder(cc.getOrder() - 1);
                    continue;
                }
                if (!movingtolower || cc.getOrder() != pos) continue;
                cc.setOrder(cc.getOrder() + 1);
            }
        }
        c.setOrder(pos);
        this.compressOrder();
    }

    byte[] serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            Log.log(0x40200000000L, "Persisting channel configuration: " + this.toString());
            ChannelList cl = ServiceRegistry.instance().getDataProvider().getChannelList();
            os.writeInt(cl.getAllChannels().size());
            Enumeration elements = cl.getAllChannels().elements();
            while (elements.hasMoreElements()) {
                Channel c = (Channel)elements.nextElement();
                boolean visible = c.isUserVisible();
                int order = c.getOrder();
                os.writeUTF(c.getId());
                os.writeBoolean(visible);
                os.writeInt(order);
            }
        }
        catch (IOException e) {
            Log.exception(this, e);
        }
        return baos.toByteArray();
    }

    void deserialize(byte[] serializedChannelConfiguration) {
        if (serializedChannelConfiguration == null) {
            Log.log(0x40200000000L, "No previous channel configuration persisted, starting up with default values: " + this.toString());
            return;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(serializedChannelConfiguration));
        try {
            int keyPairs = is.readInt();
            for (int i = 0; i < keyPairs; ++i) {
                Channel c;
                String id = is.readUTF();
                boolean visible = is.readBoolean();
                int order = is.readInt();
                if (id == null) continue;
                if (ServiceRegistry.instance().getDataProvider().getChannelList().contains(id)) {
                    c = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(id);
                    c.setOrder(order);
                    c.setUserVisibleWithoutChangingOrder(visible);
                    continue;
                }
                c = new Channel(id);
                c.setOrder(order);
                c.setVisible(true);
                c.setUserVisibleWithoutChangingOrder(visible);
                ServiceRegistry.instance().getDataProvider().getChannelList().updateChannel(c);
            }
        }
        catch (IOException e) {
            Log.exception(this, e);
        }
        Log.log(0x40200000000L, "Deserialized channel configuration: " + this.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Vector v = ServiceRegistry.instance().getDataProvider().getChannelList().getAllChannels();
        for (int a = 0; a < v.size(); ++a) {
            Channel c = (Channel)v.elementAt(a);
            String name = " name = " + c.getName();
            sb.append("id = " + c.getId() + name + " order = " + c.getOrder() + " visible = " + c.isUserVisible() + "\n");
        }
        return sb.toString();
    }
}

