/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.data;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import se.tactel.tvclient.Controller;
import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.Content;
import se.tactel.tvclient.data.CurrentContent;
import se.tactel.tvclient.data.Folder;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.gui.screen.tab.store.availablein.AvailableInStoreWindow;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class Config {
    private long serverTimeDiff = 0L;
    private String token;
    private String startupChannelId = "-1";
    private String baseUrl;
    private String epgURL;
    private String ninVersion;
    private String ninURL;
    private String ninMenu = "9999";
    private String slideShowUrl;
    private String contentInfoUrl;
    private Interval contentInfoUpdateInterval;
    private String restartStreamUrl;
    private String promotionSvgUrl;
    private String contentOfferingsUrl;
    private String userDialogUrl;
    private String interactivityServerUrl;
    private String stopSessionUrl;
    private String userAgent;
    private String TimeZone = "GMT+00:00";
    private String uid;
    private String streamingUrl;
    private CurrentContent currentContent;
    private String displayText = "";

    private String wesleyfyUrl(String url) {
        if (url.indexOf("wesley") != -1) {
            return url + ".jsp";
        }
        return url;
    }

    public void setBaseUrl(String url) {
        this.baseUrl = url;
    }

    public void setContentInfoUpdateInterval(int contentInfoUpdateInterval) {
        this.contentInfoUpdateInterval = new Interval(contentInfoUpdateInterval);
    }

    public Interval getContentInfoUpdateInterval() {
        return this.contentInfoUpdateInterval;
    }

    public String getEpgUrl(String[] channelIds, long startTime, long stopTime) {
        if (this.epgURL != null) {
            StringBuffer httpParams = new StringBuffer(this.epgURL);
            httpParams.append("?lang=");
            httpParams.append(ServiceRegistry.instance().getLocalConfiguration().getLanguage());
            httpParams.append("&channel_id=");
            for (int i = 0; i < channelIds.length; ++i) {
                if (i > 0) {
                    httpParams.append("%3B");
                }
                httpParams.append(channelIds[i]);
            }
            httpParams.append("&start_time=");
            httpParams.append(startTime);
            httpParams.append("&stop_time=");
            httpParams.append(stopTime);
            return httpParams.toString();
        }
        return null;
    }

    public String getEpgUrl(String channelId, long startTime, long stopTime) {
        if (this.epgURL != null) {
            StringBuffer httpParams = new StringBuffer(this.epgURL);
            httpParams.append("?lang=");
            httpParams.append(ServiceRegistry.instance().getLocalConfiguration().getLanguage());
            httpParams.append("&channel_id=");
            httpParams.append(channelId);
            httpParams.append("&start_time=");
            httpParams.append(startTime);
            httpParams.append("&stop_time=");
            httpParams.append(stopTime);
            return httpParams.toString();
        }
        return null;
    }

    public void setEpgUrl(String epgURL) {
        this.epgURL = epgURL;
    }

    public String getNinURL() {
        return this.ninURL;
    }

    public void setNinUrl(String ninURL) {
        this.ninURL = ninURL;
    }

    public void setNinVersion(String ninVersion) {
        this.ninVersion = ninVersion;
    }

    public String getNinVersion() {
        return this.ninVersion;
    }

    public String getNinMenu() {
        return this.ninMenu;
    }

    public void setNinMenu(String ninMenu) {
        this.ninMenu = ninMenu;
    }

    public String getPromotionSvgUrl() {
        return this.promotionSvgUrl;
    }

    public void setPromotionSvgUrl(String promotionSvgUrl) {
        this.promotionSvgUrl = promotionSvgUrl;
    }

    public String getSlideShowUrlWithLang() {
        if (this.slideShowUrl != null) {
            StringBuffer tmp = Utils.urlAppendParameter(this.slideShowUrl, "lang", ServiceRegistry.instance().getLocalConfiguration().getLanguage());
            int slideshowId = ServiceRegistry.instance().getLocalConfiguration().getCurrentSlideshowGroup().id;
            if (slideshowId != -1) {
                tmp = Utils.urlAppendParameter(tmp, "slideshow_group_id", Integer.toString(slideshowId));
            }
            return tmp.toString();
        }
        return this.slideShowUrl;
    }

    public void setSlideShowUrl(String slideShowUrl) {
        this.slideShowUrl = slideShowUrl;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String token) {
        this.uid = token;
    }

    public String getStreamingUrl() {
        return this.streamingUrl;
    }

    public void setStreamingUrl(String streamingUrl) {
        this.streamingUrl = streamingUrl;
    }

    public long getServerLocalTimeDiff() {
        return this.serverTimeDiff;
    }

    public void setServerTime(String serverTime) {
        try {
            Date server = new Date(Long.parseLong(serverTime));
            Date local = new Date();
            this.serverTimeDiff = local.getTime() - server.getTime();
        }
        catch (Exception e) {
            Log.log(0x80000000L, "Invalid server time: " + serverTime);
        }
    }

    public CurrentContent getCurrentContent() {
        if (this.currentContent == null) {
            this.currentContent = new CurrentContent();
        }
        return this.currentContent;
    }

    public String getStartupChannelId() {
        return this.startupChannelId;
    }

    public void setStartupChannelId(String startupChannelId) {
        this.startupChannelId = startupChannelId;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setInteractivityServerUrl(String interactivityServerUrl) {
        this.interactivityServerUrl = interactivityServerUrl;
    }

    public String getInteractivityRequestUrl() {
        if (this.interactivityServerUrl != null) {
            String language = ServiceRegistry.instance().getLocalConfiguration().getLanguage();
            StringBuffer urlToUse = Utils.urlAppendParameter(this.interactivityServerUrl, "lang", language);
            Controller controller = RichMediaMIDlet.instance().tController;
            Content contentWatched = this.getCurrentContent().getCurrentContent();
            boolean epgBrowsed = controller.getGuideScreenController().isShowingEpgWindow();
            Window w = ServiceRegistry.instance().getWindowServer().getTopmostWindow();
            boolean storeAvailableInBrowsed = w instanceof AvailableInStoreWindow;
            String channelId = "-1";
            if (epgBrowsed) {
                channelId = controller.getGuideScreenController().getBrowsedChannelId();
            } else if (storeAvailableInBrowsed) {
                channelId = ((AvailableInStoreWindow)w).getChannelIdScreenIsShowedFor();
            } else if (contentWatched != null && ServiceRegistry.instance().getPlayer().isRunning()) {
                channelId = contentWatched.getEcdsId();
            }
            urlToUse = Utils.urlAppendParameter(urlToUse, "channel_id", channelId);
            return urlToUse.toString();
        }
        return null;
    }

    public String getTimeZone() {
        return this.TimeZone;
    }

    public void setTimeZone(String timeZone) {
        this.TimeZone = timeZone;
    }

    public String getInitUrl() {
        return this.wesleyfyUrl(this.baseUrl + "/init");
    }

    public String getContentOfferingUrl(Content c) {
        if (c instanceof Content && this.contentOfferingsUrl != null) {
            String contentBaseUrl = Utils.urlAppendParameter(this.contentOfferingsUrl, "lang", ServiceRegistry.instance().getLocalConfiguration().getLanguage().toString()).toString();
            return contentBaseUrl + (c instanceof Channel ? "&channel_id=" : "&bundle_id=") + c.getId();
        }
        return null;
    }

    public String getContentOfferingUrlForFolderWithChannelContext(Folder f, Channel c) {
        String offerUrl = this.getContentOfferingUrl(f);
        offerUrl = offerUrl + "&view_channel=" + c.getId();
        return offerUrl;
    }

    public String getUserDialogUrl(String dialogId) {
        if (this.userDialogUrl != null) {
            return Utils.urlAppendParameter(this.userDialogUrl, "lang", ServiceRegistry.instance().getLocalConfiguration().getLanguage().toString()).toString() + "&dialog_id=" + dialogId;
        }
        return null;
    }

    public String getRestartStreamUrl() {
        return this.restartStreamUrl;
    }

    public void setRestartStreamUrl(String restartStreamUrl) {
        this.restartStreamUrl = restartStreamUrl;
    }

    public void setContentOfferingsUrl(String contentOfferingsUrl) {
        this.contentOfferingsUrl = contentOfferingsUrl;
    }

    public void setUserDialogUrl(String userDialogUrl) {
        this.userDialogUrl = userDialogUrl;
    }

    public void setContentInfoUrl(String contentInfoUrl) {
        this.contentInfoUrl = contentInfoUrl;
    }

    public String getContentInfoUrlWithLang() {
        if (this.contentInfoUrl != null) {
            return Utils.urlAppendParameter(this.contentInfoUrl, "lang", ServiceRegistry.instance().getLocalConfiguration().getLanguage()).toString();
        }
        return null;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setStopSessionUrl(String stopSessionUrl) {
        this.stopSessionUrl = stopSessionUrl;
    }

    public String getStopSessionUrlWithLang() {
        if (this.stopSessionUrl != null) {
            return Utils.urlAppendParameter(this.stopSessionUrl, "lang", ServiceRegistry.instance().getLocalConfiguration().getLanguage()).toString();
        }
        return null;
    }

    public void setDisplayText(String text) {
        this.displayText = text;
    }

    public String getDisplayText() {
        return "".equals(this.displayText) ? ServiceRegistry.instance().getLocalization().getString(202) : this.displayText;
    }

    public static class Interval
    extends ObservableData {
        private static Timer timer = null;
        private TimerTask ttask = null;
        private static final int MINIMUM_REFRESH_TIME = 300000;

        public Interval(int intervall) {
            if (intervall > 0) {
                this.ttask = new TimerTask(){

                    public void run() {
                        try {
                            Interval.this.notifyObservers();
                        }
                        catch (Exception e) {
                            Log.exception(this, e);
                        }
                    }
                };
                timer.scheduleAtFixedRate(this.ttask, Math.max(intervall, 300000), (long)Math.max(intervall, 300000));
            }
        }

        static {
            timer = new Timer();
        }
    }
}

