/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.data;

import java.util.Enumeration;
import java.util.Vector;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.resource.Resource;
import se.tactel.tvclient.resource.ResourceManager;
import se.tactel.tvclient.util.Log;

public class Slideshow {
    private SlideshowGroup dirtySlideshowGroup;

    public void setParsedSlides(int idOfDirtySlides, Vector dirtyStartSlides, Vector dirtyExitSlides) {
        this.dirtySlideshowGroup = new SlideshowGroup(idOfDirtySlides, dirtyStartSlides, dirtyExitSlides);
        this.dirtySlideshowGroup.cachedId = ServiceRegistry.instance().getLocalConfiguration().getCurrentSlideshowGroup().cachedId == 1 ? 2 : 1;
        Log.log(0x204000000L, "Added dirty slideshow " + this.dirtySlideshowGroup.toString());
    }

    public void process() {
        Log.log(0x204000000L, "Starting processing of the dirty slide show group: " + this.dirtySlideshowGroup);
        if (this.dirtySlideshowGroup == null) {
            Log.log(0x204000000L, "No dirty slides se, noting to do, aborting.");
        } else if (this.dirtySlideshowGroup.id == ServiceRegistry.instance().getLocalConfiguration().getCurrentSlideshowGroup().id) {
            Log.log(0x204000000L, "Dirty & current slides exact the same, aborting");
        } else {
            SlideshowGroup currentSlideshowGroup = ServiceRegistry.instance().getLocalConfiguration().getCurrentSlideshowGroup();
            if (currentSlideshowGroup.equals(this.dirtySlideshowGroup)) {
                Log.log(0x204000000L, "Identical slides even if groups differs, aborting");
                currentSlideshowGroup.id = this.dirtySlideshowGroup.id;
                ServiceRegistry.instance().getLocalConfiguration().setCurrentSlideshowGroup(currentSlideshowGroup);
            } else if (this.downloadSlides()) {
                this.consolidate();
            } else {
                Log.log(0x44000000L, "Unable to download slides...");
            }
        }
    }

    private boolean downloadSlides() {
        Resource imageResource;
        Slide slide;
        Enumeration e = this.dirtySlideshowGroup.startupSlides.elements();
        while (e.hasMoreElements()) {
            slide = (Slide)e.nextElement();
            imageResource = ResourceManager.instance().getSlideResource(this.dirtySlideshowGroup.cachedId, slide.url);
            if (imageResource != null && ResourceManager.instance().isSlideResourceCached(this.dirtySlideshowGroup.cachedId, imageResource)) {
                Log.log(0x204000000L, "Startup Slide pre-cached at " + this.dirtySlideshowGroup.cachedId + " " + slide.toString() + " src " + imageResource);
                imageResource = null;
                continue;
            }
            Log.log(0x104000000L, "Failed to download/fit in cache slide, aborting slide group update: " + slide.toString());
            ResourceManager.instance().clearSlideCache(this.dirtySlideshowGroup.cachedId);
            return false;
        }
        e = this.dirtySlideshowGroup.exitSlides.elements();
        while (e.hasMoreElements()) {
            slide = (Slide)e.nextElement();
            imageResource = ResourceManager.instance().getSlideResource(this.dirtySlideshowGroup.cachedId, slide.url);
            if (imageResource != null && ResourceManager.instance().isSlideResourceCached(this.dirtySlideshowGroup.cachedId, imageResource)) {
                Log.log(0x204000000L, "Exit Slide pre-cached at " + this.dirtySlideshowGroup.cachedId + " " + slide.toString() + " src " + imageResource);
                imageResource = null;
                continue;
            }
            Log.log(0x104000000L, "Failed to download/fit in cache slide, aborting slide group update: " + slide.toString());
            ResourceManager.instance().clearSlideCache(this.dirtySlideshowGroup.cachedId);
            return false;
        }
        return true;
    }

    private void consolidate() {
        Log.log(0x204000000L, "Consolidating: " + this.dirtySlideshowGroup);
        ResourceManager.instance().clearSlideCache(ServiceRegistry.instance().getLocalConfiguration().getCurrentSlideshowGroup().cachedId);
        ServiceRegistry.instance().getLocalConfiguration().setCurrentSlideshowGroup(this.dirtySlideshowGroup);
    }

    public static class SlideshowGroup {
        public int id = -1;
        public int cachedId = 1;
        public Vector startupSlides = new Vector();
        public Vector exitSlides = new Vector();

        public SlideshowGroup() {
        }

        public SlideshowGroup(int id, Vector startupSlides, Vector exitSlides) {
            this.id = id;
            this.startupSlides = startupSlides;
            this.exitSlides = exitSlides;
        }

        public boolean equals(Object o) {
            Slide s2;
            Slide s1;
            int i;
            if (!(o instanceof SlideshowGroup)) {
                return false;
            }
            SlideshowGroup otherSlideshowGroup = (SlideshowGroup)o;
            if (this.startupSlides.size() == otherSlideshowGroup.startupSlides.size()) {
                for (i = 0; i < otherSlideshowGroup.startupSlides.size(); ++i) {
                    s1 = (Slide)this.startupSlides.elementAt(i);
                    s2 = (Slide)otherSlideshowGroup.startupSlides.elementAt(i);
                    if (s1.url.equals(s2.url)) continue;
                    Log.log(0x204000000L, "Not identical startup slides: " + i + " " + s1.url + " " + s2.url);
                    return false;
                }
            } else {
                return false;
            }
            if (this.exitSlides.size() == otherSlideshowGroup.exitSlides.size()) {
                for (i = 0; i < otherSlideshowGroup.exitSlides.size(); ++i) {
                    s1 = (Slide)this.exitSlides.elementAt(i);
                    s2 = (Slide)otherSlideshowGroup.exitSlides.elementAt(i);
                    if (s1.url.equals(s2.url)) continue;
                    Log.log(0x204000000L, "Not identical exit slides: " + i + " " + s1.url + " " + s2.url);
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }

        public String toString() {
            return "id=\"" + this.id + "\" cache used=\"" + this.cachedId + "\"\n startup slides=\"" + this.startupSlides + "\"" + "\"\n exit slides=\"" + this.exitSlides + "\"";
        }
    }

    public static class Slide {
        public String url = null;
        public int order = 0;
        public int duration = 0;

        public boolean equals(Object o) {
            Slide s = (Slide)o;
            return this.url.equals(s.url);
        }

        public String toString() {
            return "order=\"" + this.order + "\" url=\"" + this.url + "\" duration=\"" + this.duration + "\"";
        }
    }
}

