/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.data.interactivity;

import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.Observer;
import se.tactel.tvclient.data.interactivity.InteractivityEvent;
import se.tactel.tvclient.data.interactivity.OneInteractivity;
import se.tactel.tvclient.notificationcenter.Notification;
import se.tactel.tvclient.notificationcenter.NotificationCenter;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class CurrentInteractivityEvent {
    public static final String INTERACTIVITY_DONE = "INTERACTIVITY_DONE";
    private OneInteractivity currentBannerInteractivityContext;
    private OneInteractivity currentOtherInteractivityContext;
    private ObserverableInteractivityEvent currentInteractivityEvent = new ObserverableInteractivityEvent();
    private Thread timerThread;
    private int beenVisibleTime;
    private int duration;

    public void observerve(Observer o) {
        this.currentInteractivityEvent.addObserver(o);
    }

    public InteractivityEvent get() {
        return this.currentInteractivityEvent.getEvent();
    }

    public ObserverableInteractivityEvent getObservable() {
        return this.currentInteractivityEvent;
    }

    public void setCurrentInteractivityContext(OneInteractivity oneInteractivity) {
        if (oneInteractivity == null) {
            return;
        }
        Log.log(128L, "Processing current interactivity context: " + oneInteractivity + " is containing banner/blank: " + oneInteractivity.isContainingBannerOrBlank());
        if (oneInteractivity.isContainingBannerOrBlank()) {
            this.currentBannerInteractivityContext = oneInteractivity;
            InteractivityEvent eventToGoTo = this.currentBannerInteractivityContext.getFirstEventToExecute();
            this.duration = eventToGoTo.getDuration();
            this.currentInteractivityEvent.setEvent(eventToGoTo);
        } else {
            this.currentOtherInteractivityContext = oneInteractivity;
            this.currentInteractivityEvent.setEvent(oneInteractivity.getFirstEventToExecute());
        }
    }

    public boolean isCurrentInteractivityContextBanner() {
        InteractivityEvent event = this.currentInteractivityEvent.getEvent();
        return this.currentBannerInteractivityContext.getEvents().indexOf(event) != -1;
    }

    public void activateBannerContextEvent(String eventId) {
        InteractivityEvent event = this.currentBannerInteractivityContext.getEvent(eventId);
        if (event != null && "form".equals(event.getType())) {
            Log.log(128L, "Going to form in banner <interactivity> context: " + event);
            this.currentInteractivityEvent.setEvent(event);
        }
    }

    public void activateOtherContextEvent(String eventId) {
        InteractivityEvent event = this.currentOtherInteractivityContext.getEvent(eventId);
        if (event != null && "form".equals(event.getType())) {
            Log.log(128L, "Going to form in non banner <interactivity> context: " + event);
            this.currentInteractivityEvent.setEvent(event);
        }
    }

    public synchronized void startTimer() {
        if (this.timerThread == null && this.currentInteractivityEvent.getEvent() != null) {
            final long waitTime = this.duration * 1000 - this.beenVisibleTime;
            Log.log(8L, "START with been visible " + this.beenVisibleTime + " and " + waitTime + " ms left of duration " + this.duration + ": " + this.currentInteractivityEvent);
            if (waitTime > 0L) {
                this.timerThread = new Thread(){
                    long startTime;

                    public void run() {
                        this.startTime = Utils.currentTimeMillis();
                        try {
                            Thread.sleep(waitTime);
                            CurrentInteractivityEvent.this.beenVisibleTime = (int)((long)CurrentInteractivityEvent.this.beenVisibleTime + waitTime);
                            CurrentInteractivityEvent.this.timeout();
                        }
                        catch (InterruptedException exc) {
                            CurrentInteractivityEvent.this.beenVisibleTime = (int)((long)CurrentInteractivityEvent.this.beenVisibleTime + (Utils.currentTimeMillis() - this.startTime));
                        }
                        catch (Throwable t) {
                            Log.exception(this, t);
                        }
                    }
                };
                this.timerThread.start();
            }
        }
    }

    public synchronized void stopTimer() {
        if (this.timerThread != null) {
            this.timerThread.interrupt();
            this.timerThread = null;
            Log.log(8L, " STOP: " + this.currentInteractivityEvent);
        }
    }

    private void timeout() {
        Log.log(8L, " TIMEOUT: " + this.currentInteractivityEvent);
        this.timerThread = null;
        this.beenVisibleTime = 0;
        this.currentInteractivityEvent.setEvent(null);
        NotificationCenter.defaultCenter().postNotification(new Notification(INTERACTIVITY_DONE, null));
    }

    public static class ObserverableInteractivityEvent
    extends ObservableData {
        public InteractivityEvent event;

        public InteractivityEvent getEvent() {
            return this.event;
        }

        public void setEvent(InteractivityEvent fullScreenEvent) {
            this.event = fullScreenEvent;
            this.notifyObserversSync();
        }

        public String toString() {
            return this.event != null ? this.event.toString() : super.toString();
        }
    }
}

