/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui;

import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.util.Log;

public class InputBoxView
extends View {
    private int outlineWidth = 0;
    private int outlineColor = 0;
    private int textColor = 0;
    private int caretIndex = 0;
    private boolean caretVisible = false;
    private int timer = 0;
    private String text = null;
    private String textPartTwo = null;
    private InputTimerTask inputTimer = null;
    private int inputTimerTime = 100;
    private String currentChar = "";
    private boolean isActive = false;
    private boolean upperCase = true;
    private boolean hideCharacters = false;
    private boolean constrainToNumbersOnly = false;
    private Font font = null;
    private Font fontHighlighted = null;
    private boolean doDrawHighlight = true;
    private String key0 = null;
    private String key1 = null;
    private String key2 = null;
    private String key3 = null;
    private String key4 = null;
    private String key5 = null;
    private String key6 = null;
    private String key7 = null;
    private String key8 = null;
    private String key9 = null;
    private String keyStar = null;
    private String keyPound = null;
    private int defaultTextColor = 0;

    public InputBoxView(Font font, Font fontHighlighted, int outlineWidth, boolean hideCharacters, boolean constrainToNumbersOnly, boolean doDrawHighlight) {
        this.font = font;
        this.fontHighlighted = fontHighlighted;
        this.outlineWidth = outlineWidth;
        this.outlineColor = 2442597;
        this.textColor = this.defaultTextColor;
        this.upperCase = true;
        this.hideCharacters = hideCharacters;
        this.constrainToNumbersOnly = constrainToNumbersOnly;
        this.doDrawHighlight = doDrawHighlight;
        if (constrainToNumbersOnly) {
            this.inputTimerTime = 5;
            this.key0 = "0";
            this.key1 = "1";
            this.key2 = "2";
            this.key3 = "3";
            this.key4 = "4";
            this.key5 = "5";
            this.key6 = "6";
            this.key7 = "7";
            this.key8 = "8";
            this.key9 = "9";
            this.keyStar = "*";
            this.keyPound = "#";
        } else {
            this.inputTimerTime = 100;
            this.key0 = "+0";
            this.key1 = ".,?!'@:;/()*1";
            this.key2 = "abc2";
            this.key3 = "def3";
            this.key4 = "ghi4";
            this.key5 = "jkl5";
            this.key6 = "mn\u00f1o6";
            this.key7 = "pqrs7";
            this.key8 = "tuv8";
            this.key9 = "wxyz9";
            this.keyStar = "*";
            this.keyPound = " #";
        }
        this.text = "";
        this.textPartTwo = "";
        this.currentChar = "";
        this.isActive = true;
    }

    public boolean event(Event event) {
        Log.log(32L, "event recieved in inputBox and activeBox is: " + this.isActive + ", and enabled is:" + this.enabled);
        if (event.type() == 1 && this.isActive && this.enabled) {
            this.timer = 10;
            switch (event.keyCode()) {
                case 48: {
                    this.handleKeyPress(this.key0);
                    return true;
                }
                case 49: {
                    this.handleKeyPress(this.key1);
                    return true;
                }
                case 50: {
                    this.handleKeyPress(this.key2);
                    return true;
                }
                case 51: {
                    this.handleKeyPress(this.key3);
                    return true;
                }
                case 52: {
                    this.handleKeyPress(this.key4);
                    return true;
                }
                case 53: {
                    this.handleKeyPress(this.key5);
                    return true;
                }
                case 54: {
                    this.handleKeyPress(this.key6);
                    return true;
                }
                case 55: {
                    this.handleKeyPress(this.key7);
                    return true;
                }
                case 56: {
                    this.handleKeyPress(this.key8);
                    return true;
                }
                case 57: {
                    this.handleKeyPress(this.key9);
                    return true;
                }
                case 42: {
                    if (this.constrainToNumbersOnly) {
                        this.handleKeyPress(this.keyStar);
                    } else {
                        this.upperCase = !this.upperCase;
                    }
                    return true;
                }
                case 35: {
                    this.handleKeyPress(this.keyPound);
                    return true;
                }
                case -8: {
                    this.deleteChar();
                    return true;
                }
                case -5: {
                    this.deactivateBox();
                    return true;
                }
                case -3: {
                    this.moveCaretLeft();
                    return true;
                }
                case -4: {
                    this.moveCaretRight();
                    return true;
                }
            }
            return super.event(event);
        }
        return super.event(event);
    }

    public void setHighlight(boolean flag) {
        super.setHighlight(flag);
        if (flag) {
            this.activateBox();
        } else {
            this.deactivateBox();
        }
    }

    private synchronized void handleKeyPress(String keyString) {
        int maxNumChar = keyString.length();
        if (maxNumChar != 0) {
            if (this.currentChar.equals("")) {
                this.currentChar = keyString.substring(0, 1);
            } else {
                int numChar;
                for (numChar = maxNumChar - 1; numChar >= 0; --numChar) {
                    if (!this.currentChar.equals(keyString.substring(numChar, numChar + 1))) continue;
                    this.currentChar = numChar == maxNumChar - 1 ? keyString.substring(0, 1) : keyString.substring(numChar + 1, numChar + 2);
                    numChar = -2;
                }
                if (numChar == -1) {
                    this.appendCharKeyPressed(this.currentChar);
                    this.currentChar = keyString.substring(0, 1);
                }
            }
        } else {
            this.currentChar = "";
        }
        this.setNeedsDisplay();
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        try {
            int i;
            Rect clip = g.getClipRect();
            g.setClipRect(rect);
            int caretXDisplacement = 0;
            int caretYDisplacement = 0;
            g.setFont(this.font);
            if (this.drawsBackground) {
                g.setColor(this.backgroundColor);
                g.setFont(this.font);
                g.graphics().fillRect(this.frame.x, this.frame.y, this.frame.width - 2, this.frame.height - 2);
            }
            if (this.doDrawHighlight && this.highlight) {
                g.setFont(this.fontHighlighted);
                g.setStrokeStyle(1);
                g.setColor(-16776961);
                g.graphics().drawRect(this.frame.x, this.frame.y, this.frame.width - 1, this.frame.height - 1);
                g.setStrokeStyle(0);
                g.setColor(this.outlineColor);
                for (i = this.outlineWidth; i > 0; --i) {
                    g.graphics().drawRect(this.frame.x + i, this.frame.y + i, this.frame.width - 1 - (i + i), this.frame.height - 1 - (i + i));
                }
            }
            if (this.enabled || !this.enabled && this.highlight) {
                g.setColor(this.outlineColor);
            } else {
                g.setColor(-1);
            }
            if (!this.highlight) {
                for (i = this.outlineWidth; i > 0; --i) {
                    g.graphics().drawRect(this.frame.x - 1 + i, this.frame.y - 1 + i, this.frame.width + 1 - (i + i), this.frame.height + 1 - (i + i));
                }
            }
            g.setStrokeStyle(0);
            g.setColor(this.textColor);
            String lineString = this.text.concat(this.upperCase ? this.currentChar.toUpperCase() : this.currentChar.toLowerCase()).concat(this.textPartTwo);
            int stringLength = lineString.length();
            if (this.hideCharacters) {
                StringBuffer lineStringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < stringLength; ++i2) {
                    lineStringBuffer.append("*");
                }
                lineString = new String(lineStringBuffer);
            }
            Vector<int[]> lineIndeces = new Vector<int[]>();
            int currentLineStartIndex = 0;
            int currentLine = 1;
            int lastLine = this.frame.height / g.getFont().getHeight();
            int caretLine = 1;
            int boxes = 0;
            lastLine = lastLine == 0 ? 1 : lastLine;
            int lastSpaceIndex = 0;
            for (int i3 = 0; i3 < stringLength + 1; ++i3) {
                if (g.getFont().substringWidth(lineString, currentLineStartIndex, i3 - currentLineStartIndex) >= this.frame.width - this.outlineWidth - this.outlineWidth) {
                    if (lastSpaceIndex <= 0) {
                        lastSpaceIndex = i3 - 1;
                    }
                    boxes = lastLine == 0 ? 0 : currentLine / lastLine;
                    ++currentLine;
                    lineIndeces.addElement(new int[]{currentLineStartIndex, lastSpaceIndex});
                    currentLineStartIndex = lastSpaceIndex + 1;
                    if (this.caretIndex >= i3) {
                        ++caretLine;
                    }
                    lastSpaceIndex = 0;
                    continue;
                }
                if (i3 >= stringLength || lineString.charAt(i3) != ' ') continue;
                lastSpaceIndex = i3;
            }
            if (stringLength != 0) {
                lineIndeces.addElement(new int[]{currentLineStartIndex, stringLength});
            } else {
                lineIndeces.addElement(new int[]{0, 0});
            }
            int caretBox = lastLine == 0 ? 0 : (caretLine - 1) / lastLine;
            if (!this.currentChar.equals("") & caretLine == (caretBox + 1) * lastLine & ((int[])lineIndeces.elementAt(caretLine - 1))[1] == this.caretIndex) {
                ++caretBox;
            }
            int j = 0;
            for (int i4 = caretBox * lastLine + 1; i4 < (caretBox + 1) * lastLine + 1; ++i4) {
                if (i4 - 1 < lineIndeces.size()) {
                    g.graphics().drawString(lineString.substring(((int[])lineIndeces.elementAt(i4 - 1))[0], ((int[])lineIndeces.elementAt(i4 - 1))[1]), this.frame.x + this.outlineWidth, this.frame.y + this.outlineWidth + j * g.getFont().getHeight(), 20);
                }
                ++j;
            }
            if (this.enabled) {
                try {
                    if (this.currentChar.equals("")) {
                        caretXDisplacement = g.getFont().stringWidth(lineString.substring(((int[])lineIndeces.elementAt(caretLine - 1))[0], this.caretIndex));
                        caretYDisplacement = g.getFont().getHeight() * ((caretLine - 1) % lastLine);
                    } else if (((int[])lineIndeces.elementAt(caretLine - 1))[1] != this.caretIndex) {
                        caretXDisplacement = g.getFont().stringWidth(lineString.substring(((int[])lineIndeces.elementAt(caretLine - 1))[0], this.caretIndex + 1));
                        caretYDisplacement = g.getFont().getHeight() * ((caretLine - 1) % lastLine);
                    } else if (caretLine != caretBox * lastLine) {
                        caretXDisplacement = g.getFont().stringWidth(lineString.substring(this.caretIndex, this.caretIndex + 1));
                        caretYDisplacement = g.getFont().getHeight() * ((caretLine - 1) % lastLine + 1);
                    } else {
                        caretXDisplacement = g.getFont().stringWidth(lineString.substring(this.caretIndex, this.caretIndex + 1));
                        caretYDisplacement = 0;
                    }
                }
                catch (Exception e) {
                    Log.exception(this, e);
                    caretXDisplacement = 0;
                    caretYDisplacement = 0;
                }
                if (this.currentChar != "" | this.caretVisible) {
                    g.graphics().drawLine(this.frame.x + caretXDisplacement + 2, this.frame.y + caretYDisplacement, this.frame.x + caretXDisplacement + 2, this.frame.y + caretYDisplacement + g.getFont().getHeight());
                }
            }
            if (caretBox < boxes) {
                g.graphics().fillRect(this.frame.x + this.frame.width - this.outlineWidth - this.outlineWidth, this.frame.y + g.getFont().getHeight() * lastLine + 2, 2, 2);
                g.graphics().fillRect(this.frame.x + this.frame.width - this.outlineWidth - this.outlineWidth - 3, this.frame.y + g.getFont().getHeight() * lastLine + 2, 2, 2);
                g.graphics().fillRect(this.frame.x + this.frame.width - this.outlineWidth - this.outlineWidth - 6, this.frame.y + g.getFont().getHeight() * lastLine + 2, 2, 2);
            }
            if (caretBox != 0) {
                g.graphics().fillRect(this.frame.x + this.outlineWidth, this.frame.y + g.getFont().getHeight(), 2, 2);
                g.graphics().fillRect(this.frame.x + this.outlineWidth + 3, this.frame.y + g.getFont().getHeight(), 2, 2);
                g.graphics().fillRect(this.frame.x + this.outlineWidth + 6, this.frame.y + g.getFont().getHeight(), 2, 2);
            }
            g.setClipRect(clip);
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }

    private synchronized void appendCharTimedOut(String character) {
        if (!this.currentChar.equals("")) {
            this.text = this.text.concat(this.upperCase ? character.toUpperCase() : character.toLowerCase());
            this.currentChar = "";
            ++this.caretIndex;
        }
    }

    private synchronized void appendCharKeyPressed(String character) {
        this.appendCharTimedOut(character);
    }

    private void deleteChar() {
        if (this.currentChar == "") {
            if (this.text.length() > 0) {
                this.text = this.text.substring(0, this.text.length() - 1);
                --this.caretIndex;
            }
        } else {
            this.currentChar = "";
        }
        this.setNeedsDisplay();
    }

    private synchronized void moveCaretLeft() {
        if (this.caretIndex != 0 && !this.text.equals("")) {
            this.appendCharKeyPressed(this.currentChar);
            this.textPartTwo = this.text.substring(this.caretIndex - 1).concat(this.textPartTwo);
            this.text = this.text.substring(0, this.caretIndex - 1);
            --this.caretIndex;
            this.setNeedsDisplay();
        }
    }

    private synchronized void moveCaretRight() {
        if (this.caretIndex != this.text.concat(this.upperCase ? this.currentChar.toUpperCase() : this.currentChar.toLowerCase()).concat(this.textPartTwo).length() && !this.textPartTwo.equals("")) {
            this.appendCharKeyPressed(this.currentChar);
            this.text = this.text.concat(this.textPartTwo.substring(0, 1));
            this.textPartTwo = this.textPartTwo.substring(1);
            ++this.caretIndex;
            this.setNeedsDisplay();
        }
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void activateBox() {
        this.isActive = true;
        this.caretVisible = true;
        this.inputTimer = new InputTimerTask();
        View.timer.scheduleAtFixedRate((TimerTask)this.inputTimer, this.inputTimerTime, (long)this.inputTimerTime);
    }

    public void deactivateBox() {
        this.isActive = false;
        this.appendCharKeyPressed(this.currentChar);
        this.caretIndex = 0;
        this.caretVisible = false;
        this.textPartTwo = this.getText();
        this.text = "";
        if (this.inputTimer != null) {
            this.inputTimer.cancel();
        }
    }

    public boolean boxIsActive() {
        return this.isActive;
    }

    public String getText() {
        return this.text.concat(this.upperCase ? this.currentChar.toUpperCase() : this.currentChar.toLowerCase()).concat(this.textPartTwo);
    }

    public void setText(String text) {
        this.text = text;
    }

    private class InputTimerTask
    extends TimerTask {
        private InputTimerTask() {
        }

        public void run() {
            try {
                if (InputBoxView.this.currentChar != "" && InputBoxView.this.timer == 0) {
                    InputBoxView.this.appendCharTimedOut(InputBoxView.this.currentChar);
                }
                if (InputBoxView.this.timer != 0) {
                    InputBoxView.this.timer--;
                }
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
        }
    }
}

