/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import se.tactel.tvclient.data.Slideshow;
import se.tactel.tvclient.gui.common.ImageView;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.resource.Resource;
import se.tactel.tvclient.resource.ResourceManager;
import se.tactel.tvclient.util.Log;

public class SlideImageView
extends ImageView
implements Runnable {
    protected boolean loop = false;
    protected boolean looped = false;
    protected Vector slides = null;
    public boolean quit = false;
    Enumeration elements = null;
    protected Thread st = null;

    public void run() {
        this.elements = this.slides.elements();
        while (!this.quit) {
            try {
                Slideshow.Slide s;
                if (this.elements.hasMoreElements()) {
                    s = (Slideshow.Slide)this.elements.nextElement();
                    this.changeImage(s.url, !this.looped);
                    Thread.sleep(Math.max(1000, s.duration * 1000));
                    continue;
                }
                if (this.loop) {
                    this.looped = true;
                    this.elements = this.slides.elements();
                    if (this.elements.hasMoreElements()) {
                        s = (Slideshow.Slide)this.elements.nextElement();
                        this.changeImage(s.url, !this.looped);
                        Thread.sleep(Math.max(1000, s.duration * 1000));
                        continue;
                    }
                    Log.log(0x4000000L, "No splashes in round");
                    continue;
                }
                this.quit = true;
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
        }
    }

    public SlideImageView(Vector slides, boolean loop, Rect aFrame, Image pendingImage) {
        super(aFrame, (Resource)null);
        this.slides = slides;
        this.loop = loop;
        this.pendingImage = pendingImage;
        if (this.slides != null) {
            this.st = new Thread(this);
        }
    }

    protected void changeImage(String url, boolean tryFromNet) {
        if (url != null) {
            try {
                Resource res = ResourceManager.instance().getResourceOnlyFromCache(url);
                if (res != null) {
                    this.setImage(res);
                    Log.log(0x4000000L, "Changing slide to " + url);
                    this.setNeedsDisplay();
                } else if (tryFromNet && (res = ResourceManager.instance().getResource(url)) != null) {
                    this.setImage(res);
                    Log.log(0x4000000L, "Changing slide to " + url + " after retiving it from net");
                    this.setNeedsDisplay();
                }
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
        }
    }

    public synchronized void start() {
        if (this.st != null) {
            this.st.start();
            Log.log(0x204000000L, "Slideshow started");
        } else {
            Log.log(0x204000000L, "Slideshow not started, probably due to no slides in round");
        }
    }

    public synchronized void join() {
        try {
            if (this.st != null) {
                this.st.join();
                this.st = null;
                Log.log(0x204000000L, "Slideshow joined");
            }
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
        this.clean();
    }

    public synchronized void quit() {
        try {
            if (this.st != null) {
                if (this.st.isAlive()) {
                    this.quit = true;
                    this.st.interrupt();
                    this.st.join();
                }
                this.st = null;
                Log.log(0x204000000L, "Slideshow quitted");
            }
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
        this.clean();
    }

    private void clean() {
        if (this.slides != null) {
            Enumeration e = this.slides.elements();
            while (e.hasMoreElements()) {
                Slideshow.Slide s = (Slideshow.Slide)e.nextElement();
                Resource res = ResourceManager.instance().getResourceOnlyFromCache(s.url);
                if (res == null) continue;
                Log.log(0x4000000L, "Releasing memory for " + res.getID());
                ResourceManager.instance().releaseData(res);
            }
        }
    }

    public void setActive(boolean flag) {
        super.setActive(flag);
        Log.log(0x204000000L, "Slideshow active " + this.active);
    }

    public void setSlides(Vector slides) {
        this.slides = slides;
        if (this.slides != null && this.st == null) {
            this.st = new Thread(this);
        }
    }
}

