/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui;

import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.screen.tab.tv.FullScreenController;
import se.tactel.tvclient.gui.windowing.ApplicationCanvas;
import se.tactel.tvclient.player.TVPlayer;
import se.tactel.tvclient.util.Log;

public class TVView
extends View {
    private boolean hide = false;
    public FullScreenController fsc = null;

    public TVView() {
        this.opaque = true;
    }

    public synchronized void setActive(boolean flag) {
        if (this.active != flag) {
            this.active = flag;
            TVPlayer player = ServiceRegistry.instance().getPlayer();
            if (player == null) {
                throw new RuntimeException("Use of player before it has been created.");
            }
            if (this.active && !ServiceRegistry.instance().getWindowServer().getLockDrawing()) {
                if (player.isPlayerVisible()) {
                    Log.log(0x200020000L, "TVView made active, TV already visible in " + this.frame + ".");
                }
            } else {
                Log.log(0x200020000L, "TVView made unactive, hiding TV.");
                player.hide();
                this.parent.setNeedsDisplay();
                ServiceRegistry.instance().getWindowServer().redraw();
            }
        }
    }

    public synchronized void showTv(boolean flag) {
        boolean bl = this.hide = !flag;
        if (this.active && !ServiceRegistry.instance().getWindowServer().getLockDrawing()) {
            TVPlayer player = ServiceRegistry.instance().getPlayer();
            ApplicationCanvas ac = (ApplicationCanvas)ServiceRegistry.instance().getWindowServer().canvas();
            if (flag) {
                if (player != null && !player.isPlayerVisible()) {
                    this.parent.setNeedsDisplay();
                    player.show(new Rect(this.frame));
                    ac.repaint();
                    ac.serviceRepaints();
                }
            } else if (player != null && player.isPlayerVisible()) {
                this.parent.setNeedsDisplay();
                player.hide();
                ac.repaint();
                ac.serviceRepaints();
            }
        }
    }

    public void hideAndRepaint(boolean orderBack) {
        this.hide = true;
        this.setNeedsDisplay();
        if (ServiceRegistry.instance().getPlayer().isPlayerVisible()) {
            this.showTv(false);
            if (orderBack) {
                ServiceRegistry.instance().getController().getTvScreenWindow().orderBack();
            }
            ApplicationCanvas ac = (ApplicationCanvas)ServiceRegistry.instance().getWindowServer().canvas();
            ac.repaint();
            ac.serviceRepaints();
        }
    }

    public void hideAndRepaintActive() {
        this.hide = true;
        this.setNeedsDisplay();
        ApplicationCanvas ac = (ApplicationCanvas)ServiceRegistry.instance().getWindowServer().canvas();
        ac.repaint();
        ac.serviceRepaints();
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        Rect clip = g.getClipRect();
        g.setClipRect(rect);
        TVPlayer player = ServiceRegistry.instance().getPlayer();
        if (!player.isRunning() || this.hide) {
            if (!this.hide && this.backgroundImage != null) {
                g.drawImageRectCenterdInRect(this.backgroundImage, this.frame, this.frame);
            } else {
                g.setColor(this.backgroundColor);
                g.fillRect(rect);
            }
        } else {
            ServiceRegistry.instance().getWindowServer().canvas().repaint();
        }
        g.setClipRect(clip);
    }
}

