/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.common;

import javax.microedition.lcdui.Font;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.GraphicUtils;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.position.Size;
import se.tactel.tvclient.gui.userdialog.UserDialogContainerView;

public class TextView
extends View {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    protected String text;
    protected Font font = Font.getFont((int)0, (int)0, (int)8);
    protected int textcolor = -16777216;
    protected int highlightTextcolor = -16777216;
    protected int alignment = 0;
    protected String anchor = "start";
    protected int inset = 3;
    protected boolean yCenter = true;

    public TextView() {
        this.opaque = false;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setText(int localizationId) {
        if (localizationId != -1) {
            this.setText(ServiceRegistry.instance().getLocalization().getString(localizationId));
        }
    }

    public void setFrame(Rect rect) {
        super.setFrame(rect);
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public Font getFont() {
        return this.font;
    }

    public void setTextColor(int color) {
        this.textcolor = color;
    }

    public void setHighlightTextColor(int color) {
        this.highlightTextcolor = color;
    }

    public int getTextColor() {
        return this.textcolor;
    }

    public void setTextColors(int color) {
        this.textcolor = this.highlightTextcolor = color;
    }

    public void setInset(int inset) {
        this.inset = inset;
    }

    public void setYCenter(boolean flag) {
        this.yCenter = flag;
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        Rect clip = g.getClipRect();
        super.drawInRect(g, rect);
        g.setClipRect(rect.rectByIntersectingRect(clip));
        g.setColor(this.highlight ? this.highlightTextcolor : this.textcolor);
        g.setFont(this.font);
        if (this.text != null) {
            int center = 0;
            if (this.yCenter) {
                center = (this.frame.height - this.font.getHeight()) / 2;
            }
            String t = GraphicUtils.sizeStringToWidthForFontAndAddDots(this.text, this.frame.width - 2 * this.inset, this.font, true);
            switch (this.alignment) {
                case 2: {
                    g.drawString(t, this.frame.x + this.frame.width - this.inset, this.frame.y + center, 24);
                    break;
                }
                case 1: {
                    g.drawString(t, this.frame.x + this.frame.width / 2, this.frame.y + center, 17);
                    break;
                }
                default: {
                    g.drawString(t, this.frame.x + this.inset, this.frame.y + center, 20);
                }
            }
        }
        g.setClipRect(clip);
    }

    public void sizeToFit() {
        if (this.font != null && this.text != null) {
            this.frame.setSize(new Size(this.font.stringWidth(this.text) + 2 * this.inset, this.font.getHeight()));
        } else {
            this.frame.setSize(new Size(20, 20));
        }
    }

    public void setAlignment(int align) {
        this.alignment = align;
    }

    public boolean isTextLongerThenView() {
        return this.frame != null && this.text != null && this.frame.width < this.font.stringWidth(this.text);
    }

    public void scale(double sfX, double sfY) {
        super.scale(sfX, sfY);
        int scaledPartOfFont = (int)((double)this.font.getHeight() - (double)this.font.getHeight() * sfY);
        this.relativeOrgin.y -= scaledPartOfFont;
        this.frame.y -= scaledPartOfFont;
        this.sizeToFit();
        if (this.parent != null && !(this.parent instanceof UserDialogContainerView)) {
            if (this.anchor.equals("middle")) {
                this.frame.x -= this.frame().width / 2;
                this.relativeOrgin.x -= this.frame().width / 2;
            } else if (this.anchor.equals("end")) {
                this.frame.x -= this.frame().width;
                this.relativeOrgin.x -= this.frame().width;
            }
        }
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public String getText() {
        return this.text;
    }
}

