/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.graphics;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.util.Log;

public class TactelGraphics {
    Graphics g;

    TactelGraphics() {
    }

    public void useGraphics(Graphics g) {
        this.g = g;
    }

    public Graphics graphics() {
        return this.g;
    }

    public void setColor(int red, int green, int blue) {
        this.g.setColor(red, green, blue);
    }

    public void setColor(int RGB) {
        this.g.setColor(RGB);
    }

    public void setStrokeStyle(int style) {
        this.g.setStrokeStyle(style);
    }

    public int getStrokeStyle() {
        return this.g.getStrokeStyle();
    }

    public Font getFont() {
        return this.g.getFont();
    }

    public void setFont(Font font) {
        this.g.setFont(font);
    }

    public Rect getClipRect() {
        return new Rect(this.g.getClipX(), this.g.getClipY(), this.g.getClipWidth(), this.g.getClipHeight());
    }

    public void setClipRect(Rect rect) {
        this.g.setClip(rect.x, rect.y, rect.width, rect.height);
    }

    public void copyArea(Rect source, Point dest, int anchor) {
        this.g.copyArea(source.x, source.y, source.width, source.height, dest.x, dest.y, anchor);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(x1, y1, x2, y2);
    }

    public void drawArc(Rect rect, int startAngle, int arcAngle) {
        this.g.drawArc(rect.x, rect.y, rect.width, rect.height, startAngle, arcAngle);
    }

    public void drawImageAtPoint(Image img, Point point) {
        this.g.drawImage(img, point.x, point.y, 20);
    }

    public void drawImageRectCenterdInRect(Image img, Rect rect, Rect frame) {
        Point imageOrigin = new Point(frame.x + (frame.width - img.getWidth()) / 2, frame.y + (frame.height - img.getHeight()) / 2);
        Rect imageRect = new Rect(imageOrigin.x, imageOrigin.y, img.getWidth(), img.getHeight());
        if (imageRect.intersectsRect(rect)) {
            imageRect = rect.rectByIntersectingRect(imageRect);
            try {
                this.g.drawRegion(img, imageRect.x - imageOrigin.x, imageRect.y - imageOrigin.y, imageRect.width, imageRect.height, 0, imageRect.x, imageRect.y, 20);
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
        }
    }

    public void drawRect(int x, int y, int width, int height) {
        this.g.drawRect(x, y, width, height);
    }

    public void drawRect(Rect rect) {
        this.g.drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRect(Rect rect, Point rounding) {
        this.g.drawRoundRect(rect.x, rect.y, rect.width, rect.height, rounding.x, rounding.y);
    }

    public void fillRect(Rect rect) {
        this.g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRect(Rect rect, Point rounding) {
        this.g.fillRoundRect(rect.x, rect.y, rect.width, rect.height, rounding.x, rounding.y);
    }

    public void drawString(String string, int x, int y, int anchor) {
        this.g.drawString(string, x, y, anchor);
    }
}

