/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.loading;

import java.util.Vector;
import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Slideshow;
import se.tactel.tvclient.gui.SlideImageView;
import se.tactel.tvclient.gui.common.ProgressView;
import se.tactel.tvclient.gui.common.core.ContainerView;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Images;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.util.Log;

public class SplashController {
    Window myWindow = null;
    ContainerView splashView = null;
    SlideImageView slideImageView = null;
    ProgressView progressView = null;

    public Window create() {
        this.splashView = new ContainerView();
        this.splashView.setFrame(new Rect(Skin.SCREEN_RECT));
        this.splashView.setBackgroundColor(-1972760);
        this.splashView.setDrawsBackground(true);
        this.slideImageView = new SlideImageView(null, false, new Rect(Skin.SCREEN_RECT), Images.getLoadingScreenSplash());
        this.slideImageView.setOpaque(false);
        this.splashView.addSubview(this.slideImageView);
        this.progressView = new ProgressView(5, -2142920010, -1);
        this.progressView.setBackgroundImage(Images.getLoadingProgressBar());
        this.progressView.setFrame(new Rect(Skin.SPLASH_BAR_FRAME));
        this.splashView.addSubview(this.progressView);
        this.myWindow = new Window(){

            public boolean event(Event event) {
                int key;
                if (event.type() == 1 && (key = event.keyCode()) == -7) {
                    RichMediaMIDlet.instance().endApplication();
                    return true;
                }
                return false;
            }
        };
        View exitView = new View();
        exitView.setFrame(new Rect(Skin.SPLASH_EXIT_FRAME));
        exitView.setBackgroundImage(Images.getLoadingScreenExit());
        exitView.setDrawsBackground(true);
        this.splashView.addSubview(exitView);
        this.myWindow.makeModal();
        this.myWindow.setContentView(this.splashView);
        this.myWindow.orderFront();
        return this.myWindow;
    }

    public void clean() {
        Log.log(0x4000010L, "Splash cleaned up");
        if (this.slideImageView != null) {
            this.slideImageView.quit();
        }
        Images.cleanLoadingProgressBar();
        Images.cleanLoadingScreenSplash();
        this.myWindow.close();
        this.slideImageView = null;
    }

    public void createSlideshow() {
        Vector slidesToDisplay = ServiceRegistry.instance().getLocalConfiguration().getCurrentSlideshowGroup().startupSlides;
        if (slidesToDisplay.size() == 0) {
            Slideshow.Slide s = new Slideshow.Slide();
            s.url = "res://screen/loading/default_startup_splash_1.png";
            s.order = 1;
            s.duration = 4;
            slidesToDisplay.addElement(s);
            s = new Slideshow.Slide();
            s.url = "res://screen/loading/default_startup_splash_2.png";
            s.order = 2;
            s.duration = 4;
            slidesToDisplay.addElement(s);
            s = new Slideshow.Slide();
            s.url = "res://screen/loading/default_startup_splash_3.png";
            s.order = 3;
            s.duration = 4;
            slidesToDisplay.addElement(s);
        }
        Log.log(0x4000000L, "Displaying startup slide group: " + slidesToDisplay.toString());
        this.slideImageView.setSlides(slidesToDisplay);
        this.slideImageView.start();
        this.splashView.setNeedsDisplay();
    }

    public void progress() {
        this.progressView.advanceProgress();
    }
}

