/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.option;

import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.gui.common.TextView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Fonts;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.position.Size;
import se.tactel.tvclient.gui.screen.exit.ExitWindow;
import se.tactel.tvclient.gui.screen.wait.WaitWindow;
import se.tactel.tvclient.player.TVPlayerListener;
import se.tactel.tvclient.util.Log;

public class OptionsMenuItem
extends View {
    public static final OptionsMenuItem EXIT_BUTTON;
    public static final OptionsMenuItem HELP_NEWS_BUTTON;
    public static final OptionsMenuItem HELP_TV_BUTTON;
    public static final OptionsMenuItem HELP_CHANNELS_BUTTON;
    public static final OptionsMenuItem HELP_SHOP_BUTTON;
    public static final OptionsMenuItem HELP_GUIDE_BUTTON;
    public static final OptionsMenuItem VOLUME_BUTTON;
    public static final OptionsMenuItem MUTE_BUTTON;
    private View containedView;

    private OptionsMenuItem() {
        this.setFrame(new Rect(0, 0, Skin.OPTIONS_MENU_ITEM_SIZE.width, Skin.OPTIONS_MENU_ITEM_SIZE.height));
    }

    public static OptionsMenuItem createButtonMenuItem() {
        TextView textView = new TextView();
        textView.setBackgroundColor(-1);
        textView.setBackgroundColor(-16776961);
        textView.setOpaque(false);
        textView.setAlignment(0);
        textView.setHighlightTextColor(-1);
        textView.setFont(Fonts.NORMAL_BOLD);
        return OptionsMenuItem.createCustomMenuItem(textView);
    }

    public static OptionsMenuItem createCustomMenuItem(View v) {
        OptionsMenuItem item = new OptionsMenuItem();
        v.setFrame(new Rect(0, 0, Skin.OPTIONS_MENU_ITEM_SIZE.width, Skin.OPTIONS_MENU_ITEM_SIZE.height));
        item.containedView = v;
        item.addSubview(v);
        return item;
    }

    public void setText(int localizationId) {
        if (this.containedView instanceof TextView) {
            TextView textView = (TextView)this.containedView;
            textView.setText(localizationId);
            textView.sizeToFit();
        }
    }

    public void setAction(Action action) {
        this.containedView.setAction(action);
    }

    public void setEnabled(boolean flag) {
        this.containedView.setEnabled(flag);
        if (this.containedView instanceof TextView) {
            if (flag) {
                ((TextView)this.containedView).setTextColor(-16777216);
                ((TextView)this.containedView).setHighlightTextColor(-1);
                ((TextView)this.containedView).setFont(Fonts.NORMAL_BOLD);
                ((TextView)this.containedView).sizeToFit();
            } else {
                ((TextView)this.containedView).setTextColor(-8618359);
                ((TextView)this.containedView).setHighlightTextColor(-8618359);
                ((TextView)this.containedView).setFont(Fonts.NORMAL_ITALIC);
                ((TextView)this.containedView).sizeToFit();
            }
        }
    }

    public boolean isEnabled() {
        return this.containedView.isEnabled();
    }

    private static OptionsMenuItem createHelpMenuItem(final String helpDialog) {
        OptionsMenuItem helpOptionsMenuItem = OptionsMenuItem.createButtonMenuItem();
        helpOptionsMenuItem.setText(100);
        helpOptionsMenuItem.setAction(new Action(){

            public void clicked(View sender) {
                if (ServiceRegistry.instance().getDataProvider().getConfig().getUserDialogUrl(helpDialog) != null) {
                    new WaitWindow(ServiceRegistry.instance().getDataProvider().getConfig().getUserDialogUrl(helpDialog)).makeKeyAndOrderFront();
                } else {
                    Log.log(0x100000000L, "No URL available for downloading help screen");
                }
                ServiceRegistry.instance().getController().closeOptionMenuWindow();
            }
        });
        return helpOptionsMenuItem;
    }

    private static OptionsMenuItem createMuteMenuItem() {
        final OptionsMenuItem muteOptionsMenuItem = OptionsMenuItem.createButtonMenuItem();
        muteOptionsMenuItem.setText(3003);
        muteOptionsMenuItem.setAction(new Action(){

            public void clicked(View sender) {
                ServiceRegistry.instance().getController().closeOptionMenuWindow();
                boolean previousMuteState = ServiceRegistry.instance().getPlayer().isMuted();
                ServiceRegistry.instance().getPlayer().setMutedFromUser(!previousMuteState);
                muteOptionsMenuItem.setText(previousMuteState ? 3003 : 3004);
                muteOptionsMenuItem.setNeedsDisplay();
            }
        });
        ServiceRegistry.instance().getPlayer().addTVPlayerListener(new TVPlayerListener(){

            public void playerMuteStateChanged(boolean muted) {
                muteOptionsMenuItem.setText(muted ? 3004 : 3003);
                muteOptionsMenuItem.setNeedsDisplay();
            }

            public void playerDroppedFromStream() {
            }

            public void playerStarted() {
            }

            public void playerIsStarting() {
            }

            public void badNinRespons() {
            }

            public void playerIsAttemptingToSwitchChannel(Channel c) {
            }

            public void playerStopped() {
            }

            public void playerSwitchChannelAttemptFailed(Channel c) {
            }
        });
        return muteOptionsMenuItem;
    }

    private static OptionsMenuItem createVolumeMenuItem() {
        return null;
    }

    public int getDesiredWidthOfItem() {
        return Math.max(this.containedView.frame().width, Skin.OPTIONS_MENU_ITEM_SIZE.width);
    }

    public void setCustomWidth(int w) {
        Rect changedRect = new Rect(this.frame);
        changedRect.setSize(new Size(w, this.frame.height));
        this.setFrame(changedRect);
    }

    public void resetToDefaultWidth() {
        Rect changedRect = new Rect(this.frame);
        changedRect.setSize(Skin.OPTIONS_MENU_ITEM_SIZE);
        this.setFrame(changedRect);
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        Rect clip = g.getClipRect();
        g.setClipRect(rect);
        if (this.highlight) {
            g.setColor(-12213578);
        } else {
            g.setColor(-1);
        }
        g.fillRect(this.frame);
        g.setClipRect(clip);
        super.drawInRect(g, rect);
    }

    static {
        HELP_NEWS_BUTTON = OptionsMenuItem.createHelpMenuItem("help.novedades");
        HELP_TV_BUTTON = OptionsMenuItem.createHelpMenuItem("help.tv");
        HELP_CHANNELS_BUTTON = OptionsMenuItem.createHelpMenuItem("help.parrilla");
        HELP_SHOP_BUTTON = OptionsMenuItem.createHelpMenuItem("help.tienda");
        HELP_GUIDE_BUTTON = OptionsMenuItem.createHelpMenuItem("help.guia");
        VOLUME_BUTTON = OptionsMenuItem.createVolumeMenuItem();
        MUTE_BUTTON = OptionsMenuItem.createMuteMenuItem();
        EXIT_BUTTON = OptionsMenuItem.createButtonMenuItem();
        EXIT_BUTTON.setText(101);
        EXIT_BUTTON.setAction(new Action(){

            public void clicked(View sender) {
                new ExitWindow(true).makeKeyAndOrderFront();
                ServiceRegistry.instance().getController().closeOptionMenuWindow();
            }
        });
    }
}

