/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.option;

import se.tactel.tvclient.gui.common.ButtonBar;
import se.tactel.tvclient.gui.common.FadeView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.screen.option.OptionsMenuItem;
import se.tactel.tvclient.gui.screen.option.OptionsView;
import se.tactel.tvclient.gui.windowing.NotPossibleToGoBackWindow;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.gui.windowing.WindowDelegate;

public class OptionsMenuWindow
extends Window
implements NotPossibleToGoBackWindow,
WindowDelegate {
    public OptionsMenuWindow(OptionsMenuItem[] menuItems) {
        ButtonBar buttonBar = ButtonBar.createDefaultButtonBar(this);
        buttonBar.setRightSoftKeyTextAndAction(2, new Action(){

            public void clicked(View sender) {
                OptionsMenuWindow.this.closeOptionsMenu();
            }
        });
        buttonBar.setLeftSoftKeyTextAndAction(3, new Action(){

            public void clicked(View sender) {
                OptionsMenuWindow.this.contentView().event(Event.keyEvent(1, -5));
            }
        });
        this.setButtonBar(buttonBar);
        this.updateItems(menuItems);
        this.setDelegate(this);
    }

    public void updateItems(OptionsMenuItem[] menuItems) {
        OptionsView optionsView = new OptionsView(menuItems);
        Rect r = new Rect(optionsView.frame());
        r.setOrgin(new Point(4, Skin.MAIN_FRAME_INCLUDING_STATUSBAR.height - optionsView.frame().height));
        optionsView.setFrame(r);
        FadeView fadeBackgroundView = new FadeView();
        fadeBackgroundView.setOpaque(false);
        fadeBackgroundView.setFrame(new Rect(Skin.MAIN_FRAME_INCLUDING_STATUSBAR));
        fadeBackgroundView.addSubview(optionsView);
        this.setContentView(fadeBackgroundView);
    }

    public boolean eventForWindow(Event event, Window window) {
        if (event.type() == 1 && event.keyCode() == -11) {
            this.closeOptionsMenu();
            return true;
        }
        return false;
    }

    public void windowDidBecomeTopWindow(Window window) {
    }

    public void windowDidLoseTopWindow(Window window) {
    }

    private void closeOptionsMenu() {
        this.goBack();
        this.close();
    }
}

