/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.option;

import se.tactel.tvclient.gui.common.ScrollableListView;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.position.Size;
import se.tactel.tvclient.gui.screen.option.OptionsMenuItem;

public class OptionsView
extends View {
    public OptionsView(OptionsMenuItem[] menuItems) {
        int totalHeightOfMenuItems = 0;
        int maximumWidthOfMenuItem = 0;
        for (int i = 0; i < menuItems.length; ++i) {
            OptionsMenuItem optionsMenuItem = menuItems[i];
            if (optionsMenuItem == null) continue;
            totalHeightOfMenuItems += optionsMenuItem.frame().height;
            maximumWidthOfMenuItem = Math.max(maximumWidthOfMenuItem, optionsMenuItem.getDesiredWidthOfItem());
            optionsMenuItem.setHighlight(false);
            optionsMenuItem.resetToDefaultWidth();
        }
        this.setFrame(new Rect().setSize(new Size(maximumWidthOfMenuItem + 8, totalHeightOfMenuItems + 8)));
        this.setBackgroundColor(-1);
        this.setOpaque(true);
        this.setDrawsBackground(true);
        ScrollableListView scrollableListView = new ScrollableListView(true);
        scrollableListView.setWrapAround(true);
        Rect listRect = new Rect((this.frame.width - maximumWidthOfMenuItem) / 2, (this.frame.height - totalHeightOfMenuItems) / 2, maximumWidthOfMenuItem, totalHeightOfMenuItems);
        scrollableListView.setFrame(listRect);
        scrollableListView.setHighlight(true);
        this.addSubview(scrollableListView);
        for (int i = 0; i < menuItems.length; ++i) {
            OptionsMenuItem optionsMenuItem = menuItems[i];
            if (optionsMenuItem == null) continue;
            optionsMenuItem.setCustomWidth(maximumWidthOfMenuItem);
            scrollableListView.addSubview(optionsMenuItem);
        }
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        super.drawInRect(g, rect);
        g.setColor(-16777216);
        g.fillRect(new Rect(this.frame.x, this.frame.y, 2, this.frame.height));
        g.fillRect(new Rect(this.frame.x, this.frame.y, this.frame.width, 2));
        g.fillRect(new Rect(this.frame.x + this.frame.width - 2, this.frame.y, 2, this.frame.height));
    }
}

