/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.tab.store.pack;

import java.util.Enumeration;
import se.tactel.tvclient.Controller;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.ChannelList;
import se.tactel.tvclient.data.Epg;
import se.tactel.tvclient.data.Folder;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.Observer;
import se.tactel.tvclient.gui.RectView;
import se.tactel.tvclient.gui.channellist.ChannelListItemView;
import se.tactel.tvclient.gui.channellist.ChannelListView;
import se.tactel.tvclient.gui.common.ButtonBar;
import se.tactel.tvclient.gui.common.ButtonView;
import se.tactel.tvclient.gui.common.ImageView;
import se.tactel.tvclient.gui.common.TextView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.HighlightContainerView;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Fonts;
import se.tactel.tvclient.gui.constants.Images;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.screen.option.OptionsMenuItem;
import se.tactel.tvclient.gui.screen.tab.store.StoreWindow;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class PackStoreWindow
extends StoreWindow
implements Observer {
    private ChannelListView packChannelsListView;
    private TextView titleTextView;
    private ButtonView comprarButton;
    private HighlightContainerView topLevelView;
    private RectView lineView;
    boolean isTopWindow = false;
    private Folder folderToDisplay;
    private Channel channelContext;

    public PackStoreWindow(Controller controller) {
        super(controller);
        OptionsMenuItem[] menuItems = new OptionsMenuItem[]{this.OPEN, this.GOTO_START_WINDOW, OptionsMenuItem.HELP_SHOP_BUTTON, OptionsMenuItem.EXIT_BUTTON};
        this.setOptionMenuItems(menuItems);
        this.setButtonBar(ButtonBar.createDefaultButtonBar(this));
        this.setContentView(this.createUI());
        this.setupObservers();
    }

    private View createUI() {
        this.topLevelView = new HighlightContainerView();
        this.topLevelView.setWrapKeyViews(true);
        this.topLevelView.setFrame(new Rect(Skin.MAIN_FRAME_EXCLUDING_INTERACTIVITY_VIEW));
        this.topLevelView.setOpaque(true);
        this.topLevelView.setBackgroundColor(-1972760);
        this.topLevelView.setDrawsBackground(true);
        ImageView sntImg = new ImageView(new Rect(Skin.SNT_TAB_IMAGE_FRAME), Images.getSNTImage(4));
        this.topLevelView.addSubview(sntImg);
        View shadeview = new View();
        shadeview.setFrame(new Rect(Skin.SHADE_FRAME));
        shadeview.setDrawsBackground(true);
        shadeview.setBackgroundImage(Images.getShade());
        this.topLevelView.addSubview(shadeview);
        this.titleTextView = new TextView();
        this.titleTextView.setFrame(new Rect(Skin.STORE_PACK_TITLE_FRAME));
        this.titleTextView.setAlignment(1);
        this.titleTextView.setFont(Fonts.NORMAL_BOLD);
        this.topLevelView.addSubview(this.titleTextView);
        this.comprarButton = new ButtonView();
        this.comprarButton.setFrame(new Rect(Skin.STORE_PACK_BUTTON_FRAME));
        this.comprarButton.setDrawsBackground(true);
        this.comprarButton.setTextColor(-16777216);
        this.comprarButton.setHighlightTextColor(-16777216);
        this.comprarButton.setFont(Fonts.NORMAL);
        this.comprarButton.setText(301);
        this.comprarButton.setBackgroundImage(Images.getButton());
        this.comprarButton.setHighlightBackgroundImage(Images.getButtonHighlight());
        this.comprarButton.setHighlight(false);
        this.topLevelView.addSubview(this.comprarButton);
        this.lineView = new RectView();
        this.lineView.setStrokeColor(-7894645);
        this.lineView.setFrame(new Rect(Skin.STORE_PACK_CHANNEL_LIST_LINE_LOWER_FRAME));
        this.topLevelView.addSubview(this.lineView);
        this.packChannelsListView = new ChannelListView();
        this.packChannelsListView.setHighlight(false);
        this.packChannelsListView.setWrapAround(false);
        this.packChannelsListView.setFrame(new Rect(Skin.STORE_PACK_CHANNEL_LIST_SMALLER_FRAME));
        this.topLevelView.addSubview(this.packChannelsListView);
        return this.topLevelView;
    }

    public void windowDidBecomeTopWindow(Window window) {
        super.windowDidBecomeTopWindow(window);
        this.packChannelsListView.didBecomeTop();
        this.isTopWindow = true;
    }

    public void windowDidLoseTopWindow(Window window) {
        super.windowDidLoseTopWindow(window);
        this.packChannelsListView.didLoseTop();
        this.isTopWindow = false;
    }

    public boolean eventForWindow(Event event, Window window) {
        if (this.comprarButton.isHighlighted() && event.type() == 1 && event.keyCode() == -1) {
            if (this.packChannelsListView.subviews().size() > 0) {
                View lastListItemView = (View)this.packChannelsListView.subviews().elementAt(this.packChannelsListView.subviews().size() - 1);
                this.packChannelsListView.scrollToItem(lastListItemView);
            }
            return false;
        }
        if (this.comprarButton.isHighlighted() && event.type() == 1 && event.keyCode() == -2) {
            if (this.packChannelsListView.subviews().size() > 0) {
                this.packChannelsListView.scrollToItem((View)this.packChannelsListView.subviews().elementAt(0));
            }
            return false;
        }
        return super.eventForWindow(event, window);
    }

    public void setPackToDisplayWithChannelContext(Folder f, Channel c) {
        this.channelContext = c;
        this.setPackToDisplay(f);
    }

    public void setPackToDisplay(Folder folder) {
        this.folderToDisplay = folder;
        Log.log(0x4000000000L, "Displaying for pack: " + this.folderToDisplay);
        this.packChannelsListView.flushItems();
        Enumeration e = this.folderToDisplay.getChildren();
        while (e.hasMoreElements()) {
            final Channel channel = (Channel)e.nextElement();
            if (!channel.isVisible()) continue;
            Log.log(0x4000000000L, "Adding: " + channel);
            ChannelListItemView channelListItemView = new ChannelListItemView(this.packChannelsListView, channel);
            if (!this.isTopWindow) {
                channelListItemView.deactivateTickers();
            }
            channelListItemView.setAction(new Action(){

                public void clicked(View sender) {
                    if (!channel.isUserVisible()) {
                        channel.setUserVisible(true);
                        ServiceRegistry.instance().getDataProvider().getChannelList().notifyObservers();
                    }
                    if (channel != null && !channel.isNotAvailable() && channel.isSubscribed() && (channel.getAdultUrl() == null || "".equals(channel.getAdultUrl()))) {
                        PackStoreWindow.this.controller.getTvScreenWindow().makeKeyAndOrderFront();
                    }
                    int resultCode = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().requestContentSwitch(channel);
                    switch (resultCode) {
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: {
                            PackStoreWindow.this.close();
                            break;
                        }
                    }
                }
            });
        }
        this.titleTextView.setText(this.folderToDisplay.getName());
        this.comprarButton.setAction(new Action(){

            public void clicked(View sender) {
                String url = PackStoreWindow.this.channelContext == null ? ServiceRegistry.instance().getDataProvider().getConfig().getContentOfferingUrl(PackStoreWindow.this.folderToDisplay) : ServiceRegistry.instance().getDataProvider().getConfig().getContentOfferingUrlForFolderWithChannelContext(PackStoreWindow.this.folderToDisplay, PackStoreWindow.this.channelContext);
                Log.log(0x4000000000L, "Initiating purchase for pack: " + url);
                Controller.popUpWaitWindowAndLoadUrl(url);
                Utils.sleep(300L);
                PackStoreWindow.this.channelContext = null;
            }
        });
        this.topLevelView.removeKeyView(this.comprarButton);
        this.topLevelView.removeKeyView(this.packChannelsListView);
        if (this.folderToDisplay.isPaymentAllowed() && !this.folderToDisplay.isSubscribed()) {
            if (this.comprarButton.parent() == null) {
                this.comprarButton.setFrame(new Rect(Skin.STORE_PACK_BUTTON_FRAME));
                this.topLevelView.addSubview(this.comprarButton);
            }
            this.topLevelView.addKeyView(this.comprarButton);
            this.topLevelView.addKeyView(this.packChannelsListView);
            this.comprarButton.setHighlight(true);
            this.packChannelsListView.setHighlight(false);
            this.packChannelsListView.setFrame(new Rect(Skin.STORE_PACK_CHANNEL_LIST_SMALLER_FRAME));
            this.lineView.setFrame(new Rect(Skin.STORE_PACK_CHANNEL_LIST_LINE_LOWER_FRAME));
        } else {
            this.comprarButton.removeFromParentView();
            this.topLevelView.addKeyView(this.packChannelsListView);
            this.comprarButton.setHighlight(false);
            this.packChannelsListView.setHighlight(true);
            this.packChannelsListView.setFrame(new Rect(Skin.STORE_PACK_CHANNEL_LIST_LARGER_FRAME));
            this.lineView.setFrame(new Rect(Skin.STORE_PACK_CHANNEL_LIST_LINE_HIGHER_FRAME));
        }
        this.topLevelView.setInitialKeyView(0);
        this.topLevelView.setNeedsDisplay();
    }

    private void setupObservers() {
        ServiceRegistry.instance().getDataProvider().getEpg().addObserver(this);
        ServiceRegistry.instance().getDataProvider().getChannelList().addObserver(this);
    }

    public void update(ObservableData data) {
        if (data instanceof Epg) {
            Log.log(0x4000000000L, "EPG triggered update in pack store window.");
            this.packChannelsListView.updateChannelsInList();
        } else if (data instanceof ChannelList) {
            Log.log(0x4000000000L, "Channed list triggered update in pack store window.");
            if (this.folderToDisplay != null) {
                this.setPackToDisplay(this.folderToDisplay);
            }
        }
    }
}

