/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.tab.tv;

import se.tactel.tvclient.Controller;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.Content;
import se.tactel.tvclient.data.CurrentContent;
import se.tactel.tvclient.gui.TVView;
import se.tactel.tvclient.gui.common.SimpleMultiTextView;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Fonts;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.interactivity.FullScreenSVGWindow;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.screen.wait.WaitWindow;
import se.tactel.tvclient.gui.windowing.NotPossibleToGoBackWindow;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.gui.windowing.WindowDelegate;
import se.tactel.tvclient.player.TVPlayerListener;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class FullScreenController
implements WindowDelegate,
TVPlayerListener,
Runnable {
    private WaitWindow waitWindow = null;
    private Window waitBkgWindow = null;
    private Window fullWindow = null;
    private TVView tvView;
    private Controller controller = null;
    private boolean activate;
    private Thread thread;

    public FullScreenController(Controller controller) {
        this.controller = controller;
        ServiceRegistry.instance().getPlayer().addTVPlayerListener(this);
    }

    public void run() {
        if (this.activate) {
            this.activateFullScreen();
        } else {
            this.deactivateFullScreen();
        }
        this.thread = null;
    }

    public void activateFullscreen() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.activate = true;
            this.thread.start();
        }
    }

    public void deactivateFullscreen() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.activate = false;
            this.thread.start();
        }
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean activateFullScreen() {
        ServiceRegistry.instance().getComm().startKeepalive();
        this.createWaitWindows();
        this.waitBkgWindow.orderBack();
        ServiceRegistry.instance().getWindowServer().orderOutAllWindows();
        this.waitBkgWindow.orderFront();
        this.waitWindow.makeKeyAndOrderFront();
        this.fullWindow = this.initFullscreenWindow(new Rect(Skin.TV_SCREEN_FULLSCREEN_FRAME));
        this.fullWindow.setDelegate(this);
        CurrentContent currentContent = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent();
        Content content = currentContent.getCurrentContent();
        ServiceRegistry.instance().getPlayer().setFullscreen(true);
        String tokenType = null;
        if (content instanceof Channel) {
            tokenType = ((Channel)content).getTokenType();
        }
        boolean success = ServiceRegistry.instance().getPlayer().orientationRestart();
        ServiceRegistry.instance().getComm().stopKeepalive();
        if (!success) {
            ServiceRegistry.instance().getPlayer().setFullscreen(false);
            Thread.yield();
            Utils.sleep(300L);
            Thread.yield();
        }
        FullScreenController fullScreenController = this;
        synchronized (fullScreenController) {
            Window topWin = ServiceRegistry.instance().getWindowServer().getTopmostWindow();
            if (!success) {
                this.controller.getStatusBarController().show();
                this.waitWindow.orderFront();
                ServiceRegistry.instance().getWindowServer().orderOutAllWindows();
                if (topWin instanceof FullScreenSVGWindow) {
                    topWin.makeKeyAndOrderFront();
                    this.controller.getTvScreenWindow().orderBack();
                } else {
                    this.controller.getTvScreenWindow().makeKeyAndOrderFront();
                }
                this.controller.getStatusBarController().show();
                this.removeWaitWindows();
                this.fullWindow = null;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateFullScreen() {
        CurrentContent currentContent = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent();
        Content content = currentContent.getCurrentContent();
        ServiceRegistry.instance().getPlayer().setFullscreen(false);
        ServiceRegistry.instance().getComm().startKeepalive();
        this.createWaitWindows();
        this.waitBkgWindow.orderFront();
        this.waitWindow.makeKeyAndOrderFront();
        this.fullWindow.close();
        String tokenType = null;
        if (content instanceof Channel) {
            tokenType = ((Channel)content).getTokenType();
        }
        ServiceRegistry.instance().getPlayer().orientationRestart();
        ServiceRegistry.instance().getComm().stopKeepalive();
        FullScreenController fullScreenController = this;
        synchronized (fullScreenController) {
            Window topWin = ServiceRegistry.instance().getWindowServer().getTopmostWindow();
            if (topWin instanceof FullScreenSVGWindow) {
                this.controller.getStatusBarController().show();
                this.waitWindow.orderFront();
                ServiceRegistry.instance().getWindowServer().orderOutAllWindows();
                this.controller.getTvScreenWindow().orderBack();
                topWin.makeKeyAndOrderFront();
            } else {
                this.controller.getTvScreenWindow().makeKeyAndOrderFront();
            }
            this.controller.getStatusBarController().show();
            this.removeWaitWindows();
        }
        this.fullWindow = null;
        this.tvView = null;
        this.controller.getStatusBarController().display();
    }

    private Window initFullscreenWindow(Rect frame) {
        Window window = new Window();
        window.setFrame(frame);
        this.tvView = new TVView();
        this.tvView.setFrame(frame);
        window.setContentView(this.tvView);
        return window;
    }

    private void removeWaitWindows() {
        if (this.waitWindow != null) {
            this.waitWindow.close();
            this.waitWindow = null;
        }
        if (this.waitBkgWindow != null) {
            this.waitBkgWindow.close();
            this.waitBkgWindow = null;
        }
    }

    public boolean eventForWindow(Event event, Window window) {
        if (window == this.fullWindow) {
            Log.log(0x2000000000L, "Event for fullscreen window");
            if (event.type() == 1) {
                switch (event.keyCode()) {
                    case -37: 
                    case -36: {
                        return false;
                    }
                    case 35: {
                        boolean muteState = ServiceRegistry.instance().getPlayer().isMuted();
                        ServiceRegistry.instance().getPlayer().setMutedFromUser(!muteState);
                        return true;
                    }
                }
                Log.log(0x2000000000L, "Key pressed - close fullscreen");
                this.deactivateFullscreen();
                return true;
            }
            if (event.type() == 2) {
                return true;
            }
        }
        return false;
    }

    public void windowDidBecomeTopWindow(Window window) {
        this.controller.getTvScreenWindow().orderOut();
        Log.log(0x2000000000L, "[*] Showing tv in fullscreen mode");
        this.tvView.setActive(true);
        this.tvView.showTv(true);
        ServiceRegistry.instance().getPlayer().setMutedWithoutNotifing(false);
    }

    public void windowDidLoseTopWindow(Window window) {
        Log.log(0x2000000000L, "[ ] Hiding tv in fullscreen mode");
        this.tvView.setActive(false);
        this.tvView.setNeedsDisplay();
        ServiceRegistry.instance().getPlayer().setMutedWithoutNotifing(true);
    }

    private void createWaitWindows() {
        this.waitWindow = Controller.getWaitWindow();
        this.waitWindow.setAutoClose(false);
        this.waitBkgWindow = new NoGoBackWindow();
        SimpleMultiTextView text = new SimpleMultiTextView();
        text.setFrame(new Rect(Skin.TV_SCREEN_FULLSCREEN_WAIT_TEXT_FRAME));
        text.setTextColor(-16777216);
        text.setAlignment(1);
        text.setFont(Fonts.NORMAL_BOLD);
        text.setText(205);
        View contentView = new View();
        contentView.addSubview(text);
        contentView.setBackgroundColor(-1);
        contentView.setDrawsBackground(true);
        this.waitBkgWindow.setContentView(contentView);
        this.waitBkgWindow.setFrame(new Rect(Skin.TV_SCREEN_FULLSCREEN_WAIT_FRAME));
    }

    public void playerStarted() {
        if (ServiceRegistry.instance().getPlayer().isFullscreen()) {
            this.fullWindow.orderBack();
            this.waitWindow.orderFront();
            ServiceRegistry.instance().getWindowServer().orderOutAllWindows();
            this.fullWindow.makeKeyAndOrderFront();
            if (this.tvView.isActive()) {
                Log.log(0x200000000L, "TV player started and TV view is active => Reactivating TV View in order to show player");
                this.tvView.setActive(true);
                this.tvView.showTv(true);
            } else {
                Log.log(0x200000000L, "TV player started and TV view is not active => NOT Reactivating TV View in order to show player");
            }
            this.removeWaitWindows();
        }
    }

    public void badNinRespons() {
        if (ServiceRegistry.instance().getPlayer().isFullscreen()) {
            this.deactivateFullscreen();
        }
    }

    public void playerIsStarting() {
    }

    public void playerDroppedFromStream() {
    }

    public void playerStopped() {
    }

    public void playerMuteStateChanged(boolean muted) {
    }

    public void playerIsAttemptingToSwitchChannel(Channel c) {
    }

    public void playerSwitchChannelAttemptFailed(Channel c) {
        if (ServiceRegistry.instance().getPlayer().isFullscreen()) {
            this.deactivateFullscreen();
        }
    }

    private static class NoGoBackWindow
    extends Window
    implements NotPossibleToGoBackWindow {
        private NoGoBackWindow() {
        }
    }
}

