/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.tab.tv;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import se.tactel.tvclient.Controller;
import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.Content;
import se.tactel.tvclient.data.CurrentContent;
import se.tactel.tvclient.data.Epg;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.Observer;
import se.tactel.tvclient.gui.TVView;
import se.tactel.tvclient.gui.channellist.ChannelIconView;
import se.tactel.tvclient.gui.common.ButtonBar;
import se.tactel.tvclient.gui.common.ImageView;
import se.tactel.tvclient.gui.common.SimpleMultiTextView;
import se.tactel.tvclient.gui.common.SpinnerView;
import se.tactel.tvclient.gui.common.TextView;
import se.tactel.tvclient.gui.common.TickerView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Fonts;
import se.tactel.tvclient.gui.constants.Images;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.screen.option.OptionsMenuItem;
import se.tactel.tvclient.gui.screen.tab.tv.FullScreenController;
import se.tactel.tvclient.gui.screen.tab.tv.TVWindow;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.player.TVPlayerListener;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class TvScreenController
implements TVPlayerListener,
Runnable {
    public TVWindow mainWindow = null;
    private View currChannelView = null;
    private ImageView hideUpImageView;
    private ImageView hideDownImageView;
    private ChannelIconView channelImage;
    private TextView currentChannelName = null;
    private TextView currentChannelInfo = null;
    public TVView playerView = null;
    Controller controller = null;
    private SpinnerView spinner = null;
    private Channel currentChannel = null;
    private int contentListIndex = 0;
    FullScreenController fullscreencontroller = null;
    private View restartText = null;
    private SimpleMultiTextView restartingText = null;
    private static final int REMOVE_RESTART_TEXT_WAIT_TIME = 3000;
    private View contentView = null;
    private String prevScrollNameStr = "";
    private String prevScrollInfoStr = "";
    private boolean blockChannelInfoScroll = false;
    private OptionsMenuItem goToWapOptionsMenuItem = null;
    private static final long INACTIVITY_TIMEOUT_VALUE = 5000L;
    private static final long INACTIVITY_TIMEOUT_START_SCROLL = 1000L;
    private Thread spinningTimeOutThread;
    private Action optionsAction = new Action(){

        public void clicked(View sender) {
            TvScreenController.this.playerView.hideAndRepaint(false);
            TvScreenController.this.mainWindow.showOptionsMenuWindow();
        }
    };
    private Thread t;

    public TvScreenController(Controller controller) {
        this.controller = controller;
    }

    public Window createWindow() {
        this.contentView = new View();
        this.contentView.setFrame(new Rect(Skin.MAIN_FRAME_EXCLUDING_INTERACTIVITY_VIEW));
        this.contentView.setBackgroundColor(-1972760);
        this.contentView.setDrawsBackground(true);
        this.contentView.setOpaque(true);
        ImageView sntImg = new ImageView(new Rect(Skin.SNT_TAB_IMAGE_FRAME), Images.getSNTImage(2));
        this.contentView.addSubview(sntImg);
        this.playerView = new TVView();
        this.playerView.setFrame(new Rect(Skin.TV_SCREEN_TV_FRAME));
        this.playerView.setBackgroundColor(-1972760);
        try {
            this.playerView.setBackgroundImage(Image.createImage((String)"/screen/tv/testbild.png"));
        }
        catch (IOException e) {
            Log.exception(this, e);
        }
        this.contentView.addSubview(this.playerView);
        ServiceRegistry.instance().getPlayer().addTVPlayerListener(this);
        ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().addContentSwitchingObserver(new Observer(){

            public void update(ObservableData data) {
                Channel channel = (Channel)ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().getCurrentContent();
                Log.log(524288L, "Channel switched: " + channel);
                Utils.sleep(4000L);
                TvScreenController.this.stopSpinning();
                TvScreenController.this.updateCurrentListChannel();
                String currId = TvScreenController.this.currentChannel.getId();
                TvScreenController.this.updateChannelListView(ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(currId));
                ServiceRegistry.instance().getTimeoutHandler().reset();
                TvScreenController.this.prevScrollNameStr = "";
                TvScreenController.this.prevScrollInfoStr = "";
            }
        });
        ServiceRegistry.instance().getDataProvider().getChannelList().addObserver(new Observer(){

            public void update(ObservableData data) {
                Log.log(524288L, "Channels updated");
                if (TvScreenController.this.currentChannel != null) {
                    TvScreenController.this.updateChannelListView(ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(TvScreenController.this.currentChannel.getId()));
                }
            }
        });
        ServiceRegistry.instance().getDataProvider().getEpg().addObserver(new Observer(){

            public void update(ObservableData data) {
                Log.log(524288L, "EPG data updated, refresh channel info");
                if (TvScreenController.this.currentChannel != null) {
                    TvScreenController.this.updateChannelListView(ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(TvScreenController.this.currentChannel.getId()));
                    ServiceRegistry.instance().getTimeoutHandler().reset();
                }
            }
        });
        ServiceRegistry.instance().getTimeoutHandler().addInactivityTimeout(5000L, new Action(){

            public void clicked(View sender) {
                Content currentlyStreamChannel = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().getCurrentContent();
                Log.log(524288L, "Key timeout, return to currently streamed channel: " + currentlyStreamChannel);
                if (TvScreenController.this.spinner.isSpinning()) {
                    Log.log(524288L, "Spinning, abort going back to current channel");
                    return;
                }
                if (!ServiceRegistry.instance().getPlayer().isRunning()) {
                    Log.log(524288L, "Not streaming, abort going back to current channel");
                    return;
                }
                if (currentlyStreamChannel == null) {
                    Log.log(524288L, "No current channel, abort going back to current channel");
                }
                if (TvScreenController.this.currentChannel != null) {
                    String prevId = TvScreenController.this.currentChannel.getId();
                    TvScreenController.this.updateCurrentListChannel();
                    String currId = TvScreenController.this.currentChannel.getId();
                    if (!prevId.equals(currId)) {
                        TvScreenController.this.updateChannelListView(ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(currId));
                        ServiceRegistry.instance().getTimeoutHandler().reset();
                    }
                }
            }
        });
        ServiceRegistry.instance().getTimeoutHandler().addInactivityTimeout(1000L, new Action(){

            public void clicked(View sender) {
                Log.log(524288L, "Key timeout, start scroll of current channel info");
                if (TvScreenController.this.currentChannel != null && !TvScreenController.this.blockChannelInfoScroll) {
                    TvScreenController.this.scrollChannelListView(ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(TvScreenController.this.currentChannel.getId()));
                }
            }
        });
        this.currChannelView = new View();
        this.currChannelView.setFrame(new Rect(Skin.TV_SCREEN_CURRENT_CHANNEL_FRAME));
        View currChannelBackImg = new View();
        currChannelBackImg.setFrame(new Rect(Skin.TV_SCREEN_CURRENT_CHANNEL_BACKGROUND_IMG_FRAME));
        currChannelBackImg.setBackgroundImage(Images.getTvScreenCurrentChannelBackground());
        currChannelBackImg.setBackgroundColor(-1972760);
        currChannelBackImg.setDrawsBackground(true);
        this.currChannelView.addSubview(currChannelBackImg);
        this.channelImage = new ChannelIconView();
        this.channelImage.setFrame(new Rect(Skin.TV_SCREEN_CURRENT_CHANNEL_VIEW_FRAME));
        this.currChannelView.addSubview(this.channelImage);
        String[] paths = new String[]{"/spinner/spinner01.png", "/spinner/spinner02.png", "/spinner/spinner03.png"};
        this.spinner = new SpinnerView();
        this.spinner.setFrame(new Rect(Skin.TV_SCREEN_CURRENT_CHANNEL_INFO_FRAME));
        this.spinner.useImagesWithPaths(paths);
        this.spinner.setBackgroundColor(-1972760);
        this.spinner.setDrawsBackground(true);
        this.currentChannelName = Skin.TV_SCREEN_CURRENT_CHANNEL_NAME_TICKER_IF_LONG ? new TickerView() : new TextView();
        this.currentChannelName.setFrame(new Rect(Skin.TV_SCREEN_CURRENT_CHANNEL_NAME_FRAME));
        this.currentChannelName.setFont(Fonts.NORMAL_BOLD);
        this.currentChannelName.setTextColors(-16777216);
        this.currChannelView.addSubview(this.currentChannelName);
        this.currentChannelInfo = Skin.TV_SCREEN_CURRENT_CHANNEL_INFO_TICKER_IF_LONG ? new TickerView() : new TextView();
        this.currentChannelInfo.setFrame(new Rect(Skin.TV_SCREEN_CURRENT_CHANNEL_INFO_FRAME));
        this.currentChannelInfo.setFont(Fonts.NORMAL);
        this.currentChannelInfo.setTextColors(-16777216);
        this.currChannelView.addSubview(this.currentChannelInfo);
        this.hideUpImageView = new ImageView(new Rect().setOrgin(Skin.TV_SCREEN_UP_ARROW_HIDER_POSITION).setSize(Skin.TV_SCREEN_HIDER_SIZE), Images.getTvScreenCurrentChannelBackgroundHideUp());
        this.hideDownImageView = new ImageView(new Rect().setOrgin(Skin.TV_SCREEN_DOWN_ARROW_HIDER_POSITION).setSize(Skin.TV_SCREEN_HIDER_SIZE), Images.getTvScreenCurrentChannelBackgroundHideDown());
        this.contentView.addSubview(this.currChannelView);
        this.mainWindow = new TVWindow(this);
        this.restartText = new View();
        Rect r = new Rect(Skin.TV_SCREEN_RESTART_TEXT);
        this.restartText.setFrame(r);
        this.restartText.setBackgroundColor(-1972760);
        this.restartText.setDrawsBackground(true);
        this.restartText.setOpaque(true);
        this.restartingText = new SimpleMultiTextView();
        this.restartingText.setFrame(r);
        this.restartingText.setVerticallyAlignment(true);
        this.restartingText.setAlignment(1);
        this.restartText.addSubview(this.restartingText);
        ButtonBar buttonBar = ButtonBar.createButtonBar();
        buttonBar.setLeftSoftKeyTextAndAction(1, this.optionsAction);
        this.mainWindow.setContentView(this.contentView);
        this.mainWindow.setButtonBar(buttonBar);
        this.mainWindow.setOptionMenuItems(this.createOptionsMenuItems());
        return this.mainWindow;
    }

    private void setFullscreen() {
        this.mainWindow.display();
        this.playerView.hideAndRepaint(false);
        if (this.fullscreencontroller == null) {
            this.fullscreencontroller = new FullScreenController(ServiceRegistry.instance().getController());
        }
        this.fullscreencontroller.activateFullscreen();
    }

    private void updateChannelListView(Content c) {
        String nameStr;
        if (c == null) {
            return;
        }
        String string = nameStr = c.getName() != null ? c.getName() : "";
        if (!nameStr.equals(this.currentChannelName.getText())) {
            this.currentChannelName.setText(nameStr);
            this.prevScrollNameStr = "";
        }
        this.currentChannelName.setEnabled(false);
        this.currentChannelName.setActive(true);
        this.currentChannelName.setNeedsDisplay();
        String infoStr = c.getDescription();
        Epg.EpgProgram prgInfo = ServiceRegistry.instance().getDataProvider().getEpg().getCurrentProgramForChannelWithId(c.getId());
        if (prgInfo != null) {
            infoStr = prgInfo.programName;
        }
        if (!infoStr.equals(this.currentChannelInfo.getText())) {
            this.currentChannelInfo.setText(infoStr);
            this.prevScrollInfoStr = "";
        }
        this.currentChannelInfo.setEnabled(false);
        this.currentChannelInfo.setActive(true);
        this.currentChannelInfo.setNeedsDisplay();
        this.channelImage.updateChannelToDisplay((Channel)c);
        if (this.goToWapOptionsMenuItem != null) {
            this.goToWapOptionsMenuItem.setEnabled(((Channel)c).getInformationUrl() != null && !"".equals(((Channel)c).getInformationUrl()));
        }
    }

    private void scrollChannelListView(Content c) {
        if (c == null) {
            return;
        }
        String nameStr = c.getName() != null ? c.getName() : "";
        this.currentChannelName.setText(nameStr);
        boolean scrollName = this.currentChannelName.getFont().stringWidth(nameStr) > this.currentChannelName.getFrame().width;
        boolean bl = scrollName = scrollName && !nameStr.equals(this.prevScrollNameStr);
        if (scrollName && this.currentChannelName instanceof TickerView) {
            ((TickerView)this.currentChannelName).setEnabled(true, 2, false);
            this.prevScrollNameStr = nameStr;
        }
        this.currentChannelName.setActive(true);
        this.currentChannelName.setNeedsDisplay();
        String infoStr = c.getDescription();
        Epg.EpgProgram prgInfo = ServiceRegistry.instance().getDataProvider().getEpg().getCurrentProgramForChannelWithId(c.getId());
        if (prgInfo != null) {
            infoStr = prgInfo.programName;
        }
        this.currentChannelInfo.setText(infoStr);
        boolean scrollInfo = this.currentChannelInfo.getFont().stringWidth(infoStr) > this.currentChannelInfo.getFrame().width;
        boolean bl2 = scrollInfo = scrollInfo && !infoStr.equals(this.prevScrollInfoStr);
        if (scrollInfo && this.currentChannelInfo instanceof TickerView) {
            ((TickerView)this.currentChannelInfo).setEnabled(scrollInfo, 2, false);
            this.prevScrollInfoStr = infoStr;
        }
        this.currentChannelInfo.setActive(true);
        this.currentChannelInfo.setNeedsDisplay();
    }

    public void startSpinning() {
        this.currentChannelInfo.setActive(false);
        this.currentChannelInfo.setEnabled(false);
        this.currChannelView.addSubview(this.spinner);
        this.spinner.start();
        this.currentChannelInfo.setNeedsDisplay();
        this.spinningTimeOutThread = new Thread(new SpinnerThread(this));
        this.spinningTimeOutThread.start();
    }

    private void stopSpinning() {
        this.spinner.stop();
        this.currChannelView.removeSubview(this.spinner);
        this.currChannelView.setNeedsDisplay();
        if (this.currentChannel != null) {
            this.updateChannelListView(ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(this.currentChannel.getId()));
        }
    }

    private void nextCurrentListChannel() {
        this.updateContentIndex();
        Vector channels = ServiceRegistry.instance().getDataProvider().getChannelList().getSortedVisibleChannels();
        if (channels == null || channels.size() < 1) {
            this.contentListIndex = 0;
            return;
        }
        ++this.contentListIndex;
        if (this.contentListIndex >= channels.size()) {
            this.contentListIndex = 0;
        }
        Log.log(524288L, "Next channel, index: " + this.contentListIndex);
        this.currentChannel = (Channel)channels.elementAt(this.contentListIndex);
        Log.log(524288L, "New list content: " + this.currentChannel);
    }

    private void prevCurrentListChannel() {
        this.updateContentIndex();
        Vector channels = ServiceRegistry.instance().getDataProvider().getChannelList().getSortedVisibleChannels();
        if (channels == null || channels.size() < 1) {
            this.contentListIndex = 0;
            return;
        }
        --this.contentListIndex;
        if (this.contentListIndex < 0) {
            this.contentListIndex = channels.size() - 1;
        }
        Log.log(524288L, "Prev channel, index: " + this.contentListIndex);
        this.currentChannel = (Channel)channels.elementAt(this.contentListIndex);
        Log.log(524288L, "New list content: " + this.currentChannel);
    }

    private void updateCurrentListChannel() {
        CurrentContent cc = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent();
        if (cc == null || cc.getCurrentContent() == null) {
            if (this.currentChannel == null) {
                return;
            }
        } else {
            this.currentChannel = (Channel)cc.getCurrentContent();
        }
    }

    private OptionsMenuItem[] createOptionsMenuItems() {
        OptionsMenuItem fullscreenOptionsMenuItem = OptionsMenuItem.createButtonMenuItem();
        fullscreenOptionsMenuItem.setText(121);
        fullscreenOptionsMenuItem.setAction(new Action(){

            public void clicked(View sender) {
                TvScreenController.this.controller.closeOptionMenuWindow();
                Content content = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().getCurrentContent();
                if (content != null) {
                    TvScreenController.this.setFullscreen();
                }
            }
        });
        fullscreenOptionsMenuItem.setEnabled(false);
        OptionsMenuItem channelListingOptionsMenuItem = OptionsMenuItem.createButtonMenuItem();
        channelListingOptionsMenuItem.setText(104);
        channelListingOptionsMenuItem.setAction(new Action(){

            public void clicked(View sender) {
                Content content = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().getCurrentContent();
                if (content != null) {
                    TvScreenController.this.controller.getGuideScreenController().showEpgForChannel((Channel)content);
                } else if (content == null && !"".equals(TvScreenController.this.currentChannelName.getText())) {
                    Vector allChannels = ServiceRegistry.instance().getDataProvider().getChannelList().getAllChannels();
                    Channel channelInChannelView = null;
                    for (int i = 0; i < allChannels.size(); ++i) {
                        if (!((Channel)allChannels.elementAt(i)).getName().equals(TvScreenController.this.currentChannelName.getText())) continue;
                        channelInChannelView = (Channel)allChannels.elementAt(i);
                        break;
                    }
                    if (channelInChannelView != null) {
                        try {
                            TvScreenController.this.controller.getGuideScreenController().showEpgForChannel(channelInChannelView);
                        }
                        catch (Exception e) {
                            Log.exception(this, e);
                        }
                    }
                }
                TvScreenController.this.controller.closeOptionMenuWindow();
            }
        });
        this.goToWapOptionsMenuItem = OptionsMenuItem.createButtonMenuItem();
        this.goToWapOptionsMenuItem.setEnabled(false);
        this.goToWapOptionsMenuItem.setText(103);
        this.goToWapOptionsMenuItem.setAction(new Action(){

            public void clicked(View sender) {
                TvScreenController.this.controller.closeOptionMenuWindow();
                Content content = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().getCurrentContent();
                if (content != null && content instanceof Channel) {
                    Channel channel = (Channel)content;
                    try {
                        RichMediaMIDlet.instance().platformRequest(channel.getInformationUrl());
                    }
                    catch (Exception e) {
                        Log.exception(this, e);
                    }
                } else if (content == null && !"".equals(TvScreenController.this.currentChannelName.getText())) {
                    Vector allChannels = ServiceRegistry.instance().getDataProvider().getChannelList().getAllChannels();
                    Channel channelInChannelView = null;
                    for (int i = 0; i < allChannels.size(); ++i) {
                        if (!((Channel)allChannels.elementAt(i)).getName().equals(TvScreenController.this.currentChannelName.getText())) continue;
                        channelInChannelView = (Channel)allChannels.elementAt(i);
                        break;
                    }
                    if (channelInChannelView != null) {
                        try {
                            RichMediaMIDlet.instance().platformRequest(channelInChannelView.getInformationUrl());
                        }
                        catch (Exception e) {
                            Log.exception(this, e);
                        }
                    }
                }
            }
        });
        OptionsMenuItem[] menuItems = null;
        menuItems = new OptionsMenuItem[]{fullscreenOptionsMenuItem, channelListingOptionsMenuItem, this.goToWapOptionsMenuItem, OptionsMenuItem.HELP_TV_BUTTON, OptionsMenuItem.EXIT_BUTTON};
        return menuItems;
    }

    public void enableOptionFullscreen(boolean enable) {
        if (this.mainWindow != null && this.mainWindow.getOptionMenuItems() != null && this.mainWindow.getOptionMenuItems()[0] != null) {
            this.mainWindow.getOptionMenuItems()[0].setEnabled(enable);
        }
    }

    public boolean handleEvent(Event event) {
        int numberKeyPressed;
        if (this.spinner.isSpinning()) {
            Log.log(524288L, "Key pressed while spinning, key ignored.");
            return true;
        }
        if (event.type() == 1) {
            int numberKeyPressed2 = Utils.getNumberKey(event.keyCode());
            if (numberKeyPressed2 > 0) {
                Channel c = ServiceRegistry.instance().getDataProvider().getChannelConfiguration().getFavoriteChannelData(numberKeyPressed2);
                String channelID = null;
                if (c != null) {
                    channelID = c.getId();
                }
                Channel shortcutContent = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(channelID);
                if (!channelID.equals("-1")) {
                    this.updateChannelListView(shortcutContent);
                    this.currentChannel = shortcutContent;
                    ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().requestContentSwitch(shortcutContent);
                }
            } else {
                switch (event.keyCode()) {
                    case -2: {
                        this.nextCurrentListChannel();
                        this.updateChannelListView(this.currentChannel);
                        this.animateDownArrow();
                        return true;
                    }
                    case -1: {
                        this.prevCurrentListChannel();
                        this.updateChannelListView(this.currentChannel);
                        this.animateUpArrow();
                        return true;
                    }
                    case -5: {
                        if (this.currentChannel != null) {
                            new Thread(this).run();
                        }
                        return true;
                    }
                    case 42: {
                        Content content = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().getCurrentContent();
                        if (content != null && ServiceRegistry.instance().getPlayer().isRunning()) {
                            Log.log(524288L, "Short key press on star - goto fullscreen/fullscreen notification");
                            this.setFullscreen();
                        }
                        return true;
                    }
                    case 35: {
                        boolean muteState = ServiceRegistry.instance().getPlayer().isMuted();
                        ServiceRegistry.instance().getPlayer().setMutedFromUser(!muteState);
                        return true;
                    }
                }
            }
        } else if (event.type() == 2 && (numberKeyPressed = Utils.getNumberKey(event.keyCode())) > 0) {
            Content c = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().getCurrentContent();
            System.out.println("Assign number " + numberKeyPressed + " to content " + c);
            System.out.println("Current channel = " + this.currentChannel);
            if (c != null) {
                Log.log(524288L, "Long key press on num key - assigned channel with ID " + c.getId() + "(" + c.getName() + ") to shortcut " + numberKeyPressed);
                Channel channelListChannel = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(c.getId());
                ServiceRegistry.instance().getDataProvider().getChannelConfiguration().insertContentAt(channelListChannel, numberKeyPressed);
                ServiceRegistry.instance().getDataProvider().getChannelList().notifyObservers();
            } else if (event.keyCode() == 35) {
                return true;
            }
            return true;
        }
        return false;
    }

    private void updateContentIndex() {
        if (this.currentChannel != null) {
            Vector channels = ServiceRegistry.instance().getDataProvider().getChannelList().getSortedVisibleChannels();
            this.contentListIndex = 0;
            while (this.contentListIndex < channels.size() && !((Content)channels.elementAt(this.contentListIndex)).getId().equals(this.currentChannel.getId())) {
                ++this.contentListIndex;
            }
            if (this.contentListIndex >= channels.size()) {
                Log.log(0x40080000L, "Could not find list index for currently active content");
                this.contentListIndex = 0;
            }
        }
    }

    private void animateUpArrow() {
        this.animateImageView(this.hideUpImageView);
    }

    private void animateDownArrow() {
        this.animateImageView(this.hideDownImageView);
    }

    private void animateImageView(final ImageView arrowImageView) {
        if (this.t == null || !this.t.isAlive()) {
            this.currChannelView.addSubview(arrowImageView);
            arrowImageView.setNeedsDisplay();
            this.t = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    TvScreenController.this.currChannelView.removeSubview(arrowImageView);
                    TvScreenController.this.currChannelView.setNeedsDisplay();
                }
            };
            this.t.start();
        }
    }

    public void run() {
        ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().requestContentSwitch(ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(this.currentChannel.getId()));
    }

    public void playerStarted() {
        new PlayerStartThread(this).start();
        TVView tvView = this.playerView;
        if (ServiceRegistry.instance().getWindowServer().getTopmostWindow() == this.mainWindow) {
            if (tvView.isActive()) {
                Log.log(0x200080000L, "TV player started and TV view is active => Reactivating TV View in order to show player");
                tvView.showTv(true);
            } else {
                Log.log(0x200080000L, "TV player started and TV view is not active => NOT Reactivating TV View in order to show player");
            }
        }
        this.enableOptionFullscreen(true);
    }

    public void badNinRespons() {
        this.restartText.removeFromParentView();
        this.contentView.setNeedsDisplay();
    }

    public void playerIsStarting() {
        this.restartingText.setText(ServiceRegistry.instance().getDataProvider().getConfig().getDisplayText());
        this.contentView.addSubview(this.restartText);
        ServiceRegistry.instance().getDataProvider().getConfig().setDisplayText("");
        this.restartText.setNeedsDisplay();
    }

    public void playerDroppedFromStream() {
        this.restartText.removeFromParentView();
        this.contentView.setNeedsDisplay();
        this.enableOptionFullscreen(false);
        this.stopSpinning();
    }

    public void playerStopped() {
        this.enableOptionFullscreen(false);
    }

    public void playerMuteStateChanged(boolean muted) {
    }

    public void playerIsAttemptingToSwitchChannel(Channel c) {
        Log.log(524288L, "Start spinning for potential switch to " + c);
        this.startSpinning();
    }

    public void playerSwitchChannelAttemptFailed(Channel c) {
        this.stopSpinning();
    }

    static class PlayerStartThread
    extends Thread {
        TvScreenController controller;

        public PlayerStartThread(TvScreenController controller) {
            this.controller = controller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.controller.restartText.setNeedsDisplay();
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
            }
            finally {
                this.controller.restartText.removeFromParentView();
                this.controller.contentView.setNeedsDisplay();
            }
        }
    }

    static class SpinnerThread
    implements Runnable {
        final int SPIN_TIMEOUT;
        TvScreenController controller;

        public SpinnerThread(TvScreenController controller) {
            this.SPIN_TIMEOUT = 12000;
            this.controller = controller;
        }

        public void run() {
            try {
                Thread.sleep(12000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.controller.spinningTimeOutThread == Thread.currentThread() && this.controller.spinner.isSpinning()) {
                Log.log(0x100080000L, "Spinning timed out after 12000 ms");
                this.controller.stopSpinning();
            }
        }
    }
}

