/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.userdialog;

import java.util.Vector;
import se.tactel.tvclient.gui.InputBoxView;
import se.tactel.tvclient.gui.common.TextView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.ContainerView;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.userdialog.ButtonGroupTag;
import se.tactel.tvclient.gui.userdialog.Command;
import se.tactel.tvclient.gui.userdialog.UserDialogView;
import se.tactel.tvclient.notificationcenter.Notification;
import se.tactel.tvclient.notificationcenter.NotificationCenter;
import se.tactel.tvclient.util.Utils;

public class UserDialogContainerView
extends ContainerView {
    public static final String ACTION = "clicked";
    protected Vector parentContainer = null;
    protected Rect anchorFrame = null;
    private Vector anchorCommandsVector = new Vector();
    private ButtonGroupTag buttonUp = null;
    private ButtonGroupTag buttonDown = null;

    public UserDialogContainerView() {
        this.opaque = false;
        this.setAction(new Action(){

            public void clicked(View sender) {
                NotificationCenter.defaultCenter().postNotification(new Notification(UserDialogContainerView.ACTION, UserDialogContainerView.this, null));
            }
        });
    }

    public UserDialogView getUserDialogView() {
        ContainerView current = this;
        while (current.parent() != null) {
            if (current.parent() instanceof UserDialogView) {
                return (UserDialogView)current.parent();
            }
            current = (ContainerView)current.parent();
        }
        return (UserDialogView)current.parent();
    }

    public void addSubview(View view) {
        view.setOpaque(false);
        if (this.anchorFrame == null) {
            this.anchorFrame = new Rect(view.frame().x, view.frame().y, view.frame().width + 2, view.frame().height + 2);
        }
        if (view.frame().x < this.anchorFrame.x) {
            this.anchorFrame.x = view.frame().x;
        }
        if (view.frame().y < this.anchorFrame.y) {
            this.anchorFrame.y = view.frame().y;
        }
        if (view.frame().width > this.anchorFrame.width) {
            this.anchorFrame.width = view.frame().width;
        }
        if (view.frame().height > this.anchorFrame.height) {
            this.anchorFrame.height = view.frame().height;
        }
        super.addSubview(view);
    }

    public ContainerView getParentContainer() {
        if (this.parentContainer.size() > 0) {
            return (ContainerView)this.parentContainer.elementAt(0);
        }
        return null;
    }

    public void setParentContainer(ContainerView parent) {
        if (this.parentContainer == null) {
            this.parentContainer = new Vector();
        } else {
            this.parentContainer.removeAllElements();
        }
        this.parentContainer.addElement(parent);
    }

    public Rect getAnchorFrame() {
        return this.anchorFrame;
    }

    public String getTextareaText(String id) {
        InputBoxView box;
        UserDialogView svg = this.getUserDialogView();
        if (svg != null && (box = (InputBoxView)svg.getTextAreaMap().get(id.substring(1))) != null && box.getText() != null && box.getText().length() > 0) {
            return box.getText();
        }
        return null;
    }

    public void relateSubviewsAbsolutePoint(Point point) {
        for (int i = 0; i < this.subviews.size(); ++i) {
            View v = (View)this.subviews.elementAt(i);
            v.getRelativeOrgin().x -= point.x - 1;
            v.getRelativeOrgin().y -= point.y - 1;
            v.getFrame().x = v.getRelativeOrgin().x;
            v.getFrame().y = v.getRelativeOrgin().y;
        }
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        Rect clip = g.getClipRect();
        g.setClipRect(rect);
        if (this.highlight) {
            if (this.buttonUp != null) {
                this.buttonUp.setDisplay("none");
            }
            if (this.buttonDown != null) {
                this.buttonDown.setDisplay("inline");
            }
            if (this.buttonDown == null && this.buttonUp == null) {
                g.setStrokeStyle(1);
                g.setColor(-16776961);
                g.graphics().drawRect(this.frame.x, this.frame.y, this.frame.width - 1, this.frame.height - 1);
                g.setStrokeStyle(0);
            }
        } else {
            if (this.buttonUp != null) {
                this.buttonUp.setDisplay("inline");
            }
            if (this.buttonDown != null) {
                this.buttonDown.setDisplay("none");
            }
        }
        super.drawInRect(g, rect);
        g.setClipRect(clip);
    }

    public boolean event(Event event) {
        if (this.highlight && this.active && event.type() == 1 && event.keyCode() == -5) {
            if (this.action != null) {
                this.action.clicked(this);
                Utils.sleep(300L);
            }
            return true;
        }
        return super.event(event);
    }

    public void setButtonDown(ButtonGroupTag buttonDown) {
        this.buttonDown = buttonDown;
    }

    public void setButtonUp(ButtonGroupTag buttonUp) {
        this.buttonUp = buttonUp;
    }

    public Vector getAnchorCommands() {
        return this.anchorCommandsVector;
    }

    public void addAnchorCommand(Command command) {
        this.anchorCommandsVector.addElement(command);
    }

    public void scale(double sfX, double sfY) {
        super.scale(sfX, sfY);
        int xDiff = 0;
        int yDiff = 0;
        for (int i = 0; i < this.subviews.size(); ++i) {
            View view = (View)this.subviews.elementAt(i);
            if (view instanceof TextView) {
                Point p;
                if (((TextView)view).getAnchor().equals("middle")) {
                    view.frame().x -= view.frame().width / 2;
                    p = view.getRelativeOrgin();
                    p.x -= view.frame().width / 2;
                    view.setRelativeOrgin(p);
                } else if (((TextView)view).getAnchor().equals("end")) {
                    view.frame().x -= view.frame().width;
                    p = view.getRelativeOrgin();
                    p.x -= view.frame().width;
                    view.setRelativeOrgin(p);
                }
            }
            if (view.frame().x < this.frame.x) {
                xDiff = Math.min(xDiff, view.frame().x - this.frame.x);
            }
            if (view.frame().y >= this.frame.y) continue;
            yDiff = Math.min(yDiff, view.frame().y - this.frame.y);
        }
        if (this.parent != null) {
            this.relativeOrgin.x += xDiff;
            this.relativeOrgin.y += yDiff;
            this.frame.x += xDiff;
            this.frame.y += yDiff;
        } else {
            this.frame.x += xDiff;
            this.frame.y += yDiff;
        }
        int maxX = this.frame.x + this.frame.width;
        int maxY = this.frame.y + this.frame.height;
        for (int i = 0; i < this.subviews.size(); ++i) {
            View view = (View)this.subviews.elementAt(i);
            view.setRelativeOrgin(new Point(view.getRelativeOrgin().x - xDiff, view.getRelativeOrgin().y - yDiff));
            maxX = Math.max(maxX, view.frame().x + view.frame().width);
            maxY = Math.max(maxY, view.frame().y + view.frame().height);
        }
        this.frame.width = maxX - this.frame.x;
        this.frame.height = maxY - this.frame.y;
    }
}

