/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.windowing;

import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.Responder;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.position.Size;
import se.tactel.tvclient.gui.screen.option.OptionsMenuItem;
import se.tactel.tvclient.gui.windowing.WindowDelegate;
import se.tactel.tvclient.gui.windowing.WindowServer;
import se.tactel.tvclient.util.Log;

public class Window
extends Responder {
    WindowServer server = ServiceRegistry.instance().getWindowServer();
    private Responder firstResponder = null;
    private Responder initialFirstResponder = null;
    private View contentView = null;
    private View buttonBar = null;
    private OptionsMenuItem[] menuItems;
    private boolean visible = false;
    private boolean modal = false;
    private boolean canBecomeKeyWindow = true;
    private WindowDelegate delegate;

    public boolean event(Event event) {
        boolean res = false;
        if (event.type() == 2 && event.keyCode() == -8) {
            ServiceRegistry.instance().getWindowServer().takeScreenshot();
            System.out.println("screen shot taken");
            return true;
        }
        if (this.delegate != null) {
            res |= this.delegate.eventForWindow(event, this);
        }
        if (this.contentView != null) {
            res |= this.contentView.event(event);
        }
        if (!res && this.buttonBar != null) {
            res |= this.buttonBar.event(event);
        }
        if (!res && this.firstResponder != null && event.type() == 1) {
            int key = event.keyCode();
            if (key == -2) {
                this.selectNextKeyView();
            } else if (key == -1) {
                this.selectPreviousKeyView();
            }
        }
        return res;
    }

    public Rect frame() {
        if (this.contentView != null) {
            return this.contentView.frame();
        }
        return null;
    }

    public void setFrame(Rect aFrame) {
        if (this.contentView != null) {
            this.contentView.setFrame(aFrame);
        }
    }

    public void center() {
        if (this.contentView != null && this.contentView.frame() != null) {
            Rect frame = this.contentView.frame();
            Size screen = this.server.getScreenSize();
            this.contentView.setFrame(new Rect((screen.width - frame.width) / 2, (screen.height - frame.height) / 2, frame.width, frame.height));
        }
    }

    public synchronized void orderBack() {
        this.setVisible(true);
        this.server.orderBack(this);
    }

    public synchronized void orderFront() {
        this.setVisible(true);
        this.server.orderFront(this);
        Log.log(0x1200000000L, this + " order front");
    }

    public synchronized void orderOut() {
        this.setVisible(false);
        this.setActive(false);
        this.server.orderOut(this);
        Log.log(0x1200000000L, this + " order out");
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void makeKeyWindow() {
        this.server.makeKeyWindow(this);
    }

    public boolean isKeyWindow() {
        return this.server.keyWindow() == this;
    }

    protected void didBecomeTopWindow() {
        Log.log(0x1200000000L, " ^ Window become top window: " + this);
        if (this.delegate != null) {
            this.delegate.windowDidBecomeTopWindow(this);
        }
    }

    protected void didLoseTopWindow() {
        Log.log(0x1200000000L, " v Window lost top window: " + this);
        if (this.delegate != null) {
            this.delegate.windowDidLoseTopWindow(this);
        }
    }

    public synchronized void makeKeyAndOrderFront() {
        Log.log(0x1200000000L, this + " make key and order front");
        this.setActive(true);
        this.setVisible(true);
        this.server.makeKeyWindow(this);
        this.server.orderFront(this);
    }

    public void display() {
        if (this.contentView != null) {
            this.contentView.setNeedsDisplay();
        }
        if (this.buttonBar != null) {
            this.buttonBar.setNeedsDisplay();
        }
        this.server.redraw();
    }

    public boolean canBecomeKeyWindow() {
        return this.canBecomeKeyWindow;
    }

    public void setCanBecomeKeyWindow(boolean flag) {
        this.canBecomeKeyWindow = flag;
    }

    public boolean makeFirstResponder(Responder aResponder) {
        boolean can = aResponder.acceptsFirstResponder();
        if (can) {
            aResponder.becomeFirstResponder();
            this.firstResponder = aResponder;
        }
        return can;
    }

    public Responder firstResponder() {
        return this.firstResponder;
    }

    public void setInitialFirstResponder(Responder first) {
        this.initialFirstResponder = this.firstResponder = first;
        if (this.firstResponder != null) {
            this.firstResponder.setHighlight(true);
        }
    }

    public Responder initialFirstResponder() {
        return this.initialFirstResponder;
    }

    public void selectNextKeyView() {
        if (this.firstResponder != null && this.firstResponder.nextResponder() != null) {
            this.firstResponder.setHighlight(false);
            if (this.firstResponder instanceof View) {
                ((View)this.firstResponder).setNeedsDisplay();
            }
            this.firstResponder = this.firstResponder.nextResponder();
            this.firstResponder.setHighlight(true);
            if (this.firstResponder instanceof View) {
                ((View)this.firstResponder).setNeedsDisplay();
            }
        }
    }

    public void selectPreviousKeyView() {
        if (this.firstResponder != null && this.firstResponder.previousResponder() != null) {
            this.firstResponder.setHighlight(false);
            if (this.firstResponder instanceof View) {
                ((View)this.firstResponder).setNeedsDisplay();
            }
            this.firstResponder = this.firstResponder.previousResponder();
            this.firstResponder.setHighlight(true);
            if (this.firstResponder instanceof View) {
                ((View)this.firstResponder).setNeedsDisplay();
            }
        }
    }

    public void selectKeyView(Responder aResponder) {
        if (this.firstResponder != null && this.firstResponder.previousResponder() != null) {
            this.firstResponder.setHighlight(false);
            if (this.firstResponder instanceof View) {
                ((View)this.firstResponder).setNeedsDisplay();
            }
            if (aResponder != null) {
                this.firstResponder = aResponder;
                this.firstResponder.setHighlight(true);
                if (this.firstResponder instanceof View) {
                    ((View)this.firstResponder).setNeedsDisplay();
                }
            }
        }
    }

    public void close() {
        Log.log(0x1200000000L, this + " close");
        this.setVisible(false);
        this.setActive(false);
        this.server.closeWindow(this);
    }

    public void goBack() {
        Log.log(0x1200000000L, this + " goback.");
        this.server.showPrevious();
    }

    public void showOptionsMenuWindow() {
        if (this.menuItems != null) {
            RichMediaMIDlet.instance().tController.getOptionsMenuWindow(this.menuItems).makeKeyAndOrderFront();
        } else {
            Log.log(0x1100000000L, "Attempting to show options menu for " + this + " but none has been set.");
        }
    }

    public void setContentView(View view) {
        if (this.contentView != null) {
            this.contentView.removeFromParentView();
        }
        this.contentView = view;
        if (this.server.getTopmostWindow() == this) {
            this.setVisible(true);
        }
    }

    public View contentView() {
        return this.contentView;
    }

    public void setButtonBar(View view) {
        if (this.buttonBar != null) {
            this.buttonBar.removeFromParentView();
        }
        this.buttonBar = view;
        if (this.server.getTopmostWindow() == this) {
            this.setVisible(true);
        }
    }

    public View buttonBar() {
        return this.buttonBar;
    }

    public void setActive(boolean flag) {
        if (this.contentView != null) {
            this.contentView.setActive(flag);
        }
        if (this.buttonBar != null) {
            this.buttonBar.setActive(flag);
        }
    }

    public void makeModal() {
        Log.log(0x1200000000L, this + " make modal");
        this.modal = true;
        this.server.runModalForWindow(this);
    }

    public void resetModal() {
        Log.log(0x1200000000L, this + " remove modal");
        this.modal = false;
    }

    public boolean isModal() {
        return this.modal;
    }

    protected void setVisible(boolean flag) {
        Log.log(0x1200000000L, this + " make visible: " + flag);
        this.visible = flag;
        if (flag) {
            if (this.contentView != null) {
                this.contentView.removeFromParentView();
            }
            this.server.background().addSubview(this.contentView);
            if (this.buttonBar != null) {
                this.buttonBar.removeFromParentView();
            }
            this.server.background().addSubview(this.buttonBar);
        } else {
            if (this.contentView != null) {
                this.contentView.removeFromParentView();
            }
            if (this.buttonBar != null) {
                this.buttonBar.removeFromParentView();
            }
        }
    }

    public OptionsMenuItem[] getOptionMenuItems() {
        return this.menuItems;
    }

    public void setOptionMenuItems(OptionsMenuItem[] menuItems) {
        this.menuItems = menuItems;
    }

    public void setDelegate(WindowDelegate delegate) {
        this.delegate = delegate;
    }
}

