/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.network.protocols;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.interactivity.InteractivityEvent;
import se.tactel.tvclient.data.interactivity.OneInteractivity;
import se.tactel.tvclient.network.protocols.EventProtocol;
import se.tactel.tvclient.network.protocols.Protocol;
import se.tactel.tvclient.util.Log;

public class InteractivityProtocol
extends Protocol {
    public static final int TAG_UNKNOWN = 0;
    public static final int TAG_INTERACTIVITY = 1;
    public static final int TAG_ERROR = 2;
    public static final int TAG_SHOW_DIALOG = 4;
    public static final int TAG_EVENT = 5;
    public static final int TAG_TEXT = 6;
    public static final int TAG_IMAGE = 7;

    public void parse(XmlPullParser parser) {
        try {
            int tag = 0;
            boolean finished = false;
            int eventType = parser.getEventType();
            OneInteractivity oneInteractivity = null;
            InteractivityEvent event = null;
            do {
                block1 : switch (eventType) {
                    case 2: {
                        String tagName = parser.getName();
                        if ("interactivity".equals(tagName)) {
                            oneInteractivity = new OneInteractivity();
                            tag = 1;
                            break;
                        }
                        if ("error".equals(tagName)) {
                            String code = parser.getAttributeValue(null, "code");
                            String description = parser.getAttributeValue(null, "description");
                            Log.log(0x40000080L, "Received error tag code=\"" + code + "\" description=\"" + description + "\"");
                            tag = 2;
                            break;
                        }
                        if ("showEvent".equals(tagName)) {
                            String eId = parser.getAttributeValue(null, "event");
                            if (oneInteractivity != null) {
                                oneInteractivity.setFirstEvent(eId);
                            }
                            tag = 4;
                            break;
                        }
                        if ("event".equals(tagName)) {
                            String id = parser.getAttributeValue(null, "id");
                            if (id != null) {
                                String type = parser.getAttributeValue(null, "type");
                                String screensize = parser.getAttributeValue(null, "screensize");
                                String duration = parser.getAttributeValue(null, "duration");
                                String next = parser.getAttributeValue(null, "next");
                                event = new InteractivityEvent();
                                event.setType(type);
                                event.setScreensize(screensize);
                                event.setId(id);
                                event.setNextEvent(next);
                                if (duration != null) {
                                    event.setDuration(Integer.parseInt(duration));
                                }
                                EventProtocol p = new EventProtocol();
                                p.setScreenSize(screensize);
                                p.parse(parser);
                                event.setEventViews(p.getEventViews());
                                if (oneInteractivity != null) {
                                    oneInteractivity.addEvent(event);
                                }
                            }
                            tag = 5;
                            break;
                        }
                        tag = 0;
                        break;
                    }
                    case 3: {
                        String name = parser.getName();
                        if (name.equals("interactivity")) {
                            if (oneInteractivity != null) {
                                ServiceRegistry.instance().getDataProvider().getInteractivityData().addOneInteractivity(oneInteractivity);
                            }
                            finished = true;
                        }
                        tag = 0;
                        break;
                    }
                    case 4: {
                        switch (tag) {
                            case 5: {
                                break block1;
                            }
                            case 0: {
                                break block1;
                            }
                        }
                    }
                }
                if (finished) continue;
                eventType = parser.next();
            } while (eventType != 1 && !finished);
        }
        catch (XmlPullParserException e) {
            Log.exception(this, e);
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }
}

