/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.network.protocols;

import java.io.IOException;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.ChannelList;
import se.tactel.tvclient.data.Config;
import se.tactel.tvclient.data.CurrentError;
import se.tactel.tvclient.data.Folder;
import se.tactel.tvclient.network.protocols.NinProtocolVersion1_0;
import se.tactel.tvclient.network.protocols.Protocol;
import se.tactel.tvclient.util.Log;

public class NinProtocol
extends Protocol {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(XmlPullParser parser) throws Protocol.ParseException {
        boolean updated = false;
        Vector knownChannels = ServiceRegistry.instance().getDataProvider().getChannelList().getAllChannels();
        try {
            int eventType = parser.getEventType();
            Config config = ServiceRegistry.instance().getDataProvider().getConfig();
            Channel currentChannel = null;
            ChannelList channelList = ServiceRegistry.instance().getDataProvider().getChannelList();
            block10: do {
                String name = parser.getName();
                switch (eventType) {
                    case 2: {
                        if ("startContent".equals(name)) {
                            String id = parser.getAttributeValue(null, "id");
                            Log.log(0x200000200L, "Parsed (ignored) id@STARTCONTENT: " + id);
                            break;
                        }
                        if ("UID".equals(name)) {
                            String value = parser.getAttributeValue(null, "value");
                            if (value == null) continue block10;
                            Log.log(0x200000200L, "Parsed value@UID: " + value);
                            ServiceRegistry.instance().getDataProvider().getConfig().setUid(value);
                            break;
                        }
                        if (("content".equals(name) || "menu".equals(name)) && parser.getAttributeValue("", "url") != null && !"".equals(parser.getAttributeValue("", "url"))) {
                            String contentInformationUrl;
                            String contentInformation;
                            String contentIconURL;
                            String channelId = parser.getAttributeValue(null, "id");
                            currentChannel = channelList.contains(channelId) ? channelList.getChannel(channelId) : new Channel(channelId);
                            knownChannels.removeElement("" + currentChannel.getId());
                            String contentUrl = parser.getAttributeValue(null, "url");
                            if (contentUrl != null) {
                                // empty if block
                            }
                            if ((contentIconURL = parser.getAttributeValue(null, "icon")) != null) {
                                currentChannel.setIconUrl(contentIconURL);
                            }
                            if ((contentInformation = parser.getAttributeValue(null, "information")) != null) {
                                currentChannel.setDescription(contentInformation);
                            }
                            if ((contentInformationUrl = parser.getAttributeValue(null, "informationUrl")) != null) {
                                currentChannel.setInformationUrl(contentInformationUrl);
                            } else {
                                String contentInformationUri = parser.getAttributeValue(null, "informationUri");
                                if (contentInformationUri != null) {
                                    currentChannel.setInformationUrl(contentInformationUri);
                                }
                            }
                            Log.log(0x200000200L, "Updating content: " + currentChannel.toString());
                            Folder parent = currentChannel.getParentFolder();
                            updated |= parent.updateChild(currentChannel);
                            break;
                        }
                        if (name.equals("ECDSTV")) {
                            String ecdsVersion = parser.getAttributeValue(null, "version");
                            String serverTime = parser.getAttributeValue(null, "serverTime");
                            if (ecdsVersion != null) {
                                Log.log(0x200000200L, "Parsed version@ECDSTV: " + ecdsVersion);
                                if (ecdsVersion.equals("1.0")) {
                                    Log.log(0x100000200L, " Response from  ECDS version 1.0 FD 1.0");
                                    new NinProtocolVersion1_0().parse(parser);
                                    return;
                                }
                                if (ecdsVersion.equals("2.0")) {
                                    Log.log(0x200000200L, " Response from UNSUPPORTED ECDS version 3.0 FD 2.0");
                                } else if (ecdsVersion.equals("3.0")) {
                                    Log.log(0x200000200L, " Response from ECDS version 3.0 FD 3.0");
                                } else {
                                    Log.log(0x40000200L, " Response from unsupported/unknown ECDS version " + ecdsVersion);
                                }
                                if (config.getNinVersion() == null) {
                                    config.setNinVersion(ecdsVersion);
                                    Log.log(0x200000200L, " Saving ECDS version in db: " + ecdsVersion);
                                }
                            }
                            if (!(serverTime != null & !"".equals(serverTime))) continue block10;
                            Log.log(0x200000200L, "Parsed serverTime@ECDSTV: " + serverTime + " DON'T DO ANYTHING, TRUST AS TIME!");
                            break;
                        }
                        if (name.equals("error") || name.equals("response")) {
                            String code = parser.getAttributeValue(null, "statusCode");
                            String description = parser.getAttributeValue(null, "information");
                            if (!"200".equals(code)) {
                                Log.log(0x100000200L, "Error/Response tag encountered code=\"" + code + "\" description=\"" + description + "\"");
                                CurrentError ce = new CurrentError();
                                if (code != null && !"".equals(code)) {
                                    ce.setCode(code);
                                }
                                if (description != null && !"".equals(description)) {
                                    ce.setDescription(description);
                                }
                                ServiceRegistry.instance().getDataProvider().setCurrentNiNError(ce);
                                ServiceRegistry.instance().getComm().processUrl("res://error_as.xml");
                                break;
                            }
                            Log.log(0x200000200L, "Error/Response tag encountered code=\"" + code + "\" description=\"" + description + "\"");
                            break;
                        }
                        if (name.equals("clientInformation") || name.equals("startContent") || name.equals("command") || name.equals("keyNum") || name.equals("menu")) {
                            Log.log(0x200000200L, "Ignoring expected tag: " + name);
                            break;
                        }
                        Log.log(0x100000200L, "Ignoring not expected tag: " + name);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
            } while ((eventType = parser.next()) != 1);
        }
        catch (XmlPullParserException e) {
            Log.exception(this, e);
        }
        catch (IOException e) {
            Log.exception(this, e);
        }
    }
}

