/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.network.protocols;

import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.network.protocols.NinProtocolVersion1_0;
import se.tactel.tvclient.network.protocols.vfe.VfeAsProtocol;
import se.tactel.tvclient.util.Log;

public abstract class Protocol {
    static /* synthetic */ Class class$se$tactel$tvclient$network$protocols$Protocol;

    public void parse(InputStream is) {
        try {
            XmlPullParser parser = Protocol.setupParser(is);
            this.parse(parser);
        }
        catch (XmlPullParserException e) {
            Log.exception(this, e);
        }
        catch (ParseException e) {
            e.displayUserDialog();
        }
    }

    public abstract void parse(XmlPullParser var1) throws ParseException;

    public void performPostParsingProcessing() {
    }

    public static Protocol parseXml(InputStream is, String url) {
        Protocol p = null;
        try {
            XmlPullParser parser = Protocol.setupParser(is);
            p = Protocol.protocolForXml(parser, url);
            if (p != null) {
                p.parse(parser);
            } else {
                Log.log(0x40000000L, "Unable to determine protocol when parsing input stream.");
            }
        }
        catch (XmlPullParserException e) {
            Log.exception(null, e);
        }
        catch (ParseException e) {
            e.displayUserDialog();
        }
        return p;
    }

    private static Protocol protocolForXml(XmlPullParser parser, String url) {
        Protocol res = null;
        try {
            parser.next();
            String name = parser.getName();
            if ("ECDSTV".equals(name)) {
                res = new NinProtocolVersion1_0();
            } else if ("app_server_mtv".equals(name) || "mtv".equals(name)) {
                res = new VfeAsProtocol(url);
            } else {
                Log.log(0x40000000L, "Unable to parse protocol starting with tag: " + name);
            }
        }
        catch (IOException e) {
            Log.exception(class$se$tactel$tvclient$network$protocols$Protocol == null ? (class$se$tactel$tvclient$network$protocols$Protocol = Protocol.class$("se.tactel.tvclient.network.protocols.Protocol")) : class$se$tactel$tvclient$network$protocols$Protocol, e);
        }
        catch (XmlPullParserException e) {
            Log.exception(class$se$tactel$tvclient$network$protocols$Protocol == null ? (class$se$tactel$tvclient$network$protocols$Protocol = Protocol.class$("se.tactel.tvclient.network.protocols.Protocol")) : class$se$tactel$tvclient$network$protocols$Protocol, e);
        }
        return res;
    }

    private static XmlPullParser setupParser(InputStream is) throws XmlPullParserException {
        XmlPullParserFactory xppf = XmlPullParserFactory.newInstance();
        XmlPullParser parser = xppf.newPullParser();
        if (Log.isLoggingOn(0x100000000000L)) {
            final StringBuffer data = new StringBuffer();
            Log.log(0x100000000000L, "Starting to read from HTTP connection");
            try {
                int c;
                while ((c = is.read()) != -1) {
                    data.append((char)c);
                }
            }
            catch (IOException e) {
                Log.exception(class$se$tactel$tvclient$network$protocols$Protocol == null ? (class$se$tactel$tvclient$network$protocols$Protocol = Protocol.class$("se.tactel.tvclient.network.protocols.Protocol")) : class$se$tactel$tvclient$network$protocols$Protocol, e);
                Log.log(0x100000000000L, "Got exception while reading from HTTP connection. The data read so far was: \n" + data);
            }
            Log.log(0x100000000000L, "Finished reading from HTTP connection. The data was: \n" + data);
            InputStream fakeIS = new InputStream(){
                int pos = 0;

                public int read() throws IOException {
                    if (this.pos >= data.length()) {
                        return -1;
                    }
                    return data.charAt(this.pos++);
                }
            };
            try {
                is.close();
            }
            catch (IOException e) {
                Log.exception(class$se$tactel$tvclient$network$protocols$Protocol == null ? (class$se$tactel$tvclient$network$protocols$Protocol = Protocol.class$("se.tactel.tvclient.network.protocols.Protocol")) : class$se$tactel$tvclient$network$protocols$Protocol, e);
            }
            parser.setInput(fakeIS, null);
        } else {
            parser.setInput(is, null);
        }
        return parser;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ParseException
    extends Exception {
        private String userDialog;

        public ParseException(String message, String userDialogToShow) {
            super(message);
            this.userDialog = userDialogToShow;
        }

        public void displayUserDialog() {
            ServiceRegistry.instance().getComm().processUrlASync(this.userDialog);
        }
    }
}

