/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.network.protocols.vfe;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.network.protocols.InteractivityProtocol;
import se.tactel.tvclient.network.protocols.Protocol;
import se.tactel.tvclient.network.protocols.UserDialogProtocol;
import se.tactel.tvclient.network.protocols.vfe.VfeContentInfoProtocol;
import se.tactel.tvclient.network.protocols.vfe.VfeEpgProtocol;
import se.tactel.tvclient.network.protocols.vfe.VfeSlideshowProtocol;
import se.tactel.tvclient.network.protocols.vfe.VfeUrlsProtocol;
import se.tactel.tvclient.util.Log;

public class VfeAsProtocol
extends Protocol {
    private static final int TAG_UNKNOWN = 0;
    private static final int TAG_ERROR = 1;
    private static final int TAG_SERVER_TIME = 2;
    private static final int TAG_HTTP_REQUEST_ALLOWED_INFO = 3;
    private static final int TAG_KEY = 4;
    private String url;
    private boolean interactivityDataChanged = false;

    public VfeAsProtocol(String url) {
        this.url = url;
    }

    public void parse(XmlPullParser parser) {
        try {
            int tag = 0;
            boolean finished = false;
            int eventType = parser.getEventType();
            boolean skipMoreInteractivity = false;
            do {
                block1 : switch (eventType) {
                    case 2: {
                        Protocol p;
                        String tagName = parser.getName();
                        if ("app_server_mtv".equals(tagName)) {
                            Log.log(0x200000800L, "Using Vfe AS parsing, triggered by <app_server_mtv> tag..");
                            break;
                        }
                        if ("error".equals(tagName)) {
                            String code = parser.getAttributeValue(null, "code");
                            String description = parser.getAttributeValue(null, "description");
                            Log.log(0x40000800L, "Received error tag code=\"" + code + "\" description=\"" + description + "\"");
                            tag = 1;
                            break;
                        }
                        if ("urls".equals(tagName)) {
                            Log.log(0x200000800L, "Creating VfeUrlsProtocol");
                            new VfeUrlsProtocol().parse(parser);
                            break;
                        }
                        if ("slide_show_info".equals(tagName)) {
                            p = new VfeSlideshowProtocol();
                            p.parse(parser);
                            ServiceRegistry.instance().getDataProvider().getConfig().setSlideShowUrl(null);
                            break;
                        }
                        if ("content_info".equals(tagName)) {
                            Log.log(0x200000800L, "Creating VfeContentInfoProtocol");
                            new VfeContentInfoProtocol(false).parse(parser);
                            break;
                        }
                        if ("userDialog".equals(tagName)) {
                            if (!skipMoreInteractivity) {
                                this.interactivityDataChanged = true;
                                skipMoreInteractivity = true;
                                p = new UserDialogProtocol(this.url);
                                p.parse(parser);
                                ((UserDialogProtocol)p).getUserDialog().setMtvRootUserDialog(true);
                                ServiceRegistry.instance().getDataProvider().getInteractivityData().addRootUserDialog(((UserDialogProtocol)p).getUserDialog());
                                break;
                            }
                            this.skipTag(parser, tagName);
                            break;
                        }
                        if ("interactivity".equals(tagName) && !skipMoreInteractivity) {
                            if (!skipMoreInteractivity) {
                                this.interactivityDataChanged = true;
                                skipMoreInteractivity = true;
                                p = new InteractivityProtocol();
                                p.parse(parser);
                                break;
                            }
                            this.skipTag(parser, tagName);
                            break;
                        }
                        if ("epg_info".equals(tagName)) {
                            new VfeEpgProtocol().parse(parser);
                            break;
                        }
                        if ("server_time".equals(tagName)) {
                            tag = 2;
                            break;
                        }
                        if ("startup_channel_info".equals(tagName)) {
                            new VfeContentInfoProtocol(true).parse(parser);
                            break;
                        }
                        if ("http_request_allowed_info".equals(tagName)) {
                            Log.log(0x200000800L, "Parsed HTTP_REQUEST_ALLOWED_INFO");
                            tag = 3;
                            break;
                        }
                        if ("key".equals(tagName)) {
                            String name = parser.getAttributeValue(null, "name");
                            String value = parser.getAttributeValue(null, "value");
                            String store = parser.getAttributeValue(null, "store");
                            if (value != null && !"".equals(value)) {
                                ServiceRegistry.instance().getComm().addKey(name, value);
                            } else {
                                ServiceRegistry.instance().getLocalConfiguration().removeInteractivityKey(name);
                            }
                            if ("true".equalsIgnoreCase(store) && value != null && !"".equals(value)) {
                                ServiceRegistry.instance().getLocalConfiguration().addInteractivityKey(name, value);
                            }
                            tag = 4;
                            break;
                        }
                        Log.log(0x100000800L, "Unknown tag: " + tagName);
                        tag = 0;
                        break;
                    }
                    case 3: {
                        String name = parser.getName();
                        if (name.equals("app_server_mtv")) {
                            finished = true;
                        }
                        tag = 0;
                        break;
                    }
                    case 4: {
                        String text = parser.getText();
                        switch (tag) {
                            case 0: {
                                break block1;
                            }
                            case 2: {
                                Log.log(0x200000800L, "Parsed SERVER_TIME: " + text);
                                ServiceRegistry.instance().getDataProvider().getConfig().setServerTime(text);
                                break block1;
                            }
                        }
                        break;
                    }
                }
                if (finished) continue;
                eventType = parser.next();
            } while (eventType != 1 && !finished);
        }
        catch (XmlPullParserException e) {
            Log.exception(this, e);
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }

    private void skipTag(XmlPullParser parser, String tagName) {
        String tag = "";
        boolean done = false;
        int depth = 0;
        do {
            try {
                parser.next();
                int eventType = parser.getEventType();
                tag = parser.getName();
                if (tag == null) continue;
                if (eventType == 1) {
                    return;
                }
                if (eventType == 2) {
                    ++depth;
                } else if (eventType == 3) {
                    --depth;
                }
                if (!tag.equals(tagName) || depth != -1) continue;
                done = true;
            }
            catch (XmlPullParserException e) {
                Log.exception(this, e);
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
        } while (!done);
    }

    public void performPostParsingProcessing() {
        if (this.interactivityDataChanged) {
            ServiceRegistry.instance().getDataProvider().getInteractivityData().letObserversKnow();
        }
    }
}

