/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;
import se.tactel.tvclient.resource.Resource;
import se.tactel.tvclient.util.Log;

public class ResourceImpl
implements Resource {
    Image data;
    String id;
    byte[] byteData = null;
    int recordId = 0;
    static final int NOT_IN_RECORD_STORAGE = 0;
    static /* synthetic */ Class class$se$tactel$tvclient$resource$ResourceImpl;

    ResourceImpl(Resource r) {
        this.id = r.getID();
        this.data = r.getData();
    }

    public ResourceImpl(String id, byte[] bData) {
        this(id, bData, 0);
        this.id = id;
        this.byteData = bData;
    }

    ResourceImpl(String id, byte[] bData, int recordId) {
        this.id = id;
        this.byteData = bData;
        this.recordId = recordId;
    }

    public Image getData() {
        if (this.data == null) {
            this.createImage();
        }
        return this.data;
    }

    public String getID() {
        return this.id;
    }

    private void createImage() {
        Log.log(256L, "Creating image " + this.toString());
        if (this.byteData == null) {
            throw new RuntimeException("Attempting to create image with no byte data for " + this.id);
        }
        this.data = Image.createImage((byte[])this.byteData, (int)0, (int)this.byteData.length);
        this.byteData = null;
        System.gc();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResourceImpl)) {
            return false;
        }
        ResourceImpl otherResource = (ResourceImpl)o;
        if (!this.id.equals(otherResource.id) || this.recordId != otherResource.recordId) {
            return false;
        }
        if (this.data == null != (otherResource.data == null)) {
            return false;
        }
        if (this.data != null) {
            int[] imageArray2;
            int[] imageArray1 = ResourceImpl.getImageAsArray(this.data);
            if (imageArray1.length != (imageArray2 = ResourceImpl.getImageAsArray(otherResource.data)).length) {
                return false;
            }
            for (int i = 0; i < imageArray1.length; ++i) {
                if (imageArray1[i] == imageArray2[i]) continue;
                return false;
            }
        }
        if (this.byteData == null != (otherResource.byteData == null)) {
            return false;
        }
        if (this.byteData != null) {
            if (this.byteData.length != otherResource.byteData.length) {
                return false;
            }
            for (int i = 0; i < this.byteData.length; ++i) {
                if (this.byteData[i] == otherResource.byteData[i]) continue;
                return false;
            }
        }
        return true;
    }

    static byte[] serialize(ResourceImpl resource) {
        if (resource.byteData == null) {
            throw new IllegalStateException("Attempting to serialize resource " + resource.id + " though the resource has no byte data to serialize.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeUTF(resource.id);
            os.writeInt(resource.byteData.length);
            ((OutputStream)os).write(resource.byteData);
            os.writeInt(resource.recordId);
        }
        catch (IOException e) {
            Log.exception(class$se$tactel$tvclient$resource$ResourceImpl == null ? (class$se$tactel$tvclient$resource$ResourceImpl = ResourceImpl.class$("se.tactel.tvclient.resource.ResourceImpl")) : class$se$tactel$tvclient$resource$ResourceImpl, e);
        }
        return baos.toByteArray();
    }

    static ResourceImpl deserialize(byte[] serializedResource) {
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(serializedResource));
        ResourceImpl resource = null;
        try {
            String id = is.readUTF();
            int len = is.readInt();
            byte[] byteData = new byte[len];
            is.readFully(byteData);
            int recordId = is.readInt();
            resource = new ResourceImpl(id, byteData, recordId);
        }
        catch (IOException e) {
            Log.exception(class$se$tactel$tvclient$resource$ResourceImpl == null ? (class$se$tactel$tvclient$resource$ResourceImpl = ResourceImpl.class$("se.tactel.tvclient.resource.ResourceImpl")) : class$se$tactel$tvclient$resource$ResourceImpl, e);
        }
        return resource;
    }

    private static int[] getImageAsArray(Image i) {
        int imageWidth = i.getWidth();
        int imageHeight = i.getHeight();
        int[] serializedImage = new int[imageWidth * imageHeight];
        i.getRGB(serializedImage, 0, imageWidth, 0, 0, imageWidth, imageHeight);
        return serializedImage;
    }

    public String toString() {
        return "id=\"" + this.id + "\" recordId=\"" + this.recordId + "\" imagedata=\"" + (this.data == null ? "NULL" : "NOT NULL") + "\" bytedata=\"" + (this.byteData == null ? "NULL" : "NOT NULL") + "\"";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

