/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui;

import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.position.Size;

public class LineView
extends View {
    int strokeColor = -1;
    boolean drawUpperLeftCorner = false;

    public Rect getLineFrame(Point point1, Point point2) {
        Point frameOrigin = new Point();
        Size frameSize = new Size();
        if (point1.x <= point2.x) {
            frameOrigin.x = point1.x;
            frameSize.width = point2.x - point1.x + 1;
        } else {
            frameOrigin.x = point2.x;
            frameSize.width = point1.x - point2.x + 1;
        }
        if (point1.y <= point2.y) {
            frameOrigin.y = point1.y;
            frameSize.height = point2.y - point1.y + 1;
        } else {
            frameOrigin.y = point2.y;
            frameSize.height = point1.y - point2.y + 1;
        }
        this.drawUpperLeftCorner = frameOrigin.x == point1.x && frameOrigin.y == point1.y || frameOrigin.x == point2.x && frameOrigin.y == point2.y;
        Rect r = new Rect(frameOrigin.x, frameOrigin.y, frameSize.width, frameSize.height);
        return r;
    }

    public void setStrokeColor(int i) {
        this.strokeColor = i;
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        Rect clip = g.getClipRect();
        g.setClipRect(rect);
        if (this.strokeColor != -1) {
            g.setColor(this.strokeColor);
            if (this.drawUpperLeftCorner) {
                g.graphics().drawLine(this.frame.x, this.frame.y, this.frame.x + this.frame.width - 1, this.frame.y + this.frame.height - 1);
            } else {
                g.graphics().drawLine(this.frame.x, this.frame.y + this.frame.height - 1, this.frame.x + this.frame.width - 1, this.frame.y);
            }
        }
        g.setClipRect(clip);
    }
}

