/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.channellist;

import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.Epg;
import se.tactel.tvclient.gui.channellist.ChannelIconView;
import se.tactel.tvclient.gui.common.AutoTickerView;
import se.tactel.tvclient.gui.common.TextView;
import se.tactel.tvclient.gui.common.core.ContainerView;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Fonts;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Rect;

public class ChannelListItemView
extends ContainerView {
    public Channel channel;
    private TextView headerView;
    private AutoTickerView detailsTextView;
    private ChannelIconView channelIconView;

    public ChannelListItemView(View parent, Channel contentToDisplay) {
        this(parent);
        this.setContentToDisplay(contentToDisplay);
    }

    private ChannelListItemView(View parent) {
        Rect rectToDraw = new Rect().setSize(Skin.CHANNEL_LIST_ITEM_SIZE);
        this.setFrame(rectToDraw);
        if (parent != null) {
            parent.addSubview(this);
        }
        this.opaque = false;
        this.headerView = new TextView();
        this.headerView.setFont(Fonts.NORMAL_BOLD);
        this.headerView.setInset(0);
        this.headerView.setFrame(new Rect(Skin.CHANNEL_LIST_ITEM_HEADER_FRAME));
        this.addSubview(this.headerView);
        this.detailsTextView = new AutoTickerView();
        this.detailsTextView.setFont(Fonts.NORMAL);
        this.detailsTextView.setInset(0);
        this.detailsTextView.setFrame(new Rect(Skin.CHANNEL_LIST_ITEM_DETAILS_FRAME));
        this.addSubview(this.detailsTextView);
        this.channelIconView = new ChannelIconView();
        this.channelIconView.setFrame(this.channelIconView.frame().setOrgin(Skin.CHANNEL_LIST_ITEM_ICON_POSITION));
        this.addSubview(this.channelIconView);
    }

    public void setContentToDisplay(Channel c) {
        this.channel = c;
        this.headerView.setText(this.channel.getName());
        Epg.EpgProgram epgProgram = ServiceRegistry.instance().getDataProvider().getEpg().getCurrentProgramForChannelWithId(this.channel.getId());
        String channelDescription = c.getDescription();
        if (epgProgram != null && epgProgram.programName != null) {
            this.detailsTextView.setText(epgProgram.programName);
        } else if (channelDescription != null) {
            this.detailsTextView.setText(channelDescription);
        } else {
            this.detailsTextView.setText("");
        }
        this.headerView.setNeedsDisplay();
        this.detailsTextView.setNeedsDisplay();
        this.channelIconView.updateChannelToDisplay(c);
    }

    public void setOrder(int order) {
        this.channelIconView.updateChannelFavouriteNumber(order);
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        Rect clip = g.getClipRect();
        g.setClipRect(rect);
        g.setColor(this.highlight ? -6697759 : -1972760);
        g.fillRect(this.frame);
        if (this.highlight) {
            g.setColor(-12213578);
            g.drawRect(this.frame.x, this.frame.y, this.frame.width - 1, this.frame.height - 1);
        }
        super.drawInRect(g, rect);
        g.setClipRect(clip);
    }

    public void deactivateTickers() {
        this.detailsTextView.setActive(false);
    }

    public void activateTickers() {
        this.detailsTextView.setActive(true);
    }
}

