/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.common;

import se.tactel.tvclient.gui.common.SoftKeyButtonView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Fonts;
import se.tactel.tvclient.gui.constants.Images;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.util.Log;

public class ButtonBar
extends View {
    public SoftKeyButtonView left = null;
    public SoftKeyButtonView right = null;

    public static ButtonBar createButtonBar() {
        ButtonBar buttonbar = new ButtonBar();
        buttonbar.setFrame(new Rect(Skin.BUTTONBAR));
        buttonbar.setBackgroundColor(-1381654);
        buttonbar.setBackgroundImage(Images.getButtonbarBackground());
        buttonbar.setDrawsBackground(true);
        buttonbar.left = new SoftKeyButtonView();
        buttonbar.left.setFrame(new Rect(Skin.BUTTONBAR_SOFTKEY_LEFT_FRAME));
        buttonbar.left.setFont(Fonts.LARGER);
        buttonbar.left.setTextColor(-16777216);
        buttonbar.left.setAlignment(1);
        buttonbar.left.setActionKey(-6);
        buttonbar.left.setDisabledTextColor(-2236963);
        buttonbar.left.setHighlightTextColor(-8618359);
        buttonbar.left.setDrawsBackground(false);
        buttonbar.left.setText("");
        buttonbar.addSubview(buttonbar.left);
        buttonbar.right = new SoftKeyButtonView();
        buttonbar.right.setFrame(new Rect(Skin.BUTTONBAR_SOFTKEY_RIGHT_FRAME));
        buttonbar.right.setFont(Fonts.LARGER);
        buttonbar.right.setTextColor(-16777216);
        buttonbar.right.setAlignment(2);
        buttonbar.right.setActionKey(-7);
        buttonbar.right.setDisabledTextColor(-2236963);
        buttonbar.right.setHighlightTextColor(-8618359);
        buttonbar.right.setDrawsBackground(false);
        buttonbar.right.setText("");
        buttonbar.addSubview(buttonbar.right);
        return buttonbar;
    }

    public static ButtonBar createDefaultButtonBar(final Window windowToCreateBarFor) {
        ButtonBar bar = ButtonBar.createButtonBar();
        bar.setLeftSoftKeyTextAndAction(1, new Action(){

            public void clicked(View sender) {
                windowToCreateBarFor.showOptionsMenuWindow();
            }
        });
        return bar;
    }

    public void setLeftSoftKeyText(int localizationId) {
        this.left.setText(localizationId);
    }

    public void setLeftSoftKeyText(String text) {
        this.left.setText(text);
    }

    public String getLeftSoftKeyText() {
        return this.left.getText();
    }

    public void setRightSoftKeyText(int localizationId) {
        this.right.setText(localizationId);
    }

    public void setRightSoftKeyText(String text) {
        this.right.setText(text);
    }

    public void setLeftSoftKeyTextAndAction(String text, Action action) {
        this.left.setAction(action);
        this.left.setText(text);
        this.left.setNeedsDisplay();
    }

    public void setRightSoftKeyTextAndAction(String text, Action action) {
        this.right.setAction(action);
        this.right.setText(text);
        this.right.setNeedsDisplay();
    }

    public void setLeftSoftKeyTextAndAction(int localizationId, Action action) {
        this.left.setAction(action);
        this.left.setText(localizationId);
        this.left.setNeedsDisplay();
    }

    public void setRightSoftKeyTextAndAction(int localizationId, Action action) {
        this.right.setAction(action);
        this.right.setText(localizationId);
        this.right.setNeedsDisplay();
    }

    public View clone() {
        ButtonBar res = ButtonBar.createButtonBar();
        res.left.setText(this.left.getText());
        res.left.setAction(this.left.action());
        Log.log(0x40000000L, "left action: " + this.left.action());
        res.right.setText(this.right.getText());
        res.right.setAction(this.right.action());
        return res;
    }
}

