/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.common;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Fonts;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;

public class ButtonView
extends View {
    public static final int LAYOUT_IMAGE_TEXT = 0;
    public static final int LAYOUT_IMAGE_OVER_TEXT = 1;
    public static final int LAYOUT_TEXT_IMAGE = 2;
    public static final int LAYOUT_TEXT_OVER_IMAGE = 3;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_RIGHT = 2;
    protected Image image = null;
    protected Point imagePoint = new Point(0, 0);
    protected int localizationId = -1;
    protected String text = null;
    protected Font font = Font.getDefaultFont();
    protected Point textPoint = new Point(0, 0);
    protected int textColor = -16777216;
    protected int textColorHighlight = 0;
    protected int textColorDisabled = 0;
    protected int textColorFlash = -8618359;
    protected int strokeColor = -1;
    protected int strokeColorHighlight = -1;
    protected int strokeColorDisabled = -1;
    protected Image backgroundImageHighlight = null;
    protected Point rounding = Skin.BUTTON_ROUNDING;
    protected int layout = 0;
    protected int alignment = 0;
    protected int margin = 3;

    public ButtonView() {
        this.setDrawsBackground(true);
        this.highlight = false;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setLayout(int layout) {
        this.layout = layout;
        this.alignObjects();
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        this.alignObjects();
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public void setText(int localizationId) {
        this.localizationId = localizationId;
    }

    public void setText(String text) {
        this.text = text;
        this.localizationId = -1;
        this.alignObjects();
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font font) {
        this.font = font;
        this.alignObjects();
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setHighlightTextColor(int highlightTextColor) {
        this.textColorHighlight = highlightTextColor;
    }

    public void setDisabledTextColor(int disabledTextColor) {
        this.textColorDisabled = disabledTextColor;
    }

    public void setRounding(Point point) {
        this.rounding = point;
    }

    public void setImage(Image image) {
        this.image = image;
        this.alignObjects();
    }

    public void setStrokeColor(int color) {
        this.strokeColor = color;
    }

    public void setHighlightStrokeColor(int strokeColor) {
        this.strokeColorHighlight = strokeColor;
    }

    public void setDisabledStrokeColor(int disabledStrokeColor) {
        this.strokeColorDisabled = disabledStrokeColor;
    }

    public void setHighlightBackgroundImage(Image highlightBackgroundImage) {
        this.backgroundImageHighlight = highlightBackgroundImage;
    }

    public void reAlign() {
        this.alignObjects();
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        Rect oldClip = g.getClipRect();
        g.setClipRect(rect);
        if (this.drawsBackground) {
            int color;
            Image imageToDraw;
            Image image = imageToDraw = this.highlight ? this.backgroundImageHighlight : this.backgroundImage;
            if (imageToDraw != null) {
                g.drawImageRectCenterdInRect(imageToDraw, rect, this.frame);
            } else {
                color = this.highlight ? this.highlightBackgroundColor : this.backgroundColor;
                g.setColor(color);
                g.graphics().fillRoundRect(this.frame.x, this.frame.y, this.frame.width, this.frame.height, this.rounding.x, this.rounding.y);
            }
            int n = this.enabled ? (this.highlight ? this.strokeColorHighlight : this.strokeColor) : (color = this.strokeColorDisabled);
            if (color != -1) {
                g.setColor(color);
                g.graphics().drawRoundRect(this.frame.x, this.frame.y, this.frame.width - 1, this.frame.height - 1, this.rounding.x, this.rounding.y);
            }
        }
        if (this.image != null) {
            g.drawImageAtPoint(this.image, this.imagePoint);
        }
        if (this.localizationId != -1) {
            String oldText = this.text;
            this.text = ServiceRegistry.instance().getLocalization().getString(this.localizationId);
            if (oldText != this.text) {
                this.reAlign();
            }
        }
        if (this.text != null) {
            int color = this.enabled ? (this.highlight ? this.textColorHighlight : this.textColor) : this.textColorDisabled;
            int x = this.frame.x + this.textPoint.x;
            int y = this.frame.y + this.textPoint.y;
            g.setFont(this.enabled ? this.font : Fonts.NORMAL_ITALIC);
            g.setColor(color);
            g.graphics().drawString(this.text, x, y, 20);
        }
        g.setClipRect(oldClip);
    }

    public boolean event(Event event) {
        if (event.type() == 1 && event.keyCode() == -5 && this.active && this.enabled && this.highlight) {
            if (this.action != null) {
                this.action.clicked(this);
            }
            return true;
        }
        return false;
    }

    private void alignObjects() {
        int width = 0;
        int height = 0;
        if (this.frame == null) {
            return;
        }
        if (this.image != null && this.text != null) {
            int fontHeight = this.font.getHeight();
            int fontWidth = this.font.stringWidth(this.text);
            switch (this.layout) {
                default: {
                    width = this.image.getWidth() + fontWidth;
                    switch (this.alignment) {
                        default: {
                            this.imagePoint.x = this.margin;
                            break;
                        }
                        case 0: {
                            this.imagePoint.x = (this.frame.width - width) / 2;
                            break;
                        }
                        case 2: {
                            this.imagePoint.x = this.frame.width - width - this.margin;
                        }
                    }
                    this.imagePoint.y = (this.frame.height - this.image.getHeight()) / 2;
                    this.textPoint.x = this.imagePoint.x + this.image.getWidth() + this.margin;
                    this.textPoint.y = (this.frame.height - fontHeight) / 2;
                    break;
                }
                case 1: {
                    height = this.image.getHeight() + fontHeight;
                    switch (this.alignment) {
                        default: {
                            this.imagePoint.x = this.margin;
                            this.textPoint.x = this.margin;
                            break;
                        }
                        case 0: {
                            this.imagePoint.x = (this.frame.width - this.image.getWidth()) / 2;
                            this.textPoint.x = (this.frame.width - fontWidth) / 2;
                            break;
                        }
                        case 2: {
                            this.imagePoint.x = this.frame.width - this.image.getWidth() - this.margin;
                            this.textPoint.x = this.frame.width - fontWidth - this.margin;
                        }
                    }
                    this.imagePoint.y = (this.frame.height - height) / 2;
                    this.textPoint.y = this.imagePoint.y + this.image.getHeight() + this.margin;
                    break;
                }
                case 2: {
                    width = this.image.getWidth() + fontWidth;
                    switch (this.alignment) {
                        default: {
                            this.textPoint.x = this.margin;
                            break;
                        }
                        case 0: {
                            this.textPoint.x = (this.frame.width - width) / 2;
                            break;
                        }
                        case 2: {
                            this.textPoint.x = this.frame.width - width - this.margin;
                        }
                    }
                    this.textPoint.y = (this.frame.height - fontHeight) / 2;
                    this.imagePoint.x = this.textPoint.x + fontWidth + this.margin;
                    this.imagePoint.y = (this.frame.height - this.image.getHeight()) / 2;
                    break;
                }
                case 3: {
                    height = this.image.getHeight() + this.font.getHeight();
                    switch (this.alignment) {
                        default: {
                            this.imagePoint.x = this.margin;
                            this.textPoint.x = this.margin;
                            break;
                        }
                        case 0: {
                            this.imagePoint.x = (this.frame.width - this.image.getWidth()) / 2;
                            this.textPoint.x = (this.frame.width - fontWidth) / 2;
                            break;
                        }
                        case 2: {
                            this.imagePoint.x = this.frame.width - this.image.getWidth() - this.margin;
                            this.textPoint.x = this.frame.width - fontWidth - this.margin;
                        }
                    }
                    this.textPoint.y = (this.frame.height - height) / 2;
                    this.imagePoint.y = this.textPoint.y + fontHeight + this.margin;
                    break;
                }
            }
        } else if (this.image != null) {
            switch (this.alignment) {
                default: {
                    this.imagePoint.x = this.margin;
                    break;
                }
                case 0: {
                    this.imagePoint.x = (this.frame.width - this.image.getWidth()) / 2;
                    break;
                }
                case 2: {
                    this.imagePoint.x = this.frame.width - this.image.getWidth() - this.margin;
                }
            }
            this.imagePoint.y = (this.frame.height - this.image.getHeight()) / 2;
        } else if (this.text != null) {
            switch (this.alignment) {
                default: {
                    this.textPoint.x = this.margin;
                    break;
                }
                case 0: {
                    this.textPoint.x = (this.frame.width - this.font.stringWidth(this.text)) / 2;
                    break;
                }
                case 2: {
                    this.textPoint.x = this.frame.width - this.font.stringWidth(this.text) - this.margin;
                }
            }
            this.textPoint.y = (this.frame.height - this.font.getHeight()) / 2;
        }
    }
}

